

# CRIミドルウェア 

## 目的とスコープ 

このドキュメントでは、DKLIKEリズムゲームにおけるCRIミドルウェアライブラリの統合と設定について説明します。CRIミドルウェアは3つの重要なサブシステムを提供します：**CriFs**（ファイルシステム）、**CriAtom**（オーディオエンジン）、**CriMana**（ビデオ再生）。このページでは、初期化、設定構造、およびすべてのミドルウェアセットアップを統括する`CriWareInitializer`コンポーネントに焦点を当てています。

オーディオ固有の実行時使用（音楽再生、効果音、ピッチシフト）については、[パッケージ依存関係](#10.2)を参照してください。CriFsと連携するアセット読込戦略については、[アセット管理](#9)を参照してください。

---

## ミドルウェアコンポーネント概要 

CRIミドルウェアは、特定の順序で初期化する必要がある3つの独立した、しかし協調するライブラリで構成されています。

### CRIミドルウェアアーキテクチャ 

```mermaid
flowchart TD

INIT["CriWareInitializer (MonoBehaviourコンポーネント)"]
FS_CFG["CriFsConfig ファイルシステムパラメータ"]
ATOM_CFG["CriAtomConfig オーディオエンジンパラメータ"]
MANA_CFG["CriManaConfig ビデオデコーダパラメータ"]
FS_PLUGIN["CriFsPlugin ファイルシステムAPI"]
ATOM_PLUGIN["CriAtomPlugin オーディオエンジンAPI"]
MANA_PLUGIN["CriManaPlugin ビデオデコーダAPI"]
CRIFS["CriFs クロスプラットフォームファイルアクセス"]
CRIATOM["CriAtom サンプル精度オーディオ"]
CRIMANA["CriMana ビデオストリーミング"]

INIT -.->|"設定"| FS_CFG
INIT -.->|"設定"| ATOM_CFG
INIT -.->|"設定"| MANA_CFG

subgraph ランタイムサブシステム ["ランタイムサブシステム"]
    CRIFS
    CRIATOM
    CRIMANA
    CRIFS -.->|"ファイルI/O提供"| CRIATOM
    CRIFS -.->|"ファイルI/O提供"| CRIMANA
end

subgraph ネイティブプラグインインターフェース ["ネイティブプラグインインターフェース"]
    FS_PLUGIN
    ATOM_PLUGIN
    MANA_PLUGIN
end

subgraph 設定オブジェクト ["設定オブジェクト"]
    FS_CFG
    ATOM_CFG
    MANA_CFG
end

subgraph Unityシーン ["Unityシーン"]
    INIT
end
```

## CriWareInitializerコンポーネント 

`CriWareInitializer`クラスは、すべてのCRIミドルウェアライブラリの完全なライフサイクルを管理するシングルトンMonoBehaviourです。

### コンポーネント設定 

| プロパティ | 型 | 目的 |
| --- | --- | --- |
| `initializesFileSystem` | `bool` | CriFsを初期化するかどうか |
| `fileSystemConfig` | `CriFsConfig` | ファイルシステムパラメータ |
| `initializesAtom` | `bool` | CriAtomを初期化するかどうか |
| `atomConfig` | `CriAtomConfig` | オーディオエンジンパラメータ |
| `initializesMana` | `bool` | CriManaを初期化するかどうか |
| `manaConfig` | `CriManaConfig` | ビデオデコーダパラメータ |
| `dontInitializeOnAwake` | `bool` | 手動初期化モード |
| `dontDestroyOnLoad` | `bool` | シーン読込時にも保持 |

### 初期化メソッド 

コンポーネントは自動初期化と手動初期化の両方をサポートします：

```
自動モード（デフォルト）：
  Awake() → CheckBinaryVersionCompatibility() → Initialize()

手動モード（dontInitializeOnAwake = true）：
  ユーザーが別のスクリプトからInitialize()を明示的に呼び出す
```

`Initialize()`メソッドは静的カウンタを通じて単一初期化を強制します：

## CriFsファイルシステム 

CriFsは、アーカイブ形式（CPKファイル）とプラットフォーム固有のストレージ位置に対する特別な処理を備えた、クロスプラットフォームファイルI/Oを提供します。

### CriFsConfigパラメータ 

```mermaid
flowchart TD

LOADERS["numberOfLoaders デフォルト: 16"]
BINDERS["numberOfBinders デフォルト: 8"]
INSTALLERS["numberOfInstallers デフォルト: 2"]
BUFFER["installBufferSize デフォルト: CriFsPlugin.defaultInstallBufferSize"]
MAXPATH["maxPath デフォルト: 256"]
AGENT["userAgentString デフォルト: 空"]
FD_SAVE["minimizeFileDescriptorUsage デフォルト: false"]
CRC["enableCrcCheck デフォルト: false"]
ANDROID_BPS["androidDeviceReadBitrate デフォルト: 50000000 bps"]

subgraph CriFsConfig構造 ["CriFsConfig構造"]
    LOADERS
    BINDERS
    INSTALLERS
    BUFFER
    MAXPATH
    AGENT
    FD_SAVE
    CRC
    ANDROID_BPS
end
```

### 主要設定パラメータ 

| パラメータ | 目的 | デフォルト値 |
| --- | --- | --- |
| `numberOfLoaders` | 並行ファイル読込操作数 | 16 |
| `numberOfBinders` | CPKアーカイブマウント操作数 | 8 |
| `numberOfInstallers` | ファイルインストールストリーム数 | 2 |
| `installBufferSize` | インストール操作用バッファ（KB） | プラットフォーム依存 |
| `maxPath` | 最大ファイルパス長 | 256 |
| `minimizeFileDescriptorUsage` | オープンファイルハンドルを削減 | `false` |
| `enableCrcCheck` | CPKファイルのCRC検証 | `false` |
| `androidDeviceReadBitrate` | Android読込速度推定（bps） | 50,000,000 |

### 初期化フロー 

ファイルシステムは、他のミドルウェアにI/Oサービスを提供するため最初に初期化されます：


---

## CriAtomオーディオエンジン 

CriAtomは、サンプル精度の再生、ピッチシフト（音楽レート変更用）、およびカテゴリ、バス、エフェクトを介した複雑なオーディオルーティングを提供するオーディオミドルウェアです。

### CriAtomConfig構造 

設定は、プラットフォーム固有のセクションを含む広範なものです：

```mermaid
flowchart TD

CORE["コアパラメータ maxVirtualVoices: 32 maxCategories: 32 maxAisacs: 8"]
POOLS["ボイスプール設定 StandardVoicePoolConfig HcaMxVoicePoolConfig"]
PREVIEW["インゲームプレビュー InGamePreviewConfig"]
IOS["iOS固有 iosBufferingTime iosOverrideIPodMusic"]
ANDROID["Android固有 androidBufferingTime androidUsesAndroidFastMixer"]
PC["PC固有 pcBufferingTime useMicrosoftSpatialSound"]

subgraph CriAtomConfig ["CriAtomConfig"]
    CORE
    POOLS
    PREVIEW
    IOS
    ANDROID
    PC
    CORE -.-> POOLS
    CORE -.-> PREVIEW
    CORE -.-> IOS
    CORE -.-> ANDROID
    CORE -.-> PC
end
```

### コアオーディオパラメータ 

| パラメータ | 目的 | デフォルト値 |
| --- | --- | --- |
| `acfFileName` | StreamingAssets内のACF設定ファイル | 空文字列 |
| `maxVirtualVoices` | 最大同時仮想ボイス数 | 32 |
| `maxCategories` | オーディオカテゴリ制限 | 32 |
| `maxAisacs` | 自動調整パラメータ | 8 |
| `serverFrequency` | オーディオサーバー更新レート（Hz） | 60.0 |
| `outputSamplingRate` | 出力サンプルレート（0=自動） | 0 |
| `soundRendererType` | オーディオレンダリングバックエンド | `Native` |
| `useRandomSeedWithTime` | システム時刻でランダム化 | `true` |



### ボイスプール設定 

ボイスプールは、同時オーディオ再生のためのメモリ割り当てを管理します：

```mermaid
flowchart TD

LOW_LAT_MEM["memoryVoices: 0 （NSR低遅延）"]
LOW_LAT_STREAM["streamingVoices: 0"]
HCA_MEM["memoryVoices: 0 （HCA-MX形式）"]
HCA_STREAM["streamingVoices: 0"]
MEM_VOICES["memoryVoices: 16 （メモリ内サンプル）"]
STREAM_VOICES["streamingVoices: 8 （ストリーミングオーディオ）"]

subgraph AndroidLowLatencyStandardVoicePoolConfig ["AndroidLowLatencyStandardVoicePoolConfig"]
    LOW_LAT_MEM
    LOW_LAT_STREAM
end

subgraph HcaMxVoicePoolConfig ["HcaMxVoicePoolConfig"]
    HCA_MEM
    HCA_STREAM
end

subgraph StandardVoicePoolConfig ["StandardVoicePoolConfig"]
    MEM_VOICES
    STREAM_VOICES
end
```

**標準プール**はほとんどのゲームオーディオを処理します。**HCA-MXプール**は特殊なミドルウェア形式用です。**Android低遅延プール**はAndroidで遅延を減らすためにNSR（Native Sound Renderer）を使用します。



### プラットフォーム固有オーディオ設定 

#### iOS設定

| パラメータ | 目的 | デフォルト |
| --- | --- | --- |
| `iosEnableSonicSync` | SonicSYNCタイミングを有効化 | `true` |
| `iosBufferingTime` | 出力バッファ持続時間（ms） | 50 |
| `iosOverrideIPodMusic` | バックグラウンド音楽を停止 | `false` |
| `iosEnableOSNotificationHandling` | iOS割り込みを処理 | `true` |

#### Android設定

| パラメータ | 目的 | デフォルト |
| --- | --- | --- |
| `androidEnableSonicSync` | SonicSYNCタイミングを有効化 | `true` |
| `androidBufferingTime` | ASRバッファ持続時間（ms） | 133 |
| `androidStartBufferingTime` | NSR初期バッファ（ms） | 100 |
| `androidUsesAndroidFastMixer` | Android Fast Mixerを使用 | `true` |
| `androidForceToUseAsrForDefaultPlayback` | NSRよりASRを強制 | `true` |
| `androidUsesAAudio` | AAudio APIを使用（β版） | `false` |
| `androidStreamType` | Androidストリームタイプ | 0 |

#### PC設定

| パラメータ | 目的 | デフォルト |
| --- | --- | --- |
| `pcBufferingTime` | 出力バッファ持続時間（ms） | 0（自動） |
| `useMicrosoftSpatialSound` | MS Spatial Soundを有効化 | `true` |



### インゲームプレビューシステム 

CriAtomには、実行時監視のためのデバッグシステムが含まれています：

| パラメータ | 目的 | デフォルト |
| --- | --- | --- |
| `usesInGamePreview` | プレビューシステムを有効化 | `false` |
| `inGamePreviewMode` | プレビュー有効化モード | `Default` |
| `maxPreviewObjects` | 最大監視オブジェクト数 | 200 |
| `communicationBufferSize` | ネットワークバッファ（KiB） | 2048 |
| `playbackPositionUpdateInterval` | 更新頻度（サーバーティック） | 8 |

`InGamePreviewSwitchMode`列挙型は、プレビューがアクティブになるタイミングを制御します：

* `Disable`: 無効
* `Enable`: 常に有効
* `FollowBuildSetting`: Development Buildのみ
* `Default`: `usesInGamePreview`フラグを使用



### オーディオ初期化 



初期化シーケンス：

1. `CriAtomPlugin.IsLibraryInitialized()`で既に初期化されているかチェック
2. プラットフォーム固有の設定を適用
3. すべての設定で`CriAtomPlugin.SetConfigParameters()`を呼び出す
4. `CriAtomPlugin.InitializeLibrary()`を呼び出す
5. `useRandomSeedWithTime`が有効な場合、乱数シードを設定
6. `acfFileName`が指定されている場合、ACFファイルを登録



---

## CriManaビデオ再生 

CriManaは、リズムゲーム譜面のバックグラウンドビデオのためのビデオデコードと再生を処理します。

### CriManaConfigパラメータ 

```mermaid
flowchart TD

DECODERS["numberOfDecoders デフォルト: 8"]
ENTRIES["numberOfMaxEntries デフォルト: 4"]
MULTITHREAD["graphicsMultiThreaded 読取専用: true"]
STREAMER["useStreamerManager デフォルト: false"]

subgraph CriManaConfig ["CriManaConfig"]
    DECODERS
    ENTRIES
    MULTITHREAD
    STREAMER
end
```

| パラメータ | 目的 | デフォルト値 |
| --- | --- | --- |
| `numberOfDecoders` | 並行ビデオデコーダインスタンス数 | 8 |
| `numberOfMaxEntries` | シームレス再生用の最大プレイリストエントリ数 | 4 |
| `graphicsMultiThreaded` | テクスチャ更新にGL.IssuePluginEventを使用 | `true`（読取専用） |
| `useStreamerManager` | ストリーミングリソースマネージャを有効化 | `false` |



### ビデオ初期化 



ビデオ初期化は直接的です：

1. `CriManaPlugin.IsLibraryInitialized()`をチェック
2. `CriManaPlugin.SetConfigParameters()`を呼び出す
3. `CriManaPlugin.InitializeLibrary()`を呼び出す
4. オプションで`UseStreamerManager()`を有効化



---

## 初期化ライフサイクル 

完全な初期化とシャットダウンフローは、Unityのコンポーネントライフサイクルに従います：

### 初期化フロー図 

```mermaid
flowchart TD

AWAKE["CriWareInitializer.Awake()"]
VERSION_CHECK["CheckBinaryVersionCompatibility()"]
INIT_FLAG["dontInitializeOnAwake?"]
SKIP["初期化をスキップ （手動モード）"]
INITIALIZE["Initialize()"]
COUNTER_CHECK["initializationCount == 0?"]
COUNTER_INC["initializationCount++"]
VALIDATE["ValidateConfig()"]
FS_CHECK["initializesFileSystem?"]
FS_INIT["InitializeFileSystem(fileSystemConfig)"]
ATOM_CHECK["initializesAtom?"]
ATOM_PREVIEW["InGamePreviewModeを適用"]
ATOM_INIT["InitializeAtom(atomConfig)"]
MANA_CHECK["initializesMana?"]
MANA_INIT["InitializeMana(manaConfig)"]
DONT_DESTROY["dontDestroyOnLoad?"]
PERSIST["DontDestroyOnLoad(gameObject)"]
COMPLETE["初期化完了"]

AWAKE -.-> VERSION_CHECK
INITIALIZE -.->|"false"| COUNTER_CHECK
VALIDATE -.->|"yes"| FS_CHECK
PERSIST -.->|"true"| COMPLETE
```



### シャットダウンフロー 

`Shutdown()`メソッドは`OnDestroy()`から呼び出されます：



 

シャットダウンシーケンス：

1. `initializationCount`をデクリメント
2. カウントが0に達した場合：
* CriAtomを終了処理（遅延推定器のクリーンアップを含む）
* CriFsを終了処理
* CriManaの終了処理は明示的に表示されていない（他の場所で処理）



---

## プロジェクト統合 

### プリロードアセット設定 

CRIミドルウェアリソースは、Unityのプロジェクト設定でプリロードアセットとして設定されています：

これらのGUIDは、シーン初期化前に読み込む必要があるCRI設定アセットに対応しています。

 

### スクリプト定義シンボル 

プロジェクトは、CRIの動作に影響を与える可能性のあるプラットフォーム固有の定義を使用します：

| プラットフォーム | 定義 |
| --- | --- |
| Android | `TMPro;DOTWEEN;UNITYWEBVIEW_ANDROID_USES_CLEARTEXT_TRAFFIC;ELEBEAT_PRODUCT` |
| iOS | `ELEBEAT_PRODUCT;TMPro;DOTWEEN` |
| Standalone | `ELEBEAT_STAGING;DOTWEEN` |

 

### コンポーネント階層 

`CriWareInitializer`コンポーネントは通常、永続的なGameObjectにアタッチされます：

```
シーンルート
└── CriWareInitializer (GameObject)
    └── CriWareInitializer (Component)
        - コンポーネントメニュー: "CRIWARE/Library Initializer"
        - Prefab属性: "Dialog/DialogManager"
```



---

## 高度な機能 

### カスタムオーディオエフェクト 

CriAtomは、ネイティブプラグインインターフェースを通じてカスタムDSPエフェクトをサポートします：



カスタムエフェクトは、`Initialize()`を呼び出す**前**に登録する必要があります。インターフェースポインタはリストに保存され、`CriAtomPlugin.InitializeLibrary()`中に適用されます。



### 多重インスタンス保護 

イニシャライザは静的カウンタを通じて複数のインスタンスを防止します：



`initializationCount != 1`の場合、重複したコンポーネントは自身を破棄します。これにより、シーン読込全体でシングルトン動作が保証されます。



 

### バージョン互換性チェック 

すべての初期化時に、システムはバイナリ互換性を検証します：



これにより、C#ラッパーとネイティブプラグイン間のバージョン不一致によるランタイムエラーを防止します。



---

## 設定サマリ表 

### クイックリファレンス：デフォルト値 

| サブシステム | 主要パラメータ | デフォルト値 | 目的 |
| --- | --- | --- | --- |
| **CriFs** | `numberOfLoaders` | 16 | 並行ファイル読込数 |
|  | `numberOfBinders` | 8 | CPKアーカイブマウント数 |
|  | `androidDeviceReadBitrate` | 50,000,000 | 読込速度推定（bps） |
| **CriAtom** | `maxVirtualVoices` | 32 | 最大同時サウンド数 |
|  | `serverFrequency` | 60.0 | オーディオ更新レート（Hz） |
|  | `memoryVoices` | 16 | メモリ内ボイスプール |
|  | `streamingVoices` | 8 | ストリーミングボイスプール |
|  | `iosBufferingTime` | 50 | iOS遅延（ms） |
|  | `androidBufferingTime` | 133 | Android ASR遅延（ms） |
|  | `androidStartBufferingTime` | 100 | Android NSR遅延（ms） |
| **CriMana** | `numberOfDecoders` | 8 | ビデオデコーダインスタンス数 |
|  | `numberOfMaxEntries` | 4 | プレイリストエントリ数 |
|  | `graphicsMultiThreaded` | `true` | スレッド化テクスチャ更新 |



---

## 使用パターン 

### 典型的な設定 

ほとんどのDKLIKEインストールでは、最小限のカスタマイズでデフォルトのCRI設定を使用します：

```yaml
initializesFileSystem: true
initializesAtom: true
initializesMana: true（バックグラウンドビデオ用）
dontInitializeOnAwake: false（自動初期化）
dontDestroyOnLoad: true（シーン間で保持）
```

### 手動初期化パターン 

初期化タイミングの高度な制御のため：

```
1. InspectorでdontInitializeOnAwake = trueを設定
2. より高い優先度のスクリプト（Script Execution Order）で：
   - CriWareInitializer.atomConfigまたは他の設定を変更
   - CriWareInitializer.Initialize()を明示的に呼び出す
```

このパターンは、設定を実行時に決定する必要がある場合（例：ファイルから設定を読み込む）に便利です。


### On this page

* [CRIミドルウェア](#10.1-cri)
* [目的とスコープ](#10.1-)
* [ミドルウェアコンポーネント概要](#10.1--1)
* [CRIミドルウェアアーキテクチャ](#10.1-cri-1)
* [CriWareInitializerコンポーネント](#10.1-criwareinitializer)
* [コンポーネント設定](#10.1--2)
* [初期化メソッド](#10.1--3)
* [CriFsファイルシステム](#10.1-crifs)
* [CriFsConfigパラメータ](#10.1-crifsconfig)
* [主要設定パラメータ](#10.1--4)
* [初期化フロー](#10.1--5)
* [CriAtomオーディオエンジン](#10.1-criatom)
* [CriAtomConfig構造](#10.1-criatomconfig)
* [コアオーディオパラメータ](#10.1--6)
* [ボイスプール設定](#10.1--7)
* [プラットフォーム固有オーディオ設定](#10.1--8)
* [インゲームプレビューシステム](#10.1--9)
* [オーディオ初期化](#10.1--10)
* [CriManaビデオ再生](#10.1-crimana)
* [CriManaConfigパラメータ](#10.1-crimanaconfig)
* [ビデオ初期化](#10.1--11)
* [初期化ライフサイクル](#10.1--12)
* [初期化フロー図](#10.1--13)
* [シャットダウンフロー](#10.1--14)
* [プロジェクト統合](#10.1--15)
* [プリロードアセット設定](#10.1--16)
* [スクリプト定義シンボル](#10.1--17)
* [コンポーネント階層](#10.1--18)
* [高度な機能](#10.1--19)
* [カスタムオーディオエフェクト](#10.1--20)
* [多重インスタンス保護](#10.1--21)
* [バージョン互換性チェック](#10.1--22)
* [設定サマリ表](#10.1--23)
* [クイックリファレンス：デフォルト値](#10.1--24)
* [使用パターン](#10.1--25)
* [典型的な設定](#10.1--26)
* [手動初期化パターン](#10.1--27)

