

# Lua APIリファレンス 

## 目的と範囲 

このドキュメントは、ゲームプレイシーン内のカスタム譜面スクリプトに公開されているLuaスクリプティングAPIの包括的なリファレンスを提供します。このAPIにより、譜面制作者はLuaスクリプトを通じて、ビジュアルエフェクト、ゲームプレイメカニクス、ノート挙動、UI要素を譜面再生と並行してカスタマイズできます。

Lua統合の全体的なアーキテクチャとスクリプトライフサイクル管理については、[7.1 Lua統合アーキテクチャ](#7.1)を参照してください。ビジュアル要素を作成するために使用されるアクターシステムの詳細については、[7.2 アクターシステム](#7.2)を参照してください。

---

## APIアーキテクチャの概要 

Lua APIは、異なるサブシステムへのアクセスを提供するグローバルシングルトンオブジェクトに編成されています。これらのオブジェクトは初期化時にLua環境に注入され、スクリプト実行全体を通じて利用可能です。

```mermaid
flowchart TD

SCRIPT["譜面Luaスクリプト main.lua"]
ACTOR_SCRIPTS["アクターLuaスクリプト (オプション)"]
GAMESTATE["GAMESTATE GameState.cs"]
SONGMAN["SONGMAN SongMan.cs"]
PLAYERSTATS["PLAYERSTATS PlayerStats.cs"]
SCREENMAN["SCREENMAN ScreenMan.cs"]
UTIL["UTIL Util.cs"]
ACTORFACTORY["ACTORFACTORY ActorFactory.cs"]
CAMERAMAN["CAMERAMAN CameraMan.cs"]
ASSETMAN["ASSETMAN AssetMan.cs"]
APPMAN["APPMAN AppMan.cs"]
DANMAKUSTAGE["DANMAKUSTAGE/DSTAGE DanmakuStageMan.cs"]
DUMMY["DummyNote DummyNotePrefab"]
LANE["LaneSprite LaneSpritePrefab"]
MATERIALS["MaterialInjection[]"]
TRANSFORMS["RootHierarchyTransformInjection[]"]

SCRIPT -.->|"アクセス"| GAMESTATE
SCRIPT -.->|"アクセス"| SONGMAN
SCRIPT -.->|"アクセス"| PLAYERSTATS
SCRIPT -.->|"アクセス"| SCREENMAN
SCRIPT -.->|"アクセス"| UTIL
SCRIPT -.->|"アクセス"| ACTORFACTORY
SCRIPT -.->|"アクセス"| CAMERAMAN
SCRIPT -.->|"作成"| ASSETMAN
SCRIPT -.->|"アクセス"| APPMAN
SCRIPT -.-> DANMAKUSTAGE
ACTORFACTORY -.->|"アクセス"| ACTOR_SCRIPTS
SCRIPT -.->|"アクセス"| DUMMY
SCRIPT -.->|"アクセス"| LANE
SCRIPT -.->|"アクセス"| MATERIALS
SCRIPT -.->|"アクセス"| TRANSFORMS

subgraph 注入されたオブジェクト ["注入されたオブジェクト"]
    DUMMY
    LANE
    MATERIALS
    TRANSFORMS
end

subgraph グローバルAPIオブジェクト ["グローバルAPIオブジェクト"]
    GAMESTATE
    SONGMAN
    PLAYERSTATS
    SCREENMAN
    UTIL
    ACTORFACTORY
    CAMERAMAN
    ASSETMAN
    APPMAN
    DANMAKUSTAGE
end

subgraph Luaスクリプト環境 ["Luaスクリプト環境"]
    SCRIPT
    ACTOR_SCRIPTS
end
```

### グローバルAPIオブジェクト一覧 

| グローバル変数 | C#クラス | 用途 |
| --- | --- | --- |
| `GAMESTATE` | `GameState` | ゲームプレイメカニクスの制御：速度、距離、ノート挙動、エフェクト、判定 |
| `SONGMAN` | `SongMan` | 楽曲メタデータへのアクセス：タイトル、アーティスト、BPM、難易度、譜面データ |
| `PLAYERSTATS` | `PlayerStats` | プレイヤー状態へのアクセス：コンボ、スコア、ライフ、設定、ハイスコア |
| `SCREENMAN` | `ScreenMan` | 画面とUI管理：メッセージ、背景制御、キャンバスアクセス |
| `UTIL` | `Util` | ユーティリティ関数：テクスチャ読込、トゥイーン、座標変換、遅延処理 |
| `ACTORFACTORY` | `ActorFactory` | カスタムビジュアル/オーディオ要素用のアクターオブジェクトを作成 |
| `CAMERAMAN` | `CameraMan` | カメラ操作（位置、回転、FOV） |
| `ASSETMAN` | `AssetMan` | アセット読込ユーティリティ |
| `APPMAN` | `AppMan` | アプリケーションレベルの制御 |
| `DANMAKUSTAGE` / `DSTAGE` | `DanmakuStageMan` | 弾幕パターンシステム |



 

---

## ライフサイクルコールバック 

Luaスクリプトは、ゲームプレイ中の重要なタイミングでエンジンから呼び出される特定のコールバック関数を実装できます。すべてのコールバックはオプションです。

```mermaid
flowchart TD
    subgraph 初期化 ["初期化"]
        ONLOADED["onLoaded()"]
        START["start()"]
    end

    subgraph フレームループ ["フレームループ"]
        UPDATE["update()"]
    end

    subgraph 入力イベント ["入力イベント（随時発火）"]
        ONINPUTDOWN["onInputDown(touchId, posX,<br/>screenPosX, screenPosY)"]
        ONINPUTMOVE["onInputMove(touchId, posX,<br/>screenPosX, screenPosY)"]
        ONINPUTUP["onInputUp(touchId, posX,<br/>screenPosX, screenPosY)"]
    end

    subgraph 状態変化 ["状態変化（随時発火）"]
        ONPAUSE["onPause()"]
        ONRESUME["onResume()"]
        ONGAMEOVER["onGameOver()"]
    end

    subgraph ゲームプレイイベント ["ゲームプレイイベント（随時発火）"]
        ONHIT["onHitNote(id, lane,<br/>noteType, judge, isAttack)"]
        ONMISS["onMissedNote(id, lane, noteType)"]
        ONSPAWN["onSpawnNote(noteController)"]
        ONSPAWNLONG["onSpawnLong(longController)"]
    end

    subgraph クリーンアップ ["クリーンアップ"]
        FINISH["finish()"]
        ONDESTROY["onDestroy()"]
    end

    %% メインフロー
    ONLOADED --> START
    START --> UPDATE
    UPDATE -->|"毎フレーム"| UPDATE
    UPDATE --> FINISH
    FINISH --> ONDESTROY

    %% イベント発火（フレームループから）
    UPDATE -.->|"タッチ開始"| ONINPUTDOWN
    UPDATE -.->|"タッチ移動"| ONINPUTMOVE
    UPDATE -.->|"タッチ終了"| ONINPUTUP
    UPDATE -.->|"一時停止時"| ONPAUSE
    ONPAUSE -.->|"再開時"| ONRESUME
    UPDATE -.->|"ライフ0"| ONGAMEOVER
    UPDATE -.->|"ノート判定時"| ONHIT
    UPDATE -.->|"ノートミス時"| ONMISS
    UPDATE -.->|"ノート生成時"| ONSPAWN
    UPDATE -.->|"ロング生成時"| ONSPAWNLONG
```



### ライフサイクルコールバックリファレンス 

| コールバック | パラメータ | 説明 | タイミング |
| --- | --- | --- | --- |
| `onloaded()` | なし | スクリプト読込直後、ゲームプレイ開始前に呼ばれる | 初期化中 |
| `start()` | なし | すべてのシステムが初期化された後、ゲームプレイ開始時に呼ばれる | ゲームプレイ開始時 |
| `update()` | なし | ゲームプレイ中の毎フレーム呼ばれる | 毎フレーム |
| `finish()` | なし | 楽曲終了時またはゲーム停止時に呼ばれる | ゲームプレイ終了時 |
| `ondestroy()` | なし | シーンが破棄される時に呼ばれる | シーンクリーンアップ時 |
| `onHitNote(id, lane, noteType, judge, isAttack)` | `int id`, `int lane`, `int noteType`, `int judge`, `bool isAttack` | プレイヤーがノートを叩いた時に呼ばれる | ノート判定時 |
| `onMissedNote(id, lane, noteType)` | `int id`, `int lane`, `int noteType` | プレイヤーがノートを外した時に呼ばれる | ノートミス時 |
| `onSpawnNote(noteController)` | `NoteController noteController` | ノートが生成された時に呼ばれる | ノート生成時 |
| `onSpawnLong(longController)` | `LongController longController` | ロングノートが生成された時に呼ばれる | ロングノート生成時 |
| `onPause()` | なし | ゲームが一時停止された時に呼ばれる | 一時停止時 |
| `onResume()` | なし | 一時停止から再開された時に呼ばれる | 再開時 |
| `onGameOver()` | なし | プレイヤーが失敗した時（ライフが0）に呼ばれる | ゲームオーバー時 |
| `onInputDown(touchId, posX, screenPosX, screenPosY)` | `int touchId`, `float posX`, `float screenPosX`, `float screenPosY` | タッチ/クリック開始時に呼ばれる | 入力開始時 |
| `onInputMove(touchId, posX, screenPosX, screenPosY)` | `int touchId`, `float posX`, `float screenPosX`, `float screenPosY` | タッチ/クリック移動時に呼ばれる | 入力移動時 |
| `onInputUp(touchId, posX, screenPosX, screenPosY)` | `int touchId`, `float posX`, `float screenPosX`, `float screenPosY` | タッチ/クリック終了時に呼ばれる | 入力終了時 |



 

---

## GAMESTATE API 

`GAMESTATE`オブジェクトは、ノート速度、判定エリア、ビジュアルエフェクト、ノート挙動などのコアゲームプレイメカニクスの制御を提供します。

```mermaid
flowchart TD

TIMING["タイミング関数 GetSongTime() GetSongBeat() TimeToBeat() BeatToTime()"]
SPEED["速度制御 SetSpeed() SetDistance() SetOffsetZ() SetVisibleRate()"]
VISUAL["ビジュアル設定 SetLaneAlpha() ChangeJudgeEffect() ChangeHoldTexture() SetLaneSeparateColor()"]
BEHAVIOR["ノート挙動 SetAutoType() SetLongEndType() ChangeFuzzyToTapJudge() RemoveSameTimeBar()"]
STATE["ゲーム状態 GetPlayMode() GetMusicRate() GetCurrentJudge() GetNotes()"]
GAMESTATE["GAMESTATE API"]

GAMESTATE -.-> TIMING
GAMESTATE -.-> SPEED
GAMESTATE -.-> VISUAL
GAMESTATE -.-> BEHAVIOR
GAMESTATE -.-> STATE

subgraph GAMESTATEコア機能 ["GAMESTATEコア機能"]
    TIMING
    SPEED
    VISUAL
    BEHAVIOR
    STATE
end
```

### タイミングとビート変換メソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetSongTime()` | `double` | 現在の楽曲再生時間（秒） |
| `GetSongBeat()` | `double` | 現在のビート位置（BPM対応） |
| `GetMusicRate()` | `float` | 楽曲再生レート（1.0 = 通常速度） |
| `GetVisibleBeat()` | `float` | 画面に表示されるビート数 |
| `GetVisibleTime()` | `double` | ノートが表示される秒数 |
| `TimeToBeat(musicTime)` | `double` | 時間（秒）をビート位置に変換（BPM対応） |
| `BeatToTime(beat)` | `double` | ビート位置を時間（秒）に変換（BPM対応） |



### 速度と距離制御メソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `SetSpeed(speed, duration, ease)` | `float speed`, `float duration`（オプション）, `string ease`（オプション） | ノートスクロール速度倍率を設定。イージングで指定期間かけてトゥイーン可能 |
| `SetDistance(distance, isSafeAuto)` | `float distance`, `bool isSafeAuto`（デフォルト: true） | 判定エリア幅倍率を設定 |
| `SetOffsetZ(offsetZ)` | `float offsetZ` | 判定位置のZ軸オフセットを設定（ノートを前後に移動） |
| `SetVisibleRate(rate)` | `float rate` | ノート生成タイミングを倍率で変更（最小0.2秒） |
| `SetNotesScrollType(type)` | `int type` | スクロールタイプを設定：0 = 等速、1 = 減速（デフォルト） |



### ビジュアルエフェクト制御メソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `SetLaneAlpha(alpha)` | `float alpha` | レーンの透明度を設定（0-1） |
| `ChangeJudgeEffect(type)` | `int type` | 判定エフェクトタイプを変更：0=なし、1=Type1、2=Type2、3=Type3 |
| `ChangeHoldTexture(noteType, texture)` | `NoteType`/`int noteType`, `Texture texture` | 特定タイプのホールドノートテクスチャを変更 |
| `ResetHoldTexture()` | なし | ホールドテクスチャをデフォルトにリセット |
| `SetLaneSeparateColor(color)` | `Color color` | レーン区切り線の色を設定 |
| `SetNoteEffectCancelType(cancelType)` | `int cancelType` | ノートエフェクトキャンセルを設定：0=なし、1=レーン別、2=X位置別 |



### ノート挙動制御メソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `SetAutoType(type)` | `int type` | オートプレイタイプを設定：0=固定レーン、1=ノートX位置に追従 |
| `SetActiveSameTimeBar(isActive)` | `bool isActive` | 同時押し線の表示を切り替え |
| `RemoveSameTimeBar(index)` | `int index` | 特定のノート番号の同時押し線を削除 |
| `SetLongEndType(type)` | `int type` | ロングノート終端挙動を設定：0=通常、1=ファジー音あり、2=ファジー音なし |
| `SetFuzzyLongEndType(type)` | `int type` | ファジーロング終端タイプを設定：0=通常、1=音なし |
| `ChangeFuzzyToTapJudge(isTap)` | `bool isTap` | ファジーノートをタップ判定に変更 |



### 状態取得メソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetPlayMode()` | `int` | プレイモードを返す：0=通常、1=オート、2=リハーサル、3=オンライン |
| `GetCurrentJudge(hasPerfect)` | `Judge` | 現在の判定カウントを返す。`hasPerfect=false`の場合、PerfectをBrilliantにマージ |
| `GetNotes()` | `Note[]` | すべてのノートの配列を返す（ビート位置、レーン、タイプ、アタックフラグ） |
| `GetNoteOffset()` | `float` | 直近の判定済みノートのタイミングオフセットを返す（`onHitNote`内で使用） |



---

## SONGMAN API 

`SONGMAN`オブジェクトは楽曲メタデータと譜面情報への読み取り専用アクセスを提供します。

### 楽曲メタデータメソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetTitle()` | `string` | 楽曲タイトル |
| `GetSubtitle()` | `string` | 楽曲サブタイトル |
| `GetArtist()` | `string` | アーティスト名 |
| `GetIllust()` | `string` | イラストレーター名 |
| `GetChartArtist()` | `string` | 譜面制作者名 |
| `GetDescription()` | `string[]` | 説明行の配列 |
| `GetBannerPath()` | `string` | ジャケット/バナー画像へのパス |
| `GetBackgroundPath()` | `string` | 背景画像へのパス |
| `GetSongDir()` | `string` | 楽曲のディレクトリパス |



### 譜面データメソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetDifficulty()` | `DifficultyType` | 難易度タイプ列挙型（Easy/Normal/Hard/Extra/Lunatic） |
| `GetDifficultyToInt()` | `int` | 難易度を整数で：0=Easy、1=Normal、2=Hard、3=Extra、4=Lunatic |
| `GetMeter()` | `int` | 数値難易度レベル |
| `GetMeterName()` | `string` | 難易度名を文字列で（"X"などの特殊値を処理） |
| `GetBaseBpm()` | `float` | 譜面の基準BPM |
| `GetBpmPositions()` | `float[]` | BPM変化が発生するビート位置 |
| `GetBpms()` | `float[]` | 位置に対応するBPM値 |
| `GetOffset()` | `float` | オーディオオフセット（秒） |
| `IsCmod()` | `bool` | C-Mod（等速スクロール）が有効かどうか |
| `MusicLengthSeconds()` | `double` | 楽曲の総時間（秒） |



### 譜面ギミックデータメソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetSpeedPositions()` | `float[]` | 速度ギミックが発生するビート位置 |
| `GetSpeedStretchRatios()` | `float[]` | 速度倍率値 |
| `GetSpeedDelayBeats()` | `float[]` | 各速度変化の遷移時間（ビート） |
| `GetScrollPositions()` | `float[]` | スクロールギミックが発生するビート位置 |
| `GetScrolls()` | `double[]` | スクロール倍率値 |
| `GetLabelPositions()` | `float[]` | ラベルのビート位置 |
| `GetLabels()` | `string[]` | ラベルのテキスト値 |



### ノートデータメソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetBeatPositions()` | `List<float>` | 譜面内のすべてのノートのビート位置 |
| `GetLanes()` | `List<int>` | すべてのノートのレーン番号（0-7） |
| `GetNoteTypes()` | `List<NoteType>` | すべてのノートのタイプ列挙型 |



---

## PLAYERSTATS API 

`PLAYERSTATS`オブジェクトはゲームプレイ中のプレイヤー状態とプレイヤー設定オプションへのアクセスを提供します。

### プレイヤー状態メソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetCurrentCombo()` | `int` | 現在のアクティブなコンボ数 |
| `MaxCombo()` | `int` | これまでに達成した最大コンボ |
| `IsFullCombo()` | `bool` | フルコンボを達成したか |
| `GetCurrentLife()` | `float` | 現在のライフパーセンテージ（0-1） |
| `SetLife(life)` | なし | 現在のライフ値を設定（0-1） |
| `IsDanger()` | `bool` | ライフが危険域かどうか |
| `IsDead()` | `bool` | プレイヤーが失敗したか |
| `GetScore()` | `int` | 現在のスコア |
| `GetGrade()` | `int` | 現在のグレード/ランク（0=S+、1=S、2=A、3=B、4=C、5=D） |



### プレイヤーオプションメソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetNotesOptions()` | `NotesOption` | ノーツ設定のディープコピー（サイズ、スキン、速度など） |
| `GetNotesOptionsJson()` | `string` | ノーツ設定をJSON文字列で |
| `GetDisplayOptions()` | `DisplayOption` | 表示設定のディープコピー |
| `GetDisplayOptionsJson()` | `string` | 表示設定をJSON文字列で |
| `GetVolumeOptions()` | `VolumeOption` | 音量設定のディープコピー |
| `GetVolumeOptionsJson()` | `string` | 音量設定をJSON文字列で |
| `GetJudgeTimeOptions()` | `JudgeTimeOption` | タイミング/判定設定のディープコピー |
| `GetJudgeTimeOptionsJson()` | `string` | タイミング設定をJSON文字列で |
| `GetNoteSpeedOption()` | `float` | ノート速度（HiSpeed）設定 |
| `GetNoteSizeOption()` | `float` | ノートサイズ倍率設定 |
| `IsMirrorOption()` | `bool` | ミラーモードが有効かどうか |



### アセットアクセスメソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetNoteTexture(type)` | `Texture` | 指定されたノートタイプのテクスチャを返す（`NoteType`または`int`を受け付ける） |
| `GetLongTexture(type)` | `Texture` | 指定されたロングノートタイプのテクスチャを返す（`LongType`または`int`を受け付ける） |



### 高度なメソッド 

| メソッド | パラメータ | 戻り値 | 説明 |
| --- | --- | --- | --- |
| `SetJudgeAreaType(type)` | `int type` | なし | 判定エリアタイプを設定：0=Screen、1=World |
| `UpdateScreenJudgeLine()` | なし | なし | カメラ移動後にスクリーン空間判定ラインを更新 |
| `GetHighScore()` | なし | `HighScore`または`nil` | 存在する場合ハイスコアデータを返す（Score、MaxCombo、ClearState、Rank） |
| `GetCurrentLanguage()` | なし | `string` | 現在のロケールコードを返す（"ja"、"en"など） |



---

## SCREENMAN API 

`SCREENMAN`オブジェクトは画面表示、背景管理、UIメッセージングを制御します。

### 表示情報メソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetScreenWidth()` | `int` | 画面幅（ピクセル） |
| `GetScreenHeight()` | `int` | 画面高さ（ピクセル） |
| `GetDpi()` | `float` | 画面DPI |



### キャンバスアクセスメソッド 

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetOverlayCanvas()` | `Canvas` | Overlayモードキャンバスを返す |
| `GetLuaOverlayCanvas()` | `Canvas` | Lua専用オーバーレイキャンバスを返す |
| `GetCameraCanvas()` | `Canvas` | Cameraモードキャンバスを返す |



### デバッグメッセージメソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `SystemMessage(message)` | `string` / `double` / `object` | 画面上部に一時的なメッセージを表示し、コンソールにログ出力 |



### 背景制御メソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `LoadBgChangeImages(names)` | `List<string>` / `string[]` / `string` | 後で使用するための背景画像を事前読込 |
| `ChangeBgImage(name)` | `string name` | 事前読込した画像に背景を変更 |
| `ResetBgImage()` | なし | 背景をデフォルト（BACKGROUNDタグの値）にリセット |
| `SetBgMaterial(material)` | `Material material` | 背景にカスタムマテリアルを適用 |
| `ResetBgMaterial()` | なし | 背景マテリアルをデフォルトにリセット |
| `SetBgDimmer(dimmer)` | `float dimmer`（0-1） | 背景の暗さを設定 |



### キャンバス順序メソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `SetSiblingLuaOverlayCanvas(isFirst)` | `bool isFirst` | Luaオーバーレイキャンバスのレンダリング順序を設定：true=背面、false=前面（デフォルト） |
| `HideLuaOverlayCanvas()` | なし | Luaオーバーレイキャンバスを無効化 |



---

## UTIL API 

`UTIL`オブジェクトはテクスチャ読込、座標変換、トゥイーン、タイミングなどの一般的なタスクのためのユーティリティ関数を提供します。

```mermaid
flowchart TD

TEXTURE["テクスチャ関数 LoadTexture() CreateSprite() CreateMultiSprite()"]
TWEEN["トゥイーン関数 TweenPosition() TweenRotation() TweenScale() KillTween()"]
COORD["座標変換 PolarToCartesian() CartesianToPolar()"]
CALC["ノート計算 CalculateBeatToNotePositionZ() CalculateTimeToNotePositionZ() CalculateNoteRotation() CalculateScrolledBeat()"]
TIMING["タイミング関数 DelayAction() DelayFrameAction()"]
MATERIAL["マテリアル関数 CreateMaterial() ShaderPropertyToID()"]
AUDIO["オーディオ解析 GetSpectrumData()"]
UTIL["UTIL API"]

UTIL -.-> TEXTURE
UTIL -.-> TWEEN
UTIL -.-> COORD
UTIL -.-> CALC
UTIL -.-> TIMING
UTIL -.-> MATERIAL
UTIL -.-> AUDIO

subgraph UTIL機能 ["UTIL機能"]
    TEXTURE
    TWEEN
    COORD
    CALC
    TIMING
    MATERIAL
    AUDIO
end
```

### テクスチャとスプライトメソッド 

| メソッド | パラメータ | 戻り値 | 説明 |
| --- | --- | --- | --- |
| `LoadTexture(fileName)` | `string fileName` | `Texture2D` | 譜面フォルダからテクスチャを読込 |
| `CreateSprite(texture)` | `Texture2D texture` | `Sprite` | テクスチャからスプライトを作成 |
| `CreateMultiSprite(texture, hCount, vCount)` | `Texture2D texture`, `int hCount`, `int vCount` | `Sprite[]` | テクスチャをグリッドに分割してスプライト配列を作成（左下から右上の順） |



### マテリアルとシェーダーメソッド 

| メソッド | パラメータ | 戻り値 | 説明 |
| --- | --- | --- | --- |
| `CreateMaterial(shader)` | `Shader shader` | `Material` | 指定されたシェーダーで新しいマテリアルインスタンスを作成 |
| `ShaderPropertyToID(propertyName)` | `string propertyName` | `int` | シェーダープロパティ名を効率的な整数IDに変換 |



### 座標変換メソッド 

| メソッド | パラメータ | 戻り値 | 説明 |
| --- | --- | --- | --- |
| `PolarToCartesian(radius, declination)` | `float radius`, `float declination` | `Vector2` | 極座標（半径、角度（度））をデカルト座標（x、y）に変換 |
| `CartesianToPolar(x, y)` | `float x`, `float y` | `Vector2` | デカルト座標を極座標（半径、角度（度））に変換 |



### ノート位置計算メソッド 

| メソッド | パラメータ | 戻り値 | 説明 |
| --- | --- | --- | --- |
| `CalculateBeatToNotePositionZ(beat)` | `double beat` | `float` | 判定までのビート数からノートのZ位置を計算（C-Mod対応） |
| `CalculateTimeToNotePositionZ(time)` | `double time` | `float` | 判定までの秒数からノートのZ位置を計算 |
| `CalculateNoteRotation(positionZ)` | `float positionZ` | `Quaternion` | Z位置に基づいてノートの回転を計算 |
| `CalculateScrolledBeat(beat)` | `double beat` | `double` | ビート位置にスクロールギミックを適用 |



### トゥイーンアニメーションメソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `TweenPosition(tr, pos, duration, ease, onComplete)` | `Transform`, `Vector3`, `float`, `string`, `Action` | ワールド座標へトゥイーン |
| `TweenLocalPosition(tr, pos, duration, ease, onComplete)` | `Transform`, `Vector3`, `float`, `string`, `Action` | ローカル座標へトゥイーン |
| `TweenRotation(tr, rot, duration, ease, onComplete)` | `Transform`, `Vector3`, `float`, `string`, `Action` | ワールド回転へトゥイーン（Vector3版） |
| `TweenRotateQuaternion(tr, rot, duration, ease, onComplete)` | `Transform`, `Quaternion`, `float`, `string`, `Action` | ワールド回転へトゥイーン（Quaternion版） |
| `TweenLocalRotation(tr, rot, duration, ease, onComplete)` | `Transform`, `Vector3`, `float`, `string`, `Action` | ローカル回転へトゥイーン（Vector3版） |
| `TweenLocalRotateQuaternion(tr, rot, duration, ease, onComplete)` | `Transform`, `Quaternion`, `float`, `string`, `Action` | ローカル回転へトゥイーン（Quaternion版） |
| `TweenScale(tr, scale, duration, ease, onComplete)` | `Transform`, `Vector3`, `float`, `string`, `Action` | スケールをトゥイーン |
| `KillTween(tr, complete)` | `Transform`, `bool` | Transformのすべてのトゥイーンを停止 |

**サポートされているイージング文字列:** `"Linear"`, `"InSine"`, `"OutSine"`, `"InOutSine"`, `"InQuad"`, `"OutQuad"`, `"InOutQuad"`, `"InCubic"`, `"OutCubic"`, `"InOutCubic"`, `"InQuart"`, `"OutQuart"`, `"InOutQuart"`, `"InQuint"`, `"OutQuint"`, `"InOutQuint"`, `"InExpo"`, `"OutExpo"`, `"InOutExpo"`, `"InCirc"`, `"OutCirc"`, `"InOutCirc"`, `"InElastic"`, `"OutElastic"`, `"InOutElastic"`, `"InBack"`, `"OutBack"`, `"InOutBack"`, `"InBounce"`, `"OutBounce"`, `"InOutBounce"`, `"Flash"`, `"InFlash"`, `"OutFlash"`, `"InOutFlash"`



 

### オーディオ解析メソッド 

| メソッド | パラメータ | 戻り値 | 説明 |
| --- | --- | --- | --- |
| `GetSpectrumData(size, channel, fftWindow)` | `int size`, `int channel`, `FFTWindow fftWindow` | `float[]` | 現在のオーディオからFFTスペクトルデータを返す |



### 遅延実行メソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `DelayAction(millisecond, action)` | `float millisecond`, `Action action` | 指定ミリ秒後にLua関数を実行 |
| `DelayFrameAction(frame, action)` | `int frame`, `Action action` | 指定フレーム数後にLua関数を実行 |



---

## ACTORFACTORY API 

`ACTORFACTORY`オブジェクトは独自のLuaスクリプトを実行でき、ビジュアル/オーディオ要素を表現できるActorインスタンスを作成します。

### Actor作成メソッド 

| メソッド | パラメータ | 戻り値 | 説明 |
| --- | --- | --- | --- |
| `Create2D(luaFileName, hasInjection)` | `string`（オプション）, `bool`（デフォルト: true） | `Actor2D` | オプションのLuaスクリプト付き2Dスプライトアクターを作成 |
| `CreateAudio(luaFileName)` | `string`（オプション） | `ActorAudio` | オプションのLuaスクリプト付きオーディオアクターを作成 |
| `CreateUIText(luaFileName)` | `string`（オプション） | `ActorUIText` | オプションのLuaスクリプト付きUIテキストアクターを作成 |
| `CreateVideoCanvas(luaFileName)` | `string`（オプション） | `ActorVideoCanvas` | オプションのLuaスクリプト付きビデオ再生アクターを作成 |



### Actorタイプ比較 

```mermaid
flowchart TD

ACTOR2D["Actor2D SpriteRenderer ワールド空間の2Dスプライト"]
ACTORAUDIO["ActorAudio AudioSource カスタム音声ファイルを再生"]
ACTORUITEXT["ActorUIText TextMeshProUGUI UIテキスト要素"]
ACTORVIDEO["ActorVideoCanvas VideoPlayer + RawImage ビデオ再生"]
ACTORFACTORY["ACTORFACTORY.CreateXXX()"]

ACTORFACTORY -.-> ACTOR2D
ACTORFACTORY -.-> ACTORAUDIO
ACTORFACTORY -.-> ACTORUITEXT
ACTORFACTORY -.-> ACTORVIDEO

subgraph Actorタイプ ["Actorタイプ"]
    ACTOR2D
    ACTORAUDIO
    ACTORUITEXT
    ACTORVIDEO
end
```



---

## Actor基底クラス 

すべてのActorタイプは共通のライフサイクルコールバックを共有し、オプションでメインの譜面スクリプトとは別に独自のLuaスクリプトを実行できます。

### Actorライフサイクルコールバック 

ActorがLuaスクリプトファイル付きで作成された場合、そのスクリプトは以下のコールバックを実装できます：

| コールバック | 説明 |
| --- | --- |
| `onloaded()` | アクターのスクリプト読込直後に呼ばれる |
| `start()` | ゲームプレイ開始時に呼ばれる |
| `update()` | 毎フレーム呼ばれる |
| `finish()` | ゲームプレイ終了時に呼ばれる |
| `ondestroy()` | アクターが破棄される時に呼ばれる |
| `onHitNote(id, lane, noteType, judge, isAttack)` | プレイヤーがノートを叩いた時に呼ばれる |
| `onMissedNote(id, lane, noteType)` | プレイヤーがノートを外した時に呼ばれる |
| `onSpawnNote(noteController)` | ノートが生成される時に呼ばれる |
| `onSpawnLong(longController)` | ロングノートが生成される時に呼ばれる |
| `onPause()` | ゲーム一時停止時に呼ばれる |
| `onResume()` | ゲーム再開時に呼ばれる |
| `onGameOver()` | ゲームオーバー時に呼ばれる |
| `onInputDown(touchId, posX, screenPosX, screenPosY)` | 入力開始時に呼ばれる |
| `onInputMove(touchId, posX, screenPosX, screenPosY)` | 入力移動時に呼ばれる |
| `onInputUp(touchId, posX, screenPosX, screenPosY)` | 入力終了時に呼ばれる |



---

## Actor2D固有メソッド 

`Actor2D`タイプはUnityのSpriteRendererを使用してワールド空間の2Dスプライトを表します。

| メソッド | 戻り値 | 説明 |
| --- | --- | --- |
| `GetSpriteRenderer()` | `SpriteRenderer` | スプライトレンダラーコンポーネントを返す |
| `GetTransform()` | `Transform` | トランスフォームコンポーネントを返す |



より参照

---

## ActorAudio固有メソッド 

`ActorAudio`タイプはAudioSourceコンポーネントを通じてオーディオ再生を管理します。

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `LoadAudio(filePath, onComplete)` | `string filePath`, `Action onComplete`（オプション） | 譜面フォルダから音声ファイルを読込 |
| `GetAudioSource()` | なし | AudioSourceコンポーネントを返す |
| `GetTransform()` | なし | トランスフォームコンポーネントを返す |
| `SetVolume(volume)` | `float volume`（0-1） | オーディオ音量を設定 |
| `SetSystemSEVolume()` | なし | 音量をシステムSEレベルに設定 |
| `SetTouchSEVolume()` | なし | 音量をタッチSEレベルに設定 |
| `SetMusicVolume()` | なし | 音量を楽曲レベルに設定 |
| `Play()` | なし | オーディオ再生を開始 |
| `Stop()` | なし | オーディオ再生を停止 |
| `Pause()` | なし | オーディオ再生を一時停止 |

---

## ActorVideoCanvas固有メソッド 

`ActorVideoCanvas`タイプは楽曲と同期したビデオ再生を管理します。

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `SetVideoPath(filePath)` | `string filePath` | ビデオファイルパス（譜面フォルダからの相対パス）を設定し、再生準備 |
| `GetVideoPlayer()` | なし | VideoPlayerコンポーネントを返す |
| `GetRawImage()` | なし | ビデオを表示するRawImageコンポーネントを返す |
| `SetOffsetTime(offsetTime)` | `double offsetTime` | ビデオ同期時間を楽曲に対してオフセット（秒） |
| `SetBrightness(brightness)` | `float brightness`（0-1） | ビデオの明るさを設定 |
| `SetAlpha(alpha)` | `float alpha`（0-1） | ビデオの透明度を設定 |
| `SetFinishCallBack(function)` | `Action function` | ビデオ完了時のコールバックを設定 |
| `Play()` | なし | ビデオ再生を開始 |
| `Pause()` | なし | ビデオ再生を一時停止 |
| `Stop()` | なし | ビデオ再生を停止 |
| `SetScreenMatchMode(mode)` | `int mode` | フィッティングモードを設定：0=画面内に収める、1=画面を埋める |
| `SetAutoMusicSync(isAuto)` | `bool isAuto` | 自動楽曲同期を有効/無効化（デフォルト: true） |
| `SetExternalReferenceTime(time)` | `double time` | ビデオ再生時間を手動設定（自動同期オフ時） |

---

## 特殊な型と列挙型 

### Note Type列挙型 

コールバックとクエリでノートタイプを識別するために使用：

```
NoteType.Tap = 0
NoteType.Long = 1
NoteType.Flick = 2
NoteType.Attack = 3
NoteType.FuzzyLong = 4
NoteType.Fuzzy = 5
```

### Difficulty Type列挙型 

```
DifficultyType.Easy = 0
DifficultyType.Normal = 1
DifficultyType.Hard = 2
DifficultyType.Extra = 3
DifficultyType.Lunatic = 4
```

### Judge Type列挙型 

`onHitNote`コールバックで使用：

```
JudgeType.Brilliant = 0
JudgeType.Perfect = 1
JudgeType.Great = 2
JudgeType.Good = 3
JudgeType.Bad = 4
JudgeType.Miss = 5
```

### Judge構造体 

`GAMESTATE.GetCurrentJudge()`によって返される：

```
judge.Brilliant  -- int: Brilliant数
judge.Perfect    -- int: Perfect数
judge.Great      -- int: Great数
judge.Good       -- int: Good数
judge.Bad        -- int: Bad数
judge.Miss       -- int: Miss数
```

### Note構造体 

`GAMESTATE.GetNotes()`によって返される：

```
note.BeatPosition  -- float: ビート位置
note.Lane         -- int: レーン番号（0-7）
note.NoteType     -- NoteType: ノートのタイプ
note.IsAttack     -- bool: アタックノートかどうか
```



### HighScore構造体 

`PLAYERSTATS.GetHighScore()`によって返される：

```
highScore.Score       -- int: スコア値
highScore.MaxCombo    -- int: 最大コンボ
highScore.ClearState  -- int: 0=GameOver、1=Clear、2=FullCombo、3=AllBrilliant
highScore.Rank        -- int: 0=S+、1=S、2=A、3=B、4=C、5=D
```



---

## APIバージョンの注記 

一部のメソッドには、追加された時期を示すAPIバージョンコメントが含まれています：

* **API ver1.6**: `SetVisibleRate()`
* **API ver1.7**: `SetLongEndType()`
* **API ver1.8**: `GetNotes()`
* **API ver1.9**: `GetNoteOffset()`
* **API ver2.0**: `CalculateScrolledBeat()`
* **API ver2.2**: `SetLaneSeparateColor()`, `RemoveSameTimeBar()`
* **API ver2.3**: `ChangeFuzzyToTapJudge()`, `GetLabelPositions()`, `GetLabels()`
* **API ver2.4**: `SetNoteEffectCancelType()`, `IsCmod()`
* **API ver2.5**: `GetCurrentJudge()`
* **API ver2.6**: `GetMeterName()`
* **API ver2.7**: `SetSiblingLuaOverlayCanvas()`

---

## API構成図 

```mermaid
flowchart TD

%% ===== メインスクリプト =====
MAIN["main.lua（譜面スクリプト）"]

%% ===== グローバルAPI =====
GAMESTATE_OBJ["GAMESTATE ゲームプレイ制御"]
SONGMAN_OBJ["SONGMAN 譜面メタデータ"]
PLAYERSTATS_OBJ["PLAYERSTATS プレイヤー状態"]
SCREENMAN_OBJ["SCREENMAN UI制御"]
UTIL_OBJ["UTIL ユーティリティ"]
ACTORFACTORY_OBJ["ACTORFACTORY Actor作成"]

%% ===== Actorインスタンス =====
ACTOR2D_INST["Actor2D actor.lua"]
ACTORAUDIO_INST["ActorAudio audio.lua"]
ACTORTEXT_INST["ActorUIText text.lua"]
ACTORVIDEO_INST["ActorVideoCanvas video.lua"]

%% ===== Unity側 =====
MGSC["MusicGameSceneController"]
MUSICGAME["MusicGame"]
JUDGES["JudgeManager"]
LIFEMGR["LifeManager"]
SCOREMGR["ScoreManager"]

%% ===== main.lua → API =====
MAIN -->|"アクセス"| GAMESTATE_OBJ
MAIN -->|"アクセス"| SONGMAN_OBJ
MAIN -->|"アクセス"| PLAYERSTATS_OBJ
MAIN -->|"アクセス"| SCREENMAN_OBJ
MAIN -->|"生成"| UTIL_OBJ
MAIN -->|"生成"| ACTORFACTORY_OBJ

%% ===== Actor生成 =====
ACTORFACTORY_OBJ -->|"生成"| ACTOR2D_INST
ACTORFACTORY_OBJ -->|"生成"| ACTORAUDIO_INST
ACTORFACTORY_OBJ -->|"生成"| ACTORTEXT_INST
ACTORFACTORY_OBJ -->|"生成"| ACTORVIDEO_INST

%% ===== Unity → Lua =====
MGSC -->|"実行"| MAIN
MUSICGAME -->|"制御"| MAIN
JUDGES -->|"クエリ"| MAIN

%% ===== サブグラフ =====
subgraph メインスクリプトコンテキスト ["メインスクリプト"]
    MAIN
end

subgraph グローバルAPIオブジェクト ["グローバルAPI"]
    GAMESTATE_OBJ
    SONGMAN_OBJ
    PLAYERSTATS_OBJ
    SCREENMAN_OBJ
    UTIL_OBJ
    ACTORFACTORY_OBJ
end

subgraph Actorインスタンス ["Actorインスタンス"]
    ACTOR2D_INST
    ACTORAUDIO_INST
    ACTORTEXT_INST
    ACTORVIDEO_INST
end

subgraph Unityコンポーネント ["Unityコンポーネント"]
    MGSC
    MUSICGAME
    JUDGES
    LIFEMGR
    SCOREMGR
end

```

### On this page

* [Lua APIリファレンス](#7.3-lua-api)
* [目的と範囲](#7.3-)
* [APIアーキテクチャの概要](#7.3-api)
* [グローバルAPIオブジェクト一覧](#7.3-api-1)
* [ライフサイクルコールバック](#7.3--1)
* [ライフサイクルコールバックリファレンス](#7.3--2)
* [GAMESTATE API](#7.3-gamestate-api)
* [タイミングとビート変換メソッド](#7.3--3)
* [速度と距離制御メソッド](#7.3--4)
* [ビジュアルエフェクト制御メソッド](#7.3--5)
* [ノート挙動制御メソッド](#7.3--6)
* [状態取得メソッド](#7.3--7)
* [SONGMAN API](#7.3-songman-api)
* [楽曲メタデータメソッド](#7.3--8)
* [譜面データメソッド](#7.3--9)
* [譜面ギミックデータメソッド](#7.3--10)
* [ノートデータメソッド](#7.3--11)
* [PLAYERSTATS API](#7.3-playerstats-api)
* [プレイヤー状態メソッド](#7.3--12)
* [プレイヤーオプションメソッド](#7.3--13)
* [アセットアクセスメソッド](#7.3--14)
* [高度なメソッド](#7.3--15)
* [SCREENMAN API](#7.3-screenman-api)
* [表示情報メソッド](#7.3--16)
* [キャンバスアクセスメソッド](#7.3--17)
* [デバッグメッセージメソッド](#7.3--18)
* [背景制御メソッド](#7.3--19)
* [キャンバス順序メソッド](#7.3--20)
* [UTIL API](#7.3-util-api)
* [テクスチャとスプライトメソッド](#7.3--21)
* [マテリアルとシェーダーメソッド](#7.3--22)
* [座標変換メソッド](#7.3--23)
* [ノート位置計算メソッド](#7.3--24)
* [トゥイーンアニメーションメソッド](#7.3--25)
* [オーディオ解析メソッド](#7.3--26)
* [遅延実行メソッド](#7.3--27)
* [ACTORFACTORY API](#7.3-actorfactory-api)
* [Actor作成メソッド](#7.3-actor)
* [Actorタイプ比較](#7.3-actor-1)
* [Actor基底クラス](#7.3-actor-2)
* [Actorライフサイクルコールバック](#7.3-actor-3)
* [Actor2D固有メソッド](#7.3-actor2d)
* [ActorAudio固有メソッド](#7.3-actoraudio)
* [ActorVideoCanvas固有メソッド](#7.3-actorvideocanvas)
* [特殊な型と列挙型](#7.3--28)
* [Note Type列挙型](#7.3-note-type)
* [Difficulty Type列挙型](#7.3-difficulty-type)
* [Judge Type列挙型](#7.3-judge-type)
* [Judge構造体](#7.3-judge)
* [Note構造体](#7.3-note)
* [HighScore構造体](#7.3-highscore)
* [APIバージョンの注記](#7.3-api-2)
* [API構成図](#7.3-api-3)

