

# Luaスクリプトシステム 

## 目的と範囲 

LuaスクリプトシステムはXLua統合ライブラリを通じて譜面にランタイム拡張性を提供します。譜面制作者はLuaスクリプトを記述して、カスタムビジュアルエフェクト、ゲームプレイの変更、動的カメラ移動、およびベースリズムゲームメカニクスを超えたインタラクティブ要素を実装できます。このシステムは包括的なC# APIをLuaスクリプトに公開し、スクリプトのライフサイクルを管理し、Actorベースのゲームオブジェクトを処理し、自動シーン復旧を伴うエラーハンドリングを提供します。

統合レイヤーの具体的な実装詳細については、[Lua統合アーキテクチャ](#7.1)を参照してください。Actorオブジェクトシステムについては、[アクターシステム](#7.2)を参照してください。完全なAPIドキュメントについては、[Lua APIリファレンス](#7.3)を参照してください。Luaコールバックを呼び出すコアゲームループについては、[ゲームループとシーンコントローラー](#3.1)を参照してください。

## システムアーキテクチャ 

Luaスクリプトシステムは、ゲームプレイシーン内で並列実行レイヤーとして動作し、コアゲームループからコールバックを受信し、LuaスクリプトとC#ゲームシステム間の双方向通信を提供します。

### 統合概要 

```mermaid
flowchart TD

MGSC["MusicGameSceneController"]
MG["MusicGame (ゲームループ)"]
MM["MusicManager"]
JUDGE["JudgeManager"]
SCORE["ScoreManager"]
COMBO["ComboManager"]
LIFE["LifeManager"]
INPUT["InputBase"]
POOLS["オブジェクトプール"]
LM["LuaManager (スクリプトオーケストレータ)"]
ENV["LuaEnv (XLua環境)"]
SCRIPT["譜面Luaスクリプト"]
GS["GAMESTATE (GameState)"]
SM["SONGMAN (SongMan)"]
PS["PLAYERSTATS (PlayerStats)"]
SCM["SCREENMAN (ScreenMan)"]
UTIL["UTIL (Util)"]
AF["ACTORFACTORY (ActorFactory)"]
ACTORS["Actorインスタンス (Actor2D, ActorAudio等)"]

MGSC -.->|"毎フレームCallUpdate"| LM
MG -.->|"OnHitNote/OnMissedNote"| LM
MG -.->|"SetSpeed/Distance/OffsetZ"| LM
MG -.->|"ノート生成"| LM
MG -.->|"OnInputDown/Move/Up"| LM
GS -.->|"読込・実行"| MG
GS -.->|"生成"| MM
PS -.->|"データ読込"| SCORE
PS -.-> COMBO
PS -.-> LIFE

subgraph subGraph2 ["Lua Scripting Layer"]
    LM
    ENV
    SCRIPT
    ACTORS
    LM -.->|"update()"| ENV
    ENV -.->|"メソッド呼出"| SCRIPT
    SCRIPT -.->|"データ読込"| GS
    SCRIPT -.->|"データ読込"| SM
    SCRIPT -.->|"メソッド呼出"| PS
    SCRIPT -.->|"メソッド呼出"| SCM
    SCRIPT -.->|"データ読込"| UTIL
    SCRIPT -.->|"メソッド呼出"| AF
    AF -.->|"インスタンス化"| ACTORS
    LM -.->|"メソッド呼出"| SCRIPT
    LM -.->|"onSpawnNote/onSpawnLong"| ACTORS
    LM -.->|"onHitNote/onMissedNote"| SCRIPT
    LM -.->|"Create2D/CreateAudio"| ACTORS
    LM -.->|"データ読込"| SCRIPT
    LM -.->|"onInputDown/Move/Up"| SCRIPT
    SM -.->|"LuaUpdate()"| SCRIPT

subgraph subGraph1 ["API Surface"]
    GS
    SM
    PS
    SCM
    UTIL
    AF
end
end

subgraph subGraph0 ["Unity Gameplay Scene"]
    MGSC
    MG
    MM
    JUDGE
    SCORE
    COMBO
    LIFE
    INPUT
    POOLS
    JUDGE -.->|"OnJudgeイベント"| MG
    POOLS -.->|"OnSpawnNote/OnSpawnLong"| MG
    INPUT -.->|"タッチイベント"| MG
end
```



 

 

### API構成 

このシステムは、機能ドメイン別に整理された9つの主要APIクラスをLuaスクリプトに公開します:

| APIグローバル | C#クラス | 目的 | 主要メソッド |
| --- | --- | --- | --- |
| `GAMESTATE` | `GameState` | ゲームプレイ状態制御 | `SetSpeed()`, `SetDistance()`, `GetSongTime()`, `GetSongBeat()` |
| `SONGMAN` | `SongMan` | 楽曲メタデータアクセス | `GetTitle()`, `GetArtist()`, `GetBpms()`, `GetBeatPositions()` |
| `PLAYERSTATS` | `PlayerStats` | プレイヤーステータスと設定 | `GetCurrentCombo()`, `GetScore()`, `GetCurrentLife()`, `GetNotesOptions()` |
| `SCREENMAN` | `ScreenMan` | 画面と背景制御 | `SystemMessage()`, `ChangeBgImage()`, `SetBgDimmer()` |
| `UTIL` | `Util` | ユーティリティ関数 | `LoadTexture()`, `TweenPosition()`, `CalculateBeatToNotePositionZ()` |
| `ACTORFACTORY` | `ActorFactory` | Actorインスタンス化 | `Create2D()`, `CreateAudio()`, `CreateUIText()`, `CreateVideoCanvas()` |
| `CAMERAMAN` | `CameraMan` | カメラ操作 | (カメラ制御メソッド) |
| `ASSETMAN` | `AssetMan` | アセット読込 | (アセット読込メソッド) |
| `APPMAN` | `AppMan` | アプリケーション制御 | (アプリケーションレベルメソッド) |



 

## XLua統合 

このシステムはC#-LuaブリッジとしてXLuaを使用し、複数のスクリプト実行間で永続化する単一のグローバル`LuaEnv`インスタンスで構成されています。

### 環境セットアップ 

```mermaid
flowchart TD

STATIC["static LuaEnv g_luaEnv"]
LOADER["CustomLoader"]
META["CreateScriptEnv()"]
ENV["LuaTable _scriptEnv"]
INJECT["SetGlobalInjection()"]
DOSTRING["g_luaEnv.DoString()"]
API["APIクラス (GAMESTATE, SONGMAN等)"]
INJECT_OBJ["注入オブジェクト (DummyNote, Materials等)"]

STATIC -.->|"シングルトン"| ENV
META -.->|"__indexメタテーブルで作成"| ENV
INJECT -.-> API
INJECT -.-> INJECT_OBJ

subgraph グローバル名前空間 ["グローバル名前空間"]
    API
    INJECT_OBJ
end

subgraph スクリプト実行 ["スクリプト実行"]
    ENV
    INJECT
    DOSTRING
    ENV -.->|"Luaスクリプト実行"| INJECT
    ENV -.-> DOSTRING
    DOSTRING -.-> ENV
end

subgraph 初期化 ["初期化"]
    STATIC
    LOADER
    META
    LOADER -.->|"g_luaEnv.AddLoader()"| STATIC
end
```

**XLua属性:**

* `[LuaCallCSharp]`: LuaからアクセスできるC#クラスとメソッドをマーク
* `[CSharpCallLua]`: Lua関数が実装できるデリゲート型をマーク
* `[BlackList]`: Luaアクセスからメソッドを除外
* `[DoNotGen]`: 特定メソッドのXLuaコード生成を防止



 

 

 

### カスタムローダー 

このシステムは、譜面のディレクトリを基準に`require()`文を解決するカスタムLuaファイルローダーを実装しています:

**ファイル読込ロジック:**

1. 譜面スクリプトが`require("subfolder/module")`を指定
2. `CustomLoader`がXLuaによってファイルパスで呼び出される
3. パス解決: `Path.Combine(s_folderPath, filepath)`
4. ファイルが存在する場合`File.ReadAllBytes(path)`を返す
5. ファイルが見つからない場合`null`を返す(次のローダーに委任)



## スクリプトライフサイクル 

Luaスクリプトは、`LuaManager`がゲームプレイライフサイクルの特定ポイントで呼び出すコールバック関数を定義します。

**コールバック関数:**

| 関数 | タイミング | パラメータ | 目的 |
| --- | --- | --- | --- |
| `onloaded()` | スクリプト解析後、ゲームプレイ前 | なし | データ構造初期化 |
| `start()` | ゲームプレイ開始 | なし | 初期状態設定 |
| `update()` | 毎フレーム | なし | フレーム毎ロジック |
| `finish()` | 楽曲完了または失敗 | なし | リザルト前クリーンアップ |
| `ondestroy()` | シーン破棄 | なし | 最終クリーンアップ |
| `onHitNote(id, lane, noteType, judge, isAttack)` | ノート判定 | ノートデータ+判定 | ヒット反応 |
| `onMissedNote(id, lane, noteType)` | ノートミス | ノートデータ | ミス反応 |
| `onSpawnNote(noteController)` | ノートインスタンス化 | `NoteController` | ノート外観変更 |
| `onSpawnLong(longController)` | ロングノートインスタンス化 | `LongController` | ロングノート外観変更 |
| `onPause()` | ゲームポーズ | なし | スクリプトロジック一時停止 |
| `onResume()` | ゲーム再開 | なし | スクリプトロジック再開 |
| `onGameOver()` | ライフ枯渇 | なし | ゲームオーバー処理 |
| `onInputDown(touchId, posX, screenPosX, screenPosY)` | タッチ開始 | タッチデータ | 入力追跡 |
| `onInputMove(touchId, posX, screenPosX, screenPosY)` | タッチ移動 | タッチデータ | 入力追跡 |
| `onInputUp(touchId, posX, screenPosX, screenPosY)` | タッチ終了 | タッチデータ | 入力追跡 |



 

### イベントコールバックフロー 

```mermaid
sequenceDiagram
  participant p1 as MusicGame
  participant p2 as LuaManager
  participant p3 as 譜面Luaスクリプト
  participant p4 as Actorリスト

  note over p1,p4: 判定イベントフロー
  p1->>p2: OnHitNote(id | lane | noteType | judge | isAttack)
  p2->>p2: IsLoaded確認
  alt _luaOnHitNoteが存在
    p2->>p3: _luaOnHitNote(id | lane | noteType | judge | isAttack)
    p3-->>p2: (例外スロー可能性)
  end
  p2->>p4: actorリストをイテレート
  loop HasLuaOnHitNoteを持つ各actor
    p2->>p4: actor.LuaOnHitNote(id | lane | noteType | judge | isAttack)
    p4-->>p2: (例外スロー可能性)
  end
  alt 例外キャッチ-
    p2->>p2: _onError.Invoke()
    p2->>p2: ShowErrorDialog()
  end
```



 

## Actorシステム 

ActorはLuaスクリプト可能なゲームオブジェクトで、メイン譜面スクリプトから独立して存在します。独自のライフサイクルとコールバックを持つモジュラーで再利用可能なコンポーネントを可能にします。

### Actor型 

このシステムは4つの具体的なActor実装を提供します:

```mermaid
classDiagram
    class Actor {
        «abstract»
        -_scriptEnv: LuaTable
        -_luaStart/Update/Finish: Action
        -_luaOnHitNote: ActionInt4
        +Init(name, scriptEnv, onError, actorTypeName)
        +LuaStart()
        +LuaUpdate()
        +LuaFinish()
        +LuaOnHitNote(id, lane, noteType, judge, isAttack)
        +LuaOnMissedNote(id, lane, noteType)
        +LuaOnCreateNote(noteController)
        +LuaOnCreateLong(longController)
        +LuaOnPause()
        +LuaOnResume()
        +LuaOnGameOver()
        +LuaOnInputDown/Move/Up(touchId, posX, screenPosX, screenPosY)
    }
    class Actor2D {
        +SpriteRenderer: SpriteRenderer
        +GetSpriteRenderer() : SpriteRenderer
        +GetTransform() : Transform
    }
    class ActorAudio {
        +AudioSource: AudioSource
        +LoadAudio(filePath, onComplete)
        +Play()/Stop()/Pause()
        +SetVolume(volume)
    }
    class ActorUIText {
        +TextMeshProUGUI: TextMeshProUGUI
        +GetTextComponent() : TextMeshProUGUI
        +GetRectTransform() : RectTransform
    }
    class ActorVideoCanvas {
        +VideoPlayer: VideoPlayer
        +RawImage: RawImage
        +SetVideoPath(filePath)
        +Play()/Pause()/Stop()
        +SetOffsetTime(offsetTime)
        +SetAutoMusicSync(isAuto)
    }
    Actor <|-- Actor2D
    Actor <|-- ActorAudio
    Actor <|-- ActorUIText
    Actor <|-- ActorVideoCanvas
```

**Actor作成例(Luaから):**

```
-- 専用スクリプトで2Dスプライトactorを作成
local sprite = ACTORFACTORY.Create2D("actors/sprite.lua")
-- スクリプトなしでaudio actorを作成
local audio = ACTORFACTORY.CreateAudio()
audio.LoadAudio("sound.wav", function()
    audio.Play()
end)
```
 
### Actorライフサイクル管理 

Actorは独自のLuaスクリプト環境を維持し、メイン譜面スクリプトと同じコールバックを受信します:

```mermaid
flowchart TD

%% ===== Actor 作成 =====
AF["ActorFactory"]
CREATE["Create2D(luaFileName)"]
PREFAB["Actor Prefab を<br/>インスタンス化"]
READLUA["ReadLua(luaFileName)"]
SCRIPTENV["LuaTable<br/>scriptEnv"]
INIT["actor.Init(name,<br/>scriptEnv, onError)"]
ACTORLIST["LuaManager.ActorList"]

AF --> CREATE
CREATE --> PREFAB
CREATE --> READLUA
READLUA --> SCRIPTENV
SCRIPTENV --> INIT
INIT -->|"登録"| ACTORLIST

CREATE -.->|"scriptEnv.Set('self', actor)"| SCRIPTENV

%% ===== コールバック配布 =====
UPDATE["LuaManager.CallUpdate()"]
HITNOTE["LuaManager.OnHitNote()"]
LOOP["ActorList 内の<br/>各 Actor をループ"]
CHECK["actor.HasLuaUpdate<br/>/ HasLuaOnHitNote"]
CALL["actor.LuaUpdate()<br/>/ LuaOnHitNote()"]

UPDATE --> LOOP
HITNOTE --> LOOP
LOOP --> CHECK
CHECK -->|true| CALL

%% ===== サブグラフ =====
subgraph Actor作成 ["Actor 作成"]
    AF
    CREATE
    PREFAB
    READLUA
    SCRIPTENV
    INIT
end

subgraph Actor登録 ["Actor 登録"]
    ACTORLIST
end

subgraph コールバック配布 ["コールバック配布"]
    UPDATE
    HITNOTE
    LOOP
    CHECK
    CALL
end

```

各Actorは独自の`LuaTable _scriptEnv`を持ち、分離されたLua状態を維持することで、複数のactorが変数の競合なしに独立したスクリプトを実行できます。



 

 

## API概要 

### GameState API 

ゲームプレイの動作とビジュアルパラメータを制御します:

| メソッド | 目的 | 使用例 |
| --- | --- | --- |
| `GetSongTime()` | 現在の音楽再生時間(秒) | 音楽にエフェクトを同期 |
| `GetSongBeat()` | 現在の拍位置 | 拍でイベントをトリガー |
| `GetVisibleBeat()` | 画面に見える拍数 | ノート生成タイミング計算 |
| `SetSpeed(speed, duration, ease)` | ノートスクロール速度をトゥイーンで変更 | 速度変化ギミック |
| `SetDistance(distance, isSafeAuto)` | 判定ライン幅を変更 | レーン幅エフェクト |
| `SetOffsetZ(offsetZ)` | 判定ラインZ位置を移動 | 3D視点変更 |
| `SetVisibleRate(rate)` | ノート生成タイミングを変更 | 突然出現エフェクト |
| `SetNotesScrollType(type)` | 等速/減速スクロール切替 | スクロールモード変更 |
| `ChangeJudgeEffect(type)` | 判定エフェクトタイプ変更 | カスタムエフェクト |
| `ChangeFuzzyToTapJudge(isTap)` | ファジーノートをタップに変換 | ゲームプレイ変更 |
| `GetCurrentJudge(hasPerfect)` | 現在の判定カウント | 統計表示 |
| `GetNotes()` | 譜面内の全ノート | 譜面データ前処理 |
| `SetLaneAlpha(alpha)` | レーン透明度 | ビジュアルエフェクト |



### SongMan API 

楽曲メタデータと譜面データへの読取専用アクセスを提供します:

| メソッド | 戻り値型 | 目的 |
| --- | --- | --- |
| `GetTitle()` | `string` | 楽曲タイトル |
| `GetArtist()` | `string` | アーティスト名 |
| `GetDifficulty()` | `DifficultyType` | 選択難易度enum |
| `GetDifficultyToInt()` | `int` | 難易度を整数で(0-4) |
| `GetMeter()` | `int` | 数値難易度レベル |
| `GetMeterName()` | `string` | 難易度表示文字列 |
| `GetBaseBpm()` | `float` | 基準BPM値 |
| `GetBpmPositions()` | `float[]` | BPM変化の拍位置 |
| `GetBpms()` | `float[]` | 各変化でのBPM値 |
| `GetSpeedPositions()` | `float[]` | SPEED変化の拍位置 |
| `GetSpeedStretchRatios()` | `float[]` | SPEED乗数 |
| `GetScrollPositions()` | `float[]` | SCROLL変化の拍位置 |
| `GetScrolls()` | `double[]` | SCROLL乗数 |
| `GetLabelPositions()` | `float[]` | LABELマーカーの拍位置 |
| `GetLabels()` | `string[]` | LABELテキスト値 |
| `GetBeatPositions()` | `List<float>` | 全ノートの拍位置 |
| `GetLanes()` | `List<int>` | 全ノートのレーン番号 |
| `GetNoteTypes()` | `List<NoteType>` | 全ノートタイプ |
| `MusicLengthSeconds()` | `double` | 楽曲の長さ(秒) |
| `IsCmod()` | `bool` | CMODが有効か |



### PlayerStats API 

リアルタイムプレイヤー状態とゲーム設定にアクセスします:

| メソッド | 戻り値型 | 目的 |
| --- | --- | --- |
| `GetCurrentCombo()` | `int` | 現在のコンボ数 |
| `GetScore()` | `int` | 現在のスコア |
| `MaxCombo()` | `int` | 達成した最大コンボ |
| `GetGrade()` | `int` | 現在のランク(0=S+, 1=S, 2=A等) |
| `GetCurrentLife()` | `float` | ライフゲージ(0.0-1.0) |
| `IsFullCombo()` | `bool` | フルコンボ維持中か |
| `IsDanger()` | `bool` | ライフが危険に低いか |
| `IsDead()` | `bool` | ライフが枯渇したか |
| `SetLife(life)` | `void` | ライフ値を変更 |
| `GetNotesOptions()` | `NotesOption` | ノート設定のコピー |
| `GetDisplayOptions()` | `DisplayOption` | 表示設定のコピー |
| `GetVolumeOptions()` | `VolumeOption` | 音量設定のコピー |
| `GetJudgeTimeOptions()` | `JudgeTimeOption` | タイミング設定のコピー |
| `GetNoteSpeedOption()` | `float` | HiSpeed倍率 |
| `GetNoteSizeOption()` | `float` | ノートサイズ倍率 |
| `IsMirrorOption()` | `bool` | ミラーモード有効か |
| `GetNoteTexture(type)` | `Texture` | ノートタイプのテクスチャ |
| `GetLongTexture(type)` | `Texture` | ロングノートタイプのテクスチャ |
| `GetHighScore()` | `HighScore` | 以前のベストスコアデータ |
| `GetCurrentLanguage()` | `string` | 選択されたロケール("ja"/"en") |
| `SetJudgeAreaType(type)` | `void` | 画面または世界空間判定 |
| `UpdateScreenJudgeLine()` | `void` | カメラ移動後画面判定を再計算 |



### Util API 

一般的な操作のためのユーティリティ関数を提供します:

**テクスチャとスプライト:**

* `LoadTexture(textureFileName)`: 譜面フォルダからテクスチャ読込
* `CreateSprite(texture)`: Texture2DをSpriteに変換
* `CreateMultiSprite(texture, horizontalCount, verticalCount)`: テクスチャをスプライト配列に分割

**マテリアルとシェーダー:**

* `CreateMaterial(shader)`: シェーダーからマテリアルをインスタンス化
* `ShaderPropertyToID(propertyName)`: パフォーマンス用シェーダープロパティIDを取得

**座標変換:**

* `PolarToCartesian(radius, declination)`: 極座標からVector2へ
* `CartesianToPolar(x, y)`: Vector2から極座標へ

**ノート位置計算:**

* `CalculateBeatToNotePositionZ(beat)`: 拍オフセットをZ位置に変換
* `CalculateTimeToNotePositionZ(time)`: 時間オフセットをZ位置に変換
* `CalculateNoteRotation(positionZ)`: Z位置からノート回転を計算
* `CalculateScrolledBeat(beat)`: SCROLLタグ変換を適用

**トゥイーン(DOTweenラッパー):**

* `TweenPosition(tr, pos, duration, ease, onComplete)`
* `TweenLocalPosition(tr, pos, duration, ease, onComplete)`
* `TweenRotation(tr, rot, duration, ease, onComplete)`
* `TweenLocalRotation(tr, rot, duration, ease, onComplete)`
* `TweenScale(tr, scale, duration, ease, onComplete)`
* `KillTween(tr, complete)`

**タイミング:**

* `DelayAction(millisecond, action)`: 遅延後にコールバック実行
* `DelayFrameAction(frame, action)`: フレーム数後にコールバック実行

**オーディオ:**

* `GetSpectrumData(size, channel, fftWindow)`: ビジュアライゼーション用オーディオスペクトラム取得



### ScreenMan API 

画面表示と背景を制御します:

| メソッド | 目的 |
| --- | --- |
| `SystemMessage(message)` | 画面にデバッグメッセージ表示 |
| `GetScreenWidth()/GetScreenHeight()` | 画面寸法(ピクセル) |
| `GetDpi()` | 画面DPI値 |
| `GetOverlayCanvas()` | Overlay Canvasにアクセス |
| `GetLuaOverlayCanvas()` | Lua専用Overlay Canvasにアクセス |
| `GetCameraCanvas()` | カメラ空間Canvasにアクセス |
| `LoadBgChangeImage(name)` | 譜面フォルダから背景画像をプリロード |
| `LoadBgChangeImages(names)` | 複数の背景画像をプリロード |
| `ChangeBgImage(name)` | プリロード済み背景に切替 |
| `ResetBgImage()` | BACKGROUNDタグデフォルトを復元 |
| `SetBgMaterial(material)` | 背景にカスタムマテリアルを適用 |
| `ResetBgMaterial()` | デフォルト背景マテリアルを復元 |
| `SetBgDimmer(dimmer)` | 背景の暗さを設定(0.0-1.0) |
| `SetSiblingLuaOverlayCanvas(isFirst)` | LuaOverlayCanvasの描画順を変更 |
| `HideLuaOverlayCanvas()` | Luaオーバーレイレンダリングを無効化 |



## エラーハンドリング 

このシステムは、Luaスクリプトエラーからのゲームクラッシュを防ぐために、自動復旧を伴う包括的なエラーハンドリングを実装しています。

### エラーハンドリングフロー 

```mermaid
sequenceDiagram
  participant p1 as Luaスクリプト
  participant p2 as LuaManager
  participant p3 as DialogManager
  participant p4 as GameManager
  participant p5 as User

  p1->>p2: コールバック実行
  alt 例外スロー
    p2->>p2: catch (Exception e)
    p2->>p2: _onError?.Invoke() (ゲームポーズ)
    p2->>p3: ShowErrorDialog(e.Message)
    p3->>p3: エラーダイアログ構築
    p3->>p3: onNextコールバック設定
    p3-->>p5: エラーメッセージ表示
    p5->>p3: ダイアログ確認
    p3->>p4: ChangeScene(SelectMusic)
    note over p4: 楽曲選択に戻る
  end
```

**エラーダイアログ内容:**

* **タイトル:** ローカライズされた"Luaエラー"文字列
* **メッセージ:** スクリプト名付き例外メッセージ
* **アクション:** "楽曲選択に戻る"ボタン
* **自動閉じ:** 却下時に楽曲選択に戻る

**エラー復旧アクション:**

1. `_onError()`コールバックでゲーム実行をポーズ
2. `BgManager`から変更された背景画像をクリア
3. 背景マテリアルをデフォルトにリセット
4. ユーザーにエラーダイアログを表示
5. 却下時に`SelectMusic`シーンへ遷移



 

## メモリ管理 

### ガベージコレクション 

XLuaはLuaオブジェクトを解放するために明示的なガベージコレクション呼出を必要とします:

```mermaid
flowchart TD

UPDATE["LuaManager.CallUpdate()"]
CHECK["Time.time - g_lastGCTime > GC_INTERVAL確認"]
TICK["g_luaEnv.Tick()"]
RESET["g_lastGCTime = Time.time"]

UPDATE -.-> CHECK
CHECK -.->|"true (1秒毎)"| TICK
TICK -.-> RESET
```

**GC戦略:**

* **間隔:** `GC_INTERVAL = 1`秒
* **メソッド:** `g_luaEnv.Tick()`が増分GCを実行
* **グローバル状態:** `g_lastGCTime`が最後の収集時刻を追跡
* **理論的根拠:** メモリ使用量とフレーム時間オーバーヘッドのバランス



 

### スクリプト環境破棄 

各Luaスクリプトは明示的に破棄する必要がある`LuaTable`環境を維持します:

**破棄ポイント:**

* `LuaManager.OnDestroy()`: `_scriptEnv`と全てのデリゲート参照を破棄
* `Actor.OnDestroy()`: 各Actorが独自の`_scriptEnv`を破棄

**破棄シーケンス:**

1. `ondestroy()` Luaコールバックを呼出
2. 全てのキャッシュされたデリゲートをクリア(`_luaStart`, `_luaUpdate`等)
3. `_scriptEnv.Dispose()`を呼出
4. `_scriptEnv = null`を設定



 

## ゲームプレイシステムとの統合 

Luaシステムはコアゲームプレイシステムと双方向に統合されます:

### 読取アクセス 

Luaスクリプトは、以下から読み取るAPIメソッドを通じて現在のゲーム状態をクエリできます:

* `MusicManager`: 音楽時間、再生状態、オーディオスペクトラム
* `ScoreManager`: 現在のスコア、ランク
* `ComboManager`: 現在のコンボ、最大コンボ
* `LifeManager`: ライフゲージ値、危険/死亡状態
* `JudgeManager`: 判定カウント(`GetCurrentJudge()`経由)
* `Sequence`: 譜面データ(ノート、BPM、スクロール、ラベル)
* `GameManager`: 選択楽曲、難易度、プレイヤーオプション

### 書込アクセス 

Luaスクリプトは、以下を制御するAPIメソッドを通じてゲーム動作を変更できます:

* `MusicGame`: 速度、距離、offsetZ、ビジブルレート、スクロールタイプ、ロングエンドタイプ
* `FilterColorController`: レーン透明度
* `JudgeEffectPool`: エフェクトタイプとキャンセル動作
* `SameTimeBarObjectPool`: 同時押しインジケータの可視性
* `VisibleHoldController`: ホールドテクスチャ
* `AutoPlay`: オートプレイタイプ(位置ベース)
* `LifeManager`: ライフ値(`PlayerStats.SetLife()`経由)
* `BgManager`: 背景画像、マテリアル、ディマー(`ScreenMan`経由)

### イベント購読 

ゲームプレイループは以下のタイミングでLuaにイベントを発行します:

| イベントソース | Luaコールバック | トリガータイミング |
| --- | --- | --- |
| `JudgeManager.OnJudge` | `onHitNote` | ノートを成功裏にヒット |
| `JudgeManager.OnJudge` | `onMissedNote` | ノートミスまたはゲームオーバーミス |
| `NoteObjectPool.OnSpawn` | `onSpawnNote` | プールからノートをインスタンス化 |
| `LongObjectPool.OnSpawn` | `onSpawnLong` | プールからロングノートをインスタンス化 |
| `InputBase` | `onInputDown/Move/Up` | タッチ入力イベント |
| `MusicGameSceneController` | `onPause/onResume` | ゲームポーズ/再開 |
| `LifeManager.OnDead` | `onGameOver` | ライフ枯渇 |

### On this page

* [Luaスクリプトシステム](#7-lua)
* [目的と範囲](#7-)
* [システムアーキテクチャ](#7--1)
* [統合概要](#7--2)
* [API構成](#7-api)
* [XLua統合](#7-xlua)
* [環境セットアップ](#7--3)
* [カスタムローダー](#7--4)
* [スクリプトライフサイクル](#7--5)
* [ライフサイクルコールバック](#7--6)
* [イベントコールバックフロー](#7--7)
* [Actorシステム](#7-actor)
* [Actor型](#7-actor-1)
* [Actorライフサイクル管理](#7-actor-2)
* [API概要](#7-api-1)
* [GameState API](#7-gamestate-api)
* [SongMan API](#7-songman-api)
* [PlayerStats API](#7-playerstats-api)
* [Util API](#7-util-api)
* [ScreenMan API](#7-screenman-api)
* [エラーハンドリング](#7--8)
* [エラーハンドリングフロー](#7--9)
* [メモリ管理](#7--10)
* [ガベージコレクション](#7--11)
* [スクリプト環境破棄](#7--12)
* [ゲームプレイシステムとの統合](#7--13)
* [読取アクセス](#7--14)
* [書込アクセス](#7--15)
* [イベント購読](#7--16)

