

# Lua統合アーキテクチャ 

## 目的と対象範囲 

このドキュメントでは、リズムゲーム内でカスタムLuaスクリプトを可能にするアーキテクチャについて説明します。Lua統合システムにより、譜面作者は楽曲フォルダに配置されたスクリプトを通じて、動的なビジュアルエフェクトの作成、ゲームプレイパラメータの操作、ゲームプレイイベントへの応答を行うことができます。このシステムはXLuaを使用してC# UnityコードとLuaスクリプトを橋渡しし、再コンパイルなしでランタイムカスタマイズを行うための包括的なAPIを提供します。

Luaスクリプトが作成および操作できるActorシステムの詳細については、[アクターシステム](#7.2)を参照してください。Luaスクリプトで利用可能な完全なAPIリファレンスについては、[Lua APIリファレンス](#7.3)を参照してください。

---

## システム概要 

Lua統合アーキテクチャは3つの主要なレイヤーで構成されています：XLua環境、LuaManagerオーケストレーター、および公開されたAPIクラスです。スクリプトは、慎重に設計されたインジェクション機構を通じてゲームシステムへの制御されたアクセスを持つ、隔離された環境で実行されます。

```mermaid
flowchart TD
    subgraph subGraph0 ["XLua コア"]
        LUAENV["LuaEnv (静的シングルトン)<br/>g_luaEnv"]
        CUSTOM_LOADER["CustomLoader<br/>ファイルシステムアクセス"]
        GC["Tick GC<br/>1秒間隔"]
    end

    subgraph subGraph1 ["LuaManager オーケストレーション"]
        LUAMGR["LuaManager<br/>MonoBehaviour"]
        SCRIPT_ENV["LuaTable _scriptEnv<br/>スクリプト毎の環境"]
        CALLBACKS["コールバックデリゲート<br/>_luaStart, _luaUpdate, 等"]
    end

    subgraph インジェクトされたAPIクラス ["インジェクトされたAPIクラス"]
        GAMESTATE["GameState<br/>GAMESTATE グローバル"]
        SONGMAN["SongMan<br/>SONGMAN グローバル"]
        PLAYERSTATS["PlayerStats<br/>PLAYERSTATS グローバル"]
        SCREENMAN["ScreenMan<br/>SCREENMAN グローバル"]
        UTIL["Util<br/>UTIL グローバル"]
        ACTORFACTORY["ActorFactory<br/>ACTORFACTORY グローバル"]
        CAMERAMAN["CameraMan<br/>CAMERAMAN グローバル"]
        ASSETMAN["AssetMan<br/>ASSETMAN グローバル"]
    end

    subgraph アクターシステム ["アクターシステム"]
        ACTOR_LIST["List &lt;Actor&gt;<br/>_actorList"]
        ACTOR_BASE["Actor 基底クラス"]
        ACTOR_IMPLS["Actor2D ActorAudio<br/>ActorVideoCanvas ActorUIText"]
    end

    LUAENV -->|"使用"| CUSTOM_LOADER
    LUAENV -->|"定期的"| GC
    LUAMGR -->|"スクリプト毎に作成"| SCRIPT_ENV
    LUAMGR --> CALLBACKS
    LUAMGR -.->|"使用"| LUAENV
    LUAMGR -->|"インジェクト"| GAMESTATE
    LUAMGR -->|"インジェクト"| SONGMAN
    LUAMGR -->|"インジェクト"| PLAYERSTATS
    LUAMGR -->|"インジェクト"| SCREENMAN
    LUAMGR -->|"インジェクト"| UTIL
    LUAMGR -->|"インジェクト"| ACTORFACTORY
    LUAMGR -->|"インジェクト"| CAMERAMAN
    LUAMGR -->|"インジェクト"| ASSETMAN
    ACTORFACTORY -->|"含む"| ACTOR_LIST
    LUAMGR -->|"ライフサイクル管理"| ACTOR_LIST
    ACTOR_LIST --> ACTOR_BASE
    ACTOR_BASE --> ACTOR_IMPLS
```



---

## XLua環境とカスタムローディング 

システムは、すべてのLuaスクリプト実行にわたって持続する単一の静的`LuaEnv`インスタンスを維持します。このグローバル環境は一度初期化され、パフォーマンスのために再利用されます。

### 静的LuaEnvシングルトン 

`g_luaEnv`フィールドは共有Luaランタイムを提供します：

```mermaid
flowchart TD

STATIC["static LuaEnv g_luaEnv 単一のグローバルインスタンス"]
LUAMGR1["LuaManager インスタンス 1 メインスクリプト"]
LUAMGR2["LuaManager インスタンス 2 (Actorスクリプト)"]

STATIC -.->|"共有される"| LUAMGR1
STATIC -.->|"共有される"| LUAMGR2
```

 

### カスタムローダー実装 

カスタムローダーは、Luaの`require`文が楽曲フォルダのファイルシステムからモジュールをロードできるようにします：

| メソッド | 目的 |
| --- | --- |
| `CustomLoader(ref string filepath)` | `s_folderPath`からの相対パスでファイルパスを解決し、Luaバイトコードを読み込む |
| `byte[]`を返す | ファイルコンテンツのロードに成功 |
| `null`を返す | ファイルが見つからず、XLuaは次のローダーを試す |

ローダーは`s_folderPath`と要求されたファイルパスを組み合わせて絶対パスを構築し、楽曲ディレクトリ内でモジュラーなLuaスクリプトを可能にします。



### ガベージコレクション管理 

システムはXLuaの`Tick()`メソッドを使用してインクリメンタルガベージコレクションを実行します：

```mermaid
flowchart TD

UPDATE["CallUpdate() 毎フレーム"]
CHECK["Time.time - g_lastGCTime > GC_INTERVAL (1秒)?"]
TICK["g_luaEnv.Tick() インクリメンタルGC"]
UPDATE_TIME["g_lastGCTime = Time.time"]
CONTINUE["続行"]

UPDATE -.-> CHECK
CHECK -.->|"はい"| TICK
CHECK -.->|"いいえ"| CONTINUE
TICK -.-> UPDATE_TIME
```



---

## スクリプト環境とメタテーブルのセットアップ 

各Luaスクリプトは、メタテーブルを通じて作成された隔離された環境で実行され、インジェクトされたAPIへのアクセスを許可しながらグローバル名前空間の汚染を防ぎます。

### 環境の作成 

`CreateScriptEnv()`メソッドはサンドボックス化された環境を確立します：

```mermaid
flowchart TD
    CREATE["CreateScriptEnv()"]
    NEW_TABLE["luaenv.NewTable()<br/>scriptEnv"]
    META["luaenv.NewTable()<br/>meta"]
    INDEX["meta.Set('__index',<br/>luaenv.Global)"]
    SETMETA["scriptEnv.SetMetaTable(meta)"]
    DISPOSE["meta.Dispose()"]
    RETURN["return scriptEnv"]

    CREATE --> NEW_TABLE
    NEW_TABLE --> META
    META --> INDEX
    INDEX --> SETMETA
    SETMETA --> DISPOSE
    DISPOSE --> RETURN
```

`__index`メタメソッドは、未定義の変数をグローバル環境に委譲し、スクリプトが独自のローカルスコープを維持しながらインジェクトされたAPIにアクセスできるようにします。



### インジェクションシステム 

`SetGlobalInjection()`メソッドは、C#オブジェクトをグローバル変数として設定することで、Luaスクリプトに公開します：

| グローバル名 | C#クラス | 目的 |
| --- | --- | --- |
| `GAMESTATE` | `GameState` | ゲームプレイ状態の操作（速度、距離、エフェクト） |
| `SONGMAN` | `SongMan` | 楽曲メタデータと譜面情報 |
| `PLAYERSTATS` | `PlayerStats` | プレイヤー統計（スコア、コンボ、ライフ） |
| `SCREENMAN` | `ScreenMan` | スクリーン操作（メッセージ、背景、キャンバスアクセス） |
| `CAMERAMAN` | `CameraMan` | カメラ制御と操作 |
| `UTIL` | `Util` | ユーティリティ関数（テクスチャ、トゥイーン、計算） |
| `ACTORFACTORY` | `ActorFactory` | アクター作成ファクトリー |
| `ASSETMAN` | `AssetMan` | アセット読込操作 |
| `APPMAN` | `AppMan` | アプリケーションレベルの操作 |
| `DANMAKUSTAGE` / `DSTAGE` | `DanmakuStageMan` | 弾幕（弾幕地獄）システム |

追加のインジェクションには、インスペクタで設定されたGameObject参照、Material参照、Transform参照、プレハブ参照が含まれます。



---

## ライフサイクル管理 

LuaManagerは、Luaスクリプトの定義されたライフサイクルを編成し、初期化中にコールバック関数を抽出し、適切なタイミングで呼び出します。

### 初期化パイプライン 

```mermaid
flowchart TD
    INIT_START["Init(folderPath, luaFileName,<br/>pause, onComplete)"]
    CHECK_EMPTY{"luaFileName<br/>IsNullOrEmpty?"}
    CLEANUP["すべてのAPIオブジェクトを解放<br/>早期リターン"]
    ADD_LOADER["g_luaEnv.AddLoader(CustomLoader)"]
    CREATE_ENV["_scriptEnv = CreateScriptEnv()"]
    SET_SELF["_scriptEnv.Set('self', this)"]
    INJECT["SetGlobalInjection()"]
    INIT_FACTORY["_actorFactory.Init(this, pause)"]
    READ_FILE["ディスクからLuaファイルを読込"]
    DOSTRING["g_luaEnv.DoString(luaString,<br/>'Lua', _scriptEnv)"]
    EXTRACT["コールバックデリゲートを抽出<br/>onloaded, start, update, 等"]
    CALL_LOADED["onloaded()を呼び出し<br/>（存在する場合）"]
    COMPLETE["onComplete()"]
    SET_LOADED["IsLoaded = true"]
    ERROR_DIALOG["ShowErrorDialog(e.Message)<br/>ゲーム一時停止"]

    INIT_START --> CHECK_EMPTY
    CHECK_EMPTY -->|Yes| CLEANUP
    CHECK_EMPTY -->|No| ADD_LOADER
    ADD_LOADER --> CREATE_ENV
    CREATE_ENV --> SET_SELF
    SET_SELF --> INJECT
    INJECT --> INIT_FACTORY
    INIT_FACTORY --> READ_FILE
    READ_FILE --> DOSTRING
    DOSTRING -->|成功| EXTRACT
    DOSTRING -->|例外| ERROR_DIALOG
    EXTRACT --> CALL_LOADED
    CALL_LOADED --> COMPLETE
    COMPLETE --> SET_LOADED
```



### コールバック関数の抽出 

初期化中、システムはLua関数参照をC#デリゲートに抽出します：

| デリゲートフィールド | Lua関数名 | 目的 |
| --- | --- | --- |
| `_luaStart` | `start` | ゲームプレイ開始時に呼ばれる |
| `_luaUpdate` | `update` | ゲームプレイ中、毎フレーム呼ばれる |
| `_luaFinish` | `finish` | 楽曲完了時に呼ばれる |
| `_luaOnDestroy` | `ondestroy` | LuaManagerが破棄される時に呼ばれる |
| `_luaOnHitNote` | `onHitNote` | プレイヤーがノーツをヒットした時に呼ばれる |
| `_luaOnMissedNote` | `onMissedNote` | プレイヤーがノーツをミスした時に呼ばれる |
| `_luaOnSpawnNote` | `onSpawnNote` | ノーツが生成された時に呼ばれる |
| `_luaOnSpawnLong` | `onSpawnLong` | ロングノーツが生成された時に呼ばれる |
| `_luaOnPause` | `onPause` | ゲームが一時停止された時に呼ばれる |
| `_luaOnResume` | `onResume` | ゲームが再開された時に呼ばれる |
| `_luaOnGameOver` | `onGameOver` | プレイヤーが死亡した時に呼ばれる |
| `_luaOnInputDown` | `onInputDown` | タッチ/入力ダウン時に呼ばれる |
| `_luaOnInputMove` | `onInputMove` | タッチ/入力移動時に呼ばれる |
| `_luaOnInputUp` | `onInputUp` | タッチ/入力アップ時に呼ばれる |

抽出には`_scriptEnv.Get<T>(functionName, out delegate)`を使用し、スクリプトに関数が存在しない場合はnullを返します。



### ライフサイクル呼び出しフロー 

```mermaid
sequenceDiagram
  participant p1 as MusicGameSceneController
  participant p2 as LuaManager
  participant p3 as Luaスクリプト
  participant p4 as ActorList

  note over p1: 毎フレーム
  p1->>p2: Init(folderPath | luaFileName | ...)
  p2->>p3: スクリプトをロード＆実行
  p2->>p3: onloaded() [定義されている場合]
  p1->>p2: StartLua()
  p2->>p3: start() [定義されている場合]
  p2->>p4: 各アクターに対してactor.LuaStart()
  loop 毎フレーム
    p1->>p2: CallUpdate(musicTime)
    p2->>p3: update() [定義されている場合]
    p2->>p4: 各アクターに対してactor.LuaUpdate()
    note over p2: 1秒毎にGC Tick
  end
  p1->>p2: OnHitNote(id | lane | noteType | judge | isAttack)
  p2->>p3: onHitNote(...) [定義されている場合]
  p2->>p4: 各アクターに対してactor.LuaOnHitNote(...)
  p1->>p2: OnFinish()
  p2->>p3: finish() [定義されている場合]
  p2->>p4: 各アクターに対してactor.LuaFinish()
  note over p2: OnDestroy()はUnityによって自動的に呼ばれる
  p2->>p3: ondestroy() [定義されている場合]
  p2->>p2: リソースを破棄
```



---

## エラーハンドリングとリカバリー 

すべてのLuaコールバック呼び出しはtry-catchブロックでラップされ、スクリプトエラーがゲームをクラッシュさせることを防ぎます。エラーが発生すると、システムはユーザーフレンドリーなダイアログを表示し、楽曲選択シーンに戻ります。

### エラーハンドリングパターン 

各コールバック呼び出しは次のパターンに従います：

```mermaid
flowchart TD
    INVOKE_START["Luaコールバックを呼び出し"]
    CHECK_NULL{"コールバック が<br/>null でない?"}
    TRY["try { callback() }"]
    SUCCESS["実行継続"]
    CATCH["catch (Exception e)"]
    PAUSE["_onError?.Invoke()<br/>(ゲーム一時停止)"]
    DIALOG["ShowErrorDialog(e.Message)"]
    RETURN["早期リターン"]
    SKIP["スキップ"]

    INVOKE_START --> CHECK_NULL
    CHECK_NULL -->|Yes| TRY
    CHECK_NULL -->|No| SKIP
    SKIP --> SUCCESS
    TRY -->|成功| SUCCESS
    TRY -->|例外| CATCH
    CATCH --> PAUSE
    PAUSE --> DIALOG
    DIALOG --> RETURN
```



### エラーダイアログ表示 

`ShowErrorDialog()`メソッドはユーザーにエラーを提示します：

| コンポーネント | 説明 |
| --- | --- |
| ヘッダー | ローカライズされた "ERROR_LUA_HEADER" 文字列 |
| メッセージ | 例外メッセージテキスト |
| アクションボタン | "BACK_SELECT_MUSIC" - 楽曲選択に戻る |
| 自動クローズコールバック | 同じく楽曲選択に戻る |
| 背景クリーンアップ | カスタム背景とマテリアルをクリア |



### Actorのエラーハンドリング 

Actorシステム（[アクターシステム](#7.2)参照）は、独自のライフサイクルメソッドで同一のエラーハンドリングを実装しています。各Actorは独自の`_onError`コールバックと`ShowErrorDialog()`実装を維持し、Actorスクリプトごとに隔離されたエラーハンドリングを提供します。



---

## Actorシステム統合 

LuaManagerは、動的に作成されたActorを追跡するための2つのコレクションを維持します：

| コレクション | 型 | 目的 |
| --- | --- | --- |
| `_actorList` | `List<Actor>` | すべての作成されたActor（2D、Audio、UIText、Video） |
| `_actorVideoCanvasList` | `List<ActorVideoCanvas>` | 特別な更新処理を必要とするビデオActor |

### Actorライフサイクルの伝播 

LuaManagerのライフサイクルコールバックが呼び出されると、それらはリスト内のすべてのActorに伝播します：

```mermaid
flowchart TD
    LM_CALLBACK["LuaManagerコールバックが呼び出される<br/>(例: StartLua, OnHitNote)"]
    MAIN_CALLBACK["メインスクリプトコールバックを実行<br/>(_luaStart, _luaOnHitNote, 等)"]
    CHECK_ERROR{"例外が<br/>発生した?"}
    HANDLE_ERROR["エラーハンドリング,<br/>早期リターン"]
    LOOP_START["_actorListをループ<br/>(逆順, i = count-1 から 0)"]
    CHECK_NULL{"actor[i] が<br/>null でない?"}
    CHECK_HAS{"actor[i].HasLuaXXX<br/>プロパティ?"}
    INVOKE_ACTOR["actor[i].LuaXXX()<br/>(例: LuaStart, LuaOnHitNote)"]
    NEXT["i--"]
    VIDEO_LOOP["_actorVideoCanvasListをループ<br/>(CallUpdateのみ)"]
    VIDEO_UPDATE["actorVideoCanvas[i].CallUpdate()"]
    DONE["完了"]

    LM_CALLBACK --> MAIN_CALLBACK
    MAIN_CALLBACK --> CHECK_ERROR
    CHECK_ERROR -->|Yes| HANDLE_ERROR
    CHECK_ERROR -->|No| LOOP_START
    LOOP_START --> CHECK_NULL
    CHECK_NULL -->|No| NEXT
    CHECK_NULL -->|Yes| CHECK_HAS
    CHECK_HAS -->|No| NEXT
    CHECK_HAS -->|Yes| INVOKE_ACTOR
    INVOKE_ACTOR --> NEXT
    NEXT -->|i >= 0| CHECK_NULL
    NEXT -->|完了| VIDEO_LOOP
    VIDEO_LOOP --> VIDEO_UPDATE
    VIDEO_UPDATE --> DONE
```

システムは逆順イテレーション（`i = count - 1`から`0`）を使用して、イテレーション中に破棄される可能性のあるActorを安全に処理します。



 

---

## APIクラス概要 

インジェクトされたAPIクラスは、Luaスクリプトとゲームエンジン間の主要なインターフェースを提供します。各クラスは、XLuaコード生成を有効にするために`[LuaCallCSharp]`でマークされています。

### APIクラスアーキテクチャ 

```mermaid
flowchart TD

AF["ActorFactory [SerializeField]"]
AF_REFS["プレハブ: Actor2D ActorAudio ActorUIText ActorVideoCanvas"]
SCR["ScreenMan [SerializeField]"]
SCR_REFS["参照: LuaOverlayPanel Canvas オブジェクト"]
UT["Util [SerializeField]"]
UT_REFS["参照: MusicManager MusicGame FastCurve Transform"]
PS["PlayerStats [SerializeField]"]
PS_REFS["参照: ScoreManager ComboManager LifeManager TouchArea Options"]
SM["SongMan [SerializeField]"]
SM_REFS["参照: SongInfo Sequence MusicManager"]
GS["GameState [SerializeField]"]
GS_REFS["参照: FilterColorController LaneController JudgePlateController JudgeEffectPool VisibleHoldController AutoPlay"]

subgraph ファクトリーAPI ["ファクトリーAPI"]
    AF
    AF_REFS
    AF -.-> AF_REFS
end

subgraph スクリーンAPI ["スクリーンAPI"]
    SCR
    SCR_REFS
    SCR -.-> SCR_REFS
end

subgraph ユーティリティAPI ["ユーティリティAPI"]
    UT
    UT_REFS
    UT -.-> UT_REFS
end

subgraph プレイヤー情報API ["プレイヤー情報API"]
    PS
    PS_REFS
    PS -.-> PS_REFS
end

subgraph 楽曲情報API ["楽曲情報API"]
    SM
    SM_REFS
    SM -.-> SM_REFS
end

subgraph ゲームステートAPI ["ゲームステートAPI"]
    GS
    GS_REFS
    GS -.-> GS_REFS
end
```

### API初期化 

各APIクラスは、スクリプトへの公開を防ぐために`[BlackList, DoNotGen]`でマークされた`Init()`メソッドを公開します。これらのメソッドはC#から呼び出され、必要な依存関係をインジェクトします：

| APIクラス | Init パラメータ | 目的 |
| --- | --- | --- |
| `GameState` | `MusicManager`, `MusicGame` | ゲームステート操作 |
| `SongMan` | `SongInfo`, `Sequence`, `MusicManager` | 楽曲データアクセス |
| `PlayerStats` | `ScoreManager`, `ComboManager`, `LifeManager`, `TouchArea` | プレイヤー統計 |
| `Util` | `MusicManager`, `MusicGame` | ユーティリティ計算 |
| `ActorFactory` | `LuaManager`, `pause コールバック` | Actor作成 |



 

 

 

### 主要なAPI機能 

**GameState** - ゲームプレイ操作：

* 速度/距離/オフセット制御（`SetSpeed`, `SetDistance`, `SetOffsetZ`）
* ビジュアルエフェクト設定（`ChangeJudgeEffect`, `SetLaneAlpha`）
* ノーツ挙動変更（`SetNotesScrollType`, `SetLongEndType`）
* タイミング/拍変換（`GetSongTime`, `GetSongBeat`, `TimeToBeat`, `BeatToTime`）

**SongMan** - 楽曲情報：

* メタデータアクセス（`GetTitle`, `GetArtist`, `GetDifficulty`）
* BPM/Speed/Scrollデータ（`GetBpms`, `GetSpeedPositions`, `GetScrolls`）
* 譜面データ（`GetBeatPositions`, `GetLanes`, `GetNoteTypes`）

**PlayerStats** - プレイヤーステート：

* 統計（`GetScore`, `GetCurrentCombo`, `GetCurrentLife`）
* 判定エリア制御（`SetJudgeAreaType`, `UpdateScreenJudgeLine`）
* オプションアクセス（`GetNotesOptions`, `GetDisplayOptions`）

**Util** - ユーティリティ関数：

* テクスチャ/スプライト作成（`LoadTexture`, `CreateSprite`）
* トゥイーンアニメーション（`TweenPosition`, `TweenRotation`, `TweenScale`）
* 位置計算（`CalculateBeatToNotePositionZ`, `CalculateTimeToNotePositionZ`）
* 座標変換（`PolarToCartesian`, `CartesianToPolar`）

**ScreenMan** - スクリーン操作：

* デバッグメッセージ（`SystemMessage`）
* 背景制御（`LoadBgChangeImages`, `ChangeBgImage`, `SetBgDimmer`）
* キャンバスアクセス（`GetOverlayCanvas`, `GetLuaOverlayCanvas`）

**ActorFactory** - Actor作成：

* `Create2D(luaFileName)` - 2DスプライトActorを作成
* `CreateAudio(luaFileName)` - オーディオActorを作成
* `CreateUIText(luaFileName)` - UIテキストActorを作成
* `CreateVideoCanvas(luaFileName)` - ビデオ再生Actorを作成

完全なAPIメソッドシグネチャと説明については、[Lua APIリファレンス](#7.3)を参照してください。



 

 

 

 

 

---

## ゲームプレイループとの統合 

LuaManagerは、MusicGameSceneController（[ゲームループとシーンコントローラー](#3.1)参照）を通じてコアゲームプレイループと統合し、更新とゲームプレイイベントを受け取ります。

### 更新サイクル統合 

```mermaid
sequenceDiagram
  participant p1 as MusicGameSceneController
  participant p2 as MusicGame
  participant p3 as LuaManager
  participant p4 as Luaスクリプト
  participant p5 as GCマネージャー

  note over p1: 毎フレーム
  p1->>p2: CallUpdate()
  p2->>p3: CallUpdate(musicTime)
  p3->>p3: IsLoadedをチェック
  alt スクリプトがロード済み
    p3->>p4: update() [_luaUpdateがnullでない場合]
    note over p3: _actorListをループ
    p3->>p4: actor.LuaUpdate() [HasLuaUpdateの場合]
    note over p3: _actorVideoCanvasListをループ
    p3->>p4: actorVideoCanvas.CallUpdate()
    p3->>p3: Time.time - g_lastGCTime > 1秒をチェック
  alt GC間隔経過
    p3->>p5: g_luaEnv.Tick()
    p3->>p3: g_lastGCTime = Time.time
  end
  end
```



### ゲームプレイイベント統合 

```mermaid
flowchart TD
    subgraph ノーツイベント ["ノーツイベント"]
        HIT["JudgeManager.OnAfterJudge"]
        MISS["JudgeManager.OnMissNote"]
        SPAWN_NOTE["NoteObjectPool.Get"]
        SPAWN_LONG["LongObjectPool.Get"]
    end

    subgraph システムイベント ["システムイベント"]
        PAUSE["MusicGameSceneController.OnPause"]
        RESUME["MusicGameSceneController.OnResume"]
        GAMEOVER["LifeManager.OnDead"]
    end

    subgraph 入力イベント ["入力イベント"]
        INPUT_DOWN["InputBase.OnTouchDown"]
        INPUT_MOVE["InputBase.OnTouchMove"]
        INPUT_UP["InputBase.OnTouchUp"]
    end

    subgraph LuaManagerメソッド ["LuaManagerメソッド"]
        ONHIT["OnHitNote(id, lane,<br/>noteType, judge, isAttack)"]
        ONMISS["OnMissedNote(id, lane, noteType)"]
        ONSPAWN_NOTE["OnSpawnNote(NoteController)"]
        ONSPAWN_LONG["OnSpawnLong(LongController)"]
        ONPAUSE["OnPause()"]
        ONRESUME["OnResume()"]
        ONGAMEOVER["OnGameOver()"]
        ONINPUT_DOWN["OnInputDown(touchId, posX, ...)"]
        ONINPUT_MOVE["OnInputMove(touchId, posX, ...)"]
        ONINPUT_UP["OnInputUp(touchId, posX, ...)"]
    end

    HIT --> ONHIT
    MISS --> ONMISS
    SPAWN_NOTE --> ONSPAWN_NOTE
    SPAWN_LONG --> ONSPAWN_LONG
    PAUSE --> ONPAUSE
    RESUME --> ONRESUME
    GAMEOVER --> ONGAMEOVER
    INPUT_DOWN --> ONINPUT_DOWN
    INPUT_MOVE --> ONINPUT_MOVE
    INPUT_UP --> ONINPUT_UP
```

各イベントメソッドは同じパターンに従います：

1. `IsLoaded`がtrueかチェック
2. メインスクリプトコールバック（例：`_luaOnHitNote`）をnullでない場合に呼び出し、try-catchでラップ
3. `_actorList`を反復処理し、そのActorがそのコールバックを持つ場合、対応するActorコールバック（例：`actor.LuaOnHitNote`）を呼び出す



---

## リソースクリーンアップ 

適切なリソースクリーンアップは、メモリリークを防ぎ、複数のスクリプト実行にわたってLuaEnvが安定したままであることを保証します。

### OnDestroyクリーンアップシーケンス 

```mermaid
flowchart TD

ONDESTROY["OnDestroy()<br/>Unity によって呼ばれる"]

CHECK_LOADED["IsLoaded ?"]
SKIP["クリーンアップを<br/>スキップして終了"]

CALL_DESTROY["_luaOnDestroy() を呼び出し<br/>(null でない場合)"]
DANMAKU["DanmakuStageMan?.<br/>OnFinalize()"]
DISPOSE_ENV["_scriptEnv?.<br/>Dispose()"]

NULL_DELEGATES["Lua デリゲートを null に設定<br/>_luaStart / _luaUpdate / _luaFinish /<br/>_luaOnDestroy / _luaOnHitNote など"]
NULL_ARRAYS["インジェクション配列を<br/>null に設定"]

END["終了"]

%% 開始
ONDESTROY --> CHECK_LOADED

%% Loaded 判定
CHECK_LOADED -->|No| SKIP
SKIP --> END

CHECK_LOADED -->|Yes| CALL_DESTROY

%% クリーンアップ順
CALL_DESTROY --> DANMAKU
DANMAKU --> DISPOSE_ENV
DISPOSE_ENV --> NULL_DELEGATES
NULL_DELEGATES --> NULL_ARRAYS
NULL_ARRAYS --> END

```

`_scriptEnv.Dispose()`の呼び出しは重要です - これはLuaテーブルを解放し、ガベージコレクタがメモリを回収できるようにします。デリゲートフィールドは、Lua関数への参照を切るためにnullに設定されます。



### Actorクリーンアップ 

各Actorも独自の`OnDestroy()`メソッドを実装しています：

1. `_luaOnDestroy()`が存在する場合、呼び出す
2. アクションおよび関数デリゲートキャッシュをクリア
3. すべてのデリゲートフィールドをnullに設定
4. `_scriptEnv?.Dispose()`を呼び出す



---

## デリゲート型定義 

システムは、コールバックのLua関数シグネチャを表すカスタムデリゲート型を定義します。これらは、XLuaコード生成を有効にするために`[CSharpCallLua]`でマークされています。

| デリゲート型 | シグネチャ | 使用法 |
| --- | --- | --- |
| `Action` | `void()` | 一般的なコールバック（start, update, finish, 等） |
| `ActionInt4` | `void(int id, int lane, int noteType, int judge, bool isAttack)` | ノーツヒットイベント |
| `ActionInt3` | `void(int id, int lane, int noteType)` | ノーツミスイベント |
| `ActionInput` | `void(int touchId, float posX, float screenPosX, float screenPosY)` | 入力イベント |
| `ActionNoteController` | `void(NoteController noteController)` | ノーツ生成イベント |
| `ActionLongController` | `void(LongController longController)` | ロングノーツ生成イベント |

### On this page

* [Lua統合アーキテクチャ](#7.1-lua)
* [目的と対象範囲](#7.1-)
* [システム概要](#7.1--1)
* [XLua環境とカスタムローディング](#7.1-xlua)
* [静的LuaEnvシングルトン](#7.1-luaenv)
* [カスタムローダー実装](#7.1--2)
* [ガベージコレクション管理](#7.1--3)
* [スクリプト環境とメタテーブルのセットアップ](#7.1--4)
* [環境の作成](#7.1--5)
* [インジェクションシステム](#7.1--6)
* [ライフサイクル管理](#7.1--7)
* [初期化パイプライン](#7.1--8)
* [コールバック関数の抽出](#7.1--9)
* [ライフサイクル呼び出しフロー](#7.1--10)
* [エラーハンドリングとリカバリー](#7.1--11)
* [エラーハンドリングパターン](#7.1--12)
* [エラーダイアログ表示](#7.1--13)
* [Actorのエラーハンドリング](#7.1-actor)
* [Actorシステム統合](#7.1-actor-1)
* [Actorライフサイクルの伝播](#7.1-actor-2)
* [APIクラス概要](#7.1-api)
* [APIクラスアーキテクチャ](#7.1-api-1)
* [API初期化](#7.1-api-2)
* [主要なAPI機能](#7.1-api-3)
* [ゲームプレイループとの統合](#7.1--14)
* [更新サイクル統合](#7.1--15)
* [ゲームプレイイベント統合](#7.1--16)
* [リソースクリーンアップ](#7.1--17)
* [OnDestroyクリーンアップシーケンス](#7.1-ondestroy)
* [Actorクリーンアップ](#7.1-actor-3)
* [デリゲート型定義](#7.1--18)

