

# UIとシーン管理 

本ドキュメントでは、ゲームプレイループの入口と出口として機能するタイトルシーンとリザルトシーンについて説明します。これらのシーンはUI制御のためにMVP（Model-View-Presenter）パターンを実装し、ダイアログ管理、シーン遷移、ローカライゼーションなどの共通UIサービスを共有しています。楽曲選択シーンについては[楽曲選択システム](#5)を参照してください。共有されるアセット読込戦略については[アセット管理](#9)を参照してください。

---

## シーンにおけるMVPパターン 

アプリケーションは厳格なMVPアーキテクチャに従っており、各シーンは3つの主要コンポーネントと`LifetimeScope`エントリポイントで構成されています：

| コンポーネント | 責務 | 基底クラス | ライフサイクルインターフェース |
| --- | --- | --- | --- |
| **LifetimeScope** | シーンのエントリポイント、プレゼンターをインスタンス化 | `LifetimeScope` (抽象MonoBehaviour) | Unityライフサイクル |
| **Presenter** | ビジネスロジックの制御 | `PresenterBase<TView, TModel>` | `IStartable`, `ITickable`, `IDisposable` |
| **View** | UI表示とイベント転送 | `ViewBase` | `ICallUpdate` |
| **Model** | データアクセスと状態管理 | (基底クラスなし) | N/A |

**シーン初期化フロー**

```mermaid
sequenceDiagram
  participant p1 as Unity
  participant p2 as LifetimeScope (MonoBehaviour)
  participant p3 as Presenter
  participant p4 as View
  participant p5 as Model

  p1->>p2: Awake()
  p2->>p4: Viewをインスタンス化
  p2->>p5: Modelをインスタンス化
  p2->>p3: new Presenter(view | model)
  p1->>p2: Start()
  p2->>p3: IStartable.Start()
  p3->>p4: Init()
  p3->>p5: データを初期化
  p3->>p3: SetEvent()
  p3->>p3: InitAsync()
  loop 毎フレーム
    p1->>p2: Update()
    p2->>p3: ITickable.Tick()
    p3->>p4: CallUpdate()
  end
  p1->>p2: OnDestroy()
  p2->>p3: IDisposable.Dispose()
  p3->>p3: クリーンアップ
```

このパターンはUnityのライフサイクルをビジネスロジックから分離し、プレゼンターをテスト可能にし、ビューを純粋にリアクティブにします。



 高レベル図4

---

## タイトルシーン 

タイトルシーン（`Title.unity`）はアプリケーションのエントリポイントとして機能し、初期化、メインメニューの表示、楽曲選択シーンへの遷移を処理します。

### シーン構造 

```mermaid
flowchart TD

TLS["TitleLifetimeScope (シーンルート)"]
TSV["TitleSceneView GameObje...<br>...(シリアライズされたオブジェクト)"]
CANVAS["Canvas"]
CAMERA["Camera"]
TOP["TopPanel"]
BG["BgImage"]
TITLE["TitleImage"]
TOUCH["TouchToStartImage"]
PARTICLE["TouchToStartUIParticle"]
START["StartButton"]
MENU["MenuButton"]
VERSION["VersionText"]
MENU_PANEL["MenuPanel (初期状態で非表示)"]
NOTICE["NoticePanelController"]
PACKAGE["PackagePanelController"]
SETTINGS["TitleMenuSettingPanelController"]
FAQ["FAQコンテンツ"]
LICENSE["ライセンスコンテンツ"]
BACKUP["バックアップコンテンツ"]
TSP["TitleScenePresenter"]

TLS -.->|"制御"| TSP
TSP -.->|"参照"| TSV
TSP -.->|"生成"| MENU_PANEL

subgraph タイトルシーン階層 ["タイトルシーン階層"]
    TLS
    TSV
    CANVAS
    CAMERA
    TSV -.->|"参照"| START
    TSV -.->|"参照"| MENU
    TSV -.->|"参照"| TITLE
    TSV -.-> TOUCH

subgraph メニューシステム ["メニューシステム"]
    MENU_PANEL
    NOTICE
    PACKAGE
    SETTINGS
    FAQ
    LICENSE
    BACKUP
end

subgraph UI要素 ["UI要素"]
    TOP
    BG
    TITLE
    TOUCH
    PARTICLE
    START
    MENU
    VERSION
end
end
```

シーンは、すべてのUIコンポーネントへの参照を保持する単一の`TitleSceneView` GameObjectを使用します（階層からインスタンス化）。`MenuButton`はネストされたパネルの表示を切り替えます。

### TitleScenePresenter 

プレゼンターはタイトル画面のフローを制御します：

**主な責務:**

1. **ディレクトリ作成** - ユーザーコンテンツ用の外部ディレクトリが存在することを確認 ( ) * `ExternalDirectory.CreateSongsDirectory()` * `ExternalDirectory.CreateNoteSkinsDirectory()` * `ExternalDirectory.CreateGlobalLuaDirectory()`
2. **アニメーションシーケンス** - タイトルイントロアニメーションを再生 ( ) ``` await _view.AnimateTitleAsync() _view.SetEnableStartButton(true) ```
3. **スタートボタンロジック** - 遷移前にSongsフォルダを検証 ( ) ``` Directory.Exists(songsDirectory)をチェック subFolders.Length > 0をチェック 有効な場合: FadeManager.Instance.StartFadeOutAsync(SceneBuildIndex.SelectMusic) 無効な場合: ShowSongsDirectoryPanel(songsDirectory) ```
4. **プラットフォーム固有のセットアップ** - iOSのiCloudバックアップ除外を設定 ( )

### MenuPanelController 

`MenuPanelController`は遅延読込を伴うマルチパネルメニューシステムを管理します：

| パネル | コントローラークラス | 目的 |
| --- | --- | --- |
| Notice | `NoticePanelController` | サーバーからのお知らせを表示 |
| Package | `PackagePanelController` | 楽曲パッケージをダウンロード |
| Settings | `TitleMenuSettingPanelController` | 言語、オンライン、サーバー設定 |
| FAQ | (WebView) | FAQドキュメントを開く |
| License | (WebView) | ライセンス情報を開く |
| Backup | (ダイアログベース) | セーブデータのバックアップ/復元 |

**パネル開くパターン** (

)

```
async UniTask OpenPanelAsync<T>() where T : MenuContentPanelBase
    _mainPanel.SetActive(false)
    _scrollRect.verticalNormalizedPosition = 1f  // スクロールを最上部にリセット
    
    if (パネルがまだインスタンス化されていない)
        RotateLoadingControllerを表示
        await panel.InitAsync()
        RotateLoadingControllerを非表示
    
    panel.SetActive(true)
```

この遅延読込パターンにより、起動時にすべてのパネルが初期化されることを防ぎ、初期読込時間を改善します。



 

---

## リザルトシーン 

リザルトシーン（`Result.unity`）はゲームプレイの結果を表示し、パフォーマンスデータを可視化し、スコアの永続化を処理します。

### MVPトライアド構造 

```mermaid
flowchart TD

RLS["ResultLifetimeScope"]
RSP["ResultScenePresenter"]
RSM["ResultSceneModel"]
RSV["ResultSceneView"]
ANIM["ResultAnimationController アニメーションシーケンス"]
CLEAR["ClearStateViewController Clear/FC/AB状態"]
ONLINE["ResultOnlinePanel マルチプレイヤー結果"]
RATE["ResultMusicRatePanel 速度変更表示"]
GRAPH["ResultGraph ライフグラフ描画"]
TIMING["ResultAutoTimingPanel タイミング調整UI"]
HISTOGRAM["ResultTimingHistogramController KDEヒストグラム"]
JUDGE["ResultJudgeOptionPanel 判定設定"]
HISTORY["ResultScoreHistoryPanel 過去のスコア"]
RANKING["ResultRankingResultPanel オンラインランキング"]
SCORE_DB["ScoreDataBaseConnector"]
LITEDB["LiteDB player.db"]
CALC["スコア計算 ランク, ClearState"]

RSP -.->|"使用"| GRAPH
RSP -.->|"制御"| TIMING
RSV -.->|"含む"| ANIM
RSV -.->|"含む"| CLEAR
RSV -.->|"制御"| ONLINE
RSV -.->|"含む"| RATE
RSV -.->|"含む"| HISTOGRAM
RSV -.->|"含む"| JUDGE
RSV -.-> HISTORY
RSV -.->|"実行"| RANKING
RSM -.->|"制御"| SCORE_DB
RSM -.->|"クエリ/更新"| CALC

subgraph Model操作 ["Model操作"]
    SCORE_DB
    LITEDB
    CALC
end

subgraph Viewコンポーネント ["Viewコンポーネント"]
    ANIM
    CLEAR
    ONLINE
    RATE
    GRAPH
    TIMING
    HISTOGRAM
    JUDGE
    HISTORY
    RANKING
end

subgraph リザルトシーンMVP ["リザルトシーンMVP"]
    RLS
    RSP
    RSM
    RSV
    RLS -.->|"インスタンス化"| RSP
    RSP -.->|"含む"| RSV
    RSP -.->|"使用"| RSM
end
```



 

### ResultScenePresenterフロー 

プレゼンターは非同期操作の線形シーケンスを実行します：

```mermaid
sequenceDiagram
  participant p1 as Presenter
  participant p2 as Model
  participant p3 as View
  participant p4 as ResultGraph
  participant p5 as ScoreDataBaseConnector
  participant p6 as ResultBgmController

  note over p1: Start()
  p1->>p2: InitializeModel()
  p2->>p2: ランク、クリア状態を計算
  p2->>p5: GetPlayerScores()
  p5-->>p2: 以前のスコア
  p1->>p3: InitializeView()
  p3->>p3: ジャケット、タイトル、難易度を設定
  p3->>p3: 判定数、コンボ、スコアを設定
  p3->>p3: ランクスプライト、クリア状態を設定
  p1->>p4: Init(lifeHistory | lifeOption)
  p1->>p6: PlayResultBgm()
  note over p1: アニメーションシーケンス
  p1->>p3: PlayResultAnimationAsync()
  p3-->>p1: アニメーション完了
  p1->>p3: SetInteractable(true)
  note over p1: スコア保存（有効な場合）
  p1->>p2: IsSaveScore()
  alt 保存可能
    p1->>p2: SaveScore()
    p2->>p5: SetPlayerScore()
  end
  note over p1: ランキング送信（有効な場合）
  p1->>p1: SendRankingAsync()
```

**主要メソッド:**

* `InitializeModel()` - ランクを計算し、新記録をチェック ( )
* `InitializeView()` - `ResultData`からすべてのテキスト/画像コンポーネントを設定 ( )
* `InitializeControllers()` - グラフとヒストグラムレンダラーにデータを渡す ( )
* `RunResultSequenceAsync()` - フローを調整するメインエントリポイント ( )



### ResultSceneViewコンポーネント参照 

ビューは複数のサブコントローラーを集約します：

| フィールド | 型 | 目的 |
| --- | --- | --- |
| `_resultAnimationController` | `ResultAnimationController` | スコア/コンボ表示のDOTweenアニメーションをシーケンス |
| `_clearStateViewController` | `ClearStateViewController` | CLEAR/FAIL/AB/FCバッジを表示 |
| `_resultOnlinePanel` | `ResultOnlinePanel` | マルチプレイヤーでの他プレイヤーのスコアを表示 |
| `_musicRatePanel` | `ResultMusicRatePanel` | 楽曲速度変更を表示（0.5x - 2.0x） |
| `_groupToggleTextColorController` | `GroupToggleTextColorController` | パネルタブを管理（判定/履歴/タイミング） |
| `_judgeOptionPanel` | `ResultJudgeOptionPanel` | カスタム判定ウィンドウ設定 |
| `_timingHistogramController` | `ResultTimingHistogramController` | 入力タイミングのKDEヒストグラム |
| `_scoreHistoryPanel` | `ResultScoreHistoryPanel` | LiteDBからの過去10スコア |


### リザルト可視化コンポーネント 

**ResultGraph** - ライフゲージ履歴レンダラー

プレイヤーのライフゲージの時間経過を折れ線グラフで描画します。`ResultData`から`LifeHistory`配列を受け取り、UnityのUIVertexシステムを使用してグラフメッシュを描画します。

**ResultTimingHistogramController** - タイミング誤差のKDE分布


ヒストグラムはタイミング誤差を100ビンにグループ化し、滑らかな曲線のためにカーネル密度推定を適用します。統計値（中央値、最頻値、平均）はテキストラベルとして表示されます。



 

### スコア永続化フロー 

```mermaid
sequenceDiagram
  participant p1 as Presenter
  participant p2 as Model
  participant p3 as ScoreDataBaseConnector
  participant p4 as LiteDB (player.db)

  note over p1: スコアを保存すべきかチェック
  p1->>p2: IsSaveScore()
  p2->>p2: playMode != Autoをチェック
  p2->>p2: customJudge保存許可をチェック
  p2-->>p1: bool canSave
  alt canSave == true
    p1->>p2: SaveScore()
    p2->>p3: SetPlayerScore(resultData | folderName | difficulty)
    p3->>p4: GetCollection<PlayerScore>("player_score")
    p3->>p4: 既存スコアをクエリ
    p4-->>p3: PlayerScore[]
    p3->>p3: スコア降順でソート
    p3->>p3: MAX_SCORE_DATA_COUNT (10)に制限
    p3->>p4: Upsert(playerScore)
    p3->>p4: DeleteMany(古いスコア)
    note over p2: キャッシュを更新
    p2->>p2: ScoreDataPrefas.Instanceを更新
    p2->>p2: FolderScoreCacheを更新
  end
```

データベースは(folderName, difficulty)ペアごとに最大10スコアを保存します。制限を超える古いスコアは自動的に削除されます。

**データベーススキーマ**

```
public sealed class PlayerScore
{    
  public int Id { get; set; }
  public string FolderName { get; set; }
  public int Difficulty { get; set; }
  public int Score { get; set; }
  public int ClearState { get; set; }
  public string Date { get; set; }
}
```


## 共有UIコンポーネント 

アプリケーションはクロスシーンUI機能のためにシングルトンマネージャーを使用します。

### DialogManager 

優先度ベースのモーダルダイアログシステム。ダイアログはスタック可能で、最上位のものが入力をキャプチャします。

**ダイアログ作成パターン**

```c#
var localize = LocalizeManager.Instance;
var builder = new DialogParametor.Builder(headerText, bodyText);
builder.AddDefaultAction(buttonText, () => { /* コールバック */ });
builder.AddCancelAction(buttonText, () => { /* コールバック */ });
builder.AddCallbackOnAutoClosed(() => { /* クリーンアップ */ });
DialogManager.Instance.Open(builder.Build());
```

**機能:**

* 複数のボタンタイプ（デフォルト、キャンセル、破壊的）
* タイムアウト後の自動クローズ
* クローズ時のコールバック（ボタンクリックまたは自動クローズのいずれか）
* ダイアログの重複を防ぐ優先度キュー



 高レベル図4

### FadeManager 

非同期操作でシーン遷移フェードを処理します。

**API:**

* `SetBlack()` - 即座に黒画面（シーン初期化用）
* `StartFadeInAsync()` - 黒からクリアへフェード
* `StartFadeOutAsync(sceneIndex, useHeavyGC)` - 黒へフェード、その後シーン読込

主要な遷移ポイントで呼び出されます：

* タイトル → 楽曲選択: 
* 楽曲選択 → ゲーム: （同様のパターン）
* ゲーム → リザルト: （同様のパターン）
 

### LocalizeManager 

Unityのローカライゼーションパッケージのラッパーで、ローカライズされた文字列への型安全なアクセスを提供します。

**文字列取得**

```c#
var localize = LocalizeManager.Instance;
string closeButton = localize.GetStringValue(LocalizationConstant.CloseButton);
string formattedError = localize.GetStringFormat(LocalizationConstant.ERROR_NO_SONGS_TEXT, dir);
```

**定数生成**
すべてのローカライゼーションキーは`LocalizationConstant.cs`で`const long`値として自動生成されます。これによりコンパイル時の安全性とIDEオートコンプリートが提供されます。

```c#
public static class LocalizationConstant
{
    public const long CloseButton = 44982853632;
    public const long BackButton = 429172711424;
    // ... 500以上のエントリ
}
```

**言語サポート:**

* 日本語（ja）
* 英語（en）

### BgManager 

シーン間で背景画像/動画を管理します。読みやすさのために背景を暗くすることができます。

### SystemSEManager 

UIサウンドエフェクトの再生を提供するシングルトン（ボタンクリック、パネル開くなど）。CriWareオーディオミドルウェアと統合されています。

---

## シーン遷移フロー 

完全なシーン遷移パイプライン：

```mermaid
flowchart TD

START["ユーザーがボタンをクリック"]
DISABLE["ダブルクリックを防ぐためボタンを無効化"]
ANALYTICS["AnalyticsManager.SendEvent()"]
FADE_START["FadeManager.StartFadeOutAsync(sceneIndex)"]
FADE["DOTweenで黒へフェード (期間 ~0.5s)"]
LOAD["GameManager.ChangeSceneAsync(sceneIndex)"]
SCENE_LOAD["SceneManager.LoadSceneAsync()"]
UNLOAD["Resources.UnloadUnusedAssets()"]
GC["System.GC.Collect()"]
NEW_SCENE["新しいシーンのLifetimeScope.Awake()"]
PRESENTER["Presenter.Start()"]
FADE_IN["FadeManager.StartFadeInAsync()"]
END["シーンがアクティブ"]

START -.->|"1"| DISABLE
DISABLE -.->|"2"| ANALYTICS
ANALYTICS -.->|"3"| FADE_START
FADE -.->|"5"| LOAD
LOAD -.->|"6a"| SCENE_LOAD
LOAD -.->|"6b"| UNLOAD
LOAD -.->|"6c"| GC
PRESENTER -.->|"9"| FADE_IN
```

**最適化ノート:**

1. `useHeavyGCCollect`パラメータ ( ) * `true`: `GC.Collect()`を3回実行（重いが徹底的） * `false`: `GC.Collect()`を1回実行（高速な遷移用）
2. アセットアンロードは黒画面中に行われ、パフォーマンスコストが隠されます
3. シーンの加算読込は使用されません；各シーンは前のシーンを完全に置き換えます



 

---

## 共通UIパターン 

### ボタンイベントバインディング 

ビューはボタンイベントをプロパティとして公開し、プレゼンターは初期化時にサブスクライブします：

 

### 非同期初期化 

長時間実行される操作はキャンセレーショントークンを持つ`async UniTask`メソッドを使用します

**利点:**

* 起動中のノンブロッキングUI
* キャンセル可能な操作（`CancellationTokenSource`経由）
* シーケンシャルな非同期操作が読みやすい（コールバック地獄なし）



 

### 遅延パネル読込 

パネルはシーン開始時ではなく、最初のアクセス時にインスタンス化されます：

```c#
if (_packagePanelController == null)
{    
    _rotateLoadingController.SetActive(true);    
    await _packagePanelController.InitAsync();
    _rotateLoadingController.SetActive(false);
}
```

このパターンにより、初期メモリフットプリントと起動時間が削減されます。

### On this page

* [UIとシーン管理](#8-ui)
* [シーンにおけるMVPパターン](#8-mvp)
* [タイトルシーン](#8-)
* [シーン構造](#8--1)
* [TitleScenePresenter](#8-titlescenepresenter)
* [MenuPanelController](#8-menupanelcontroller)
* [リザルトシーン](#8--2)
* [MVPトライアド構造](#8-mvp-1)
* [ResultScenePresenterフロー](#8-resultscenepresenter)
* [ResultSceneViewコンポーネント参照](#8-resultsceneview)
* [リザルト可視化コンポーネント](#8--3)
* [スコア永続化フロー](#8--4)
* [共有UIコンポーネント](#8-ui-1)
* [DialogManager](#8-dialogmanager)
* [FadeManager](#8-fademanager)
* [LocalizeManager](#8-localizemanager)
* [BgManager](#8-bgmanager)
* [SystemSEManager](#8-systemsemanager)
* [シーン遷移フロー](#8--5)
* [共通UIパターン](#8-ui-2)
* [ボタンイベントバインディング](#8--6)
* [非同期初期化](#8--7)
* [遅延パネル読込](#8--8)

