

# アセット管理 

## 概要 

アセット管理システムは、組み込みアセット用のUnityのAddressablesシステムと、ユーザー提供コンテンツ用の直接ファイルシステムアクセスを組み合わせた**ハイブリッドアプローチ**を採用しています。このアーキテクチャにより、リズムゲームはコアアセットを同梱しながら、外部譜面パック、カスタムスキン、ユーザー追加楽曲による拡張性をサポートできます。

システムは3つの主要な関心事に整理されています：

* **読込戦略**：異なるソースからアセットを取得する方法
* **キャッシュメカニズム**：読み込まれたアセットを保持し、冗長なI/Oを防ぐ方法
* **ライフサイクル管理**：アセットがいつ読み込まれ、解放されるか

データ永続化（セーブファイル、設定）については[データ永続化システム](#2.3)を参照してください。譜面ファイルの解析については[ノートと譜面管理](#3.2)を参照してください。

---

## アセット読込アーキテクチャ 

以下の図は、全体的なアセット読込パイプラインを示しています：

**アセット読込パイプライン概要**

```mermaid
flowchart TD

%% ===== アセットソース =====
ADDR["Unity Addressables<br/>(組み込みアセット)"]
EXT["外部ファイルシステム<br/>(ユーザーコンテンツ)"]
STREAM["StreamingAssets<br/>(CRI ミドルウェア)"]

%% ===== ローダー =====
ADDR_LOADER["AddressableLoader"]
TEX_LOADER["TextureLoader<br/>FolderTextureLoader"]
SEQ_READER["SequenceReader"]
SONG_LOADER["SongInfoLoader"]
CHART_LOADER["ChartInfoLoader"]

%% ===== キャッシュ =====
ADDR_CACHE["AssetGroupHandle List"]
FOLDER_TEX["FolderTextureCache"]
SONG_CACHE["SongInfoCache"]
CHART_CACHE["ChartInfoCache"]
SKIN_CACHE["NoteSkinCache<br/>TouchSeCache"]

%% ===== 利用者 =====
SELECT["楽曲選択シーン"]
GAME["ゲームプレイシーン"]
RESULT["リザルトシーン"]
LUA["Lua スクリプト"]

%% --- ソース → ローダー ---
ADDR --> ADDR_LOADER
EXT --> TEX_LOADER
EXT --> SEQ_READER
EXT --> SONG_LOADER
EXT --> CHART_LOADER
STREAM --> GAME

%% --- ローダー → キャッシュ ---
ADDR_LOADER --> ADDR_CACHE
TEX_LOADER --> FOLDER_TEX
SONG_LOADER --> SONG_CACHE
CHART_LOADER --> CHART_CACHE
SEQ_READER --> SKIN_CACHE

%% --- Lua → ローダー ---
LUA --> ADDR_LOADER
LUA --> TEX_LOADER

%% --- キャッシュ → 利用者 ---
ADDR_CACHE --> SELECT
ADDR_CACHE --> GAME
FOLDER_TEX --> SELECT
SONG_CACHE --> SELECT
CHART_CACHE --> GAME
SKIN_CACHE --> GAME
GAME --> RESULT

subgraph アセットソース ["アセットソース"]
    ADDR
    EXT
    STREAM
end

subgraph ローダー ["ローダー"]
    ADDR_LOADER
    TEX_LOADER
    SEQ_READER
    SONG_LOADER
    CHART_LOADER
end

subgraph キャッシュ ["キャッシュ"]
    ADDR_CACHE
    FOLDER_TEX
    SONG_CACHE
    CHART_CACHE
    SKIN_CACHE
end

subgraph 利用者 ["利用者"]
    SELECT
    GAME
    RESULT
    LUA
end

```

## Addressablesによる組み込みアセット読込 

UnityのAddressablesシステムは、アプリケーションに同梱されるすべてのアセットに使用されます。`AddressableLoader`クラスは、グループベースのライフサイクル管理抽象化を提供します。

### AddressableLoaderの実装 

`AddressableLoader`は、シーン固有の読込とクリーンアップを可能にするグループベースのアセット管理を実装しています：

**AddressableLoaderのグループ管理**

```mermaid
flowchart TD

%% ===== シーン =====
SELECT_SCENE["SelectMusicScene<br/>groupId = GetHashCode()"]
GAME_SCENE["GameScene<br/>groupId = GetHashCode()"]
RESULT_SCENE["ResultScene<br/>groupId = GetHashCode()"]

%% ===== AddressableLoader =====
LOAD["LoadAsync(groupId)"]
RELEASE["ReleaseGroup(groupId)"]
HANDLE_LIST["_assetGroupHandleList<br/>List&lt;AssetGroupHandle&gt;"]

subgraph AddressableLoader ["AddressableLoader"]
    LOAD
    RELEASE
    HANDLE_LIST
end

%% ===== Unity Addressables =====
ADDR_API["Addressables API"]

subgraph Unity_Addressables ["Unity Addressables"]
    ADDR_API
end

%% --- シーン → Loader ---
SELECT_SCENE -->|ロード要求| LOAD
GAME_SCENE -->|ロード要求| LOAD
RESULT_SCENE -->|ロード要求| LOAD

SELECT_SCENE -->|解放要求| RELEASE
GAME_SCENE -->|解放要求| RELEASE
RESULT_SCENE -->|解放要求| RELEASE

%% --- Loader 内部処理 ---
LOAD -->|"LoadAssetAsync()<br/>ハンドル生成"| ADDR_API
ADDR_API -->|"AsyncOperationHandle"| LOAD
LOAD -->|"groupId と紐付けて保存"| HANDLE_LIST

RELEASE -->|"groupId で検索"| HANDLE_LIST
RELEASE -->|"Release(handle)"| ADDR_API

```

**主要コンポーネント：**

| クラス | 目的 |
| --- | --- |
| `AddressableLoader` | グループベースのライフサイクル管理を持つ静的ローダー |
| `AssetGroupHandle` | Unityの`AsyncOperationHandle`を`GroupId`に関連付ける |
| `_assetGroupHandleList` | グループごとに読み込まれたすべてのアセットを追跡する静的リスト |

**使用パターン：**

1. **読込**：呼び出し側はアセットアドレスとともに`groupId`（通常はリクエストオブジェクトのハッシュコード）を提供
2. **追跡**：読み込まれた各アセットは`AssetGroupHandle`にラップされ、`_assetGroupHandleList`に保存される
3. **解放**：`ReleaseGroup(groupId)`を呼び出すと、そのグループに関連付けられたすべてのアセットが解放される

出典：

### Addressableアセットタイプ 

以下のアセットタイプがAddressables経由で読み込まれます：

| アセットタイプ | 目的 | アドレス例 |
| --- | --- | --- |
| **テクスチャ** | UIグラフィック、デフォルト画像 | `TEXTUREALL_SONGS`、`TEXTURENO_GROUP`、`TEXTURENO_IMAGE` |
| **プレハブ** | ノートオブジェクト、エフェクト、UIパネル | ゲームプレイシーンで読み込まれる |
| **オーディオクリップ** | UIサウンドエフェクト | `SystemSEManager`によって個別に管理 |

実際のアセットアドレスは`AddressableAssetAddress`定数で定義されています（コードで参照されていますが、ファイルリストには含まれていません）。

### グループベースライフサイクルの例 

**典型的なシーンライフサイクル：**

```mermaid
sequenceDiagram
  participant p1 as FolderSelectPanel
  participant p2 as AddressableLoader
  participant p3 as Unity Addressables

  note over p1: 初期化フェーズ
  p1->>p1: groupId = GetHashCode()
  p1->>p2: LoadAsync<Texture>(ct | "TEXTUREALL_SONGS" | groupId)
  p2->>p3: Addressables.LoadAssetAsync<Texture>()
  p3-->>p2: AsyncOperationHandle
  p2->>p2: AssetGroupHandle(groupId | handle)を保存
  p2-->>p1: Textureアセット
  note over p1: 使用フェーズ
  p1->>p1: レンダリングにテクスチャを使用
  note over p1: クリーンアップフェーズ (OnDestroy)
  p1->>p2: ReleaseGroup(groupId)
  p2->>p2: groupIdのすべてのハンドルを検索
  loop 各ハンドルについて
    p2->>p3: Addressables.Release(handle)
  end
  p2->>p2: リストからすべて削除
```

## 外部コンテンツ読込 

ユーザー提供のコンテンツ（楽曲、譜面、カスタムテクスチャ）は、ファイルシステムから直接読み込まれます。このセクションでは、外部コンテンツを担当するローダーについて詳しく説明します。

### 外部ディレクトリシステム 

`ExternalDirectory`クラス（ファイルには含まれていませんが、全体で参照されています）は、プラットフォーム固有のファイルシステムパスを抽象化します：

**プラットフォーム固有のパス：**

| プラットフォーム | ベースパス | 用途 |
| --- | --- | --- |
| **Windows** | `AppData/LocalLow` | 永続的なユーザーコンテンツ |
| **Android** | 外部ストレージ | 実行時権限が必要 |
| **iOS** | Documentsディレクトリ | アプリ固有のストレージ |

システムは以下のパスを提供します：

* `SongsPath`：ユーザー追加楽曲フォルダ
* `GlobalLuaPath`：カスタムLuaスクリプト
* `NoteSkinPath`：カスタムノートスキンアセット
* `TouchSePath`：カスタムタッチサウンドエフェクト

出典：高レベルアーキテクチャの図3、

で参照

### テクスチャ読込 

**FolderTextureLoader**

`FolderTextureLoader`は楽曲フォルダのジャケット/バナー画像をスキャンします：

**フォルダテクスチャ読込プロセス**

```mermaid
flowchart TD

START["LoadTextureAsync()"]
GET_FOLDERS["GroupFolderNameListを取得"]
LOOP_START["各フォルダについて"]
BUILD_PATH["ディレクトリパスを構築"]
SEARCH[".png/.jpg/.jpegを検索"]
FOUND{"画像が見つかった？"}
LOAD_TEX["TextureLoader.Load(path)"]
LOAD_NO_IMG["Addressablesから<br/>TEXTURENO_IMAGEを読込"]
STORE["(Texture, hasImage)を結果に追加"]
LOOP_END{"さらにフォルダ？"}
RETURN["List&lt;(Texture, bool)&gt;を返す"]

START --> GET_FOLDERS
GET_FOLDERS --> LOOP_START
LOOP_START --> BUILD_PATH
BUILD_PATH --> SEARCH
SEARCH --> FOUND
FOUND -->|"はい"| LOAD_TEX
FOUND -->|"いいえ"| LOAD_NO_IMG
LOAD_TEX --> STORE
LOAD_NO_IMG --> STORE
STORE --> LOOP_END
LOOP_END -->|"はい"| LOOP_START
LOOP_END -->|"いいえ"| RETURN
```

**実装の詳細：**

ローダーは複数の拡張子で画像ファイルを検索します：

```
var extensions = new string[] { "*.png", "*.jpg", "*.jpeg", "*.PNG", "*.JPG", "*.JPEG" };
```

画像が見つからない場合、Addressables経由で読み込まれるデフォルトの「画像なし」テクスチャにフォールバックします。

**TextureLoader**

`TextureLoader`クラス（提供されていませんが参照されています）は、低レベルのテクスチャファイル読込を処理します。

で`FolderTextureLoader`によって呼び出されます：

```
texture = TextureLoader.Load(path);
```

これは、ディスクから画像ファイルを読み取り、Unityの`Texture2D`オブジェクトを作成する静的ユーティリティであることを示唆しています。

### 楽曲メタデータ読込 

**SongInfoLoader**

`SongInfoLoader`（ファイルには提供されていません）は、アプリケーション起動時に再帰的なディレクトリスキャンを実行して`SongInfoCache`を構築します。以下を実行します：

1. `ExternalDirectory.SongsPath`ディレクトリをスキャン
2. 譜面ファイルヘッダーを解析してメタデータ（タイトル、アーティスト、BPM、難易度値）を抽出
3. 完全な譜面データを読み込まずに`SongInfo`オブジェクトを生成
4. 結果を`SongInfoCache`に保存

この遅延読込戦略により、完全な譜面データをメモリに読み込むことなく、楽曲選択UIで何百もの楽曲を表示できます。

### 譜面データ読込 

**SequenceReader**

`SequenceReader`（参照されていますが提供されていません）は、楽曲がプレイ用に選択されたとき、または譜面の詳細が要求されたときに完全な譜面解析を実行します：

```
sequence = _sequenceReader.Read(songInfo, difficultyType);
```

これは以下を含む`Sequence`オブジェクトを返します：

* `BeatPositions`：ノートタイミングのリスト
* `NoteTypes`：各ノートのタイプ（Normal、Long、Fuzzyなど）
* `Lanes`：各ノートのレーン配置
* `LongInfo`：ロングノートのペアリング情報
* `Credit`：譜面作者情報

**ChartInfoLoader**

`ChartInfoLoader`（提供されていません）は、すべての楽曲の譜面メタデータを非同期に読み込みます。これは、ユーザーがノート数でソートしたい場合にソートパネルによってトリガーされます：

```
await new ChartInfoLoader().LoadAllChartInfoAsync(ct, OnLoadedSong);
```

各楽曲の各難易度のノート数データで`ChartInfoCache`を生成し、以下のようなソート操作を可能にします：

* 総ノート数でソート
* 黄色/青色/緑色ノート数でソート

---

## キャッシュシステム 

複数の特化したキャッシュ実装が、冗長なファイルI/Oと解析を防ぎます。各キャッシュには明確な目的とライフサイクルがあります。

### キャッシュアーキテクチャ概要 

**キャッシュシステムの関係**

```mermaid
flowchart TD

subgraph データソース ["データソース"]
    FOLDER_LOADER["FolderTextureLoader"]
    SONG_LOADER["SongInfoLoader"]
    CHART_LOADER["ChartInfoLoader"]
    FILE_SYSTEM["ファイルシステム"]
    SCORE_DB["ScoreDataPrefas"]
end

subgraph キャッシュ実装 ["キャッシュ実装"]
    FOLDER_CACHE["FolderTextureCache"]
    SONG_CACHE["SongInfoCache"]
    CHART_CACHE["ChartInfoCache"]
    SKIN_CACHE["NoteSkinCache"]
    SE_CACHE["TouchSeCache"]
    FOLDER_SCORE["FolderScoreCache"]
end

subgraph 利用者 ["利用者"]
    FOLDER_PANEL["FolderSelectPanel"]
    SCROLL_VIEW["楽曲リストScrollView"]
    SORT_PANEL["SortPanelController"]
    GAME["ゲームプレイシーン"]
end

%% データソース → キャッシュ
FOLDER_LOADER --> FOLDER_CACHE
SONG_LOADER --> SONG_CACHE
CHART_LOADER --> CHART_CACHE
FILE_SYSTEM --> SKIN_CACHE
FILE_SYSTEM --> SE_CACHE
SCORE_DB --> FOLDER_SCORE

%% キャッシュ → 利用者
FOLDER_CACHE --> FOLDER_PANEL
SONG_CACHE --> SCROLL_VIEW
CHART_CACHE --> SORT_PANEL
SKIN_CACHE --> GAME
SE_CACHE --> GAME
FOLDER_SCORE --> FOLDER_PANEL
```

### FolderTextureCache 

**目的**：ファイルシステムから読み込まれたフォルダバナー/ジャケットテクスチャをキャッシュします。

**実装**：

| プロパティ | 型 | 説明 |
| --- | --- | --- |
| `_cache` | `List<(Texture, bool)>` | hasImageフラグ付きのキャッシュされたテクスチャ |
| `HasCache` | `bool` | キャッシュが生成されている場合trueを返す |

**ライフサイクル**：

1. 初回アクセス：`FolderTextureLoader`がすべてのフォルダ画像を読み込む
2. 結果を`SetCache()`で保存
3. 以降のアクセス：`GetCache()`がキャッシュされたデータを返す
4. クリーンアップ：`Clear()`がテクスチャを破棄し、キャッシュを空にする

**主要機能**：`hasImage`ブール値は、実際のフォルダ画像とフォールバック「画像なし」テクスチャを区別し、適切なクリーンアップを可能にします（ファイルから読み込まれたテクスチャのみを破棄し、Addressableフォールバックは破棄しない）。

### SongInfoCache 

**目的**：アプリケーション起動時に読み込まれるすべての楽曲メタデータのグローバルシングルトンキャッシュ。

**構造**：

```
public class SongInfoCache : Serializable<SongInfoCache>{    
    public SongInfo[] Data;
    public bool HasChartInfoCache;
}
```

`Data`配列には以下を含む`SongInfo`オブジェクトが含まれます：

* `Title`、`Artist`、`ChartArtist`
* `BaseBpm`
* `Difficulty`配列（難易度ごとのレベル）
* `FolderName`、`GroupFolderIndex`
* `LastWriteTime`
* `ChartInfoList`（後で`ChartInfoLoader`によって生成される）

**使用パターン**：

```
var songInfos = SongInfoCache.Instance.Data;
```

このキャッシュは以下によって照会されます：

* 楽曲リストを表示する楽曲選択スクロールビュー
* 楽曲をグループ化するフォルダシステム
* 楽曲を整理するソートシステム

### ChartInfoCache 

**目的**：各譜面のノート数統計を保存し、ノート数でのソート操作を可能にします。

**生成**：
キャッシュは以下を行う`ChartInfoLoader`によって生成されます：

1. `SongInfoCache`内のすべての楽曲を反復
2. 各譜面ファイルを読み込んで解析
3. タイプ別にノートをカウント
4. 各`SongInfo.ChartInfoList`に`ChartInfo`オブジェクトを保存

**メモリ最適化**：
譜面データはカウントされますが保持されないため、完全な譜面データをメモリに保持することなく、ノートベースのソートが可能になります。

### FolderScoreCache 

**目的**：フォルダ選択パネルでの表示用に、フォルダごとのスコア統計を集約します。

**データモデル**：

```mermaid
classDiagram
    class FolderScore {
        +int[] AB
        +int[] FC
        +int[] Clear
    }
    class FolderScoreCache {
        -Dictionary<short,FolderScore> _folderScoreDict
        +SetCache()
        +GetMusicFolderNameAndDifficulty()
    }
    class MusicScoreData {
        +short FolderIndex
        +string MusicFolder
        +int Difficulty
        +int Score
        +bool Ab
        +bool Fc
        +bool Clear
    }
    FolderScoreCache --> FolderScore : 作成
    FolderScoreCache ..> MusicScoreData
```

**キャッシュ生成プロセス**：

1. `ScoreDataPrefas.instance.ScoreDataList`からすべての`ScoreData`を読み込む
2. 各スコアのIDを解析してフォルダ名と難易度を抽出
3. `SongInfoCache`からフォルダインデックスを検索
4. フォルダと難易度ごとにカウントを`FolderScore`配列に集約
5. フォルダインデックスをキーとして`_folderScoreDict`に保存
6. 特別なキー`-1`はすべてのフォルダの合計を保存

**配列構造**：
各`FolderScore`には難易度（0-4）でインデックス付けされた3つの配列が含まれます：

* `AB[difficulty]`：All Brilliantクリア数
* `FC[difficulty]`：フルコンボクリア数
* `Clear[difficulty]`：通常クリア数

### NoteSkinCacheとTouchSeCache 

これらのキャッシュ（ファイルには提供されていません）はカスタムコンテンツを処理します：

**NoteSkinCache**：

* `ExternalDirectory.NoteSkinPath`からカスタムノートスプライトシートを読み込む
* スキン名でインデックス付け
* ゲームプレイ中にカスタムノートの外観を適用するために使用

**TouchSeCache**：

* `ExternalDirectory.TouchSePath`からカスタムタッチサウンドエフェクトを読み込む
* デフォルトのヒット音を置き換える
* ユーザー設定に基づいてゲームプレイ中に適用

## アセットライフサイクル管理 

### シーンベースの読込 

アセットはシーン遷移に結び付けられた予測可能なライフサイクルに従います：

### メモリ管理戦略 

システムは、メモリ使用量を最小限に抑えるためにいくつかの戦略を採用しています：

| 戦略 | 実装 | 利点 |
| --- | --- | --- |
| **遅延読込** | `SongInfoLoader`はヘッダーのみを解析 | 高速起動、低メモリ |
| **オンデマンド譜面読込** | `SequenceReader`は必要に応じて完全な譜面を読み込む | メモリは総譜面数ではなくアクティブな譜面に応じてスケール |
| **グループベース解放** | Addressablesはシーンごとに解放 | アセットリークを防ぐ |
| **キャッシュ無効化** | シーン遷移時にキャッシュをクリア | 古いデータを防ぐ |
| **テクスチャ破棄** | ファイル読込テクスチャの手動`Destroy()` | GPUメモリを解放 |

### 例：楽曲選択シーンのアセットフロー 

```mermaid
sequenceDiagram
  participant p1 as SceneInit
  participant p2 as FolderSelectPanel
  participant p3 as FolderTextureLoader
  participant p4 as FolderTextureCache
  participant p5 as AddressableLoader

  p1->>p2: InitAsync()
  p2->>p2: groupId = GetHashCode()
  alt キャッシュミス
    p2->>p3: LoadTextureAsync()
  loop 各フォルダについて
    p3->>p3: 画像を検索
  alt 画像が見つかった
    p3->>p3: TextureLoader.Load()
  else 画像なし
    p3->>p5: LoadAsync("TEXTURENO_IMAGE" | groupId)
    p5-->>p3: フォールバックテクスチャ
  end
  end
    p3-->>p4: SetCache(textures)
  else キャッシュヒット
    p4-->>p2: GetCache()
  end
  p2->>p5: LoadAsync("TEXTUREALL_SONGS" | groupId)
  p5-->>p2: All Songsテクスチャ
  note over p2: シーンアクティブ
  p2->>p2: OnDestroy()
  p2->>p5: ReleaseGroup(groupId)
  p2->>p4: Clear()
  p4->>p4: ファイルテクスチャを破棄
```

## アセットタイプとファイル形式 

### サポートされている形式 

| アセットタイプ | 形式 | 場所 | ローダー |
| --- | --- | --- | --- |
| **画像** | PNG、JPG、JPEG（大文字小文字区別なし） | 外部フォルダ | `TextureLoader` |
| **譜面** | `.dl`、`.txt` | 外部楽曲フォルダ | `SequenceReader` |
| **オーディオ** | CRIミドルウェアで管理 | `StreamingAssets` | CRIシステム |
| **スプライト** | Unityアセットバンドル | Addressables | `AddressableLoader` |

### アセットアドレッシング規約 

Addressableアセットは定数識別子を使用します：

```
// コード参照からの例
AddressableAssetAddress.TEXTUREALL_SONGS
AddressableAssetAddress.TEXTURENO_GROUP
AddressableAssetAddress.TEXTURENO_IMAGE
```

これらの定数（`AddressableAssetAddress`クラスで定義）は、Addressableアセットキーへの型安全な参照を提供します。

## パフォーマンスに関する考慮事項 

### 非同期読込 

すべてのアセット読込操作は`CancellationToken`サポート付きの`async`/`await`パターンを使用します：

これにより、大規模な読込操作中のUIフリーズを防ぎます。

### キャッシュファースト戦略 

フォルダテクスチャ読込はキャッシュファーストパターンに従います

このチェックしてから読み込むパターンは、繰り返しアクセス時の冗長なファイルシステム操作を回避します。

### 進捗レポート 

`ChartInfoLoader`は長時間実行操作のための進捗コールバックをサポートします：

これにより、何百もの譜面ファイルを解析する際にUIが読込進捗を表示できます。

## 他のシステムとの統合 

### Luaスクリプト統合 

Luaスクリプトは同じ読込システムを通じて動的にアセットを読み込むことができます：

これにより、カスタム譜面スクリプトが実行時に追加のビジュアルまたはオーディオアセットを読み込むことができます。

### シリアライゼーション統合 

`File<T>`システム（[データ永続化システム](#2.3)で文書化）は、キャッシュのシリアライゼーションを処理します：
`Serializable<T>`パターンは自動保存/読込機能を提供しますが、`SongInfoCache`は通常、シリアライズされるのではなく起動時に再構築されます。

### シーンシステム統合 

各シーンは独自のアセットグループを管理します：

| シーン | グループIDソース | 読み込まれるアセット |
| --- | --- | --- |
| **MusicSelectScene** | 各コンポーネントのハッシュ | フォルダテクスチャ、UI画像、楽曲ジャケット |
| **GameScene** | シーンコントローラーのハッシュ | ノートプレハブ、エフェクトプレハブ、譜面データ |
| **ResultScene** | シーンコントローラーのハッシュ | 背景画像、UI要素 |

この分離により、シーン遷移時にアセットが適切にクリーンアップされます。

### On this page

* [アセット管理](#9-)
* [概要](#9--1)
* [アセット読込アーキテクチャ](#9--2)
* [Addressablesによる組み込みアセット読込](#9-addressables)
* [AddressableLoaderの実装](#9-addressableloader)
* [Addressableアセットタイプ](#9-addressable)
* [グループベースライフサイクルの例](#9--3)
* [外部コンテンツ読込](#9--4)
* [外部ディレクトリシステム](#9--5)
* [テクスチャ読込](#9--6)
* [楽曲メタデータ読込](#9--7)
* [譜面データ読込](#9--8)
* [キャッシュシステム](#9--9)
* [キャッシュアーキテクチャ概要](#9--10)
* [FolderTextureCache](#9-foldertexturecache)
* [SongInfoCache](#9-songinfocache)
* [ChartInfoCache](#9-chartinfocache)
* [FolderScoreCache](#9-folderscorecache)
* [NoteSkinCacheとTouchSeCache](#9-noteskincachetouchsecache)
* [アセットライフサイクル管理](#9--11)
* [シーンベースの読込](#9--12)
* [クリーンアップパターン](#9--13)
* [メモリ管理戦略](#9--14)
* [例：楽曲選択シーンのアセットフロー](#9--15)
* [アセットタイプとファイル形式](#9--16)
* [サポートされている形式](#9--17)
* [アセットアドレッシング規約](#9--18)
* [パフォーマンスに関する考慮事項](#9--19)
* [非同期読込](#9--20)
* [キャッシュファースト戦略](#9--21)
* [進捗レポート](#9--22)
* [他のシステムとの統合](#9--23)
* [Luaスクリプト統合](#9-lua)
* [シリアライゼーション統合](#9--24)
* [シーンシステム統合](#9--25)

