


# オブジェクトプールシステム

## 目的と範囲

オブジェクトプールシステムは、ゲームプレイシーンにおけるパフォーマンス重視のオブジェクト再利用インフラを提供します。リズムゲームの実行中、ノート、ロングノート、視覚エフェクト、ビートバーは高頻度で連続的に生成・破棄されます。このシステムは、オブジェクトを新規インスタンス化・破棄する代わりに再利用することで、ガベージコレクションのオーバーヘッドとフレームドロップを排除します。

このドキュメントでは、5つの主要なプール実装（`NoteObjectPool`、`LongObjectPool`、`JudgeEffectPool`、`BeatBarObjectPool`、`SameTimeBarObjectPool`）とゲームループとの統合について説明します。これらのプールを使用するノートのスポーンと配置ロジックについては、[ノートとチャート管理](#3.2)を参照してください。判定がエフェクトプールの使用をトリガーする方法の詳細については、[判定メカニクス](#4.1)を参照してください。

---

## アーキテクチャ概要

システム内のすべてのオブジェクトプールは、Unityの`UnityEngine.Pool.ObjectPool<T>` APIを基盤とした一貫したアーキテクチャに従っています。各プール実装は、4つのライフサイクルコールバックを通じて特定の種類のゲームオブジェクトを管理します。

### プールライフサイクルパターン

```mermaid
flowchart TD
    FINALIZE["OnFinalize()"]
    CLEAR["Pool.Clear() Pool.Dispose()"]
    DESTROY["OnDestroyPoolObject(obj)"]
    INIT["Pool.Init()"]
    PREWARM["Pool.WormUp(capacity)"]
    CREATE["OnCreatePoolObject()"]
    GET["Pool.Get()"]
    TAKE["OnTakeFromPool(obj)"]
    SHOW["obj.Show()"]
    ADD_LIST["_currentActiveリストに追加"]
    UPDATE["CallUpdate()ループ"]
    GAME_LOGIC["オブジェクトが位置を更新<br/>解放条件をチェック"]
    TRIGGER["解放トリガー:<br/>- 位置が閾値を超過<br/>- 時間超過<br/>- 手動解放"]
    RELEASE["Pool.Release(obj)"]
    RETURN["OnReturnedToPool(obj)"]
    HIDE["obj.Hide()"]
    REMOVE_LIST["_currentActiveから削除"]

    subgraph subGraph0 ["プール初期化"]
        INIT
        PREWARM
        CREATE
    end

    subgraph subGraph1 ["オブジェクト取得"]
        GET
        TAKE
        SHOW
        ADD_LIST
    end

    subgraph subGraph2 ["アクティブオブジェクトのライフサイクル"]
        UPDATE
        GAME_LOGIC
        TRIGGER
    end

    subgraph subGraph3 ["オブジェクト返却"]
        RELEASE
        RETURN
        HIDE
        REMOVE_LIST
    end

    subgraph subGraph4 ["プールクリーンアップ"]
        FINALIZE
        CLEAR
        DESTROY
    end

    INIT --> PREWARM
    PREWARM --> CREATE
    CREATE -.-> GET
    GET --> TAKE
    TAKE --> SHOW
    SHOW --> ADD_LIST
    ADD_LIST --> UPDATE
    UPDATE --> GAME_LOGIC
    GAME_LOGIC --> TRIGGER
    TRIGGER -.-> RELEASE
    RELEASE --> RETURN
    RETURN --> HIDE
    HIDE --> REMOVE_LIST
    FINALIZE --> CLEAR
    CLEAR --> DESTROY
```

### 共通プールプロパティ

すべてのプール実装は以下の構造パターンを共有しています：

| コンポーネント | 型 | 目的 |
| --- | --- | --- |
| `_pool` | `ObjectPool<T>` | Unityのプールインスタンス、遅延初期化 |
| `_currentActive*` | `List<T>` | 現在アクティブ（スポーン済み）のすべてのオブジェクトを追跡 |
| `_listCount` | `int` | `List.Count`のオーバーヘッドを避けるための高速カウントキャッシュ |
| `_transform` | `Transform` | インスタンス化されたオブジェクトの親Transform |
| `DEFAULT_CAPACITY` | `const int` | 初期プール容量（型によって異なる） |
| `MAX_SIZE` | `const int` | プールの最大成長制限 |
| `SWAP_THRESHOLD` | `const int` | 最適化の閾値（通常3） |

---

## ノートオブジェクトプール

`NoteObjectPool`はタップノートとフリックノートのオブジェクトを管理し、ゲームプレイオブジェクトの大部分を構成します。このプールはAddressablesを使用した非同期プレファブ読み込みをサポートし、動的なノートサイズ変更に対応しています。

### 初期化とAddressables読み込み

```mermaid
flowchart TD
    INIT["NoteObjectPool.Init(useAttack)"]
    ASYNC["InitAsync()"]
    LOAD["Addressables.LoadAssetAsync()"]
    PREFAB_ADDR["NOTE_PREFAB_ADDRESS<br/>または<br/>NOTE_OLD_PREFAB_ADDRESS"]
    EXTRACT["_noteControllerPrefab =<br/>_opHandle.Result.GetComponent()"]
    SIZE["_noteSize = prefab.scale *<br/>GameManager.NotesOption.Size"]
    WARMUP["Pool.WormUp(DEFAULT_CAPACITY/2)"]

    INIT --> ASYNC
    ASYNC --> LOAD
    LOAD --> PREFAB_ADDR
    PREFAB_ADDR --> EXTRACT
    EXTRACT --> SIZE
    SIZE --> WARMUP
```

プールは`useAttack`パラメータに基づいて2つのプレファブアドレスを動的に選択します：

* `"Prefabs/Note"` - モダンアタックモード用
* `"Prefabs/Note_Legacy"` - レガシーモード用

### プール設定

| パラメータ | 値 | 根拠 |
| --- | --- | --- |
| `DEFAULT_CAPACITY` | 32 | 画面上の典型的な同時ノート数 |
| `MAX_SIZE` | 1024 | 極端な譜面密度に対応 |
| `SWAP_THRESHOLD` | 3 | 最適化された削除アルゴリズムをトリガー |

### ミス検出を伴うオブジェクトライフサイクル

`NoteObjectPool`は返却フェーズで特別なミス検出ロジックを実装しています：

```mermaid
flowchart TD
    RETURN["OnReturnedToPool(noteController)"]
    CHECK_MISS{"noteController.IsMissed?"}
    INVOKE_EVENT["OnMissedNote?.Invoke(JudgeType.Missed)"]
    INVOKE_LUA["OnMissedNoteLua?.Invoke(<br/>noteIndex, lane, noteType)"]
    CHECK_COUNT{"_listCount > SWAP_THRESHOLD?"}
    SWAP["RemoveBeforeSwapLast(noteController)"]
    REMOVE["List.Remove(noteController)"]
    HIDE["noteController.Hide()"]

    RETURN --> CHECK_MISS
    CHECK_MISS -->|Yes| INVOKE_EVENT
    INVOKE_EVENT --> INVOKE_LUA
    INVOKE_LUA --> CHECK_COUNT
    CHECK_MISS -->|No| CHECK_COUNT
    CHECK_COUNT -->|Yes| SWAP
    CHECK_COUNT -->|No| REMOVE
    SWAP --> HIDE
    REMOVE --> HIDE
```

`RemoveBeforeSwapLast`最適化は、対象要素を最後の要素とスワップしてから削除することで、大きなリストから要素を削除する際の高価なリストメモリコピーを回避します。

### 更新ループとフレームごとの実行

```mermaid
flowchart TD
    CALL["NoteObjectPool.CallUpdate(<br/>beat, musicTime, speedStretchRatio)"]
    CALC_LOOP["loop = _listCount - 1"]
    CHECK_EMPTY{"loop < 0?"}
    RETURN["早期リターン"]
    LOOP_START["for i = loop down to 0"]
    BOUNDS_CHECK{"i < _listCount?"}
    UPDATE["CurrentActiveNote[i].CallUpdate(<br/>beat, musicTime, speedStretchRatio)"]
    NEXT["i--"]

    CALL --> CALC_LOOP
    CALC_LOOP --> CHECK_EMPTY
    CHECK_EMPTY -->|Yes| RETURN
    CHECK_EMPTY -->|No| LOOP_START
    LOOP_START --> BOUNDS_CHECK
    BOUNDS_CHECK -->|Yes| UPDATE
    BOUNDS_CHECK -->|No| NEXT
    UPDATE --> NEXT
    NEXT --> LOOP_START
```

逆方向イテレーションパターン（`loop down to 0`）により、イテレーション中のオブジェクト削除が安全に行えます。オブジェクトはリストの末尾から削除されるためです。

### 動的ノートサイズ変更

プールは`ChangeNoteSize()`メソッドを通じて実行時のノートサイズ変更をサポートしています。このメソッドはすべてのアクティブノートを反復処理し、`GameManager.Instance.NotesOption.Size`から更新されたスケールを適用します。

---

## ロングオブジェクトプール

`LongObjectPool`はホールド/ロングノートのオブジェクトを管理します。これらはその持続時間と視覚的表現のため、タップノートよりも複雑な状態追跡を必要とします。

### ヘルパー依存関係を伴う初期化

`NoteObjectPool`とは異なり、ロングプールは初期化時にヘルパーオブジェクトを受け取ります：

```mermaid
flowchart TD
    INIT["LongObjectPool.Init(<br/>bpmHelper, scrollHelper,<br/>visibleHoldController)"]
    STORE["ヘルパー参照を保存"]
    WARMUP["Pool.WormUp(DEFAULT_CAPACITY/2)"]

    INIT --> STORE
    STORE --> WARMUP
```

作成された各`LongController`は、時間からビートへの変換と位置スクロールを計算するためにこれらのヘルパーを受け取ります。

### プール設定

| パラメータ | 値 | 根拠 |
| --- | --- | --- |
| `DEFAULT_CAPACITY` | 8 | ロングノートはタップより少ない |
| `MAX_SIZE` | 64 | 予想される最大同時ホールド数 |

### ビジュアルビートを伴う更新ループ

ロングノートはスクロールエフェクト計算のために追加の`visualBeat`パラメータを必要とします：

```mermaid
flowchart TD
    CALL["LongObjectPool.CallUpdate(<br/>beat, visualBeat, musicTime,<br/>speedStretchRatio)"]
    LOOP["_currentActiveLongを逆方向に反復"]
    UPDATE["CurrentActiveLong[i].CallUpdate(<br/>beat, visualBeat, musicTime,<br/>speedStretchRatio)"]

    CALL --> LOOP
    LOOP --> UPDATE
```

### ロングサイズ調整

`ChangeLongSize()`メソッドはロングノートの幅の視覚的クリッピング問題を防ぐため、サイズを最大1.0にクランプします。

---

## 判定エフェクトプール

`JudgeEffectPool`はノートがヒットしたときに表示されるパーティクルシステムエフェクトを管理します。このプールはエフェクトキャンセルと実行時エフェクトタイプ切り替えを含む高度な機能を実装しています。

### エフェクトタイプを伴う非同期初期化

```mermaid
flowchart TD
    INIT["JudgeEffectPool.Init(notesEffectType)"]
    CHECK{"notesEffectType != None?"}
    ASYNC["InitAsync(notesEffectType)"]
    MAP["GetNoteEffectTypeToAddress()"]
    ADDR["Type1: PREFABS_JUDGE_EFFECT<br/>Type2: PREFABS_JUDGE_EFFECT_TYPE2<br/>Type3: PREFABS_JUDGE_EFFECT_TYPE3"]
    LOAD["Addressables.LoadAssetAsync()"]
    EXTRACT["_judgeEffectControllerPrefab =<br/>_opHandle.Result.GetComponent()"]
    PREWARM["ループ DEFAULT_CAPACITY/2:<br/>Play(100f, 0) 画面外位置"]

    INIT --> CHECK
    CHECK -->|Yes| ASYNC
    ASYNC --> MAP
    MAP --> ADDR
    ADDR --> LOAD
    LOAD --> EXTRACT
    EXTRACT --> PREWARM
```

プリウォームフェーズでは位置100f（画面外）でエフェクトを再生し、パーティクルシステム初期化による初回フレームのカクつきを排除します。

### プール設定

| パラメータ | 値 | 根拠 |
| --- | --- | --- |
| `DEFAULT_CAPACITY` | 32 | ノートプール容量と一致 |
| `MAX_SIZE` | 128 | 密集パターンのバーストエフェクトを許容 |
| `SWAP_THRESHOLD` | 3 | 標準最適化閾値 |

### エフェクトキャンセルシステム

プールは重複エフェクトを防ぐために2つのキャンセル戦略を実装しています：

```mermaid
flowchart TD
    PLAY["JudgeEffectPool.Play(posX, lane)"]
    CANCEL_TYPE{"_cancelType"}
    TYPE1["GetPlayingLaneEffect(lane)"]
    TYPE2["GetPlayingPosXEffect(posX)"]
    NONE["effectIndex = -1"]
    CHECK_FOUND{"effectIndex != -1?"}
    STOP["_currentActiveJudgeEffects[effectIndex].Stop()"]
    GET["Pool.Get()"]
    SET_POS["controller.localPosition = (posX, 0, 0)"]
    SET_LANE["controller.Lane = lane"]
    PLAY_EFFECT["controller.Play()"]

    PLAY --> CANCEL_TYPE
    CANCEL_TYPE -->|Type1| TYPE1
    CANCEL_TYPE -->|Type2| TYPE2
    CANCEL_TYPE -->|None| NONE
    TYPE1 --> CHECK_FOUND
    TYPE2 --> CHECK_FOUND
    NONE --> CHECK_FOUND
    CHECK_FOUND -->|Yes| STOP
    CHECK_FOUND -->|No| GET
    STOP --> GET
    GET --> SET_POS
    SET_POS --> SET_LANE
    SET_LANE --> PLAY_EFFECT
```

**キャンセルタイプの動作：**

* `Type1`: 同じレーンの前のエフェクトをキャンセル（レーンごとのスタッキングを防止）
* `Type2`: 同じX位置の前のエフェクトをキャンセル（位置ごとのスタッキングを防止）
* `None`: キャンセルなし、すべてのエフェクトが完了まで再生

### ライフサイクル管理の違い

他のプールとは異なり、`JudgeEffectPool`は独自の作成パターンを使用します：

```mermaid
flowchart TD
    CREATE["OnCreatePoolObject()"]
    INC["_listCount++"]
    INSTANTIATE["プレファブをインスタンス化"]
    INIT_CTRL["controller.Init(Pool)"]
    ADD["_currentActiveJudgeEffects.Add()"]
    RETURN["controllerを返す"]

    TAKE["OnTakeFromPool()"]
    INC2["_listCount++"]
    ADD2["_currentActiveJudgeEffects.Add()"]

    CREATE --> INC
    INC --> INSTANTIATE
    INSTANTIATE --> INIT_CTRL
    INIT_CTRL --> ADD
    ADD --> RETURN

    TAKE --> INC2
    INC2 --> ADD2
```

エフェクトは作成時と取得時の両方で`_currentActiveJudgeEffects`に追加され、正確な追跡を保証します。これはオブジェクトが`OnTakeFromPool`中にのみ追加されるノートプールとは異なります。

### 実行時エフェクトタイプ切り替え

プールはゲーム中のエフェクトタイプ変更をサポートしています：

```mermaid
flowchart TD
    CHANGE["ChangeEffectType(notesEffectType)"]
    CHECK{"notesEffectType == None?"}
    RETURN["早期リターン"]
    ASYNC["ChangeEffectTypeAsync()"]
    CLEAR_ALL["Clear() - すべてのアクティブエフェクトを解放"]
    MAP["GetNoteEffectTypeToAddress()"]
    CHECK_HANDLE{"_opHandle.Status == Succeeded?"}
    RELEASE_HANDLE["Addressables.Release(_opHandle)"]
    LOAD["新しいプレファブを読み込み"]
    EXTRACT["新しいコントローラーコンポーネントを抽出"]

    CHANGE --> CHECK
    CHECK -->|Yes| RETURN
    CHECK -->|No| ASYNC
    ASYNC --> CLEAR_ALL
    CLEAR_ALL --> MAP
    MAP --> CHECK_HANDLE
    CHECK_HANDLE -->|Yes| RELEASE_HANDLE
    CHECK_HANDLE -->|No| LOAD
    RELEASE_HANDLE --> LOAD
    LOAD --> EXTRACT
```

## ビートバーオブジェクトプール

`BeatBarObjectPool`はプレイヤーがリズムタイミングを維持するのを助ける視覚的なビートインジケーターを管理します。これらは音楽のビートに同期して判定ラインに向かってスクロールする水平バーとして表示されます。

### プール設定

| パラメータ | 値 | 根拠 |
| --- | --- | --- |
| `DEFAULT_CAPACITY` | 16 | 典型的な表示ビート数 |
| `MAX_SIZE` | 64 | 高テンポの曲に対応 |
| `SWAP_THRESHOLD` | 3 | 標準最適化 |

### BeatBarControllerとの統合

```mermaid
flowchart TD
    CREATE["OnCreatePoolObject()"]
    INSTANTIATE["Instantiate(_beatBarControllerPrefab)"]
    INIT_CTRL["controller.Init(Pool)"]
    STORE_SPEED["_normalizedSpeed = FIXED_BPM / BaseBpm"]
    STORE_HITTIME["_hitTime = JudgeTimeOption.GetHitTime()"]
    STORE_CMOD["_isCMod = GameManager.IsCMod"]
    RETURN["controllerを返す"]

    CREATE --> INSTANTIATE
    INSTANTIATE --> INIT_CTRL
    INIT_CTRL --> STORE_SPEED
    STORE_SPEED --> STORE_HITTIME
    STORE_HITTIME --> STORE_CMOD
    STORE_CMOD --> RETURN
```

`BeatBarController`は初期化時にタイミング定数を保存し、フレームごとの計算を最適化します。

### 位置更新ロジック

ビートバーはスピードモッドタイプに基づいて2つの位置モードをサポートしています：

```mermaid
flowchart TD
    UPDATE["BeatBarController.CallUpdate(<br/>beat, musicTime, speedStretchRatio)"]
    CHECK_RELEASED{"_isReleased || !enabled?"}
    RETURN["リターン"]
    CHECK_CMOD{"_isCMod?"}
    CMOD["UpdateCmodPosition()"]
    NORMAL["UpdatePosition()"]
    CHECK_RELEASE["CheckRelease(musicTime)"]

    UPDATE --> CHECK_RELEASED
    CHECK_RELEASED -->|Yes| RETURN
    CHECK_RELEASED -->|No| CHECK_CMOD
    CHECK_CMOD -->|Yes| CMOD
    CHECK_CMOD -->|No| NORMAL
    CMOD --> CHECK_RELEASE
    NORMAL --> CHECK_RELEASE
```

**位置計算式：**

**ビートベース（通常）：**

```
posZ = (beatPosition - currentBeat) * BEAT_DISTANCE * normalizedSpeed * noteSpeed * speedStretchRatio - visualOffset - OFFSET_Z - offsetZ
```

**タイムベース（CMod）：**

```
posZ = (justTime - musicTime) * TIME_DISTANCE * noteSpeed * speedStretchRatio - visualOffset - OFFSET_Z - offsetZ
```

### 減速カーブサポート

両方の位置モードはオプションの減速カーブを適用します。

## 同時押しバーオブジェクトプール

`SameTimeBarObjectPool`は同時押しインジケーター（同時にヒットする必要のあるノートを接続する視覚的なライン）を管理します。このプールは`SameTimeBar`マネージャークラスとの独自の統合を持っています。

### プール設定

| パラメータ | 値 | 根拠 |
| --- | --- | --- |
| `DEFAULT_CAPACITY` | 16 | 典型的な同時押しパターン |
| `MAX_SIZE` | 128 | コード重視の譜面をサポート |
| `SWAP_THRESHOLD` | 3 | 標準最適化 |

### マネージャー統合を伴うアーキテクチャ

```mermaid
flowchart TD
    subgraph subGraph0 ["SameTimeBar マネージャー"]
        MANAGER["SameTimeBar"]
        QUEUES["_sameTimeBeatPosition Queue<br/>_sameTimeNoteLanes Queue[2]<br/>_sameTimeNoteIndex Queue[2]"]
        ON_CREATE["OnCreateNote(noteIndex)"]
        ON_RELEASE["OnReleaseLong(releaseLong)"]
        ON_JUDGE["OnJudgeTiming(note)"]
    end

    subgraph SameTimeBarObjectPool ["SameTimeBarObjectPool"]
        POOL["SameTimeBarObjectPool"]
        POOL_GET["Pool.Get()"]
        ACTIVE_LIST["_currentActiveSameTimeBar"]
    end

    subgraph SameTimeBarController ["SameTimeBarController"]
        CONTROLLER["SameTimeBarController"]
        MESH["カスタムメッシュ生成"]
        UPDATE["OnUpdate(beat, musicTime,<br/>speedStretchRatio)"]
        RELEASE_CTRL["Release()"]
    end

    MANAGER --> QUEUES
    ON_CREATE --> QUEUES
    ON_RELEASE --> QUEUES
    ON_JUDGE --> QUEUES
    QUEUES -->|"CallUpdate()でデキュー"| POOL_GET
    POOL_GET --> CONTROLLER
    CONTROLLER --> ACTIVE_LIST
    CONTROLLER --> MESH
    CONTROLLER --> UPDATE
    CONTROLLER --> RELEASE_CTRL
    RELEASE_CTRL --> POOL
```

### 同時ノート検出

`SameTimeBar.OnCreateNote()`メソッドは、連続するノートが一致するビート位置を持つかどうかを検出します：

```mermaid
flowchart TD
    ON_CREATE["OnCreateNote(noteIndex)"]
    CHECK_SAME{"BeatPositions[noteIndex] ≈<br/>_beforeNoteBeat?"}
    CHECK_RELAY{"リレー接続か？"}
    SKIP["スキップ<br/>（リレー接続にはラインなし）"]
    ENQUEUE_LEFT["左ノートのレーン/インデックスをエンキュー"]
    ENQUEUE_RIGHT["右ノートのレーン/インデックスをエンキュー"]
    ENQUEUE_BEAT["ビート位置をエンキュー"]
    UPDATE_BEFORE["_beforeNoteBeat = 現在のビート<br/>_beforeNoteIndex = 現在のインデックス"]

    ON_CREATE --> CHECK_SAME
    CHECK_SAME -->|Yes| CHECK_RELAY
    CHECK_SAME -->|No| UPDATE_BEFORE
    CHECK_RELAY -->|Yes| SKIP
    CHECK_RELAY -->|No| ENQUEUE_LEFT
    ENQUEUE_LEFT --> ENQUEUE_RIGHT
    ENQUEUE_RIGHT --> ENQUEUE_BEAT
    ENQUEUE_BEAT --> UPDATE_BEFORE
    SKIP --> UPDATE_BEFORE
```

近似は`Calculate.FastApproximately(_sequence.BeatPositions[noteIndex], _beforeNoteBeat, 0.00001)`を使用し、浮動小数点精度を処理するためにイプシロン0.00001を使用しています。

### 動的幅のためのメッシュ生成

各`SameTimeBarController`は左レーンから右レーンにまたがるカスタムメッシュを生成します：

```mermaid
flowchart TD
    INIT["SameTimeBarController.Init(pool)"]
    CALC_WIDTH["width = WIDTH * SameTimeWidthRate"]
    CREATE_VERTICES["_vertices[4] = {<br/>  (-LANE_DISTANCE3, 0, -width),<br/>  (-LANE_DISTANCE3, 0, width),<br/>  (LANE_DISTANCE3, 0, width),<br/>  (LANE_DISTANCE3, 0, -width)<br/>}"]
    CREATE_MESH["_mesh = new Mesh()"]
    SET_VERTS["_mesh.SetVertices(_vertices)"]
    SET_INDICES["_mesh.SetIndices(TRIANGLES)"]
    SET_PARAM["SetParam(beatPosition, justTime,<br/>laneLeft, laneRight,<br/>leftNoteIndex, rightNoteIndex)"]
    UPDATE_VERTS["_vertices[0-3]を実際のレーン位置で更新:<br/>laneLeft - 3, laneRight - 3"]
    UPDATE_MESH["_mesh.SetVertices(_vertices)"]

    INIT --> CALC_WIDTH
    CALC_WIDTH --> CREATE_VERTICES
    CREATE_VERTICES --> CREATE_MESH
    CREATE_MESH --> SET_VERTS
    SET_VERTS --> SET_INDICES
    SET_INDICES --> SET_PARAM
    SET_PARAM --> UPDATE_VERTS
    UPDATE_VERTS --> UPDATE_MESH
```

メッシュは4つの頂点で構成され、インデックス`{0, 1, 2, 0, 2, 3}`で2つの三角形を形成するクアッドを作成します。

### 解放トリガー

同時押しバーは3つの条件で解放されます：

1. **時間ベース:** `justTime < musicTime`の場合（バーが判定ラインを通過）
2. **判定:** `OnJudgeTiming()`を介して接続されたノートが判定された場合
3. **ロング解放:** `OnReleaseLong()`を介して接続されたロングノートが解放された場合

## パフォーマンス最適化

### スワップ閾値最適化

すべてのプールはアクティブリストからオブジェクトを削除する際に「スワップラスト」最適化を実装しています。リストサイズが`SWAP_THRESHOLD`（通常3）を超えると、システムは高価なメモリコピーを避けるために、削除前に対象要素を最後の要素とスワップします：

```mermaid
flowchart TD
    REMOVE["_currentActiveからオブジェクトを削除"]
    CHECK{"_listCount > SWAP_THRESHOLD?"}
    SWAP["RemoveBeforeSwapLast(obj):<br/>1. オブジェクトインデックスを検索<br/>2. list[last]とスワップ<br/>3. RemoveAt(last)"]
    DIRECT["List.Remove(obj):<br/>線形検索 + メモリシフト"]

    REMOVE --> CHECK
    CHECK -->|Yes| SWAP
    CHECK -->|No| DIRECT
```

**計算量：**

* `List.Remove()`: O(n)検索 + O(n)メモリシフト
* `RemoveBeforeSwapLast()`: O(n)検索 + O(1)スワップ + O(1)削除

この最適化はメモリシフトがパフォーマンスを支配する大きなリストで最も効果的です。

### プリウォーム戦略

プールは初期化中にオブジェクトを事前インスタンス化するために`WormUp()`を使用します：

| プールタイプ | ウォームアップ数 | 根拠 |
| --- | --- | --- |
| `NoteObjectPool` | `DEFAULT_CAPACITY / 2` = 16 | ノートは徐々に出現 |
| `LongObjectPool` | `DEFAULT_CAPACITY / 2` = 4 | ロングノートは頻度が低い |
| `JudgeEffectPool` | `DEFAULT_CAPACITY / 2` = 16 | 画面外で再生してパーティクルを初期化 |
| `BeatBarObjectPool` | 5 | 最初は少数のバーが表示 |
| `SameTimeBarObjectPool` | `DEFAULT_CAPACITY` = 16 | 即座の可用性のためフル容量 |

プリウォームにより、オブジェクトが最初にスポーンされる早期のゲームプレイ中のフレームドロップを防止します。

### 逆方向イテレーションパターン

すべての更新ループはイテレーション中のオブジェクト削除を安全に処理するために逆方向（`for i = loop; i >= 0; i--`）にイテレートします：

```mermaid
flowchart TD
    A["リスト: [0, 1, 2, 3, 4]"]
    B["イテレート i=4 → 0"]
    C["i=2のオブジェクトが解放"]
    D["リスト: [0, 1, 4, 3]<br/>（スワップラスト）"]
    E["続行 i=1, i=0"]
    F["スキップされたオブジェクトなし"]

    A --> B
    B --> C
    C --> D
    D --> E
    E --> F
```

順方向イテレーションは削除後にオブジェクトをスキップする可能性がありますが、逆方向イテレーションはリストが縮小してもすべてのオブジェクトが処理されることを保証します。

### 容量制限

各プールは無制限のメモリ増加を防ぐために最大サイズ制約を定義しています：

| プール | 最大サイズ | 閾値 |
| --- | --- | --- |
| `NoteObjectPool` | 1024 | 極端な譜面密度 |
| `LongObjectPool` | 64 | 最大同時ホールド数 |
| `JudgeEffectPool` | 128 | バーストエフェクトシナリオ |
| `BeatBarObjectPool` | 64 | 高テンポの曲 |
| `SameTimeBarObjectPool` | 128 | コード重視のパターン |

`MAX_SIZE`に達すると、`ObjectPool`は自動的に余分なオブジェクトをプールする代わりに破棄します。

## ゲームプレイループとの統合

### フレームごとの更新フロー

```mermaid
flowchart TD
    CALL_UPDATE["MusicGame.CallUpdate()"]
    MUSIC_MGR["MusicManagerがmusicTimeを更新"]
    BEAT_CALC["現在のビートを計算"]
    NOTE_POOL["NoteObjectPool.CallUpdate(<br/>beat, musicTime, speedStretchRatio)"]
    LONG_POOL["LongObjectPool.CallUpdate(<br/>beat, visualBeat, musicTime,<br/>speedStretchRatio)"]
    BEAT_POOL["BeatBarObjectPool.CallUpdate(<br/>beat, musicTime, speedStretchRatio)"]
    SAME_POOL["SameTimeBarObjectPool.CallUpdate(<br/>beat, musicTime, speedStretchRatio)"]
    EFFECT_POOL["JudgeEffectPool.CallUpdate()"]

    NOTE_UPDATE["各NoteController:<br/>- 位置を更新<br/>- 判定ライン通過をチェック<br/>- 通過したら自動解放"]
    LONG_UPDATE["各LongController:<br/>- ヘッド/テール位置を更新<br/>- ホールドバーメッシュを更新<br/>- 完了をチェック"]
    BEAT_UPDATE["各BeatBarController:<br/>- 位置を更新<br/>- 減速の場合カーブを適用<br/>- 閾値を超えたら解放"]
    SAME_UPDATE["各SameTimeBarController:<br/>- 位置を更新<br/>- 時間超過で解放"]
    EFFECT_UPDATE["各JudgeEffectController:<br/>- パーティクル完了をチェック<br/>- 終了時に自動解放"]

    CALL_UPDATE --> MUSIC_MGR
    MUSIC_MGR --> BEAT_CALC
    BEAT_CALC --> NOTE_POOL
    BEAT_CALC --> LONG_POOL
    BEAT_CALC --> BEAT_POOL
    BEAT_CALC --> SAME_POOL
    BEAT_CALC --> EFFECT_POOL
    NOTE_POOL --> NOTE_UPDATE
    LONG_POOL --> LONG_UPDATE
    BEAT_POOL --> BEAT_UPDATE
    SAME_POOL --> SAME_UPDATE
    EFFECT_POOL --> EFFECT_UPDATE
```

### スポーン統合

```mermaid
flowchart TD
    SPAWN_LOGIC["MusicGameノートスポーンロジック"]
    CHECK_TIME{"ノートスポーン時間か？"}
    GET_NOTE["NoteObjectPool.Pool.Get()"]
    CONFIG_NOTE["ビート位置、レーン、<br/>ノートタイプ、色などを設定"]
    NOTIFY_SAME["SameTimeBar.OnCreateNote(noteIndex)"]
    GET_LONG["LongObjectPool.Pool.Get()"]
    CONFIG_LONG["LongInfoを設定、メッシュを計算"]
    GET_BAR["BeatBarObjectPool.Pool.Get()"]
    CONFIG_BAR["ビート位置、justTimeを設定"]

    SPAWN_LOGIC --> CHECK_TIME
    CHECK_TIME -->|タップノート| GET_NOTE
    CHECK_TIME -->|ロングノート| GET_LONG
    CHECK_TIME -->|ビートバー| GET_BAR
    GET_NOTE --> CONFIG_NOTE
    CONFIG_NOTE --> NOTIFY_SAME
    GET_LONG --> CONFIG_LONG
    GET_BAR --> CONFIG_BAR
```

ノートは`musicTime + scrollTime >= justTime`のときにスポーンされます。`scrollTime`はノートスピードとスクロール距離に基づいて計算されます。

### 判定統合

```mermaid
flowchart TD
    JUDGE["JudgeManager.JudgeTap/Long/Hold()"]
    EFFECT_PLAY["JudgeEffectPool.Play(posX, lane)"]
    SAME_JUDGE["SameTimeBar.OnJudgeTiming(note)"]
    RELEASE_SAME["接続されたSameTimeBarControllerを解放"]
    LONG_RELEASE["LongController.Release()"]
    SAME_RELEASE["SameTimeBar.OnReleaseLong(long)"]
    SEARCH["一致するnoteIndexの<br/>アクティブ同時押しバーを検索"]
    RELEASE_MATCH["一致するバーを解放"]

    JUDGE --> EFFECT_PLAY
    JUDGE --> SAME_JUDGE
    SAME_JUDGE --> RELEASE_SAME
    LONG_RELEASE --> SAME_RELEASE
    SAME_RELEASE --> SEARCH
    SEARCH --> RELEASE_MATCH
```

### クリーンアップと終了処理

```mermaid
flowchart TD
    FINALIZE["MusicGameSceneController.OnFinalize()"]

    NOTE_FIN["NoteObjectPool.OnFinalize()"]
    NOTE_CLEAR["Pool.Clear()<br/>Pool.Dispose()"]
    NOTE_ADDR["Addressables.Release(_opHandle)"]
    NOTE_LIST["_currentActiveNote.Clear()"]

    LONG_FIN["LongObjectPool.OnFinalize()"]
    LONG_CLEAR["Pool.Clear()<br/>Pool.Dispose()"]
    LONG_LIST["_currentActiveLong.Clear()"]

    EFFECT_FIN["JudgeEffectPool.OnFinalize()"]
    EFFECT_CLEAR["Pool.Clear()<br/>Pool.Dispose()"]
    EFFECT_ADDR["Addressables.Release(_opHandle)"]

    BEAT_FIN["BeatBarObjectPool.OnFinalize()"]
    SAME_FIN["SameTimeBarObjectPool.OnFinalize()"]

    FINALIZE --> NOTE_FIN
    FINALIZE --> LONG_FIN
    FINALIZE --> EFFECT_FIN
    FINALIZE --> BEAT_FIN
    FINALIZE --> SAME_FIN

    NOTE_FIN --> NOTE_CLEAR
    NOTE_CLEAR --> NOTE_ADDR
    NOTE_ADDR --> NOTE_LIST

    LONG_FIN --> LONG_CLEAR
    LONG_CLEAR --> LONG_LIST

    EFFECT_FIN --> EFFECT_CLEAR
    EFFECT_CLEAR --> EFFECT_ADDR
```

すべてのプールは`OnFinalize()`を実装してUnityプールオブジェクトを適切に破棄し、リストをクリアします。Addressablesを使用するプールはメモリリークを防ぐためにアセットハンドルも解放します。

---

## まとめ

オブジェクトプールシステムは、5つの特化したプール実装を通じてリズムゲーム実行のための重要なパフォーマンスインフラを提供します。各プールはUnityの`ObjectPool<T>`パターンに従い、カスタマイズされたライフサイクルコールバック、プリウォーム戦略、最適化された削除アルゴリズムを備えています。システムはオブジェクトの再利用を通じてガベージコレクションのオーバーヘッドを排除しながら、ノートスポーン、判定処理、視覚エフェクトトリガーとのクリーンな統合を維持します。`OnFinalize()`による適切なクリーンアップにより、ゲームプレイセッション間の遷移時にメモリリークが発生しないことを保証します。

### このページの内容

* [オブジェクトプールシステム](#3.3-object-pooling-system)
* [目的と範囲](#3.3-purpose-and-scope)
* [アーキテクチャ概要](#3.3-architecture-overview)
* [プールライフサイクルパターン](#3.3-pool-lifecycle-pattern)
* [共通プールプロパティ](#3.3-common-pool-properties)
* [ノートオブジェクトプール](#3.3-note-object-pool)
* [初期化とAddressables読み込み](#3.3-initialization-and-addressable-loading)
* [プール設定](#3.3-pool-configuration)
* [ミス検出を伴うオブジェクトライフサイクル](#3.3-object-lifecycle-with-miss-detection)
* [更新ループとフレームごとの実行](#3.3-update-loop-and-frame-by-frame-execution)
* [動的ノートサイズ変更](#3.3-dynamic-note-sizing)
* [ロングオブジェクトプール](#3.3-long-object-pool)
* [ヘルパー依存関係を伴う初期化](#3.3-initialization-with-helper-dependencies)
* [プール設定](#3.3-pool-configuration-1)
* [ビジュアルビートを伴う更新ループ](#3.3-update-loop-with-visual-beat)
* [ロングサイズ調整](#3.3-long-size-adjustment)
* [判定エフェクトプール](#3.3-judge-effect-pool)
* [エフェクトタイプを伴う非同期初期化](#3.3-asynchronous-initialization-with-effect-types)
* [プール設定](#3.3-pool-configuration-2)
* [エフェクトキャンセルシステム](#3.3-effect-cancellation-system)
* [ライフサイクル管理の違い](#3.3-lifecycle-management-difference)
* [実行時エフェクトタイプ切り替え](#3.3-runtime-effect-type-switching)
* [ビートバーオブジェクトプール](#3.3-beat-bar-object-pool)
* [プール設定](#3.3-pool-configuration-3)
* [BeatBarControllerとの統合](#3.3-integration-with-beatbarcontroller)
* [位置更新ロジック](#3.3-position-update-logic)
* [減速カーブサポート](#3.3-deceleration-curve-support)
* [同時押しバーオブジェクトプール](#3.3-same-time-bar-object-pool)
* [プール設定](#3.3-pool-configuration-4)
* [マネージャー統合を伴うアーキテクチャ](#3.3-architecture-with-manager-integration)
* [同時ノート検出](#3.3-simultaneous-note-detection)
* [動的幅のためのメッシュ生成](#3.3-mesh-generation-for-dynamic-width)
* [解放トリガー](#3.3-release-triggers)
* [パフォーマンス最適化](#3.3-performance-optimizations)
* [スワップ閾値最適化](#3.3-swap-threshold-optimization)
* [プリウォーム戦略](#3.3-pre-warming-strategy)
* [逆方向イテレーションパターン](#3.3-backwards-iteration-pattern)
* [容量制限](#3.3-capacity-limits)
* [ゲームプレイループとの統合](#3.3-integration-with-gameplay-loop)
* [フレームごとの更新フロー](#3.3-frame-by-frame-update-flow)
* [スポーン統合](#3.3-spawning-integration)
* [判定統合](#3.3-judgment-integration)
* [クリーンアップと終了処理](#3.3-cleanup-and-finalization)
* [まとめ](#3.3-summary)
