
# キャッシュシステム 

## 目的と範囲 

本ドキュメントでは、冗長なファイルI/O、高コストな計算、重複するアセット読み込みを回避してパフォーマンスを最適化するために、アプリケーション全体で実装されている様々なキャッシュシステムについて説明します。キャッシュシステムは、テクスチャ、楽曲メタデータ、集計されたスコアデータ、レンダーバッファ、およびアドレサブルアセットハンドルをカバーしています。

キャッシュ前に外部コンテンツが最初にどのように読み込まれるかについては、[外部コンテンツ読込](#9.2)を参照してください。アドレサブルアセットのライフサイクル管理の詳細については、[Addressableアセット](#9.1)を参照してください。一部のキャッシュソースの基盤となるデータ永続化メカニズムについては、[データ永続化システム](#2.3)を参照してください。

---

## キャッシュアーキテクチャの概要 

キャッシュシステムは、5つの主要なドメインに分類できます：

| キャッシュドメイン | 主な用途 | 無効化戦略 |
| --- | --- | --- |
| **テクスチャキャッシュ** | フォルダ画像、ジャケット、カスタムノートスキン | セッション永続、破棄時に手動クリア |
| **メタデータキャッシュ** | 楽曲情報、譜面統計 | アプリケーション寿命シングルトン |
| **スコア集計** | フォルダレベル統計（AB/FC/Clearカウント） | オンデマンドで計算、アクセス時に再計算 |
| **レンダーバッファ** | 密度グラフテクスチャ、UIプロット | パネルごとのライフサイクル、クローズ時にクリア |
| **アセットハンドル** | シーン/機能ごとにグループ化されたアドレサブルアセット参照 | 機能終了時にグループIDで解放 |

```mermaid
flowchart TD

ADDR_HANDLES["AddressableLoader _assetGroupHandleList"]
FTC["FolderTextureCache"]
ADDR_TEX["AddressableLoader テクスチャキャッシュ"]
SIC["SongInfoCache シングルトン"]
CIC["ChartInfoCache"]
FSC["FolderScoreCache"]
SDP["ScoreDataPrefas"]
DD_TEX["DensityDrawer Texture2D配列"]
DD_PLOTS["DensityDrawer プロットリスト"]
FSP["FolderSelectPanel"]
SIP["SequenceInfoPanel"]
MS["MusicSort"]
FTL["FolderTextureLoader"]
SPC["SortPanelController"]

FSP -.-> FTC
FSP -.-> FSC
SIP -.-> DD_TEX
SIP -.-> DD_PLOTS
MS -.-> SIC
MS -.-> CIC
FSC -.-> SIC
FTL -.-> FTC
FTL -.-> ADDR_TEX
SPC -.-> CIC

subgraph レンダーキャッシュ層 ["レンダーキャッシュ層"]
    DD_TEX
    DD_PLOTS
end

subgraph スコア集計層 ["スコア集計層"]
    FSC
    SDP
    FSC -.-> SDP
end

subgraph メタデータキャッシュ層 ["メタデータキャッシュ層"]
    SIC
    CIC
end

subgraph テクスチャキャッシュ層 ["テクスチャキャッシュ層"]
    FTC
    ADDR_TEX
end

subgraph アセットハンドル管理 ["アセットハンドル管理"]
    ADDR_HANDLES
end
```

**図：キャッシュアーキテクチャの概要**

 

 

 

 

---

## テクスチャキャッシュ 

### FolderTextureCache 

`FolderTextureCache`は、フォルダ選択パネルをナビゲートする際にディスクから再読み込みするのを避けるため、読み込まれたフォルダ画像を保存します。キャッシュは`(Texture tex, bool hasImage)`のタプルを保持し、実際の画像とプレースホルダーテクスチャを区別します。

**主要実装：**



| メソッド | 目的 |
| --- | --- |
| `SetCache(List<(Texture, bool)>)` | 読み込まれたテクスチャでキャッシュを設定 |
| `GetCache()` | キャッシュされたテクスチャリストを取得 |
| `Clear()` | テクスチャを破棄してキャッシュをクリア |
| `HasCache` | キャッシュが設定されているか確認 |

**使用パターン：**

```mermaid
sequenceDiagram
  participant p1 as FolderSelectPanel
  participant p2 as FolderTextureLoader
  participant p3 as FolderTextureCache
  participant p4 as ファイルシステム

  p1->>p3: HasCache?
  alt キャッシュミス
    p3-->>p1: false
    p1->>p2: LoadTextureAsync(ct)
    p2->>p4: ディスクからテクスチャを読み込み
    p4-->>p2: Texture2D[]
    p2->>p3: SetCache(textures)
  else キャッシュヒット
    p3-->>p1: true
    p1->>p3: GetCache()
    p3-->>p1: List<(Texture | bool)>
  end
```

**図：FolderTextureCacheアクセスパターン**

キャッシュは`FolderSelectPanel.SetFolderScrollerAsync()`で初期化され、パネル破棄時にクリアされます

**ライフサイクル：**

1. **初期化**: 最初のパネルオープン時に遅延読み込み
2. **永続化**: `FolderSelectPanel.OnDestroy()`まで、メモリ内に保持
3. **クリーンアップ**: `hasImage == true`の各テクスチャを手動で破棄


---

## 楽曲と譜面データのキャッシュ 

### SongInfoCache 

アプリケーションのライフタイム全体で読み込まれたすべての楽曲メタデータを保持するシングルトンキャッシュです。このキャッシュはグローバルに参照され、アプリケーション起動時に`SongInfoLoader`によって設定されます。

**アクセスパターン：**

```
var songInfos = SongInfoCache.Instance.Data;int songCount = songInfos.Length;
```

キャッシュは以下で広く使用されています：

* `MusicSort.SetSongInfoData()` 
* `FolderSelectPanel.GetFolderSongsCount()` 
* `FolderScoreCache.SetCache()` 
* `SortPanelController.OnLoadedSong()` 

### ChartInfoCache 

すべての譜面の事前計算されたノート数統計を保存し、ノート数でソートする際の繰り返し譜面解析を避けます。このキャッシュは、すべての譜面をバックグラウンド操作でスキャンする`ChartInfoLoader.LoadAllChartInfoAsync()`によって設定されます。

**可用性チェック：**

キャッシュステータスをチェックします：
```c#
bool hasChartInfo = SongInfoCache.Instance.HasChartInfoCache;
```

利用不可の場合、ソートパネルは「全譜面情報を読み込む」ボタンを表示するようになっています。

**キャッシュ設定フロー：**

```mermaid
flowchart TD

SPC["SortPanelController"]
CIL["ChartInfoLoader"]
SR["SequenceReader"]
CI["ChartInfo"]
SIC["SongInfoCache.ChartInfoList"]
UI["読み込み進捗バー"]
MS["MusicSort"]

SPC -.->|"LoadAllChartInfoAsync"| CIL
CIL -.->|"各楽曲について"| SR
SR -.->|"譜面を解析"| CI
CI -.->|"保存先"| SIC
SPC -.->|"進捗コールバック"| UI
SIC -.->|"使用元"| MS
```

**図：ChartInfoCache設定**

**キャッシュを必要とするソート操作：**



は、`ChartInfoList`に依存する4つのソートタイプを示しています：

| ソートタイプ | アクセスされるプロパティ |
| --- | --- |
| `TotalNoteCount` | `ChartInfoList[difficulty].TotalNoteCount` |
| `YellowNoteCount` | `ChartInfoList[difficulty].TapNoteCount` |
| `BlueNoteCount` | `ChartInfoList[difficulty].LongNoteCount` |
| `GreenNoteCount` | `ChartInfoList[difficulty].FuzzyNoteCount` |

キャッシュが欠落している場合、`MusicSort.ResetSortOption()` 

は、利用できないデータを参照しないようにソートタイプをリセットします。

 

 

 

---

## スコア集計キャッシュ 

### FolderScoreCache 

`FolderScoreCache`は、フォルダごとにスコアデータを集計し、難易度ごとのAB（All Brilliant）、FC（Full Combo）、Clearカウントなどの統計を計算します。これは、生のスコアデータをフォルダレベルのサマリーに変換するETL（Extract-Transform-Load）パターンのキャッシュです。

**データ構造：**

```mermaid
classDiagram
    class FolderScoreCache {
        -Dictionary<short, FolderScore> _folderScoreDict
        +SetCache() : void
    }
    class FolderScore {
        +int[] AB
        +int[] FC
        +int[] Clear
    }
    class MusicScoreData {
        +short FolderIndex
        +string MusicFolder
        +int Difficulty
        +int Score
        +bool Ab
        +bool Fc
        +bool Clear
    }
    class ScoreDataPrefas {
    }
    class SongInfoCache {
    }
    FolderScoreCache --> FolderScore : 変換
    FolderScoreCache ..> MusicScoreData : ソース
    ScoreDataPrefas --> FolderScoreCache : メタデータ
    SongInfoCache --> FolderScoreCache
```

**図：FolderScoreCacheデータモデル**

**計算プロセス：**



は集計パイプラインを実装しています：

1. **抽出**: `ScoreDataPrefas`から`ScoreDataList`を読み込み 
2. **変換**:
* スコアIDを解析してフォルダ名と難易度を抽出 
* `SongInfoCache`と結合して`GroupFolderIndex`を取得 
* `FolderIndex`でグループ化 
3. **集計**: フォルダごと、難易度ごとのAB/FC/Clearをカウント 
4. **ロード**: フォルダインデックスをキーとして`_folderScoreDict`に保存 
5. **合計**: キー`-1`で「全楽曲」の集計を計算 

**アクセスパターン：**

```
_folderScoreCache.SetCache();  
// 集計を計算
if (_folderScoreCache.FolderScoreDict.ContainsKey(key))
{
    _folderScoreView.SetScore(_folderScoreCache.FolderScoreDict[key]);
}
```

**キャッシュ無効化：**

キャッシュは`InitFolderScore()`呼び出しごとに再計算されます。これは以下の場合に発生します：

* パネル初期化時 
* ゲームプレイから戻った時（スコアが変更された可能性がある）

## レンダーデータキャッシュ 

### DensityDrawer テクスチャとプロットキャッシュ 

`DensityDrawer`は、ノートタイミングデータに対してカーネル密度推定（KDE）を実行し、密度グラフを生成します。計算されたプロットデータとレンダリングされたテクスチャの両方がキャッシュされ、密度タイプ（Total/Yellow/Blue/Green）を切り替える際の再計算を回避します。

**キャッシュ構造：**

```mermaid
flowchart TD

PLOTS["_densityPlotList~DensityPlot~"]
TEXTURES["_drawTexture Texture2D配列"]
FLAGS["_isDensityDrawn bool配列"]
BUFFER["_buffer Color配列"]
DT0["DensityType.Total インデックス0"]
DT1["DensityType.Yellow インデックス1"]
DT2["DensityType.Blue インデックス2"]
DT3["DensityType.Green インデックス3"]

DT0 -.->|"インデックス"| TEXTURES
DT1 -.->|"インデックス"| TEXTURES
DT2 -.->|"インデックス"| TEXTURES
DT3 -.->|"インデックス"| TEXTURES
DT0 -.-> FLAGS
DT1 -.->|"インデックス"| FLAGS
DT2 -.->|"インデックス"| FLAGS
DT3 -.->|"インデックス"| FLAGS

subgraph キャッシュキー ["キャッシュキー"]
    DT0
    DT1
    DT2
    DT3
end

subgraph DensityDrawerキャッシュ状態 ["DensityDrawerキャッシュ状態"]
    PLOTS
    TEXTURES
    FLAGS
    BUFFER
    PLOTS -.->|"再利用"| TEXTURES
end
```

**図：DensityDrawer多層キャッシュ**

**キャッシュフィールド：**



| フィールド | 型 | 目的 |
| --- | --- | --- |
| `_densityPlotList` | `List<DensityPlot>` | 現在の密度タイプのKDE計算結果 |
| `_drawTexture` | `Texture2D[4]` | レンダリングされたグラフテクスチャ、`DensityType`ごとに1つ |
| `_buffer` | `Color[]` | テクスチャレンダリング用のピクセルバッファ |
| `_isDensityDrawn` | `bool[4]` | どの密度タイプがレンダリングされたかを追跡 |

**計算 vs レンダリング：**

```mermaid
sequenceDiagram
  participant p1 as SequenceInfoPanel
  participant p2 as DensityDrawer
  participant p3 as KernelDensityEstimation

  p1->>p2: Calculate(sequence | bpmHelper | type)
  p2->>p3: KernelDensityEstimate() ループ
  p3-->>p2: 密度値
  p2->>p2: _densityPlotListに保存
  p2-->>p1: ノート長
  p1->>p2: DrawGraph(type | length)
  alt _isDensityDrawn[type] == true
    p2-->>p1: スキップ（既にキャッシュ済み）
  else 未描画
    p2->>p2: nullの場合Texture2Dを作成
    p2->>p2: _densityPlotListを_bufferにレンダリング
    p2->>p2: バッファを_drawTexture[type]に適用
    p2->>p2: _isDensityDrawn[type] = trueに設定
  end
```

**図：DensityDrawer二段階キャッシュ**

**KDE計算：**



は、ガウシアンカーネルを使用して密度推定を計算します：

```mermaid
flowchart TD

BP["BeatPositions"]
TIMES["float times配列"]
KDE["KernelDensityEstimation.KernelDensityEstimate"]
DENSITY["密度値"]
PLOT_LIST["_densityPlotList"]

BP -.->|"BpmHelper.BeatToTime"| TIMES
TIMES -.->|"各tについて"| KDE
KDE -.->|"GaussianKernel"| DENSITY
DENSITY -.->|"DensityPlot"| PLOT_LIST
```

**図：密度計算パイプライン**

カーネル帯域幅は`0.42`に固定されており

、ガウシアンカーネルは

で実装されています。

**テクスチャレンダリング：**



はレンダリングロジックを実装しています：

1. **キャッシュチェック** 
2. **必要に応じてテクスチャを作成** 
3. **背景を塗りつぶし** 
4. **中央値ラインを描画** 
5. **密度曲線をレンダリング** 
6. **適用してキャッシュフラグを設定** 


## アセットグループ管理 

### AddressableLoader ハンドルキャッシュ 

`AddressableLoader`は、機能/シーンごとにアドレサブルアセットのライフタイムを管理するため、`AssetGroupHandle`オブジェクトの静的リストを保持します。各ハンドルは`groupId`（通常はハッシュコード）に関連付けられており、機能終了時にバッチで解放できます。

**キャッシュ構造：**

```mermaid
classDiagram
    class AddressableLoader {
        -static List<AssetGroupHandle> _assetGroupHandleList
        +static LoadAsync<T>(ct, assetAddress, groupId) : UniTask<T>
        +static ReleaseGroup(groupId) : void
    }
    class AssetGroupHandle {
        +int GroupId
        +AsyncOperationHandle Handle
    }
    class FolderTextureLoader {
    }
    class FolderSelectPanel {
    }
    AddressableLoader --> AssetGroupHandle : groupId = GetHashCode()
    FolderTextureLoader ..> AddressableLoader : groupId = _hash
    FolderSelectPanel ..> AddressableLoader
```

**図：AddressableLoaderハンドル管理**

**実装：**

キャッシュは読み込み中にハンドルを蓄積します

：

```c#
var handle = Addressables.LoadAssetAsync<T>(assetAddress);_assetGroupHandleList.Add(new AssetGroupHandle(groupId, handle));
```

**グループベースの解放：**



機能が破棄されると、そのグループ内のすべてのアセットを解放します：

```
AddressableLoader.ReleaseGroup(GetHashCode());
```

使用例：

* `FolderTextureLoader.OnFinalize()` 
* `FolderSelectPanel.OnDestroy()` 

**解放ロジック：**

```mermaid
flowchart TD

RP["ReleaseGroup groupId"]
FIND["groupIdに一致するハンドルをすべて検索"]
LOOP["各ハンドルについて"]
REL["Addressables.Release handle"]
REMOVE["_assetGroupHandleListからRemoveAll"]
DONE["解放完了"]

RP -.-> FIND
FIND -.->|"handle"| LOOP
LOOP -.-> REL
REL -.-> REMOVE
REMOVE -.-> DONE
```

**図：グループ解放プロセス**

これにより、コンポーネントが破棄されるときに、そのコンポーネントによって読み込まれたすべてのアドレサブルアセットが適切に解放されることが保証され、メモリリークを防ぎます。

 

 

 

---

## キャッシュライフサイクルパターン 

### 初期化戦略 

| キャッシュタイプ | 初期化タイミング | メソッド |
| --- | --- | --- |
| `FolderTextureCache` | 遅延（最初のパネルオープン時） | `HasCache`チェック → `LoadTextureAsync()` → `SetCache()` |
| `FolderScoreCache` | 即座（パネル初期化時） | `InitFolderScore()` → `SetCache()` |
| `DensityDrawer` | 譜面ごとのオンデマンド | `Calculate()` → `DrawGraph()` |
| `AddressableLoader` | 読み込みごとの蓄積 | 各`LoadAsync()`がリストに追加 |

### クリーンアップパターン 

**手動クリーンアップの例：**

```mermaid
sequenceDiagram
  participant p1 as Unityエンジン
  participant p2 as FolderSelectPanel
  participant p3 as FolderTextureCache
  participant p4 as FolderTextureLoader
  participant p5 as AddressableLoader

  p1->>p2: OnDestroy()
  p2->>p4: OnFinalize()
  p4->>p5: ReleaseGroup(hashCode)
  p5->>p5: グループ内のすべてのハンドルを解放
  p2->>p3: Clear()
  p3->>p3: 各テクスチャを破棄
  p3->>p3: リストをクリア
```

**図：FolderSelectPanelクリーンアップシーケンス**



**自動クリーンアップ：**

`DensityDrawer.Dispose()` は、`SequenceInfoPanel.OnDestroy()` から呼び出されます

```
for (int i = 0; i < _drawTexture.Length; i++)
{    
    Destroy(_drawTexture[i]);    
    _drawTexture[i] = null;
}
```

### キャッシュ無効化トリガー 

| キャッシュ | 無効化イベント | 動作 |
| --- | --- | --- |
| `FolderTextureCache` | なし（破棄まで） | セッション中持続 |
| `FolderScoreCache` | `InitFolderScore()`呼び出し | オンデマンドで再計算 |
| `DensityDrawer` | `Reset(offset)` | `_isDensityDrawn`フラグをクリア |
| `AddressableLoader` | `ReleaseGroup(groupId)` | グループのハンドルを削除 |

**リセットの例：**



は、新しい譜面を読み込む前に`Reset()`を呼び出します：

```
_densityDrawer.Reset(songInfo.Offset);
```

これにより、`_isDensityDrawn`配列がクリアされます

が、テクスチャは破棄されず、同じ密度タイプが再度要求された場合に再利用できます。

### On this page

* [キャッシュシステム](#9.3-)
* [目的と範囲](#9.3--1)
* [キャッシュアーキテクチャの概要](#9.3--2)
* [テクスチャキャッシュ](#9.3--3)
* [FolderTextureCache](#9.3-foldertexturecache)
* [楽曲と譜面データのキャッシュ](#9.3--4)
* [SongInfoCache](#9.3-songinfocache)
* [ChartInfoCache](#9.3-chartinfocache)
* [スコア集計キャッシュ](#9.3--5)
* [FolderScoreCache](#9.3-folderscorecache)
* [レンダーデータキャッシュ](#9.3--6)
* [DensityDrawer テクスチャとプロットキャッシュ](#9.3-densitydrawer-)
* [アセットグループ管理](#9.3--7)
* [AddressableLoader ハンドルキャッシュ](#9.3-addressableloader-)
* [キャッシュライフサイクルパターン](#9.3--8)
* [初期化戦略](#9.3--9)
* [クリーンアップパターン](#9.3--10)
* [キャッシュ無効化トリガー](#9.3--11)

