

# ゲームループとシーンコントローラー 

## 目的と範囲 

このページでは、ゲームプレイシーンのオーケストレーション層について文書化します。`MusicGameSceneController`が初期化パイプライン、サブシステム更新の調整、フレームごとのゲームループの実装をどのように管理するかに焦点を当てます。シーンのエントリから完了までのライフサイクル、マネージャー間のイベント配線、`MusicGame`へのコアゲームプレイロジックの委譲について説明します。

ノートのスポーン、譜面解析、位置計算の詳細については、[ノートと譜面管理](#3.2)を参照してください。入力処理の詳細については、[入力システム](#3.4)を参照してください。判定メカニクスについては、[判定メカニクス](#4.1)を参照してください。

---

## シーンコントローラーアーキテクチャ 

`MusicGameSceneController`は、ゲームプレイシーンの中央オーケストレーションハブとして機能します。すべてのマネージャーコンポーネントを所有し、それらの初期化を調整し、フレームごとの更新サイクルを駆動します。コントローラーは、クラスドキュメントに記載されている設計哲学に従います：すべてのシーンスクリプトは`Start()`と`Update()`を避け、代わりにコントローラーが制御されたシーケンスで呼び出す`Init()`と`CallUpdate()`メソッドを提供します。

### コンポーネントの所有関係 

```mermaid
flowchart TD

MGSC["MusicGameSceneController (シーンルート)"]
MG["MusicGame _musicGame"]
MM["MusicManager _musicManager"]
INPUT["InputBase _input"]
JUDGE["JudgeManager _judgeManager"]
LIFE["LifeManager _lifeManager"]
SCORE["ScoreManager _scoreManager"]
COMBO["ComboManager _comboManager"]
CAMERA["GameCameraController _gameCameraController"]
FILTER["FilterColorController _filterColorController"]
LANE["LaneController _laneController"]
PLATE["JudgePlateController _judgePlateController"]
STATE["ClearStateViewController _stateViewController"]
WAIT["WaitPlayPanel _waitPlayPanel"]
PAUSE["PausePanelController _pausePanelController"]
TIME["MusicTimePanelController _musicTimePanelController"]
LUA["LuaManager _luaManager"]
ONLINE["OnlineManager _onlineManager"]

MGSC -.-> MG
MGSC -.-> MM
MGSC -.-> INPUT
MGSC -.-> JUDGE
MGSC -.-> LIFE
MGSC -.-> SCORE
MGSC -.-> COMBO
MGSC -.-> CAMERA
MGSC -.-> FILTER
MGSC -.-> LANE
MGSC -.-> PLATE
MGSC -.-> STATE
MGSC -.-> WAIT
MGSC -.-> PAUSE
MGSC -.-> TIME
MGSC -.-> LUA
MGSC -.-> ONLINE

subgraph 拡張機能 ["拡張機能"]
    LUA
    ONLINE
end

subgraph UIパネル ["UIパネル"]
    WAIT
    PAUSE
    TIME
end

subgraph プレゼンテーション ["プレゼンテーション"]
    CAMERA
    FILTER
    LANE
    PLATE
    STATE
end

subgraph 判定システム ["判定システム"]
    JUDGE
    LIFE
    SCORE
    COMBO
end

subgraph コアシステム ["コアシステム"]
    MG
    MM
    INPUT
end
```


## シーンライフサイクル 

ゲームプレイシーンは、`MusicGameSceneController`によって管理される厳密なライフサイクルに従います。ライフサイクルは5つのフェーズを経て進行します：エントリ、初期化、待機、プレイ、完了。

## 初期化パイプライン 

初期化パイプラインは、すべてのサブシステムを特定の順序で設定する非同期メソッド（`InitAsync`）として実装されています。このアプローチは、高コストな操作中にUnityに制御を譲ることでフレーム落ちを防ぎます。

### 初期化シーケンス 

```mermaid
sequenceDiagram
  participant p1 as Unity
  participant p2 as MusicGameSceneController
  participant p3 as BgManager
  participant p4 as マネージャー群
  participant p5 as MusicGame
  participant p6 as LuaManager
  participant p7 as WaitPlayPanel

  p1->>p2: Start()
  p2->>p2: SelectSongInfo検証
  p2->>p3: SetBlack()
  p2->>p2: SetEvent()
  p2->>p2: InitAsync(ct)
  p2->>p3: UseDimmer(true)
  p2->>p4: Init() x11コンポーネント
  note over p4: GameCameraController FilterColorController LaneController JudgePlateController PlayStateController ClearStateViewController LifeManager JudgeManager PausePanelController ComboManager ScoreManager
  p2->>p2: LoadTouchSE()
  p2->>p2: 入力選択(_autoPlayまたは_touchArea)
  p2->>p3: LoadBgChangeImages()
  p2->>p5: InitAsync(ct | songInfo | input | judgeManager)
  p5-->>p2: bool isSuccess
  alt オンラインモード
    p2->>p2: LoadAudioAsync()
    p2->>p2: InitMqttAsync()
  end
  p2->>p2: BindLua(songInfo)
  p2->>p6: Init()とAPI連携
  p2->>p7: Init(ct | onClickPlayButton | songInfo)
  p2->>p4: SetTotalNote()
  alt オートモード
    p2->>p2: _autoPlay.Init()
  end
  p2->>p2: _touchArea.Init()
  p2->>p2: FadeManager.StartFadeInAsync()
  p2-->>p1: 初期化完了
```



* 
* 

### マネージャー初期化順序 

コントローラーは依存関係を満たすために、特定の順序でマネージャーを初期化します：

| 順序 | コンポーネント | Initメソッド | 目的 |
| --- | --- | --- | --- |
| 1 | `_gameCameraController` | `Init()` | レンダリング前のカメラ設定 |
| 2 | `_filterColorController` | `Init()` | ポストプロセスフィルター |
| 3 | `_laneController` | `Init()` | レーンビジュアル設定 |
| 4 | `_judgePlateController` | `Init()` | 判定ラインビジュアル |
| 5 | `_playStateController` | `Init()` | プレイモードコントローラー |
| 6 | `_stateViewController` | `Init()` | クリア状態表示 |
| 7 | `_lifeManager` | `Init()` | ヘルスゲージ |
| 8 | `_judgeManager` | `Init()` | タイミングウィンドウ |
| 9 | `_pausePanelController` | `Init()` | ポーズメニュー |
| 10 | `_comboManager` | `Init()` | コンボカウンター |
| 11 | `_scoreManager` | `Init()` | スコア計算 |


### MusicGame初期化 

`MusicGame.InitAsync()`は譜面を解析してオブジェクトプールを設定するため、最も重要な初期化ステップです：

```mermaid
flowchart TD

A["MusicGame.InitAsync()"]
B["SequenceReader.Read()"]
C["有効な場合レーンミラー化"]
D["MaxSameTimeLong計算"]
E["ヘルパー初期化"]
F["開始/最終時間計算"]
G["SetRelayLongStartIndex()"]
E1["BpmHelper.Init()"]
E2["ScrollHelper.Init()"]
E3["SpeedStretchRatio.Init()"]
E4["BgChangeHelper.Init()"]
E5["ObjectPools.Init()"]
E6["TimingHistory.Init()"]

A -.-> B
B -.-> C
C -.-> D
D -.-> E
E -.-> F
F -.-> G
E -.-> E1
E -.-> E2
E -.-> E3
E -.-> E4
E -.-> E5
E -.-> E6
```



* 

---

## イベント配線 

コントローラーはマネージャー間のイベントを配線して、リアクティブなデータフローを作成します。イベントは、密結合なしに判定結果、ライフ変更、ゲーム状態遷移を伝播します。

### イベントトポロジー 

```mermaid
flowchart TD

MM["MusicManager"]
MG["MusicGame"]
JUDGE["JudgeManager"]
LIFE["LifeManager"]
COMBO["ComboManager"]
SCORE["ScoreManager"]
MGSC["MusicGameSceneController"]
PAUSE["PausePanelController"]
ONLINE["OnlineManager"]
WAIT["WaitPlayPanel"]

MM -.->|"OnJudge"| MGSC
LIFE -.->|"OnMissedNote"| MGSC
JUDGE -.->|"OnJudge"| LIFE
JUDGE -.->|"OnMissedNote"| COMBO
JUDGE -.->|"OnAfterJudge"| SCORE
MG -.->|"OnMissedNote"| JUDGE
MG -.->|"OnDead"| LIFE
MG -.->|"OnMissedNote"| COMBO
MG -.->|"OnExit"| MGSC
PAUSE -.->|"OnFinalize"| MGSC
PAUSE -.->|"OnFinalize_"| WAIT
PAUSE -.->|"OnDisconnected"| MGSC
ONLINE -.->|"OnTopicStartEvent"| MGSC
ONLINE -.->|"OnRetire"| MGSC
ONLINE -.-> MGSC
```

### イベント設定実装 

`SetEvent()`メソッドは`Start()`中にすべてのイベントを配線します：

**コアゲームプレイイベント:**

```
_musicManager.OnFinishMusic += OnFinishMusic;
_lifeManager.OnDead += OnDead;
```

**判定カスケード:**

```
_judgeManager.OnJudge += _lifeManager.UpdateLife;
_judgeManager.OnJudge += _comboManager.UpdateCombo;
_judgeManager.OnAfterJudge += _scoreManager.OnAfterJudge;
```

**ミス伝播:**

```
_musicGame.OnMissedNote += _judgeManager.AddMissedJudge;
_musicGame.OnMissedNote += _lifeManager.UpdateLife;
_musicGame.OnMissedNote += _comboManager.UpdateCombo;
_musicGame.OnMissedNote += OnMissedNote;
```

## フレームごとの更新ループ 

コアゲームループは`MusicGameSceneController.Update()`で実行され、`CallUpdate()`メソッドを介してサブシステムに委譲されます。この一元化されたアプローチは、Unityのマネージド-ネイティブ間の呼び出しオーバーヘッドを削減し、明示的な順序付けを提供します。

### 更新実行フロー 

```mermaid
sequenceDiagram
  participant p1 as Unity
  participant p2 as MusicGameSceneController.Update()
  participant p3 as MusicManager
  participant p4 as InputBase
  participant p5 as MusicGame
  participant p6 as JudgeManager
  participant p7 as ScoreManager
  participant p8 as ComboManager
  participant p9 as LifeManager
  participant p10 as MusicTimePanelController
  participant p11 as OnlineManager
  participant p12 as LuaManager

  p1->>p2: Update() [毎フレーム]
  p2->>p3: CallUpdate()
  note over p3: AudioSource更新 楽曲終了チェック
  p2->>p2: _musicManager.IsPlayチェック
  alt 楽曲再生中
    p2->>p2: musicTime = GetMusicTime()
    p2->>p4: CallUpdate(musicTime)
    note over p4: タッチ入力処理 TouchData辞書構築
    p2->>p5: CallUpdate(musicTime)
    note over p5: 入力判定 ノート/ロング生成 位置更新 ロング終端チェック
    p2->>p4: ClearInputData()
    p2->>p6: CallUpdate()
    p2->>p7: CallUpdate()
    p2->>p8: CallUpdate()
    p2->>p9: UpdateRecord(musicTime)
    p2->>p10: CallUpdate(musicTime)
  alt オンラインモード有効
    p2->>p11: CallUpdate(musicTime)
  end
  alt Lua読込済み
    p2->>p12: CallUpdate(musicTime)
  end
  end
```

### 更新呼び出しシグネチャ 

コントローラーは一貫したパターンで更新を行います：

| メソッド | シグネチャ | 目的 |
| --- | --- | --- |
| `MusicManager.CallUpdate()` | `void CallUpdate()` | オーディオ再生状態を更新 |
| `InputBase.CallUpdate()` | `void CallUpdate(double musicTime)` | このフレームの入力を処理 |
| `MusicGame.CallUpdate()` | `void CallUpdate(double musicTime)` | コアゲームプレイロジック |
| `JudgeManager.CallUpdate()` | `void CallUpdate()` | 判定UIを更新 |
| `ScoreManager.CallUpdate()` | `void CallUpdate()` | スコア表示を更新 |
| `ComboManager.CallUpdate()` | `void CallUpdate()` | コンボ表示を更新 |
| `LifeManager.UpdateRecord()` | `void UpdateRecord(double musicTime)` | ライフ履歴を記録 |
| `MusicTimePanelController.CallUpdate()` | `void CallUpdate(double musicTime)` | 時間表示を更新 |
| `OnlineManager.CallUpdate()` | `void CallUpdate(double musicTime)` | オンライン状態を同期 |
| `LuaManager.CallUpdate()` | `void CallUpdate(double musicTime)` | Lua更新を実行 |

## MusicGameコアループ 

`MusicGameSceneController.Update()`が高レベルの更新を調整する一方で、`MusicGame.CallUpdate()`はコアゲームプレイループを実装します。このメソッドは、ノート生成、位置更新、すべての判定処理を扱います。

### MusicGame.CallUpdate構造 

```mermaid
flowchart TD

START["MusicGame.CallUpdate(musicTime)"]
BEAT["musicTimeからbeat計算"]
VISUAL["スクロール適用してvisualBeat計算"]
SORT["SortTouchIdList()"]
JUDGE_TAP["各タッチでJudgeTap()"]
JUDGE_UP["各タッチでJudgeUp()"]
JUDGE_HOLD["各タッチでJudgeHold()"]
SPEED["SpeedStretchRatio更新"]
CREATE_NOTE["ノート生成（最大32/フレーム）"]
UPDATE_NOTE["NoteObjectPool.CallUpdate()"]
CREATE_LONG["キューからロング生成"]
UPDATE_LONG["LongObjectPool.CallUpdate()"]
JUDGE_LONG["各タッチでJudgeLong()"]
CHECK_END["CheckEndLong()"]
SAMETIME["SameTimeBar.CallUpdate()"]
BEATBAR["拍線生成&更新"]
EFFECT["JudgeEffectPool.CallUpdate()"]
BG["BgChangeHelper.CheckBgChange()"]

START -.-> BEAT
BEAT -.-> VISUAL
VISUAL -.-> SORT
SORT -.-> JUDGE_TAP

subgraph その他要素 ["その他要素"]
    SAMETIME
    BEATBAR
    EFFECT
    BG
    SAMETIME -.-> BEATBAR
    BEATBAR -.-> EFFECT
    EFFECT -.-> BG
end

subgraph ロング処理 ["ロング処理"]
    CREATE_LONG
    UPDATE_LONG
    JUDGE_LONG
    CHECK_END
end

subgraph ノート処理 ["ノート処理"]
    SPEED
    CREATE_NOTE
    UPDATE_NOTE
    SPEED -.-> CREATE_NOTE
end

subgraph 判定フェーズ ["判定フェーズ（最優先）"]
    JUDGE_TAP
    JUDGE_UP
    JUDGE_HOLD
end
```

### ノート生成ループ 

フレームスパイクを避けるため、ノートは段階的に生成されます。ループはフレームごとに最大32ノートを処理します：

```mermaid
flowchart TD

A["ループ: i = 0 to 32"]
B["NeedsCreateNote()?"]
C["スキップするノート?"]
D["CreateNoteFromObjectPool()"]
E["スキップセットから削除"]
F["ロングチェックにエンキュー"]
G["_noteIndexインクリメント"]
H["Break"]

A -.->|"いいえ"| B
B -.->|"はい"| C
C -.->|"いいえ"| D
C -.->|"はい"| E
D -.-> F
E -.-> F
F -.-> G
G -.-> B
B -.-> H
```

**ノートは以下の条件で生成されます:**

* CMOD: `musicTime > justTime - visibleTime`
* 通常: `visualBeat > scrolledBeat - GameParam.VisibleBeat`


### 判定優先度 

判定処理は更新ループの最初に行われ、最小限の入力レイテンシを確保します。コントローラーはタッチIDをソートして順番に処理します：

```mermaid
flowchart TD

A["各タッチID（ソート済み）"]
B["JudgeTap()"]
C["JudgeUp()"]
D["JudgeHold()"]
E["JudgeLong()"]
B1["最も近いノートを探す"]
B2["距離と時間をチェック"]
B3["JudgeTiming()"]
C1["LongEndノートを探す"]
C2["UpTouchIdをチェック"]
C3["JudgeTiming()"]
D1["Fuzzyノートを探す"]
D2["ホールド開始時間をチェック"]
D3["JudgeTiming()"]
E1["アクティブなロングを探す"]
E2["beat範囲をチェック"]
E3["OnHoldLong()またはOnReleaseLong()"]

A -.-> B
B -.-> C
C -.-> D
D -.-> E
B -.-> B1
B1 -.-> B2
B2 -.-> B3
C -.-> C1
C1 -.-> C2
C2 -.-> C3
D -.-> D1
D1 -.-> D2
D2 -.-> D3
E -.-> E1
E1 -.-> E2
E2 -.-> E3
```

## プレイ状態管理 

コントローラーは、オーディオ、入力、Luaスクリプトを慎重に調整しながら、待機、プレイ、ポーズ状態間の遷移を管理します。

### プレイ遷移 

```mermaid
sequenceDiagram
  participant p1 as WaitPlayPanel
  participant p2 as MusicGameSceneController
  participant p3 as MusicGame
  participant p4 as MusicManager
  participant p5 as LuaManager

  p1->>p2: Play(speed | startTime)
  p2->>p2: ポーズボタン有効化
  p2->>p2: GameParam.NoteSpeed設定
  p2->>p3: SetStartBarFromStartTime()
  p2->>p2: GC.Collect()
  p2->>p2: PlayAsync(startTime)
  alt リハーサルモード
    p2->>p3: SetMidPlay(startTime)
  end
  p2->>p4: InitAsync(path | file | lastNoteTime | startTime)
  note over p4: AudioClip読込/準備 再生位置設定
  p2->>p2: _musicTimePanelController.Init()
  alt Lua読込済み
    p2->>p5: StartLua()
  end
  note over p2: Update()が処理開始
```

### ポーズ/再開 

## ゲーム完了フロー 

楽曲が終了するかプレイヤーが死亡すると、コントローラーは結果を収集し、クリア状態を表示し、リザルトシーンに遷移します。

### 完了シーケンス 

```mermaid
sequenceDiagram
  participant p1 as MusicManager
  participant p2 as LifeManager
  participant p3 as MusicGameSceneController
  participant p4 as MusicGame
  participant p5 as LuaManager
  participant p6 as ClearStateViewController
  participant p7 as BgManager

  alt 楽曲終了
    p1->>p3: OnFinishMusic()
  else プレイヤー死亡
    p2->>p3: OnDead()
  end
  p3->>p5: OnGameOver()またはOnFinish()
  p3->>p3: ポーズボタン無効化
  p3->>p3: 入力停止
  p3->>p3: LongSE強制停止
  p3->>p3: CreateResultData()
  note over p3: 以下から集計: TimingHistory LifeHistory JudgeManager ScoreManager ComboManager
  p3->>p6: ShowClearState(resultData)
  note over p6: 表示内容: AllBrilliant/FullCombo/ Cleared/Failed
  p3->>p3: UpdatePlayDataThisGame()
  note over p3: ScoreDataPrefasに保存
  p3->>p3: WaitPlayPanel.OnEndMusic()
  p3->>p7: UseDimmer(false)
  p3->>p7: bg変更キャッシュクリア
  alt オンラインモード
    p3->>p3: OnlineManager.OnFinishMusic()
  else 通常モード
    p3->>p3: WaitAsync()後にChangeScene()
  end
```


### リザルトデータ集計 

`CreateResultData()`は全マネージャーからデータを収集して単一の`ResultData`オブジェクトにします：

```mermaid
flowchart TD

MGSC["MusicGameSceneController.CreateResultData()"]
TH["MusicGameからTimingHistory"]
LH["LifeManagerからLifeHistory"]
J["JudgeManagerから判定カウント"]
S["ScoreManagerからスコア/ランク"]
C["ComboManagerから最大コンボ"]
META["GameManagerから楽曲メタデータ"]
FLAGS["MusicGameからDisableRanking"]
RD["ResultData"]
GM["GameManager.Instance.ResultData"]

MGSC -.-> TH
MGSC -.-> LH
MGSC -.-> J
MGSC -.-> S
MGSC -.-> C
MGSC -.-> META
MGSC -.-> FLAGS
TH -.-> RD
LH -.-> RD
J -.-> RD
S -.-> RD
C -.-> RD
META -.-> RD
FLAGS -.-> RD
RD -.-> GM
```

## 特殊機能 

### タッチSE読込 

コントローラーは初期化中にカスタムタッチSEを読み込みます：

```mermaid
flowchart TD

A["LoadTouchSE()"]
B["TouchSeCache.GetInfo()"]
C["CriAtom.LoadTouchSE_Ex()"]
D["ACBでロングSEチェック"]
E["LongSEManager.SetExist()"]
B1["カスタムSE?"]
F["デフォルト使用"]

A -.-> B
B -.->|"はい"| C
C -.->|"いいえ"| D
D -.-> E
B -.-> B1
B1 -.-> C
B1 -.-> F
```

### Luaバインディング 

コントローラーはすべてのゲームプレイAPIへのアクセスを持つLuaスクリプトを初期化します：

```mermaid
flowchart TD

MGSC["BindLua(songInfo)"]
LUA["LuaManager.Init()"]
API1["ScreenMan.Init()"]
API2["GameState.Init(musicManager, musicGame)"]
API3["PlayerStats.Init(score, combo, life, touch)"]
API4["CameraMan.Init(cameraController)"]
API5["SongMan.Init(songInfo, sequence, musicManager)"]
API6["AssetMan.Init(pauseCallback)"]
API7["Util.Init(musicManager, musicGame)"]
API8["DanmakuStageMan.Init(life, musicGame)"]
E1["OnHitNoteLua配線"]
E2["OnMissedNoteLua配線"]
E3["OnSpawnNoteLua配線"]
E4["OnSpawnLongLua配線"]
E5["OnInputDown/Move/Up配線"]

MGSC -.-> LUA
LUA -.-> API1
LUA -.-> API2
LUA -.-> API3
LUA -.-> API4
LUA -.-> API5
LUA -.-> API6
LUA -.-> API7
LUA -.-> API8
MGSC -.-> E1
MGSC -.-> E2
MGSC -.-> E3
MGSC -.-> E4
MGSC -.-> E5
```

### オンラインモード 

オンラインプレイ時、コントローラーは同期されたゲームプレイのために`OnlineManager`と調整します：

```mermaid
sequenceDiagram
  participant p1 as MusicGameSceneController
  participant p2 as OnlineManager
  participant p3 as MQTTサーバー
  participant p4 as WaitPlayPanel

  p1->>p2: InitMqttAsync(camera | musicLength)
  p2->>p3: 接続&購読
  p3-->>p2: 接続確立
  p4->>p2: OnPressOnlineStartButton()
  p2->>p3: 準備状態を公開
  p3->>p2: OnTopicStartEvent
  p2->>p1: PlayOnline()
  p1->>p1: Play(hiSpeed | 0f)
  note over p1,p2: 更新ループで スコア/コンボ/判定を同期
  p1->>p2: CallUpdate(musicTime)
  p2->>p3: ゲームプレイデータ送信
```

## パフォーマンスに関する考慮事項 

### 一元化された更新パターン 

コントローラーは、Unityのマネージド-ネイティブ間呼び出しオーバーヘッドを削減するために一元化された更新パターンを使用します。各コンポーネントが独自の`Update()`メソッドを持つ代わりに、コントローラーが各コンポーネントの`CallUpdate()`を明示的に呼び出します。この設計はクラスコメントに記載されています：

> "UnityのUpdateはマネージドコード(C# IL)と非マネージドコード(ネイティブC++)のやり取りにコストがあるため、一つのUpdateから他のUpdateとなる処理を呼ぶほうが効率が良い"

### 非同期初期化 

すべての高コストな初期化操作は、メインスレッドをブロックしないように`UniTask`を使用します。これには以下が含まれます：

* オーディオクリップ読込
* 譜面解析（SequenceReader）
* テクスチャ読込
* MQTT接続（オンラインモード）

### ガベージコレクション 

コントローラーは、ゲームプレイ中のコレクション停止を最小化するため、ゲームプレイ開始直前に明示的に`GC.Collect()`を呼び出します：

## まとめ 

`MusicGameSceneController`は、以下を実現する調整されたオーケストレーションパターンを実装しています：

1. **ライフサイクル管理の一元化** `Start()`、`InitAsync()`、`Update()`を通じて
2. **初期化の順序付け** 15以上のマネージャーコンポーネント間の依存関係を満たすため
3. **イベント配線** 密結合なしにリアクティブなデータフローを作成
4. **コアロジックの委譲** 高レベルの関心事を調整しながら`MusicGame.CallUpdate()`へ
5. **状態遷移の管理** 待機、プレイ、ポーズ、完了状態間で
6. **結果の集計** すべてのマネージャーから統一された`ResultData`構造へ

このアーキテクチャは、明確な関心の分離を提供します：コントローラーはオーケストレーションとライフサイクルを処理し、`MusicGame`は[ノートと譜面管理](#3.2)で詳述されているフレームごとのゲームプレイロジックを実装します。

### On this page

* [ゲームループとシーンコントローラー](#3.1-)
* [目的と範囲](#3.1--1)
* [シーンコントローラーアーキテクチャ](#3.1--2)
* [コンポーネントの所有関係](#3.1--3)
* [シーンライフサイクル](#3.1--4)
* [ライフサイクルステートマシン](#3.1--5)
* [初期化パイプライン](#3.1--6)
* [初期化シーケンス](#3.1--7)
* [マネージャー初期化順序](#3.1--8)
* [MusicGame初期化](#3.1-musicgame)
* [イベント配線](#3.1--9)
* [イベントトポロジー](#3.1--10)
* [イベント設定実装](#3.1--11)
* [フレームごとの更新ループ](#3.1--12)
* [更新実行フロー](#3.1--13)
* [更新呼び出しシグネチャ](#3.1--14)
* [MusicGameコアループ](#3.1-musicgame-1)
* [MusicGame.CallUpdate構造](#3.1-musicgamecallupdate)
* [ノート生成ループ](#3.1--15)
* [判定優先度](#3.1--16)
* [プレイ状態管理](#3.1--17)
* [プレイ遷移](#3.1--18)
* [ポーズ/再開](#3.1--19)
* [ゲーム完了フロー](#3.1--20)
* [完了シーケンス](#3.1--21)
* [リザルトデータ集計](#3.1--22)
* [特殊機能](#3.1--23)
* [タッチSE読込](#3.1-se)
* [Luaバインディング](#3.1-lua)
* [オンラインモード](#3.1--24)
* [パフォーマンスに関する考慮事項](#3.1--25)
* [一元化された更新パターン](#3.1--26)
* [非同期初期化](#3.1--27)
* [ガベージコレクション](#3.1--28)
* [まとめ](#3.1--29)

