

# ゲーム設定管理 

本ドキュメントでは、`NotesOption`、`DisplayOption`、`VolumeOption`のデータ構造、プレイヤーがこれらの設定を構成できる`GameSettingsPanel` UI、およびプレイヤーの設定を保存・読み込む永続化メカニズムを含む、コアゲーム設定システムについて説明します。判定タイミングおよびタイミング関連の設定については、[判定タイミング設定](#6.2)を参照してください。より広範な永続化システムのアーキテクチャについては、[データ永続化システム](#2.3)を参照してください。

---

## 概要 

ゲーム設定管理システムは、プレイヤーにビジュアル、オーディオ、およびゲームプレイプレゼンテーションパラメータの制御を提供します。設定は3つの主要なドメインに整理されています：

| ドメイン | 目的 | 主要パラメータ |
| --- | --- | --- |
| **NotesOption** | ノートの外観と動作を制御 | サイズ、スキン、速度、距離、オフセット |
| **DisplayOption** | 視覚要素とパフォーマンスを制御 | FPS表示、UI可視性、エフェクト |
| **VolumeOption** | オーディオレベルを制御 | 音楽、効果音、動画音声 |

すべての設定は`GameManager.Instance`を通じてアクセスされ、`Serializable<T>`パターンを使用して`GameSettingsPrefas`経由で永続化されます。設定は変更時に即座にゲーム状態に適用され、アプリケーション終了時に自動的に保存されます。

---

## 設定データモデル 

### オプションクラスのアーキテクチャ 

```mermaid
flowchart TD

GM["GameManager.Instance"]
NO["NotesOption (ノート設定)"]
DO["DisplayOption (表示設定)"]
VO["VolumeOption (音量設定)"]
JTO["JudgeTimeOption (タイミング設定)"]
GSP["GameSettingsPrefas (シングルトンインスタンス)"]
SN["Serializable<NotesOption>"]
SD["Serializable<DisplayOption>"]
SV["Serializable<VolumeOption>"]
SJ["Serializable<JudgeTimeOption>"]
JSON["(GameSettingsPrefas).json ExternalDirectory.SavePath"]

NO -.->|"含む"| SN
DO -.->|"管理"| SD
VO -.->|"読込元"| SV
JTO -.->|"管理"| SJ
GSP -.->|"GameSettingsPrefas.Save"| JSON
GSP -.->|"File.Open<T>"| JSON

subgraph ファイルシステム ["ファイルシステム"]
    JSON
end

subgraph シリアライゼーション層 ["シリアライゼーション層"]
    GSP
    SN
    SD
    SV
    SJ
    GSP -.->|"読込元"| SN
    GSP -.->|"管理"| SD
    GSP -.->|"読込元"| SV
    GSP -.->|"管理"| SJ
end

subgraph subGraph0 ["GameManager シングルトン"]
    GM
    NO
    DO
    VO
    JTO
    GM -.->|"含む"| NO
    GM -.->|"含む"| DO
    GM -.->|"含む"| VO
    GM -.->|"読込元"| JTO
end
```

### NotesOption 

`NotesOption`はゲームプレイ中のノートの視覚的プレゼンテーションを制御します。これにはノートのサイズ、外観、移動速度、位置調整が含まれます。

**主要プロパティ：**

* **Size**: ノートオブジェクトの視覚的スケール
* **Skin**: ノートスキン名（デフォルトまたはカスタム）
* **Speed**: ノートスクロール速度の倍率
* **Distance**: ヒットラインとスポーン地点間の距離
* **OffsetZ**: 3D位置決めのための深度オフセット
* **TouchEffect**: タッチエフェクトの可視性トグル
* **JudgeLine**: ジャッジラインの可視性トグル

これらの設定は、`MusicGame.CallUpdate`のノートスポーンおよびレンダリングロジックと、`ScrollHelper`の位置計算に直接影響します。

 高レベル図1（アプリケーションシーンフロー）、高レベル図2（ゲームプレイコア）

### DisplayOption 

`DisplayOption`はUI要素、視覚エフェクト、およびパフォーマンス関連の表示設定を制御します。

**主要プロパティ：**

* **FPS**: フレームレート表示トグル
* **UIVisibility**: UI要素の可視性設定
* **Effects**: 視覚エフェクトの強度/可視性
* **Resolution**: ディスプレイ解像度設定
* **Fullscreen**: フルスクリーンモードトグル

これらの設定は主にUIコンポーネントとレンダリングパイプラインによって使用されます。FPS表示は通常、専用のUIコントローラーによって処理されます。

### VolumeOption 

`VolumeOption`は異なるオーディオカテゴリのオーディオレベルを制御します。値は通常、0.0～1.0の正規化されたfloatです。

**主要プロパティ：**

* **MusicVolume**: 背景音楽の音量レベル
* **SeVolume**: 効果音の音量レベル
* **VideoVolume**: 動画再生の音声レベル

音量設定はアプリケーション全体の`AudioSource`コンポーネントに適用されます。例えば、

では、音楽の音量が`GameManager.Instance.VolumeOption.MusicVolume`から取得されます。

## 永続化アーキテクチャ 

### ファイルベースの永続化フロー 

```mermaid
flowchart TD

START["アプリ起動"]
RUNTIME["実行時 (設定変更)"]
QUIT["アプリ終了"]
GM["GameManager.Instance"]
OPTS["NotesOption DisplayOption VolumeOption"]
GSP["GameSettingsPrefas"]
FILE_SYS["File<T>.Open File<T>.Save"]
SAVE_DIR["ExternalDirectory.SavePath"]
JSON_FILE["(GameSettingsPrefas).json"]

START -.->|"読込"| GSP
GSP -.->|"File.Open"| JSON_FILE
GM -.->|"プレイ中"| RUNTIME
RUNTIME -.->|"変更"| OPTS
QUIT -.->|"保存トリガー"| GSP
OPTS -.->|"シリアライズ"| GSP
GSP -.->|"File.Save"| JSON_FILE

subgraph ファイルシステム ["ファイルシステム"]
    SAVE_DIR
    JSON_FILE
end

subgraph 永続化層 ["永続化層"]
    GSP
    FILE_SYS
end

subgraph GameManager ["GameManager"]
    GM
    OPTS
    OPTS -.->|"初期化"| GM
end

subgraph アプリケーションライフサイクル ["アプリケーションライフサイクル"]
    START
    RUNTIME
    QUIT
end
```

 高レベル図3（データ永続化）、

### 保存パスの解決 

設定は、`ExternalDirectory`によって管理されるプラットフォーム固有の場所に保存されます：

| プラットフォーム | 保存パス |
| --- | --- |
| **Editor** | `Application.dataPath/ThirtySec/Save/Files` |
| **Android** | `Application.persistentDataPath/Save` |
| **iOS** | `Application.persistentDataPath/Save` |

`ExternalDirectory.SavePath`プロパティ

は、プラットフォームに適したパスを提供します。初回実行時、`ExternalDirectory.CreateSaveDirectory()` 

はディレクトリが存在することを保証します。

レガシー保存ファイルの移行は`ExternalDirectory.MoveSaveFiles()` 

によって処理され、古い保存データを非推奨のパスから現在の構造に再配置します。



、

### Serializableパターン 

`Serializable<T>`パターンは、自動的な遅延読み込みと終了時保存機能を提供します：

1. **遅延読み込み**: 設定は最初にアクセスされたときにのみディスクから読み込まれます
2. **シングルトンインスタンス**: 各オプションタイプにはシングルトンラッパー（`GameSettingsPrefas.instance.NotesOption`）があります
3. **自動永続化**: 変更はアプリケーション終了時に`GameSettingsPrefas.Save()`を介して自動的にシリアライズされます

このパターンにより、ほとんどのコンテキストで手動の読み込み/保存呼び出しなしに、アプリケーションライフサイクル全体で設定が利用可能になります。

 高レベル図3（データ永続化）

---

## UIコンポーネント 

### GameSettingsPanelの構造 

```mermaid
flowchart TD

MSV["MusicSelectSceneView"]
GSP["GameSettingsPanel"]
NSP["NotesSettingsPanel (ScrollView)"]
DSP["DisplaySettingsPanel (ScrollView)"]
VSP["VolumeSettingsPanel (ScrollView)"]
JTSP["JudgeTimeSettingsPanel (6.2を参照)"]
MV["MusicVolumeSlider"]
SV["SeVolumeSlider"]
VV["VideoVolumeSlider"]
RESET["ResetButton"]
VO["VolumeOption.MusicVolume"]

GSP -.->|"タブ2"| NSP
GSP -.->|"含む"| DSP
GSP -.->|"タブ3"| VSP
GSP -.->|"タブ4"| JTSP
VSP -.->|"含む"| MV
VSP -.->|"更新"| SV
VSP -.->|"含む"| VV
VSP -.->|"含む"| RESET
MV -.->|"更新"| VO
SV -.->|"更新"| VO
VV -.-> VO

subgraph UI要素 ["UI要素（例：音量）"]
    MV
    SV
    VV
    RESET
end

subgraph 設定パネル ["設定パネル"]
    NSP
    DSP
    VSP
    JTSP
end

subgraph MusicSelectSceneView ["MusicSelectSceneView"]
    MSV
    GSP
    MSV -.->|"含む"| GSP
end
```

 高レベル図1（アプリケーションシーンフロー）、高レベル図4（UIアーキテクチャ）、

### 設定パネルのインタラクションパターン 

各設定パネルは、JudgeTimeSettingsPanelの実装で観察できる一貫したインタラクションパターンに従います（NotesSettingsPanel、DisplaySettingsPanel、VolumeSettingsPanelも同じパターンに従います）：

### 音量設定パネルの例 

音量設定パネルは典型的な実装パターンを示しています：

1. **初期化**  : * `GameManager.Instance.VolumeOption`参照を取得 * 現在の音量値でスライダーコントロールをセットアップ * オプションオブジェクトを更新する`onValueChanged`リスナーをアタッチ
2. **実行時更新**: * スライダーの変更は`VolumeOption`プロパティを直接変更 * 変更は即座に`GameManager`インスタンスに反映される * アプリ全体のオーディオコンポーネントは更新されたオプションから読み取る
3. **リセット機能**: * リセットボタンはデフォルト値（通常`Constant`クラスで定義）を復元 * UIコントロールはリセットされた値を反映するように更新される



### ノート設定パネルの例 

ノート設定パネルは視覚的なノートプレゼンテーションパラメータを管理します：

**UIコンポーネント：**

* **サイズスライダー**: ノートのスケールを調整（通常0.5x～2.0x）
* **スキンドロップダウン**: ノートスキンを選択（デフォルトまたはNoteSkinsフォルダのカスタム）
* **速度スライダー**: ノートスクロール速度の倍率を制御
* **距離スライダー**: スポーンからヒットまでの距離を調整
* **トグルスイッチ**: タッチエフェクト、ジャッジラインなどを有効/無効化

カスタムノートスキンは`ExternalDirectory.NoteSkinsPath` 

から読み込まれます。`NoteSkinCache`は読み込まれたスキンアセットを維持し、冗長なファイルI/Oを回避します。

---

## ゲームプレイとの統合 

### 設定アクセスパターン 

```mermaid
flowchart TD

MG["MusicGame (コアループ)"]
SCROLL["ScrollHelper (位置計算)"]
NOTE_POOL["NoteObjectPool (レンダリング)"]
AUDIO["AudioSource (サウンド)"]
GM["GameManager.Instance"]
NO["NotesOption"]
DO["DisplayOption"]
VO["VolumeOption"]

MG -.->|"読取"| NO
MG -.->|"読取"| DO
SCROLL -.->|"Speed Distance"| NO
AUDIO -.->|"MusicVolume SeVolume"| VO

subgraph 設定アクセス ["設定アクセス"]
    GM
    NO
    DO
    VO
    NO -.->|"アクセス経由"| GM
    DO -.->|"アクセス経由"| GM
    VO -.->|"Size Skin"| GM
end

subgraph ゲームプレイシステム ["ゲームプレイシステム"]
    MG
    SCROLL
    NOTE_POOL
    AUDIO
end
```

図2（ゲームプレイコアアーキテクチャ）

### NotesOptionを使用したノートレンダリング 

ゲームプレイ中、ノートの視覚的プロパティは`NotesOption`によって決定されます：

1. **位置計算**: `ScrollHelper`は`NotesOption.Speed`と`NotesOption.Distance`を使用して、音楽時間に基づいてノートのY位置を計算します
2. **スケール適用**: `NoteObjectPool`はインスタンス化中にノートGameObjectに`NotesOption.Size`を適用します
3. **スキン選択**: ノートスプライトは`NoteSkinCache`を介して`NotesOption.Skin`で指定されたスキンから読み込まれます
4. **エフェクト可視性**: タッチエフェクトとジャッジラインの可視性は、`NotesOption`の対応するトグルによって制御されます

これらの値はゲームプレイ中は読み取り専用です；変更は設定パネルでのみ行われます。

### VolumeOptionを使用したオーディオ 

アプリケーション全体のオーディオコンポーネントは`VolumeOption`から読み取ります：

このパターンは以下で使用されます：

* **音楽再生**: 背景音楽の`AudioSource`コンポーネント
* **効果音**: SE再生システム

音量設定の変更は、設定パネルで変更されたときにアクティブなオーディオソースに即座に適用されます。

 
### 表示設定の適用 

`DisplayOption`プロパティは、さまざまなUIおよびレンダリングシステムによって使用されます：

* **FPS表示**: FPSカウンターUIコンポーネントによって切り替え
* **UI可視性**: ゲームプレイ中の非必須UI要素の可視性を制御
* **エフェクト**: パーティクルシステムのエミッションレートまたは可視性を調整

これらの設定は、通常、コアゲームプレイロジックではなく、レンダリングまたはUIの動作に影響します。

---

## 設定のライフサイクル 

### 初期化シーケンス 

```mermaid
sequenceDiagram
  participant p1 as アプリ
  participant p2 as GameManager
  participant p3 as GameSettingsPrefas
  participant p4 as ファイルシステム
  participant p5 as SelectMusicシーン
  participant p6 as GameSettingsPanel

  p1->>p2: Awake() / 初期化
  p2->>p3: .instanceにアクセス
  p3->>p4: File.Open<T>()
  p4-->>p3: JSONデータまたはデフォルト
  p3-->>p2: オプションオブジェクトを設定
  p1->>p5: SelectMusicシーンをロード
  p5->>p6: UIを初期化
  p6->>p2: 現在の設定を読み取る
  p2-->>p6: NotesOption, DisplayOption, VolumeOption
  p6->>p6: 値でUIコントロールを設定
```

### 変更フロー 

設定の変更は即時更新パターンに従います：

1. **ユーザーインタラクション**: プレイヤーが設定パネルでスライダー/トグルを調整
2. **イベントハンドラー**: UIイベントリスナーが発火
3. **直接更新**: ハンドラーが`GameManager.Instance`のオプションオブジェクトプロパティを直接変更
4. **即時効果**: オプションから読み取るゲームシステムが更新された値を見る
5. **遅延保存**: 実際のファイル書き込みはオプション画面を閉じる時

このアプローチは、I/O操作を最小限に抑えながら、設定が常にメモリ内で利用可能であることを保証します



### 保存メカニズム 

```mermaid
flowchart TD

QUIT["Application.Quit"]
MANUAL["手動保存 (リロードボタン)"]
GM["GameManager"]
GSP["GameSettingsPrefas"]
FILE["File<T>.Save()"]
JSON["(GameSettingsPrefas).json"]

QUIT -.->|"トリガー"| GM
MANUAL -.->|"トリガー"| GM
FILE -.->|"書込"| JSON

subgraph 結果 ["結果"]
    JSON
end

subgraph 保存プロセス ["保存プロセス"]
    GM
    GSP
    FILE
    GM -.->|"オプションをコピー"| GSP
    GSP -.->|"シリアライズ"| FILE
end

subgraph トリガーポイント ["トリガーポイント"]
    QUIT
    MANUAL
end
```

`JudgeTimeSettingsPanel`のリロードボタンは、手動保存のトリガーを示しています：

この手動保存は主に楽曲リストをリロードするときに使用され、キャッシュをクリアして楽曲選択シーンを再初期化する前に設定が永続化されることを保証します。

---

## まとめ 

ゲーム設定管理システムは、以下の間のクリーンな分離を提供します：

| レイヤー | 責任 | 主要クラス |
| --- | --- | --- |
| **データ** | 設定値を格納 | `NotesOption`, `DisplayOption`, `VolumeOption` |
| **永続化** | 設定をシリアライズ/デシリアライズ | `GameSettingsPrefas`, `File<T>`, `Serializable<T>` |
| **UI** | プレイヤーに設定を提示 | `GameSettingsPanel`、個別の設定パネル |
| **アクセス** | グローバル設定アクセスを提供 | `GameManager.Instance` |

設定はアプリケーション起動時に1回読み込まれ、実行時にメモリ内で変更され、アプリケーション終了時にディスクに永続化されます。このアーキテクチャは、アプリケーションライフサイクル全体で設定の一貫性を維持しながら、I/Oオーバーヘッドを最小限に抑えます。判定ウィンドウやオーディオバッファ設定などのタイミング固有の設定については、[判定タイミング設定](#6.2)を参照してください。

### On this page

* [ゲーム設定管理](#6.1-)
* [概要](#6.1--1)
* [設定データモデル](#6.1--2)
* [オプションクラスのアーキテクチャ](#6.1--3)
* [NotesOption](#6.1-notesoption)
* [DisplayOption](#6.1-displayoption)
* [VolumeOption](#6.1-volumeoption)
* [永続化アーキテクチャ](#6.1--4)
* [ファイルベースの永続化フロー](#6.1--5)
* [保存パスの解決](#6.1--6)
* [Serializable パターン](#6.1-serializable)
* [UIコンポーネント](#6.1-ui)
* [GameSettingsPanelの構造](#6.1-gamesettingspanel)
* [設定パネルのインタラクションパターン](#6.1--7)
* [音量設定パネルの例](#6.1--8)
* [ノート設定パネルの例](#6.1--9)
* [ゲームプレイとの統合](#6.1--10)
* [設定アクセスパターン](#6.1--11)
* [NotesOptionを使用したノートレンダリング](#6.1-notesoption-1)
* [VolumeOptionを使用したオーディオ](#6.1-volumeoption-1)
* [表示設定の適用](#6.1--12)
* [設定のライフサイクル](#6.1--13)
* [初期化シーケンス](#6.1--14)
* [変更フロー](#6.1--15)
* [保存メカニズム](#6.1--16)
* [まとめ](#6.1--17)

