

# コアゲームプレイシステム 

## 目的と範囲 

コアゲームプレイシステムは、アクティブなゲームプレイ中に実行されるリアルタイムのリズムゲームメカニクスを包含します。このドキュメントは、プレイヤー入力またはオートプレイに応答してノートがスポーン、レンダリング、判定、スコアリングされる仕組みと、これらのサブシステムがどのように連携してプレイ可能なリズムゲーム体験を生み出すかについて、アーキテクチャの概要を提供します。

以下の詳細情報については、各ページを参照してください：

* シーン初期化とフレームごとのゲームループについては、[ゲームループとシーンコントローラー](#3.1)を参照
* 譜面データ構造とノートスポーンアルゴリズムについては、[ノートと譜面管理](#3.2)を参照
* パフォーマンス重視のオブジェクトリサイクルについては、[オブジェクトプーリングシステム](#3.3)を参照
* タッチ処理と入力の抽象化については、[入力システム](#3.4)を参照

スコアリングと判定アルゴリズムについては、[判定とスコアリングシステム](#4)を参照してください。


## システム概要 

ゲームプレイシステムは、`MusicGameSceneController`によってオーケストレーションされるマネージャーの同期されたコレクションとして動作し、`MusicGame`が中央の更新コーディネーターとして機能します。各フレームで、システムは以下を実行します：

1. `MusicManager`から音楽再生時間を読み取る
2. `InputBase`（`TouchArea`または`AutoPlay`のいずれか）を通じてプレイヤー入力を処理する
3. 拍位置に基づいてオブジェクトプールからノートとロングノートをスポーンする
4. 判定ラインに近づくにつれてZ軸に沿ってノート位置を更新する
5. `JudgeManager`を介してアクティブなノートに対する入力を評価する
6. 判定結果に基づいてライフ、スコア、コンボカウンターを更新する
7. 設定されている場合はカスタムLuaスクリプトコールバックを実行する
8. ゲーム後の分析のためにタイミングデータを記録する

システムは、倍精度の音楽時間を権威あるクロックとして使用することでフレームレートの独立性を維持し、ノートは`BpmHelper`によって計算される拍-時間変換に基づいて配置されます。


## コアアーキテクチャ図 

```mermaid
flowchart TD

MGSC["MusicGameSceneController シーンオーケストレーター"]
MG["MusicGame CallUpdate()"]
MM["MusicManager GetMusicTime()"]
INPUT["InputBase TouchArea or AutoPlay"]
SEQ["Sequence パース済み譜面"]
BPMH["BpmHelper 拍/時間変換"]
SCROLLH["ScrollHelper 位置計算"]
NPOOL["NoteObjectPool 32インスタンス"]
LPOOL["LongObjectPool 32インスタンス"]
BPOOL["BeatBarObjectPool 100インスタンス"]
EPOOL["JudgeEffectPool 32インスタンス"]
JUDGE["JudgeManager タイミング評価"]
LIFE["LifeManager ヘルストラッキング"]
SCORE["ScoreManager スコア計算"]
COMBO["ComboManager コンボカウント"]
RESULT["ResultData 集約された結果"]
THIST["TimingHistory フレーム単位の記録"]
LHIST["LifeHistory ヘルス記録"]

MGSC -.->|"TouchData"| MG
MGSC -.->|"初期化"| MM
MGSC -.->|"Update()"| INPUT
MGSC -.->|"位置計算"| JUDGE
MGSC -.->|"musicTime"| LIFE
MGSC -.->|"JudgeTap/Hold/Up"| SCORE
MGSC -.->|"OnMissedNoteイベント"| COMBO
MGSC -.->|"初期化"| MM
MGSC -.->|"Update()"| INPUT
MG -.->|"スポーン"| NPOOL
MG -.->|"記録"| LPOOL
MG -.->|"寄与"| BPOOL
SEQ -.->|"譜面提供"| MG
BPMH -.->|"拍→時間"| MG
SCROLLH -.->|"寄与"| MG
MG -.->|"OnMissedNoteイベント"| JUDGE
MG -.->|"寄与"| JUDGE
MG -.->|"寄与"| LIFE
MG -.->|"OnMissedNoteイベント"| COMBO
JUDGE -.->|"初期化"| EPOOL
JUDGE -.-> THIST
LIFE -.-> LHIST
MGSC -.->|"スポーン"| RESULT
JUDGE -.->|"寄与"| RESULT
SCORE -.->|"初期化"| RESULT
COMBO -.->|"初期化"| RESULT

subgraph 出力 ["出力"]
    RESULT
    THIST
    LHIST
    THIST -.-> RESULT
    LHIST -.-> RESULT
end

subgraph 判定システム ["判定システム"]
    JUDGE
    LIFE
    SCORE
    COMBO
    JUDGE -.->|"記録"| LIFE
    JUDGE -.->|"OnAfterJudgeイベント"| SCORE
    JUDGE -.->|"OnAfterJudgeイベント"| COMBO
end

subgraph オブジェクト管理 ["オブジェクト管理"]
    NPOOL
    LPOOL
    BPOOL
    EPOOL
end

subgraph 譜面データ ["譜面データ"]
    SEQ
    BPMH
    SCROLLH
end

subgraph コアゲームループ ["コアゲームループ"]
    MG
    MM
    INPUT
    MM -.->|"スポーン"| MG
    INPUT -.->|"OnJudgeイベント"| MG
end

subgraph シーンエントリーポイント ["シーンエントリーポイント"]
    MGSC
end
```


## コンポーネントの責務 

### MusicGameSceneController 

ゲームプレイシーンのエントリーポイント。すべてのサブシステムの非同期初期化を処理し、マネージャー間のイベントバインディングを設定し、`Update()`を呼び出してフレーム更新ループを駆動します。ゲームロジック自体は含まれません。

**主要メソッド:**

* `InitAsync()`: 譜面を読み込み、マネージャーを初期化し、イベントをバインドする
* `Update()`: すべてのマネージャーの`CallUpdate()`を順番に呼び出す
* `OnFinishMusic()`: `ResultData`を構築し、リザルトシーンに遷移する

---

### MusicGame 

中央のゲームプレイコーディネーター。オブジェクトプールからノート/ロング/拍線をスポーンし、位置を更新し、入力とノートの近接を検出し、判定をトリガーする責任を持ちます。どのノート/ロングがスポーン済みかのインデックスを維持し、すべてのアクティブオブジェクトのフレームごとの更新を管理します。

**主要メソッド:**

* `CallUpdate(double musicTime)`: マスター更新ループ
* `JudgeTap()`, `JudgeUp()`, `JudgeHold()`: 入力評価
* `JudgeLong()`: ロングノートのホールド検出
* `CreateNoteFromObjectPool()`: 可視範囲に入った際のノートスポーン

---

### Sequence 

パース済み譜面を表す不変データ構造。拍位置、レーン、ノートタイプ、アタックフラグの並列配列と、マルチセグメントロングノートを記述する`LongInfo`オブジェクトのリストを含みます。

**主要プロパティ:**

* `BeatPositions`: 拍タイムスタンプの`List<double>`
* `Lanes`: レーンインデックス（0-6）の`List<int>`
* `NoteTypes`: `List<NoteType>`（Normal、LongStart、Fuzzyなど）
* `LongInfo`: ロングノートセグメントを記述する`List<LongInfo>`

---

### BpmHelper 

譜面で定義されたBPM変更とストップを考慮して、拍位置と絶対時間の間を変換します。効率的な時間→拍変換のために二分探索を使用します。

**主要メソッド:**

* `BeatToTime(double beat)`: 秒を返す
* `TimeToBeat(double time)`: 拍位置を返す

---

### ScrollHelper 

スクロール速度修飾子（加速/減速ギミック）を視覚的な拍位置に適用します。音楽とは独立してノートのアプローチ速度を変更する`SPEEDS`または`SCROLLS`タグを持つ譜面で使用されます。

**主要メソッド:**

* `ApplyScroll(double beat)`: レンダリング用の修正された拍位置を返す

---

### NoteObjectPool 

32個の`NoteController`インスタンスのリサイクルプールを管理します。ノートがアクティブになると`Pool.Get()`で取得され、拍位置、レーン、テクスチャ、タイプで設定され、判定または期限切れ時に`Release()`で返されます。

---

### LongObjectPool 

32個の`LongController`インスタンスのリサイクルを管理します。各インスタンスは、ロングノートのリボンを表すプロシージャル生成メッシュを制御し、ノートパスに従うように各フレームで頂点位置を更新します。
 
---

### JudgeManager 

入力とノートのジャストタイムの間のタイミング差を評価します。`JudgeType`（Brilliant、Great、Good、Miss）を含む`OnJudge`イベントを発行し、ライフ/スコア/コンボマネージャーにカスケードします。

---

### InputBase (抽象) 

入力システムのインターフェースを定義します。サブクラスの`TouchArea`（人間の入力）と`AutoPlay`（完璧なプレイのシミュレーション）は、`TouchData`ディクショナリを設定するために`CallUpdate()`を実装します。

**主要プロパティ:**

* `TouchData`: タッチIDを位置/フェーズ/時間にマッピングする`Dictionary<int, TouchData>`

---

## フレーム更新フロー図 

```mermaid
sequenceDiagram
  participant p1 as MusicGameSceneController
  participant p2 as MusicManager
  participant p3 as InputBase
  participant p4 as MusicGame
  participant p5 as NoteObjectPool
  participant p6 as LongObjectPool
  participant p7 as JudgeManager
  participant p8 as LifeManager
  participant p9 as ScoreManager
  participant p10 as ComboManager

  p1->>p2: CallUpdate()
  p2-->>p1: (オーディオ時間を更新)
  p1->>p2: GetMusicTime()
  p2-->>p1: musicTime (double)
  p1->>p3: CallUpdate(musicTime)
  p3-->>p3: (タッチ処理/自動入力生成)
  p3-->>p1: TouchData設定完了
  p1->>p4: CallUpdate(musicTime)
  p4->>p4: SortTouchIdList()
  loop 各タッチ
    p4->>p4: JudgeTap/JudgeUp/JudgeHold()
    p4->>p7: (ノートが見つかれば判定をトリガー)
    p7-->>p8: OnJudgeイベント
    p7-->>p9: OnAfterJudgeイベント
    p7-->>p10: OnAfterJudgeイベント
  end
  loop フレームあたり最大32回
    p4->>p4: NeedsCreateNote()?
  alt ノートをスポーンすべき
    p4->>p5: Pool.Get()
    p5-->>p4: NoteController
    p4->>p5: noteController.SetParam()
  end
  end
  p4->>p5: CallUpdate(beat | time | speedRatio)
  p5-->>p5: (すべてのアクティブノートの位置を更新)
  loop ロングノート用
    p4->>p6: CreateLongFromObjectPool()
    p4->>p6: CallUpdate()
    p4->>p4: JudgeLong(beat | time | touchId)
  end
  p4->>p4: CheckEndLong()
  p1->>p7: CallUpdate()
  p1->>p9: CallUpdate()
  p1->>p10: CallUpdate()
  p1->>p8: UpdateRecord(musicTime)
```
 

### スポーンロジック 

ノートは、拍位置が判定ラインより前の可視ウィンドウに入ったときにスポーンします。システムは以下を使用してスポーンが必要かどうかを計算します：

```
visualBeat > scrollHelper.ApplyScroll(notePosition) - GameParam.VisibleBeat
```

またはCMod（定速モード）の場合：

```
musicTime > bpmHelper.BeatToTime(notePosition) - GameParam.VisibleTime
```

密度の高いパターンに対応するため、フレームあたり最大`CREATABLE_NOTES_PER_FRAME`（32）個のノートをスポーンできます。



---

### 位置更新 

各フレーム、`NoteController.UpdatePosition()`はZ位置を計算します：

```
posZ = (justTime - musicTime) * TIME_DISTANCE * speed * speedRatio - (visualOffset + OFFSET_Z)
```

拍ベースモードの場合：

```
posZ = (beatPosition - currentBeat) * BEAT_DISTANCE * normalizedSpeed * hiSpeed * speedRatio - offset
```

ノートはまた、「落下するカード」の視覚効果を作成するためにZ位置に基づいて回転します。



---

### 判定 

タッチが発生すると、`MusicGame.JudgeTap()`はアクティブノートを検索して、次の範囲内の候補を見つけます：

* 水平距離: `abs(note.PosX - touch.PosX) < judgeDistance`
* 時間ウィンドウ: `abs(note.justTime - touch.touchTime) < judgeManager.HitTime`

時間的に最も近いノートが選択され、評価のために`JudgeManager`に渡されます。

---

## ロングノートメカニクス 

ロングノートは通常のノートとは異なるライフサイクルを使用します：

### LongController構造 

各`LongController`は以下を管理します：

* `LongInfo`: セグメントデータ（拍位置、レーン、ノートインデックス）
* プロシージャルメッシュ: セグメントウェイポイントから生成
* タッチID: どの指がロングをホールドしているか
* ホールド状態: 現在ホールド中かどうか
* ステンシルマスク: ホールド中のロング下の視覚フィードバック用



---

### ロング判定フロー 

```mermaid
flowchart TD

START["タッチフェーズ == Hold?"]
CHECK_RANGE["beat in [InputStartBeat, EndBeat]?"]
SKIP["このロングをスキップ"]

HAS_TOUCH["longController.TouchId == -1?"]
CHECK_DIST["distance < judgeDistance?"]
ASSIGN["OnJudgeStartHold()<br/>TouchIdを割当<br/>ステンシルマスクを有効化"]

MATCH_ID["TouchIdが一致?"]
UPDATE["SetPosition()<br/>ホールド位置を更新"]

RELEASE["タッチフェーズ == Up?"]
HANDLE_RELEASE["HandleNormalLongRelease()<br/> or <br/>HandleFuzzyLongRelease()"]
RELEASE_SECTION["セクションインデックスを決定"]
REMOVE["メッシュセグメントを削除<br/>ミスノートを判定<br/>TouchIdをリセット"]

START -->|Yes| CHECK_RANGE
CHECK_RANGE -->|No| SKIP
CHECK_RANGE -->|Yes| HAS_TOUCH

HAS_TOUCH -->|Yes| CHECK_DIST
CHECK_DIST -->|Yes| ASSIGN
CHECK_DIST -->|No| SKIP

HAS_TOUCH -->|No| MATCH_ID
ASSIGN --> MATCH_ID

MATCH_ID -->|Yes| UPDATE
MATCH_ID -->|No| SKIP

UPDATE --> RELEASE
RELEASE -->|Yes| HANDLE_RELEASE
RELEASE -->|No| UPDATE

HANDLE_RELEASE --> RELEASE_SECTION
RELEASE_SECTION --> REMOVE
```


### ロングリリース動作 

**通常ロング（青）:**

* 途中のセクションでリリースすると次の中継ノートがミス判定される
* 後続のラインセグメントとノートも削除される
* 早くリリースすると複数のミスが発生

**ファジーロング（オレンジ）:**

* 途中のセクションでリリースするとそのセグメントのラインのみが削除される
* 中継ノートは表示されたまま
* 次のセグメントで再びロングをつかむことが可能



---

## データフローパターン 

### イベント駆動判定パイプライン 

システムはC#イベントを使用して判定とその効果を分離します：

| イベントソース | イベント名 | サブスクライバー | 目的 |
| --- | --- | --- | --- |
| `JudgeManager` | `OnJudge` | `LifeManager`, `ComboManager` | スコアリング前の即座の効果 |
| `JudgeManager` | `OnAfterJudge` | `ScoreManager`, `ComboManager` | ライフチェック後のスコア計算 |
| `MusicGame` | `OnMissedNote` | `JudgeManager`, `LifeManager`, `ComboManager` | 未判定で期限切れのノートを処理 |
| `MusicManager` | `OnFinishMusic` | `MusicGameSceneController` | リザルトシーン遷移をトリガー |
| `LifeManager` | `OnDead` | `MusicGameSceneController` | ゲームオーバーを処理 |



---

### タイミング精度戦略 

システムは全体を通して倍精度タイムスタンプを維持します：

1. **マスタークロック**: `MusicManager.GetMusicTime()`は`AudioSource.timeSamples`から`double`を返す
2. **拍変換**: `BpmHelper`はすべての計算に`double`を使用
3. **ノートジャストタイム**: `NoteController.JustTime`に`double`として保存
4. **入力タイムスタンプ**: `TouchData.TouchTime`は`double`

これにより、タイミングチェーン全体でサブミリ秒の精度が保証されます。リズムゲームでは1ms = ~60Hzのフレーム時間であるため、これは重要です。



 

---

### フレームレート独立性 

ノートはフレームデルタではなく時間デルタに基づいて移動します：

```
double diff = isCMod ? (justTime - musicTime) : (beatPosition - beat);float posZ = diff * distance * speed * speedRatio - offset;
```

この計算は30fps、60fps、120fpsで同一の結果を生成します。

**カウンターベース同期**: 180フレームごとに、システムは`AudioSource.timeSamples`から`musicTime`を再同期し、累積された`Time.deltaTime`からのドリフトを防ぎます。

---

## パフォーマンス最適化 

### オブジェクトプーリング 

頻繁に割り当てられるすべてのゲームプレイオブジェクトは`UnityEngine.Pool.ObjectPool<T>`を使用します：

| プール | サイズ | リサイクル頻度 |
| --- | --- | --- |
| `NoteObjectPool` | 32 | ノート判定/期限切れごと |
| `LongObjectPool` | 32 | ロング完了ごと |
| `BeatBarObjectPool` | 100 | 拍線期限切れごと |
| `JudgeEffectPool` | 32 | 判定エフェクト完了ごと |

プールは`InitAsync()`中に事前にウォームアップされ、実行時の割り当てを回避します。

---

### GC回避テクニック 

**メッシュ頂点のArrayPool**: `LongController`は頂点バッファに`ArrayPool<Vector3>.Shared`を使用し、フレーム間で配列を再利用します。

**フォーマットのためのZString**: `Cysharp.Text.ZString`はヒープ割り当てなしでフォーマット済み文字列を生成します。

**Spanベースのパース**: `SequenceReader`はノート文字のパースに`Span<char>`とstackallocを使用します。

**キャッシュされたコレクション**: `_sortedKeyList`、`_nearTimeNoteList`は再作成ではなく各フレームで事前割り当てとクリアされます。


### バッチ処理制限 

フレームスパイクを防ぐため、システムはフレームごとの作業を制限します：

```
const int CREATABLE_NOTES_PER_FRAME = 32;
const int CREATABLE_BARS_PER_FRAME = 16;
```

密度の高いパターンは、一度にすべてではなく複数のフレームにわたってノートをスポーンします。


## 初期化シーケンス 

```mermaid
sequenceDiagram
  participant p1 as MusicGameSceneController
  participant p2 as MusicGame
  participant p3 as SequenceReader
  participant p4 as オブジェクトプール
  participant p5 as ヘルパー (BPM/Scroll)
  participant p6 as マネージャー (Judge/Life/Score)

  p1->>p1: Start()
  p1->>p1: InitAsync()
  p1->>p6: Init() (同期)
  note over p6: JudgeManager LifeManager ScoreManager ComboManager
  p1->>p2: InitAsync(songInfo | input | judgeManager)
  p2->>p3: Read(songInfo | difficulty)
  p3-->>p2: Sequence
  p2->>p2: ミラーモードならSwapMirrorLane()
  p2->>p4: Init()
  note over p4: NoteObjectPool LongObjectPool BeatBarObjectPool JudgeEffectPool
  p2->>p5: Init(songInfo)
  note over p5: BpmHelper ScrollHelper SpeedStretchRatio BgChangeHelper
  p2->>p2: CalculateStartBeatBar()
  p2->>p2: CalculateLastNoteTime()
  p2->>p2: SetRelayLongStartIndex()
  p2-->>p1: (初期化完了)
  p1->>p1: Play(speed | startTime)
  p1->>p1: PlayAsync()
  note over p1: オーディオ読込 音楽開始 Update()ループ有効化
```

---

## 設定とカスタマイズ 

### GameParamシングルトン 

実行時のゲームプレイパラメータは`GameParam.Instance`に保存されます：

| プロパティ | 型 | 目的 |
| --- | --- | --- |
| `NoteSpeed` | `float` | 現在のハイスピード倍率 |
| `VisibleBeat` | `float` | レンダリングする先の拍数 |
| `VisibleTime` | `double` | CModの時間ウィンドウ |
| `OffsetZ` | `float` | ノートのグローバルZオフセット |
| `NotesScrollCurve` | `FastCurve` | スクロールタイプの減速カーブ |

 

---

### GameManagerオプション 

`GameManager.Instance`からの永続化された設定：

**NotesOption:**

* `HiSpeed`: ベースノート速度倍率（1.0-20.0）
* `Size`: ノート幅スケール（0.5-1.5）
* `JudgeAreaType`: スクリーン空間またはワールド空間のヒット検出

**DisplayOption:**

* `BeatBar`: 拍線の表示/非表示
* `NotesEffectType`: 判定エフェクトの強度
* `VisualOffset`: 手動位置調整（ms）

**JudgeTimeOption:**

* `JudgeDistance`: 水平ヒットウィンドウ幅
* `MusicRate`: 再生速度（0.5-2.0）
* `Mirror`: レーン順序を反転

---

## 統合ポイント 

### Luaスクリプトフック 

`MusicGame`はカスタムLuaスクリプト用のイベントを公開します：

```
public event Action<int, int, int, int, bool> OnHitNoteLua = null;
public event Action<int, int, int> OnMissedNoteLua = null;
public event Action<NoteController> OnSpawnNoteLua = null;
public event Action<LongController> OnSpawnLongLua = null;
```

これらにより、譜面固有の視覚効果やゲームプレイ修飾子が可能になります。詳細は[Luaスクリプトシステム](#7)を参照してください。



 

---

### リザルトデータ出力 

ゲームプレイ終了時、`MusicGameSceneController.CreateResultData()`は以下を集約します：

* `TimingHistory`: すべての入力と判定のフレームごと
* `LifeHistory`: 1秒あたりのヘルス値
* `JudgeManager`: 各判定タイプのカウント
* `ScoreManager`: 最終スコアとランク
* `ComboManager`: 達成した最大コンボ
* `MusicGame`: 総ノート数、ランキング無効フラグ

この`ResultData`オブジェクトは、視覚化のためにリザルトシーンに渡されます。


### On this page

* [コアゲームプレイシステム](#3-)
* [目的と範囲](#3--1)
* [システム概要](#3--2)
* [コアアーキテクチャ図](#3--3)
* [コンポーネントの責務](#3--4)
* [MusicGameSceneController](#3-musicgamescenecontroller)
* [MusicGame](#3-musicgame)
* [Sequence](#3-sequence)
* [BpmHelper](#3-bpmhelper)
* [ScrollHelper](#3-scrollhelper)
* [NoteObjectPool](#3-noteobjectpool)
* [LongObjectPool](#3-longobjectpool)
* [JudgeManager](#3-judgemanager)
* [InputBase (抽象)](#3-inputbase-)
* [フレーム更新フロー図](#3--5)
* [ノートのライフサイクル](#3--6)
* [ライフサイクル状態マシン](#3--7)
* [スポーンロジック](#3--8)
* [位置更新](#3--9)
* [判定](#3--10)
* [ロングノートメカニクス](#3--11)
* [LongController構造](#3-longcontroller)
* [ロング判定フロー](#3--12)
* [ロングリリース動作](#3--13)
* [データフローパターン](#3--14)
* [イベント駆動判定パイプライン](#3--15)
* [タイミング精度戦略](#3--16)
* [フレームレート独立性](#3--17)
* [パフォーマンス最適化](#3--18)
* [オブジェクトプーリング](#3--19)
* [GC回避テクニック](#3-gc)
* [バッチ処理制限](#3--20)
* [初期化シーケンス](#3--21)
* [設定とカスタマイズ](#3--22)
* [GameParamシングルトン](#3-gameparam)
* [GameManagerオプション](#3-gamemanager)
* [統合ポイント](#3--23)
* [Luaスクリプトフック](#3-lua)
* [リザルトデータ出力](#3--24)

