

# サードパーティ統合 

このドキュメントでは、DKLIKEリズムゲームプロジェクトに統合されたサードパーティミドルウェア、ライブラリ、Unityパッケージについて説明します。パッケージ管理、初期化手順、設定パラメータ、およびコードベース全体での外部依存関係の利用方法を取り扱います。

特定の統合に関する詳細情報については、以下を参照してください：

* CRIミドルウェアの使用方法と設定：[CRIミドルウェア](#10.1)
* Unity Package Managerのセットアップと依存関係：[パッケージ依存関係](#10.2)
* XLuaスクリプトシステムのアーキテクチャ：[Luaスクリプトシステム](#7)
* Addressablesによるアセット読込：[アセット管理](#9)

## 概要 

プロジェクトは7つの主要なサードパーティシステムカテゴリを統合しています：

| カテゴリ | ライブラリ | 目的 |
| --- | --- | --- |
| **オーディオ/ビデオ** | CRI Atom、CRI Mana、CRI Fs | サンプル精度のオーディオ再生、ピッチシフト、ビデオ背景レンダリング |
| **UIフレームワーク** | TextMeshPro、FancyScrollView、UI Particle、Unity WebView | テキストレンダリング、最適化されたスクロール、ビジュアルエフェクト、ブラウザ統合 |
| **アセット管理** | Addressables | グループベースのアセットライフサイクル管理 |
| **ローカライゼーション** | Unity Localization | 多言語文字列テーブル |
| **入力** | Unity Input System | EnhancedTouch APIによる拡張タッチ処理 |
| **アニメーション** | DOTween | UIとゲームプレイのためのトゥイーンベースアニメーション |
| **スクリプティング** | XLua | カスタム譜面動作のためのランタイムLuaスクリプト |

---

## 依存関係アーキテクチャ 

### 図：サードパーティ依存関係グラフ 

```mermaid
flowchart TD

ASSETHUNTER["com.heurekagames.assethunterpro"]
UTILS["com.heurekagames.utils"]
TMP["com.unity.textmeshpro v3.0.9"]
ADDR["com.unity.addressables v1.21.20"]
LOC["com.unity.localization v1.3.2"]
INPUT["com.unity.inputsystem v1.7.0"]
BURST["com.unity.burst v1.8.18"]
TIMELINE["com.unity.timeline v1.6.5"]
UIPART["com.coffee.ui-particle v3.3.9"]
FANCY["jp.setchi.fancyscrollview v1.9.0"]
WEBVIEW["net.gree.unity-webview github.com/gree/unity-webview"]
HEAP["com.oddworm.heapexplorer github.com/pschraut/UnityHeapExplorer"]
CRI["CRIミドルウェア CriFs, CriAtom, CriMana"]
XLUA["XLua Lua 5.3 相互運用"]
DOTWEEN["DOTween トゥイーンエンジン"]
GAME["DKLIKEアプリケーション"]

TMP -.-> GAME
ADDR -.-> GAME
LOC -.-> GAME
INPUT -.-> GAME
BURST -.-> GAME
TIMELINE -.-> GAME
UIPART -.-> GAME
FANCY -.-> GAME
WEBVIEW -.-> GAME
CRI -.-> GAME
XLUA -.-> GAME
DOTWEEN -.-> GAME

subgraph アプリケーション層 ["アプリケーション層"]
    GAME
end

subgraph ネイティブプラグイン ["ネイティブプラグイン"]
    CRI
    XLUA
    DOTWEEN
end

subgraph Gitベースパッケージ ["Gitベースパッケージ"]
    WEBVIEW
    HEAP
end

subgraph OpenUPMレジストリ ["OpenUPMレジストリ"]
    UIPART
    FANCY
end

subgraph 公式Unityレジストリ ["公式Unityレジストリ"]
    TMP
    ADDR
    LOC
    INPUT
    BURST
    TIMELINE
    LOC -.-> ADDR
end

subgraph 埋め込みパッケージ ["埋め込みパッケージ"]
    ASSETHUNTER
    UTILS
end
```


## Unity Package Manager設定 

### パッケージソース 

プロジェクトは`manifest.json`で設定された3つのパッケージソースを使用します：

1. **公式Unityレジストリ** (`https://packages.unity.com`)：コアUnityパッケージ
2. **OpenUPMレジストリ** (`https://package.openupm.com`)：スコープ付きアクセスのコミュニティパッケージ
3. **Gitリポジトリ**：特定のライブラリのための直接GitHub統合

### 図：パッケージレジストリ設定 

```mermaid
flowchart TD

DEPS["dependencies"]
SCOPED["scopedRegistries"]
SCOPE_DEF["name: package.openupm.com url: https://package.openupm.com"]
SCOPES["scopes: - com.coffee.ui-particle - jp.setchi.fancyscrollview"]
UI_PART["UI Particle com.coffee.ui-particle@3.3.9"]
FANCY_SV["FancyScrollView jp.setchi.fancyscrollview@1.9.0"]
WEBVIEW_PKG["Unity WebView net.gree.unity-webview Git Hash: c01a265"]

DEPS -.-> SCOPE_DEF
SCOPED -.-> SCOPE_DEF
SCOPES -.-> UI_PART
SCOPES -.-> FANCY_SV
DEPS -.-> WEBVIEW_PKG

subgraph パッケージ解決 ["パッケージ解決"]
    UI_PART
    FANCY_SV
    WEBVIEW_PKG
end

subgraph OpenUPMスコープ ["OpenUPMスコープ"]
    SCOPE_DEF
    SCOPES
end

subgraph manifest.json ["manifest.json"]
    DEPS
    SCOPED
end
```

### 重要な依存関係 

| パッケージ | バージョン | 目的 | レジストリ |
| --- | --- | --- | --- |
| `com.unity.textmeshpro` | 3.0.9 | すべてのUIテキストレンダリング | Unity |
| `com.unity.addressables` | 1.21.20 | アセット管理と読込 | Unity |
| `com.unity.localization` | 1.3.2 | 文字列テーブルと多言語サポート | Unity |
| `com.unity.inputsystem` | 1.7.0 | EnhancedTouch APIによるタッチ入力 | Unity |
| `jp.setchi.fancyscrollview` | 1.9.0 | 最適化されたスクロール可能リスト | OpenUPM |
| `com.coffee.ui-particle` | 3.3.9 | UIパーティクルエフェクト | OpenUPM |
| `net.gree.unity-webview` | Git | オンライン機能用の埋め込みブラウザ | Git |


### Gitベースパッケージ統合 

2つのパッケージはGitHubリポジトリから直接読み込まれます：

**Unity WebView**

* リポジトリ：`https://github.com/gree/unity-webview.git`
* パス：`/dist/package`
* コミットハッシュ：`c01a265480314a23cd0eb1362eeb5089209bee3e`
* 用途：オンラインリザルト送信とFAQ表示のための埋め込みブラウザ

**Heap Explorer**

* リポジトリ：`https://github.com/pschraut/UnityHeapExplorer.git`
* バージョン：`4.1.1`（タグ）
* コミットハッシュ：`ed5f4c7e25d796915853fd70ef682c1e2a34a878`
* 用途：メモリプロファイリングと解析（開発用のみ）


## CRIミドルウェア統合 

CRIミドルウェアはリズムゲームのためのオーディオとビデオエンジンを提供します。統合は3つの主要モジュールで構成されています：**CriFs**（ファイルシステム）、**CriAtom**（オーディオエンジン）、**CriMana**（ビデオ再生）。

### 図：CRIミドルウェアアーキテクチャ 

```mermaid
flowchart TD

INIT["CriWareInitializer MonoBehaviour"]
FS_CFG["CriFsConfig"]
ATOM_CFG["CriAtomConfig"]
MANA_CFG["CriManaConfig"]
FS_PLUGIN["CriFsPlugin"]
FS_UTIL["CriFsUtility"]
LOADERS["ローダー: 16"]
BINDERS["バインダー: 8"]
INSTALLERS["インストーラー: 2"]
ATOM_PLUGIN["CriAtomPlugin"]
ATOM_EX["CriAtomEx"]
ATOM_SERVER["CriAtomServer"]
ACF["ACFファイル オーディオ設定"]
VOICE_POOLS["ボイスプール メモリ: 16 ストリーミング: 8"]
MANA_PLUGIN["CriManaPlugin"]
DECODERS["デコーダー: 8"]
ENTRIES["最大エントリー: 4"]
ANDROID_CFG["Android設定 AAudioサポート Fast Mixer"]
IOS_CFG["iOS設定 バッファリング時間 iPod上書き"]
PC_CFG["PC設定 空間サウンド バッファリング"]
MUSIC_MGR["MusicManager"]
VIDEO_MGR["ビデオ背景"]
SOUND_MGR["サウンドエフェクト"]

subgraph ゲームシステム ["ゲームシステム"]
    MUSIC_MGR
    VIDEO_MGR
    SOUND_MGR
end

subgraph プラットフォーム固有 ["プラットフォーム固有"]
    ANDROID_CFG
    IOS_CFG
    PC_CFG
end

subgraph subGraph3 ["CRI Manaビデオ"]
    MANA_PLUGIN
    DECODERS
    ENTRIES
end

subgraph subGraph2 ["CRI Atomオーディオ"]
    ATOM_PLUGIN
    ATOM_EX
    ATOM_SERVER
    ACF
    VOICE_POOLS
end

subgraph CRIファイルシステム ["CRIファイルシステム"]
    FS_PLUGIN
    FS_UTIL
    LOADERS
    BINDERS
    INSTALLERS
end

subgraph 初期化層 ["初期化層"]
    INIT
    FS_CFG
    ATOM_CFG
    MANA_CFG
    INIT -.-> FS_CFG
    INIT -.-> ATOM_CFG
    INIT -.-> MANA_CFG
end
```

出典：

### CriWareInitializerコンポーネント 

`CriWareInitializer`クラスは、すべてのCRIミドルウェア初期化を統制するシングルトンMonoBehaviourです。通常、最初のシーンのGameObjectにアタッチされ、`DontDestroyOnLoad`でマークされます。

**主要な初期化フラグ：**

| フラグ | 型 | 目的 |
| --- | --- | --- |
| `initializesFileSystem` | `bool` | CRIファイルシステム初期化を有効化 |
| `initializesAtom` | `bool` | CRI Atomオーディオ初期化を有効化 |
| `initializesMana` | `bool` | CRI Manaビデオ初期化を有効化 |
| `dontInitializeOnAwake` | `bool` | 手動制御のための初期化を延期 |
| `dontDestroyOnLoad` | `bool` | シーン遷移をまたいで持続 |

出典：

### CRIファイルシステム設定 

`CriFsConfig`はファイルシステム層のパラメータを定義します：

```
public class CriFsConfig {    public int numberOfLoaders = 16;    public int numberOfBinders = 8;    public int numberOfInstallers = 2;    public int installBufferSize = CriFsPlugin.defaultInstallBufferSize / 1024;    public int maxPath = 256;    public string userAgentString = "";    public bool minimizeFileDescriptorUsage = false;    public bool enableCrcCheck = false;    public int androidDeviceReadBitrate = defaultAndroidDeviceReadBitrate;}
```

**パラメータ詳細：**

* **numberOfLoaders**：同時ファイル読込操作数（デフォルト：16）
* **numberOfBinders**：ファイルアクセス用のCPKアーカイブバインダー（デフォルト：8）
* **numberOfInstallers**：同時インストール操作数（デフォルト：2）
* **installBufferSize**：インストール用バッファサイズ（KB単位）（デフォルト：プラットフォーム固有）
* **maxPath**：最大ファイルパス長（デフォルト：256）
* **minimizeFileDescriptorUsage**：厳格な制限のあるプラットフォームでファイルディスクリプタ数を削減
* **enableCrcCheck**：CRCチェックでCPKファイルの整合性を検証
* **androidDeviceReadBitrate**：Androidデバイス読込速度（bps単位）（デフォルト：50 Mbps）

出典：

### CRI Atomオーディオ設定 

`CriAtomConfig`は広範なオーディオエンジン設定を提供します：

**ボイスプール設定：**

| プールタイプ | メモリボイス | ストリーミングボイス | 目的 |
| --- | --- | --- | --- |
| 標準 | 16 | 8 | 一般的なオーディオ再生 |
| HCA-MX | 0 | 0 | 高圧縮オーディオ（オプション） |
| Android低遅延 | 0 | 0 | 最小遅延のタッチサウンドエフェクト |

**コアオーディオパラメータ：**

```
public int maxVirtualVoices = 32;public int maxVoiceLimitGroups = 32;public int maxCategories = 32;public int maxAisacs = 8;public float serverFrequency = 60.0f;public int outputSamplingRate = 0;  // 0 = プラットフォームデフォルト
```

出典：

### プラットフォーム固有のオーディオ設定 

**iOS設定：**

| パラメータ | デフォルト | 説明 |
| --- | --- | --- |
| `iosEnableSonicSync` | `true` | SonicSYNC遅延削減を有効化 |
| `iosBufferingTime` | `50` ms | オーディオ出力バッファサイズ |
| `iosOverrideIPodMusic` | `false` | バックグラウンド音楽アプリから制御を奪う |
| `iosEnableOSNotificationHandling` | `true` | システムオーディオ中断に応答 |

**Android設定：**

| パラメータ | デフォルト | 説明 |
| --- | --- | --- |
| `androidEnableSonicSync` | `true` | SonicSYNC遅延削減を有効化 |
| `androidBufferingTime` | `133` ms | ASR（通常）バッファリング時間 |
| `androidStartBufferingTime` | `100` ms | NSR（低遅延）開始バッファ |
| `androidUsesAndroidFastMixer` | `true` | 低遅延のためAndroid Fast Mixerを使用 |
| `androidForceToUseAsrForDefaultPlayback` | `true` | 非低遅延サウンドにASRを強制 |
| `androidUsesAAudio` | `false` | ベータ：OpenSL ESの代わりにAAudio APIを使用 |

**PC設定：**

| パラメータ | デフォルト | 説明 |
| --- | --- | --- |
| `pcBufferingTime` | `0` ms | 出力バッファリング（0 = 自動） |
| `useMicrosoftSpatialSound` | `true` | Windows Spatial Sound APIを有効化 |

出典：

### ACFファイル読込 

**Atom Craft Format (ACF)** ファイルには、CRI Atom Craftで作成されたグローバルオーディオ設定が含まれています：

```
public string acfFileName = "";
```

`acfFileName`が設定されている場合、初期化プロセスは`StreamingAssets`からACFファイルを読み込みます：

```
if (config.acfFileName.Length != 0) {    string acfPath = config.acfFileName;    if (CriWare.Common.IsStreamingAssetsPath(acfPath)) {        acfPath = Path.Combine(CriWare.Common.streamingAssetsPath, acfPath);    }    CriAtomEx.RegisterAcf(null, acfPath);}
```

### CRI Manaビデオ設定 

`CriManaConfig`はビデオデコードを制御します：

```
public class CriManaConfig {    public int numberOfDecoders = 8;    public int numberOfMaxEntries = 4;    public readonly bool graphicsMultiThreaded = true;    public bool useStreamerManager = false;}
```

**パラメータ詳細：**

* **numberOfDecoders**：最大同時ビデオデコーダー数（デフォルト：8）
* **numberOfMaxEntries**：連結再生のための最大プレイリストエントリー数（デフォルト：4）
* **graphicsMultiThreaded**：常に`true` - マルチスレッドテクスチャ更新を使用
* **useStreamerManager**：ストリーミングマネージャーモジュールを有効化（デフォルト：`false`）

### カスタムオーディオエフェクト 

システムはプラグインSDKを介してカスタムASRバスエフェクトをサポートします：

カスタムエフェクトは`Initialize()`を呼び出す**前に**登録する必要があります。シャットダウン時に自動的に登録解除されます。

出典：

---

## XLua統合 

XLuaはカスタム譜面動作のためのLua 5.3スクリプト機能を提供します。統合は[Luaスクリプトシステム](#7)セクションで詳細に文書化されています。主要な統合ポイント：

* **LuaManager**：`LuaEnv`ライフサイクルとスクリプト実行を管理
* **アクターシステム**：Luaからの動的GameObjectの作成（オーディオ、ビデオ、スプライト、テキスト）
* **GameState API**：ゲームプレイ状態へのLuaアクセス（速度、距離、ノートイベント）
* **SongMan API**：楽曲メタデータとタイミングへのLuaアクセス

XLuaライブラリはUnity Package Managerで管理されていませんが、プロジェクトにネイティブプラグインとして含まれています。

のスクリプト定義シンボルで参照

---

## DOTween統合 

DOTweenはすべてのトゥイーン操作の主要なアニメーションライブラリです。統合はスクリプト定義シンボルで設定されています。

**スクリプト定義シンボル：**

* シンボル：`DOTWEEN`
* プラットフォーム：すべて（Android、iOS、Standaloneなど）

**コードベースでの使用例：**

* UI要素のフェードイン/アウトアニメーション
* パネルスライド遷移
* スムーズな値の補間（スコア、コンボカウンター）
* リザルトシーンアニメーションシーケンス

ライブラリはUPMで管理されておらず、アセットパッケージとして含まれています。


## FancyScrollView統合 

FancyScrollViewは、ビューポートカリングとオブジェクトプーリングを備えた最適化されたスクロール可能リストを提供します。

**パッケージ詳細：**

* パッケージID：`jp.setchi.fancyscrollview`
* バージョン：`1.9.0`
* レジストリ：OpenUPM（`https://package.openupm.com`）

**統合ポイント：**

1. **楽曲選択シーン**：メイン楽曲リストスクロール

* 基底クラス：`FancyScrollView<SongInfo, ScrollContext>`
* セルプレハブのインスタンス化と再利用
* `SingleTouchScroller`によるスムーズスクロール
2. **フォルダ選択パネル**：フォルダリストナビゲーション

* 楽曲選択シーン内のネストされたスクロールビュー
3. **カスタムスクローラー**：`SingleTouchScroller`が基底スクローラーを拡張

* モバイルデバイス向けの拡張タッチ処理
* 慣性とスナップ位置動作


## Unity WebView統合 

Unity WebViewはオンライン機能のためにゲーム内にネイティブブラウザを埋め込みます。

**パッケージ詳細：**

* パッケージID：`net.gree.unity-webview`
* ソース：Git（`https://github.com/gree/unity-webview.git`）
* パス：`/dist/package`
* コミット：`c01a265480314a23cd0eb1362eeb5089209bee3e`

**Android設定：**

プロジェクトは開発ビルド用にクリアテキストHTTPトラフィックを有効化します：

```
UNITYWEBVIEW_ANDROID_USES_CLEARTEXT_TRAFFIC
```

このスクリプト定義シンボルはAndroidビルドのみに設定され、ローカルテスト用のHTTP接続を許可します。

**使用シナリオ：**

* FAQページ表示（埋め込みヘルプドキュメント）
* オンラインスコア送信確認
* ゲームを離れずに外部リンクナビゲーション

---

## UI Particle統合 

UI ParticleはUnity UI Canvas要素内でパーティクルエフェクトをレンダリングします。

**パッケージ詳細：**

* パッケージID：`com.coffee.ui-particle`
* バージョン：`3.3.9`
* レジストリ：OpenUPM

**用途：**

* UI要素にオーバーレイされた視覚効果
* ボタン押下フィードバックエフェクト
* メニュー内の装飾的パーティクルアニメーション

パッケージはUnityのUIシステムを拡張して、パーティクルシステムがCanvasのソートとマスキングを尊重できるようにします。

## Unity Localization統合 

UnityのLocalizationパッケージは文字列テーブルを介した多言語サポートを提供します。

**パッケージ詳細：**

* パッケージID：`com.unity.localization`
* バージョン：`1.3.2`
* 依存関係：Addressables（1.19.19）、Newtonsoft.Json（2.0.2）

### 図：ローカライゼーションシステムアーキテクチャ 

```mermaid
flowchart TD

CREATOR["LocalizationConstantCreator エディタースクリプト"]
CMD["メニュー項目: Tools/Create Constant/Localize Key"]
TABLE["DKLIKEStringTable StringTableアセット"]
ENTRIES["文字列テーブルエントリー キー-値ペア"]
CONST_CLASS["LocalizationConstant.cs public static class"]
CONST_FIELDS["public const long KEY_NAME = ID"]
LOC_MGR["LocalizeManager シングルトン"]
LOC_SETTINGS["LocalizationSettings.StringDatabase"]
UI_TEXT["TMP_Textコンポーネント"]
LOCALIZE["Localize String Event"]

CREATOR -.-> TABLE
ENTRIES -.-> CONST_CLASS

subgraph UIコンポーネント ["UIコンポーネント"]
    UI_TEXT
    LOCALIZE
    LOCALIZE -.-> UI_TEXT
end

subgraph ランタイムアクセス ["ランタイムアクセス"]
    LOC_MGR
    LOC_SETTINGS
end

subgraph 生成された定数 ["生成された定数"]
    CONST_CLASS
    CONST_FIELDS
end

subgraph ローカライゼーションアセット ["ローカライゼーションアセット"]
    TABLE
    ENTRIES
    TABLE -.-> ENTRIES
end

subgraph エディターツール ["エディターツール"]
    CREATOR
    CMD
    CMD -.-> CREATOR
end
```

出典：

### 定数生成ワークフロー 

プロジェクトは型安全な文字列キー定数を生成するためにカスタムエディタースクリプトを使用します：

**プロセス：**

1. エディターメニューコマンド：`Tools/Create Constant/Localize Key`
2. `LocalizationSettings.AssetDatabase`を介して`DKLIKEStringTable`アセットを読込
3. すべての文字列テーブルエントリーを反復
4. `public const long`フィールドで`LocalizationConstant.cs`を生成
5. 各定数は文字列キーにちなんで命名され、ID値を持つ

**生成されたコード構造：**

```c#
public static class LocalizationConstant
{
    public const long MENU_TITLE_SETTINGS = 987654321;  
    public const long MENU_TITLE_START = 123456789;
    // ... など
}
```

このアプローチが提供するもの：

* コンパイル時のキー検証（タイプミスなし）
* 利用可能なローカライゼーションキーのIntelliSenseサポート
* 文字列テーブル変更時の自動更新

出典：

---

## Unity Input System統合 

プロジェクトは拡張タッチ処理のためにUnityの新しいInput System（バージョン1.7.0）を使用します。

**設定：**

* パッケージ：`com.unity.inputsystem` v1.7.0
* アクティブ入力ハンドラー：`2`（旧システムと新システムの両方）
* 主要API：`EnhancedTouch`

**プロジェクト設定：**

```yaml
activeInputHandler: 2  # 両方（段階的な移行を可能にする）
```

**使用パターン：**

* タッチ入力処理のための`EnhancedTouch.Touch` API
* `InputBase`抽象化を介してゲームプレイ入力に変換されたタッチデータ
* 同時ノート押下のためのマルチタッチサポート


## プラットフォーム固有の設定 

### Android設定 

**ビルド設定：**

* 最小SDKバージョン：26（Android 8.0）
* ターゲットSDKバージョン：0（自動）
* スクリプティングバックエンド：IL2CPP
* ターゲットアーキテクチャ：ARM64のみ
* バンドルバージョンコード：71

**スクリプト定義シンボル：**

```
TMPro;DOTWEEN;UNITYWEBVIEW_ANDROID_USES_CLEARTEXT_TRAFFIC;ELEBEAT_PRODUCT
```

**グラフィックスAPI：**

* 強制API：OpenGL ES 3.0
* 自動グラフィックスAPI：無効


### iOS設定 

**ビルド設定：**

* iOS SDKバージョン：988（最新）
* ターゲットiOSバージョン：13.0
* スクリプティングバックエンド：IL2CPP（iOSのデフォルト）

**スクリプト定義シンボル：**

```
ELEBEAT_PRODUCT;TMPro;DOTWEEN
```

**グラフィックスAPI：**

* Metal（自動）


### Standalone（Windows/Mac/Linux） 

**スクリプト定義シンボル（Windows/Mac）：**

```
ELEBEAT_STAGING;DOTWEEN
```

**ビルド設定：**

* グラフィックスジョブ：無効（すべてのスタンドアロンプラットフォーム）
* バックグラウンドで実行：`false`
* ネイティブ解像度がデフォルト：`true`


## シェーダーバリアントプリロード 

プロジェクトは`ShaderVariantCollection`を使用して一般的に使用されるシェーダーバリアントをプリロードし、ランタイムコンパイルのスタッターを削減します。

**シェーダーバリアントファイル：**

* パス：`Assets/MyProject/Shader/GameShaderVariants.shadervariants`
* 含まれるシェーダー：インスタンシングバリアントを持つ5つのカスタムシェーダー
* アプリケーション起動時にプリロード

**プリロードアセット設定：**

```
preloadedAssets:  - {fileID: 11400000, guid: eead5772186b249bf81fcd547cf1bfe7, type: 2}  - {fileID: 11400000, guid: 7561201d366dfe5429487603f3b96523, type: 2}
```


## 依存関係バージョンロック 

`packages-lock.json`ファイルは、正確なパッケージバージョンとコミットハッシュをロックして、再現可能なビルドを保証します。

**ロックされたバージョンの例：**

| パッケージ | バージョン/ハッシュ | ソース |
| --- | --- | --- |
| Addressables | 1.21.20 | Unityレジストリ |
| Unity WebView | c01a265480314... | Git |
| FancyScrollView | 1.9.0 | OpenUPM |
| Heap Explorer | ed5f4c7e25d79... | Git（タグ4.1.1） |

ロックファイルは、Unity Package Manager UIを介して、または依存関係を解決する際に、パッケージが追加、削除、またはアップグレードされると自動的に更新されます。

## 統合ポイントの概要 

### 図：サードパーティシステム使用マップ 

```mermaid
flowchart TD

GRAPH["パフォーマンスグラフ"]
TMP3["TextMeshPro リザルト"]
TIMING["タイミング表示"]
ONLINE["オンライン送信"]
WEBVIEW["Unity WebView ブラウザ"]
DOTWEEN3["DOTween アニメーション"]
NOTES["ノート表示"]
DOTWEEN2["DOTween ノートアニメーション"]
MUSIC["音楽再生"]
CRI_ATOM["CriAtom オーディオエンジン"]
VIDEO["背景ビデオ"]
CRI_MANA["CriMana ビデオデコーダー"]
TOUCH["タッチ入力"]
INPUT_SYS["Input System EnhancedTouch"]
LUA["Luaスクリプト"]
XLUA_E["XLua スクリプト実行"]
SCROLL["楽曲リストスクロール"]
FANCY_S["FancyScrollView 最適化されたスクロール"]
FOLDER["フォルダナビゲーション"]
JACKET["ジャケット画像"]
ADDR_S["Addressables ジャケット読込"]
TMP2["TextMeshPro 楽曲情報"]
LOC_S["Localization UI文字列"]
TITLE_UI["タイトルUI"]
TMP1["TextMeshPro テキストレンダリング"]
DOTWEEN1["DOTween アニメーション"]

subgraph リザルトシーン ["リザルトシーン"]
    GRAPH
    TMP3
    TIMING
    ONLINE
    WEBVIEW
    DOTWEEN3
    GRAPH -.-> TMP3
    TIMING -.-> TMP3
    ONLINE -.-> WEBVIEW
    GRAPH -.-> DOTWEEN3
end

subgraph ゲームプレイシーン ["ゲームプレイシーン"]
    NOTES
    DOTWEEN2
    MUSIC
    CRI_ATOM
    VIDEO
    CRI_MANA
    TOUCH
    INPUT_SYS
    LUA
    XLUA_E
    NOTES -.-> DOTWEEN2
    MUSIC -.-> CRI_ATOM
    VIDEO -.-> CRI_MANA
    TOUCH -.-> INPUT_SYS
    LUA -.-> XLUA_E
end

subgraph 楽曲選択シーン ["楽曲選択シーン"]
    SCROLL
    FANCY_S
    FOLDER
    JACKET
    ADDR_S
    TMP2
    LOC_S
    SCROLL -.-> FANCY_S
    FOLDER -.-> FANCY_S
    JACKET -.-> ADDR_S
    SCROLL -.-> TMP2
    FOLDER -.-> LOC_S
end

subgraph タイトルシーン ["タイトルシーン"]
    TITLE_UI
    TMP1
    DOTWEEN1
end
```

出典：プロジェクト構造全体の複数ファイル

### On this page

* [サードパーティ統合](#10-)
* [概要](#10--1)
* [依存関係アーキテクチャ](#10--2)
* [図：サードパーティ依存関係グラフ](#10--3)
* [Unity Package Manager設定](#10-unity-package-manager)
* [パッケージソース](#10--4)
* [図：パッケージレジストリ設定](#10--5)
* [重要な依存関係](#10--6)
* [Gitベースパッケージ統合](#10-git)
* [CRIミドルウェア統合](#10-cri)
* [図：CRIミドルウェアアーキテクチャ](#10-cri-1)
* [CriWareInitializerコンポーネント](#10-criwareinitializer)
* [CRIファイルシステム設定](#10-cri-2)
* [CRI Atomオーディオ設定](#10-cri-atom)
* [プラットフォーム固有のオーディオ設定](#10--7)
* [ACFファイル読込](#10-acf)
* [CRI Manaビデオ設定](#10-cri-mana)
* [初期化シーケンス](#10--8)
* [図：CRIミドルウェア初期化フロー](#10-cri-3)
* [カスタムオーディオエフェクト](#10--9)
* [XLua統合](#10-xlua)
* [DOTween統合](#10-dotween)
* [FancyScrollView統合](#10-fancyscrollview)
* [Unity WebView統合](#10-unity-webview)
* [UI Particle統合](#10-ui-particle)
* [Unity Localization統合](#10-unity-localization)
* [図：ローカライゼーションシステムアーキテクチャ](#10--10)
* [定数生成ワークフロー](#10--11)
* [Unity Input System統合](#10-unity-input-system)
* [プラットフォーム固有の設定](#10--12)
* [Android設定](#10-android)
* [iOS設定](#10-ios)
* [Standalone（Windows/Mac/Linux）](#10-standalonewindowsmaclinux)
* [シェーダーバリアントプリロード](#10--13)
* [依存関係バージョンロック](#10--14)
* [統合ポイントの概要](#10--15)
* [図：サードパーティシステム使用マップ](#10--16)

