

# シーンフローとライフサイクル 

## 目的と範囲 

本ドキュメントでは、シーン遷移システム、初期化シーケンス、およびアプリケーション起動からシャットダウンまでのライフサイクル管理について説明します。4つのメインシーン（タイトル、楽曲選択、ゲームプレイ、リザルト）間でアプリケーションがどのように遷移するか、各シーンがサブシステムを非同期で初期化する方法、および各シーン内でのアップデートループの調整方法について説明します。

各シーン内でのMVPパターンの実装の詳細については、[MVPパターンの実装](#2.2)を参照してください。永続化データのストレージメカニズムについては、[データ永続化システム](#2.3)を参照してください。

---

## シーンの概要 

アプリケーションは4つの主要なシーンで構成されており、それぞれ明確な目的を持っています：

| シーン名 | Unityシーンファイル | 主要コントローラー | 目的 |
| --- | --- | --- | --- |
| **タイトル** | `Title.unity` | `TitleScenePresenter` | 初期ランディング画面、設定へのアクセス、メインメニューへのナビゲーション |
| **楽曲選択** | `SelectMusic.unity` | `MusicSelectScenePresenter` | 楽曲のブラウジング、ゲーム設定の構成、難易度の選択 |
| **ゲームプレイ** | `Game.unity` | `MusicGameSceneController` | コアリズムゲームメカニクス、ノート判定、スコアリング |
| **リザルト** | `Result.unity` | `ResultScenePresenter` | パフォーマンス統計の表示、スコアの保存、選択画面への戻り |

各シーンは、エントリーポイント、初期化パイプライン、およびライフサイクル管理を持つ一貫したアーキテクチャパターンに従っています。



 

---

## アプリケーション起動とグローバル状態 

### GameManagerシングルトン 

アプリケーションは`GameManager`シングルトンから始まり、Unityの`DontDestroyOnLoad`メカニズムを使用してすべてのシーン遷移を通じて永続化されます。このシングルトンはグローバル状態と構成を保持します。

```mermaid
flowchart TD

APP_START["アプリケーション開始"]
GM_INIT["GameManager.Awake()<br/>シングルトン初期化"]
LOAD_SETTINGS["永続設定の読込<br/>GameSettingsPrefabs"]
LOAD_OPTIONS["オプションの初期化<br/>NotesOption / DisplayOption / VolumeOption / JudgeTimeOption"]
FIRST_SCENE["タイトルシーンの読込<br/>SceneBuildIndex.Title"]

APP_START --> GM_INIT
GM_INIT --> LOAD_SETTINGS
LOAD_SETTINGS --> LOAD_OPTIONS
LOAD_OPTIONS --> FIRST_SCENE
```

**図: アプリケーション起動シーケンス**

`GameManager`は、シーン遷移を超えて存続するランタイム状態を維持します：

* **選択された楽曲情報**: `SelectSongInfo`（現在の楽曲、難易度、フォルダ）
* **ゲームオプション**: `NotesOption`, `DisplayOption`, `VolumeOption`, `JudgeTimeOption`, `PlayModeOption`
* **リザルトデータ**: `ResultData`（ゲームプレイシーンからリザルトシーンへ渡される）
* **グループフォルダリスト**: `GroupFolderNameList`（利用可能な楽曲フォルダ）



---

## シーン遷移メカニズム 

### SceneBuildIndex列挙型 

シーン遷移は`SceneBuildIndex`列挙型を通じて管理され、型安全なシーン参照を提供します：

```c#
// コードベースで定義
public enum SceneBuildIndex
{    
    Title = 0,    
    SelectMusic = 1,    
    Game = 2,    
    Result = 3
}
```

### FadeManager統合 

シーン遷移は`FadeManager`を使用してスムーズな視覚的遷移を提供します：

1. **フェードアウト**: 現在のシーンが遷移前に`FadeManager.Instance.StartFadeOutAsync()`を呼び出す
2. **シーン読込**: `GameManager.Instance.ChangeScene(SceneBuildIndex)`が新しいシーンを読み込む
3. **フェードイン**: 新しいシーンが初期化後に`FadeManager.Instance.StartFadeInAsync()`を呼び出す



 

---

## シーン初期化パターン 

各シーンは、フレームドロップを防ぎ、適切な読込順序を確保するために、標準化された非同期初期化パターンに従います。

### 初期化アーキテクチャ 

```mermaid
flowchart TD

START["MonoBehaviour.Start()"]
LIFETIME["LifetimeScopeエントリー<br/>(VContainer DI)"]
PRESENTER["Presenterの作成<br/>Startableインターフェース"]
INIT_ASYNC["InitAsync()<br/>CancellationToken"]

LOAD_ASSETS["アセット読込<br/>Addressables / ファイル"]
INIT_MANAGERS["マネージャー初期化<br/>Judge / Score / Life / Combo"]
INIT_UI["UI初期化<br/>Views / Panels"]
PARSE_DATA["データ解析<br/>Charts / Songs"]

WAIT_COMPLETE["await UniTask.WhenAll()"]
FADE_IN["FadeManager.StartFadeInAsync()"]
READY["シーン準備完了"]

START --> LIFETIME
LIFETIME --> PRESENTER
PRESENTER --> INIT_ASYNC

INIT_ASYNC --> LOAD_ASSETS
INIT_ASYNC --> INIT_MANAGERS
INIT_ASYNC --> INIT_UI
INIT_ASYNC --> PARSE_DATA

subgraph 初期化タスク ["初期化タスク"]
    LOAD_ASSETS
    INIT_MANAGERS
    INIT_UI
    PARSE_DATA
end

LOAD_ASSETS --> WAIT_COMPLETE
INIT_MANAGERS --> WAIT_COMPLETE
INIT_UI --> WAIT_COMPLETE
PARSE_DATA --> WAIT_COMPLETE

WAIT_COMPLETE --> FADE_IN
FADE_IN --> READY
```

**図: シーン初期化パイプライン**

### 主要な初期化パターン 

| パターン | 目的 | 例 |
| --- | --- | --- |
| **同期Init** | I/Oなしの軽量セットアップ | `_judgeManager.Init()` |
| **非同期InitAsync** | 重い操作（ファイル読込、解析） | `_musicGame.InitAsync()` |
| **CancellationToken** | 非同期操作中のキャンセルを許可 | `InitAsync(CancellationToken ct)` |
| **エラーハンドリング** | ダイアログを表示して前のシーンに戻る | `try/catch`と`DialogManager` |
| **ローディング画面** | 長い操作中に進捗を表示 | `LoadingCanvasController` |



 

---

## シーンライフサイクルとアップデートループ 

### CallUpdateパターン 

マネージドからネイティブへの遷移オーバーヘッドを最小限に抑えるため、シーンは各コンポーネントが独自の`Update()`を定義するのではなく、サブシステムの`CallUpdate()`を呼び出す集中型の`Update()`メソッドを使用します。

### ゲームプレイのアップデートループ 

```mermaid
flowchart TD
    UNITY_UPDATE["Unity Update()<br/>MonoBehaviour"]
    MUSIC_TIME["musicTime =<br/>_musicManager.GetMusicTime()"]
    CLEAR_INPUT["_input.ClearInputData()"]

    subgraph 入力処理 ["入力処理"]
        INPUT_UPDATE["_input.CallUpdate(musicTime)"]
        TOUCH_DATA["TouchDataの収集"]
    end

    subgraph コアゲームロジック ["コアゲームロジック"]
        GAME_UPDATE["_musicGame.CallUpdate(musicTime)"]
        NOTE_SPAWN["ノート生成"]
        NOTE_POSITION["ノート位置更新"]
        LONG_UPDATE["ロングノート更新"]
        JUDGE_CHECK["判定処理"]
    end

    subgraph マネージャー更新 ["マネージャー更新"]
        JUDGE_UPDATE["_judgeManager.CallUpdate()"]
        SCORE_UPDATE["_scoreManager.CallUpdate()"]
        COMBO_UPDATE["_comboManager.CallUpdate()"]
        LIFE_UPDATE["_lifeManager.UpdateRecord()"]
    end

    subgraph 外部システム ["外部システム"]
        LUA_UPDATE["_luaManager.CallUpdate()"]
        ONLINE_UPDATE["_onlineManager.CallUpdate()"]
    end

    %% メインフロー
    UNITY_UPDATE --> MUSIC_TIME
    MUSIC_TIME --> INPUT_UPDATE
    INPUT_UPDATE --> TOUCH_DATA
    TOUCH_DATA --> GAME_UPDATE

    %% コアゲームロジック内のフロー
    GAME_UPDATE --> NOTE_SPAWN
    NOTE_SPAWN --> NOTE_POSITION
    NOTE_POSITION --> LONG_UPDATE
    LONG_UPDATE --> JUDGE_CHECK

    %% マネージャー更新へ
    JUDGE_CHECK --> JUDGE_UPDATE
    JUDGE_UPDATE --> SCORE_UPDATE
    SCORE_UPDATE --> COMBO_UPDATE
    COMBO_UPDATE --> LIFE_UPDATE

    %% 外部システムへ
    LIFE_UPDATE --> LUA_UPDATE
    LUA_UPDATE --> ONLINE_UPDATE
    ONLINE_UPDATE --> CLEAR_INPUT
```

**図: ゲームプレイシーンのアップデートループ**


## シーンの終了とクリーンアップ 

### 完了イベント 

各シーンは、遷移をトリガーする完了イベントを定義します：

| シーン | 完了イベント | 次のシーン | データ転送 |
| --- | --- | --- | --- |
| **タイトル** | スタートボタンのクリック | SelectMusic | なし |
| **楽曲選択** | プレイボタンのクリック | Game | `GameManager`経由の`SelectSongInfo` |
| **ゲーム** | `_musicManager.OnFinishMusic` | Result | `GameManager`経由の`ResultData` |
| **リザルト** | 戻るボタンのクリック | SelectMusic | なし |

## イベント駆動型のシーン制御 

### イベント登録パターン 

シーンはC#イベントを使用してサブシステムを分離し、初期化中に通信チャネルを確立します。


### イベントフローの例 

```mermaid
flowchart TD
    NOTE_MISS["ノートミス (MusicGame)"]
    ON_MISSED["OnMissedNoteイベント発火"]

    subgraph イベントハンドラー ["イベントハンドラー（並列実行）"]
        JUDGE_HANDLER["JudgeManager.AddMissedJudge"]
        LIFE_HANDLER["LifeManager.UpdateLife"]
        COMBO_HANDLER["ComboManager.UpdateCombo"]
        SCENE_HANDLER["MusicGameSceneController.OnMissedNote"]
    end

    NOTE_MISS --> ON_MISSED
    ON_MISSED --> JUDGE_HANDLER
    ON_MISSED --> LIFE_HANDLER
    ON_MISSED --> COMBO_HANDLER
    ON_MISSED --> SCENE_HANDLER
```

**図: イベント駆動型のノートミス処理**

---

## シーン間の永続状態 

### GameManagerシングルトン状態 

```mermaid
flowchart TD
    subgraph subGraph0 ["GameManager (DontDestroyOnLoad)"]
        SELECT_INFO["SelectSongInfo<br/>現在の楽曲選択"]
        OPTIONS["ゲームオプション<br/>Notes/Display/Volume/Judge"]
        RESULT["ResultData<br/>最新のゲームプレイ結果"]
        FOLDERS["GroupFolderNameList<br/>利用可能な楽曲グループ"]
    end

    TITLE["タイトルシーン"]
    SELECT["楽曲選択シーン"]
    GAME["ゲームシーン"]
    RESULT_SCENE["リザルトシーン"]

    %% タイトルシーン
    TITLE -->|"フォルダ読込"| FOLDERS

    %% 楽曲選択シーン
    SELECT -->|"楽曲選択書込"| SELECT_INFO
    SELECT -->|"オプション読込/書込"| OPTIONS
    SELECT -->|"フォルダ読込"| FOLDERS

    %% ゲームシーン
    GAME -->|"楽曲情報読込"| SELECT_INFO
    GAME -->|"オプション読込"| OPTIONS
    GAME -->|"ResultData書込"| RESULT

    %% リザルトシーン
    RESULT_SCENE -->|"ResultData読込"| RESULT
    RESULT_SCENE -->|"楽曲情報読込"| SELECT_INFO
```

**図: GameManagerを通じた永続状態管理**

### データフローパターン 

| データタイプ | ソースシーン | 宛先シーン | 転送メカニズム |
| --- | --- | --- | --- |
| **楽曲選択** | SelectMusic | Game | `GameManager.Instance.SelectSongInfo` |
| **ゲームプレイ結果** | Game | Result | `GameManager.Instance.ResultData` |
| **ユーザーオプション** | SelectMusic | Game | `GameManager.Instance.[Option]`プロパティ |
| **グループフォルダ** | Title（起動時） | SelectMusic | `GameManager.Instance.GroupFolderNameList` |

---

## 初期化タイミングのまとめ 

### シーン固有のタイミング 

| シーン | 標準的な初期化時間 | 非同期操作 | ローディング画面 |
| --- | --- | --- | --- |
| **タイトル** | ~100ms | Addressableアセット | なし |
| **楽曲選択** | 1-5秒 | 楽曲スキャン、サムネイル読込 | あり（`LoadingCanvasController`） |
| **ゲーム** | 500ms-2秒 | 譜面解析、オーディオ読込、Lua初期化 | あり（`WaitPlayPanel`） |
| **リザルト** | ~200ms | なし（キャッシュされたデータを使用） | なし |

### SongInfoLoaderのフェーズ 

楽曲選択シーンは、利用可能なすべての楽曲をスキャンするため、最も複雑な初期化を持っています：

```
LoadingCanvasControllerのフェーズ:
1. MusicSelectLoadingPhase.Search - .dlファイルのファイルシステムスキャン
2. MusicSelectLoadingPhase.MusicInfo - 譜面メタデータの解析
3. MusicSelectLoadingPhase.ReadThumbnail - ジャケット画像の読込
4. MusicSelectLoadingPhase.Complete - 完了してローディング画面を非表示
```

## 遷移中のエラーハンドリング 

### エラーリカバリーパターン 

すべての非同期初期化メソッドは、安全なシーンに戻るエラーリカバリーを実装しています：

```c#
try 
{
    // 非同期操作    
    await SomeAsyncOperation(ct);
} 
catch (Exception ex)
{    
    var localize = LocalizeManager.Instance;    
    var builder = new DialogParametor.Builder(
        localize.GetStringValue(LocalizationConstant.ERROR_HEADER),ex.Message
    );
    builder.AddDefaultAction(
        localize.GetStringValue(LocalizationConstant.BACK_TO_MENU),
        () => GameManager.Instance.ChangeScene(SceneBuildIndex.SafeScene)
    );
    builder.AddCallbackOnAutoClosed(() => GameManager.Instance.ChangeScene(SceneBuildIndex.SafeScene));
    DialogManager.Instance.Open(builder.Build());
    AnalyticsManager.SendError(ErrorCode.Category.SpecificError);
    return;
}
```

### エラーリカバリールート 

| エラー発生場所 | リカバリーシーン | 理由 |
| --- | --- | --- |
| タイトルシーンの初期化 | タイトルシーン | エラーダイアログを表示、再試行を許可 |
| SelectMusicの楽曲読込 | タイトルシーン | 楽曲なしでは進行不可 |
| ゲームの譜面解析 | SelectMusic | 選択画面に戻る |
| ゲームのオーディオ読込 | SelectMusic | オーディオなしでは再生不可 |
| リザルトシーンの初期化 | SelectMusic | リザルト表示をスキップ |


### On this page

* [シーンフローとライフサイクル](#2.1-)
* [目的と範囲](#2.1--1)
* [シーンの概要](#2.1--2)
* [アプリケーション起動とグローバル状態](#2.1--3)
* [GameManagerシングルトン](#2.1-gamemanager)
* [シーン遷移メカニズム](#2.1--4)
* [SceneBuildIndex列挙型](#2.1-scenebuildindex)
* [遷移フロー](#2.1--5)
* [FadeManager統合](#2.1-fademanager)
* [シーン初期化パターン](#2.1--6)
* [初期化アーキテクチャ](#2.1--7)
* [MusicGameSceneControllerの例](#2.1-musicgamescenecontroller)
* [主要な初期化パターン](#2.1--8)
* [シーンライフサイクルとアップデートループ](#2.1--9)
* [CallUpdateパターン](#2.1-callupdate)
* [ゲームプレイのアップデートループ](#2.1--10)
* [アップデートループの実装](#2.1--11)
* [シーンの終了とクリーンアップ](#2.1--12)
* [完了イベント](#2.1--13)
* [ゲームプレイシーンの完了](#2.1--14)
* [クリーンアップシーケンス](#2.1--15)
* [イベント駆動型のシーン制御](#2.1--16)
* [イベント登録パターン](#2.1--17)
* [イベントフローの例](#2.1--18)
* [シーン間の永続状態](#2.1--19)
* [GameManagerシングルトン状態](#2.1-gamemanager-1)
* [データフローパターン](#2.1--20)
* [初期化タイミングのまとめ](#2.1--21)
* [シーン固有のタイミング](#2.1--22)
* [SongInfoLoaderのフェーズ](#2.1-songinfoloader)
* [遷移中のエラーハンドリング](#2.1--23)
* [エラーリカバリーパターン](#2.1--24)
* [エラーリカバリールート](#2.1--25)

