

# タイトルシーン 

## 目的と範囲 

タイトルシーンはアプリケーションのエントリーポイントであり、ユーザーがゲーム設定へアクセス、コンテンツパッケージのダウンロード、お知らせの閲覧、および楽曲選択画面への移動を行うメインメニューインターフェースとして機能します。このページでは、シーンのMVPアーキテクチャ、UIコンポーネント、メニューナビゲーションシステム、およびビジュアルアニメーションについて説明します。

タイトル画面に続く楽曲選択シーンについては、[楽曲選択システム](#5)を参照してください。アプリケーション全体のライフサイクル管理については、[シーンフローとライフサイクル](#2.1)を参照してください。

---

## シーンアーキテクチャ 

タイトルシーンは、アプリケーション全体で確立されているMVP（Model-View-Presenter）パターンに従います。エントリーポイントは`TitleLifetimeScope`で、プレゼンターとビューコンポーネントを作成してバインドします。

### MVPコンポーネント構造 

```mermaid
flowchart TD

TLS["TitleLifetimeScope (MonoBehaviour)"]
TSP["TitleScenePresenter (IStartable, ITickable)"]
TSV["TitleSceneView (ViewBase)"]
MPC["MenuPanelController"]
ANIM["TitleAnimationController"]
CAM["Camera"]
TITLE["_titleImage"]
TOUCH["_touchToStartImage"]
VERSION["_versionText"]
PARTICLE["_touchToStartParticle"]
TAP_FX["_tapEffect"]
START_BTN["_startButton"]
MENU_BTN["_menuButton"]

TLS -.->|"作成してインジェクト"| TSP
TLS -.->|"参照を渡す"| TSV
TSP -.->|"制御"| MPC
TSP -.->|"制御"| ANIM
TSV -.->|"参照"| CAM
TSV -.->|"参照"| TITLE
TSV -.->|"参照"| TOUCH
TSV -.->|"参照"| VERSION
TSV -.->|"参照"| PARTICLE
TSV -.->|"参照"| TAP_FX
TSV -.->|"参照"| START_BTN
TSV -.-> MENU_BTN

subgraph ビジュアルコンポーネント ["ビジュアルコンポーネント"]
    CAM
    TITLE
    TOUCH
    VERSION
    PARTICLE
    TAP_FX
    START_BTN
    MENU_BTN
end

subgraph UIコントローラー ["UIコントローラー"]
    MPC
    ANIM
end

subgraph プレゼンテーション層 ["プレゼンテーション層"]
    TSP
    TSV
    TSP -.->|"制御"| TSV
end

subgraph タイトルシーン入口 ["タイトルシーン入口"]
    TLS
end
```

**図：タイトルシーンのMVP構造**

`TitleSceneView`コンポーネントはシーンのルートGameObjectにアタッチされており、すべてのビジュアル要素とUIコントローラーへのシリアライズされた参照を保持しています。

## UIコンポーネントレイアウト 

タイトルシーンのビジュアル階層は、静的UI要素とユーザーフィードバック用のアニメーションコンポーネントを含むトップパネルを持つキャンバスで構成されています。

### ビジュアル階層 

```mermaid
flowchart TD

CANVAS["Canvas"]
TOP_PANEL["TopPanel (RectTransform)"]
BG["BgImage"]
TITLE_IMG["TitleImage (Image)"]
TOUCH_IMG["TouchToStartImage (Image) アルファアニメーション"]
TOUCH_PARTICLE["TouchToStartUIParticle (UIParticle)"]
UI_PARTICLE["UIParticle (中央エフェクト)"]
VERSION_TXT["VersionText (TMP) Ver.#95"]
START_BTN["StartButton (Button)"]
MENU_BTN["MenuButton (Button) 左上隅"]

CANVAS -.-> TOP_PANEL
CANVAS -.-> TOUCH_PARTICLE
```

**図：タイトルシーンのビジュアル階層**

このシーンはUnityのUI Particleシステムを使用して、UIキャンバス上にレイヤー化された装飾的なパーティクルエフェクトを表示します。バージョンテキストは`Constant.App.VERSION_NAME`の定数値を表示します。

## メニューシステムアーキテクチャ 

タイトルシーンは、`MenuPanelController`によって制御される階層的なメニュー構造を通じて、複数の設定とコンテンツ管理パネルへのアクセスを提供します。

### メニューナビゲーション構造 

```mermaid
flowchart TD

MENU_BTN["Menu Button"]
MAIN_PANEL["MenuPanel (メインメニュー)"]
NOTICE["_notificationButton → NoticePanelController"]
PACKAGE["_packageButton → PackagePanelController"]
SETTINGS["_settingButton → TitleMenuSettingPanelController"]
FAQ["_howToPlayButton → FAQPanelController (Resources)"]
LICENSE["_licenseButton → LicensePanelController (Resources)"]
BACKUP["_backupButton → BackupPanelController (Resources)"]
CONTENT["_contentButton → UserContentPanel"]
ACCOUNT["_accountButton → AccountPanel"]
FM["_fileManagerButton → FileManagerPanelController"]
IGF["_ignoreGroupFolderButton → IgnoreGroupFolderPanelController"]
SETTINGS_PANEL["TitleMenuSettingPanelController"]
ONLINE["OnlinePanelController"]
LANG["LanguagePanelController"]
API["CustomServerPanelController"]
OTHER["OtherPanelController"]

SETTINGS -.-> SETTINGS_PANEL

subgraph 設定サブメニュー ["設定サブメニュー"]
    SETTINGS_PANEL
    ONLINE
    LANG
    API
    OTHER
end

subgraph 主要メニューボタン ["主要メニューボタン"]
    NOTICE
    PACKAGE
    SETTINGS
    FAQ
    LICENSE
    BACKUP
    CONTENT
    ACCOUNT
    FM
    IGF
end
```

**図：メニューナビゲーション階層**

各パネルコントローラーは、シーンにシリアライズされているか、`Resources.Load<T>(ResourcesName.PREFABS_TITLEMENU_*)`のパターンを使用してResourcesから遅延読み込みされます。


## MenuPanelControllerの実装 

`MenuPanelController`はメインメニューのライフサイクルを管理し、各機能領域の専門化されたサブコントローラーに処理を委譲します。

### 主要な責務 

| 責務 | 実装 |
| --- | --- |
| **パネルの表示/非表示** | `SetActivePanel(bool)`でメインメニューの表示/非表示を制御 |
| **ネットワークチェック** | ネットワーク操作前に`CanUseNetWork()`で接続性を検証 |
| **遅延読み込み** | 特定のパネルは初回アクセス時のみResourcesから読み込み |
| **API検証** | `CheckSupportApi()`を呼び出してサーバー機能サポートを確認 |
| **サブパネル管理** | 複数の子パネルコントローラーを初期化して調整 |

### パネル読み込み戦略 

メニューは2つの読み込み戦略を採用しています：

**シリアライズされたパネル**（シーン開始時に読み込み）：

* `NoticePanelController`
* `PackagePanelController`
* `TitleMenuSettingPanelController`

**遅延読み込みパネル**（初回使用時にインスタンス化）：

* `FAQPanelController` from `ResourcesName.PREFABS_TITLEMENU_FAQPANEL`
* `LicensePanelController` from `ResourcesName.PREFABS_TITLEMENU_LICENSEPANEL`
* `BackupPanelController` from `ResourcesName.PREFABS_TITLEMENU_BACKUPPANEL`

 

### ネットワーク接続検証 

```mermaid
flowchart TD

BTN["ボタンクリック"]
CHECK["CanUseNetWork()"]
NETWORK_CHECK["NetworkChecker.CanConnect()"]
DIALOG["DialogManager.ShowAsync()"]
ACTION["ネットワーク操作実行"]

BTN -.-> CHECK
CHECK -.->|"false"| DIALOG
CHECK -.->|"true"| NETWORK_CHECK
DIALOG -.->|"ユーザー確認"| ACTION
```

**図：ネットワーク検証フロー**

ネットワーク依存操作（パッケージのダウンロード、お知らせの取得）を実行する前に、システムは接続性をチェックし、オプションでモバイルデータの使用についてユーザーに警告します。

 

 

---

## 設定パネル構造 

`TitleMenuSettingPanelController`は、シーン間で永続化されるアプリケーションレベルの設定を構成するためのタブ付きインターフェースを提供します。

### 設定の構成 

```mermaid
flowchart TD

SETTINGS_PANEL["TitleMenuSettingPanelController"]
ONLINE_TAB["_onlineToggle"]
LANG_TAB["_languageToggle"]
API_TAB["_apiServerToggle"]
OTHER_TAB["_otherToggle"]
ONLINE_P["OnlinePanelController MQTT設定"]
LANG_P["LanguagePanelController ロケール選択"]
API_P["CustomServerPanelController APIエンドポイント"]
OTHER_P["OtherPanelController BannerLoadType"]

subgraph パネルコントローラー ["パネルコントローラー"]
    ONLINE_P
    LANG_P
    API_P
    OTHER_P
end

subgraph タブトグル ["タブトグル"]
    ONLINE_TAB
    LANG_TAB
    API_TAB
    OTHER_TAB
end
```

**図：設定パネルのタブアーキテクチャ**

このコントローラーはUnityの`Toggle`コンポーネントと`onValueChanged`リスナーを使用して、`ChangeActivePanel(SettingPanel)`経由でアクティブなパネルを切り替えます。

 

### 設定パネルのライフサイクル 

| フェーズ | アクション |
| --- | --- |
| **初期化** | 親の`MenuPanelController`から`Init(Action onClose)`が呼ばれる |
| **サブコントローラー初期化** | 各パネルコントローラーの`Init()`メソッドが呼び出される |
| **デフォルト状態** | `_onlineToggle.isOn = true`でOnlineパネルが有効化される |
| **タブ切り替え** | トグルリスナーが`ChangeActivePanel(SettingPanel)`を呼び出す |
| **クローズ** | prefasを通じて`OnlineSettings`、`CustomServerSettings`、`OtherSettings`を保存 |

 

---

## アニメーションとビジュアルフィードバック 

タイトルシーンはパーティクルエフェクトとアニメーションUI要素を使用して、ビジュアルの洗練度とユーザーフィードバックを提供します。

### パーティクルシステム 

| コンポーネント | 目的 | 構成 |
| --- | --- | --- |
| `_touchToStartParticle` | "Touch to Start"プロンプトのUIParticle | スケール: 200x200x200、5つのパーティクルシステム |
| `UIParticle` (中央) | 背景装飾エフェクト | スケール: 15x15x15、単一パーティクルシステム |
| `_tapEffect` | タップ時のビジュアルフィードバック | TapEffectCameraコンポーネント |

パーティクルシステムは`UIParticle`コンポーネント（UI Particleパッケージより）を使用して、UnityのParticleSystemsをUIキャンバス空間内でレンダリングします。

 

 

### タッチフィードバックアニメーション 

"Touch to Start"画像は、`TitleScenePresenter`によって制御されるアルファフェードアニメーションを使用して、スタートボタンへユーザーの注意を誘導する脈動エフェクトを作成します。

 

---

## ローカリゼーション統合 

タイトルシーンは多言語サポートのためにUnity Localizationパッケージを多用しています。

### ローカライズされたUI要素 

```mermaid
flowchart TD

LOC_MGR["LocalizeManager.Instance"]
CONST["LocalizationConstant"]
MENU["TitleMenu"]
NOTICE["TitleMenuNotice"]
PACKAGE["TitleMenuPackage"]
FAQ["TitleMenuFAQ"]
LICENSE["TitleMenuLicense"]
BACKUP["TitleMenuBackup"]
SETTINGS["TitleMenuSettings"]
ONLINE["TitleMenuSettingsOnline"]
LANG["TitleMenuSettingsLanguage"]
API["TitleMenuSettingsCustomServer"]
OTHER["TitleMenuSettingsOther"]

CONST -.->|"キーを提供"| MENU
CONST -.-> NOTICE
CONST -.-> PACKAGE
CONST -.-> FAQ
CONST -.-> LICENSE
CONST -.-> BACKUP
CONST -.-> SETTINGS
SETTINGS -.-> ONLINE
SETTINGS -.-> LANG
SETTINGS -.-> API
SETTINGS -.-> OTHER

subgraph サブメニューラベル ["サブメニューラベル"]
    ONLINE
    LANG
    API
    OTHER
end

subgraph メニューボタンラベル ["メニューボタンラベル"]
    MENU
    NOTICE
    PACKAGE
    FAQ
    LICENSE
    BACKUP
    SETTINGS
end
```

**図：ローカリゼーションキー構造**

すべてのメニューラベルは`LocalizationConstant`の定数を参照しており、これはローカリゼーション文字列テーブルから自動生成されます。システムは日本語（`ja`）と英語（`en`）の両方のロケールをサポートしています。

 

 

### バージョン表示 

バージョンテキストは定数から取得され、右上隅に表示されます：

この値は`VersionText (TMP)`コンポーネントによって"Ver.#96"としてレンダリングされます。

 

 

---

## シーン遷移フロー 

タイトルシーンは他のアプリケーションシーンへのゲートウェイとして機能し、主に楽曲選択シーンへ遷移します。

### ナビゲーションパス 

```mermaid
flowchart TD

TITLE["タイトルシーン (Title.unity)"]
SELECT["楽曲選択シーン (SelectMusic.unity)"]
PACKAGE_DL["パッケージダウンロード"]
SETTINGS_SAVE["設定変更"]
BACKUP_OPS["バックアップ操作"]

TITLE -.->|"シーン内に留まる"| SELECT
TITLE -.->|"シーン内に留まる"| PACKAGE_DL
TITLE -.->|"シーン内に留まる"| SETTINGS_SAVE
TITLE -.->|"_startButtonクリック"| BACKUP_OPS

subgraph メニューアクション ["メニューアクション"]
    PACKAGE_DL
    SETTINGS_SAVE
    BACKUP_OPS
end
```

**図：タイトルシーンのナビゲーション**

スタートボタンは`GameManager.Instance.ChangeSceneAsync()`を介して楽曲選択シーンへのシーン遷移をトリガーします。すべてのメニュー操作はシーン変更をトリガーせずにタイトルシーン内に留まります。

 

---

## ローディング状態管理 

いくつかのメニューパネルは非同期操作（ネットワークリクエスト、ファイルI/O）を実行し、共有のローディングインジケーターパターンを使用します。

### ローディングインジケーター 

`RotateLoadingController`はフェードアニメーション付きの回転アイコンを提供します：

| メソッド | 目的 |
| --- | --- |
| `Init()` | 初期アルファ値を0に設定 |
| `StartLoading()` | フェードインして回転アニメーションを開始（1秒あたり360°、無限ループ） |
| `EndLoading()` | フェードアウトして回転を停止 |
| `Cancel()` | 即座に非表示状態にリセット |

回転はDOTweenを使用し、`RotateMode.FastBeyond360`と`Ease.Linear`でスムーズな連続回転を実現します。

 

---

## パネル基底クラス 

すべてのメニューパネルは`MenuContentPanelBase`を継承しており、パネルライフサイクル管理のための共通機能を提供します。

### パネルインターフェース 

静的な`IsOpenPanel`プロパティは、複数のパネルが同時に開くのを防ぎ、一度に1つのモーダルダイアログのみがアクティブであることを保証します。

## 外部リソース統合 

いくつかのメニュー機能は実行時に外部アセットを読み込みます：

### リソース読み込みパターン 

| 機能 | 読み込み方法 | パスパターン |
| --- | --- | --- |
| FAQパネル | `Resources.Load<FAQPanelController>()` | `ResourcesName.PREFABS_TITLEMENU_FAQPANEL` |
| ライセンスパネル | `Resources.Load<LicensePanelController>()` | `ResourcesName.PREFABS_TITLEMENU_LICENSEPANEL` |
| バックアップパネル | `Resources.Load<BackupPanelController>()` | `ResourcesName.PREFABS_TITLEMENU_BACKUPPANEL` |
| パッケージデータ | `ImageDownloader.DownloadAsync()`経由のネットワークダウンロード | リモートURL |

遅延読み込みパターンは、ユーザーの操作までパネルのインスタンス化を遅延させることで、初期シーン読み込み時間を短縮します。

 

 

---

## まとめ 

タイトルシーンはMVPアーキテクチャを使用した包括的なメニューシステムを実装しており、各機能領域用のモジュール式パネルコントローラーを備えています。このシーンはパーティクルエフェクトとアニメーションを通じてビジュアルの洗練度を提供し、完全なローカリゼーションをサポートし、ローディングインジケーターで非同期操作を管理します。ナビゲーションはモーダルの競合を防ぐために厳密に制御されており、外部リソースはパフォーマンスを最適化するために遅延読み込みされます。


### On this page

* [タイトルシーン](#8.1-)
* [目的と範囲](#8.1--1)
* [シーンアーキテクチャ](#8.1--2)
* [MVPコンポーネント構造](#8.1-mvp)
* [UIコンポーネントレイアウト](#8.1-ui)
* [ビジュアル階層](#8.1--3)
* [メニューシステムアーキテクチャ](#8.1--4)
* [メニューナビゲーション構造](#8.1--5)
* [MenuPanelControllerの実装](#8.1-menupanelcontroller)
* [主要な責務](#8.1--6)
* [パネル読み込み戦略](#8.1--7)
* [ネットワーク接続検証](#8.1--8)
* [設定パネル構造](#8.1--9)
* [設定の構成](#8.1--10)
* [設定パネルのライフサイクル](#8.1--11)
* [アニメーションとビジュアルフィードバック](#8.1--12)
* [パーティクルシステム](#8.1--13)
* [タッチフィードバックアニメーション](#8.1--14)
* [ローカリゼーション統合](#8.1--15)
* [ローカライズされたUI要素](#8.1-ui-1)
* [バージョン表示](#8.1--16)
* [シーン遷移フロー](#8.1--17)
* [ナビゲーションパス](#8.1--18)
* [ローディング状態管理](#8.1--19)
* [ローディングインジケーター](#8.1--20)
* [パネル基底クラス](#8.1--21)
* [パネルインターフェース](#8.1--22)
* [外部リソース統合](#8.1--23)
* [リソース読み込みパターン](#8.1--24)
* [まとめ](#8.1--25)

