

# データ永続化システム 

## 目的と範囲 

この文書では、プレイヤー設定、構成、ゲームデータを保存および読み込むために使用されるデータ永続化アーキテクチャについて説明します。このシステムは、JSONと暗号化バイナリストレージの両方をサポートする汎用シリアライゼーションフレームワークを実装しており、プラットフォーム固有のパス管理と自動終了時保存機能を備えています。

LiteDBを使用したスコアデータストレージについては、[リザルトデータ収集](#4.3)を参照してください。アセットキャッシュシステムについては、[キャッシュシステム](#9.3)を参照してください。

---

## アーキテクチャ概要 

永続化システムは、ランタイム状態、永続化ロジック、ストレージメカニズムを分離する3層アーキテクチャに従っています。

### 3層アーキテクチャ 

```mermaid
flowchart TD

GM["GameManager.Instance"]
NO["NotesOption"]
DO["DisplayOption"]
VO["VolumeOption"]
JTO["JudgeTimeOption"]
OS["OnlineSettings"]
GSP["GameSettingsPrefas Serializable<GameSettingsPrefas>"]
OSP["OnlineSettingsPrefas Serializable<OnlineSettings>"]
SDP["ScoreDataPrefas Serializable<ScoreDataPrefas>"]
LTD["LocalTimingData Serializable<LocalTimingData>"]
FILE["File<T> システム"]
JSON["JSONファイル persistentDataPath/Save"]
BINARY["暗号化バイナリ BinaryFormatter"]
DB["LiteDB player.db"]

NO -.->|"読込/保存"| GSP
DO -.->|"読込/保存"| GSP
VO -.->|"読込/保存"| GSP
JTO -.->|"File.Open<T>"| GSP
OS -.->|"読込/保存"| OSP
FILE -.->|"保持"| JSON
FILE -.->|"Device.instance.encrypt = true"| BINARY
SDP -.->|"書込先"| DB

subgraph subGraph2 ["第3層: ストレージ"]
    JSON
    BINARY
    DB
end

subgraph subGraph1 ["第2層: 永続化レイヤー"]
    GSP
    OSP
    SDP
    LTD
    FILE
    GSP -.->|"Device.instance.encrypt = false"| FILE
    OSP -.->|"File.Open<T>"| FILE
    SDP -.->|"File.Open<T>"| FILE
    LTD -.->|"File.Open<T>"| FILE
end

subgraph subGraph0 ["第1層: ランタイム状態"]
    GM
    NO
    DO
    VO
    JTO
    OS
    GM -.->|"保持"| NO
    GM -.->|"保持"| DO
    GM -.->|"保持"| VO
    GM -.->|"保持"| JTO
    GM -.->|"読込/保存"| OS
end
```



 

---

## コアシリアライゼーションシステム 

### File システム 

`File<T>`クラスは、プレーンJSONと暗号化バイナリフォーマットの両方をサポートする汎用ファイルI/O操作を提供します。

#### ファイル操作フロー

```mermaid
flowchart TD

START["File.Open<T>(fileName)"]
PATH["パス生成 Device.filePath()"]
EXISTS["File.Exists(path)"]
ENCRYPT_CHECK["Device.instance.encrypt"]
JSON_LOAD["ReadAllText JsonUtility.FromJson<T>"]
BINARY_LOAD["BinaryFormatter.Deserialize Cryptography.Decrypt JsonUtility.FromJson<T>"]
CREATE_ENCRYPT["Device.instance.encrypt"]
JSON_CREATE["WriteAllText JsonUtility.ToJson"]
BINARY_CREATE["BinaryFormatter.Serialize Cryptography.Encrypt JsonUtility.ToJson"]
REGISTER["保存コールバック登録 FileDelegate.onQuit FileDelegate.onPause"]
RETURN["Tインスタンスを返す"]

START -.->|"true"| PATH
PATH -.->|"false"| EXISTS
EXISTS -.->|"true"| ENCRYPT_CHECK
EXISTS -.->|"false"| CREATE_ENCRYPT
REGISTER -.-> RETURN

subgraph 作成分岐 ["作成分岐"]
    CREATE_ENCRYPT
    JSON_CREATE
    BINARY_CREATE
end

subgraph 読込分岐 ["読込分岐"]
    ENCRYPT_CHECK
    JSON_LOAD
    BINARY_LOAD
end
```



#### 主要メソッド

| メソッド | 目的 | 場所 |
| --- | --- | --- |
| `File.Open<T>(string fileName)` | ファイルを読み込むまたは作成 | 
| `File.Save<T>(this T file)` | ファイルをディスクに保存 | 
| `Device.filePath(string name)` | プラットフォーム固有のパスを生成 |

#### スレッド動作

システムはメインスレッドをブロックしないように、すべてのファイルI/Oをバックグラウンドスレッドで実行します：

### Serializable パターン 

`Serializable<T>`基底クラスは、永続データの遅延読み込みのためのシングルトンパターンを実装しています。

#### クラス階層

```mermaid
flowchart TD

IFACE["ISerializable インターフェース"]
BASE["Serializable 抽象クラス"]
GENERIC["Serializable<T> ジェネリッククラス"]
GSP["GameSettingsPrefas"]
OSP["OnlineSettingsPrefas"]
SDP["ScoreDataPrefas"]
LTD["LocalTimingData"]

IFACE -.->|"実装"| BASE
BASE -.->|"継承"| GENERIC
GENERIC -.->|"拡張"| GSP
GENERIC -.->|"拡張"| OSP
GENERIC -.->|"拡張"| SDP
GENERIC -.->|"拡張"| LTD
```

#### シングルトン実装

#### 使用パターン

クラスは`Serializable<T>`を拡張して自動永続化を獲得します：

シングルトン経由でアクセス：

```
var settings = GameSettingsPrefas.instance;settings.NotesOption = newOptions;GameSettingsPrefas.Save();
```

## オプションクラス 

### オプションクラス階層 

```mermaid
flowchart TD

GSP["GameSettingsPrefas"]
NO["NotesOption サイズ、スキン、スピードなど"]
DO["DisplayOption FPS、UI、エフェクト"]
VO["VolumeOption 音楽、SE、動画"]
JTO["JudgeTimeOption タイミングウィンドウ、レート"]

GSP -.->|"保持"| NO
GSP -.->|"保持"| DO
GSP -.->|"保持"| VO
GSP -.-> JTO
```



### JudgeTimeOption 構造 

`JudgeTimeOption`クラスは、カスタム検証を伴う判定タイミング設定を格納します：

| フィールド | 型 | デフォルト | 目的 |
| --- | --- | --- | --- |
| `BrilliantTime` | `float` | `Constant.JudgeTime.BRILLIANT_TIME` | Brilliant判定ウィンドウ |
| `GreatTime` | `float` | `Constant.JudgeTime.GREAT_TIME` | Great判定ウィンドウ |
| `FastTime` | `float` | `Constant.JudgeTime.FAST_TIME` | Fast判定ウィンドウ |
| `BadTime` | `float` | `Constant.JudgeTime.BAD_TIME` | Bad判定ウィンドウ |
| `JudgeDistance` | `float` | `Constant.JudgeTime.JUDGE_DISTANCE` | ヒット検出距離 |
| `MusicRate` | `float` | `1.0f` | 音楽再生速度 |
| `Mirror` | `bool` | `false` | ノートを水平反転 |
| `Vibration` | `bool` | `false` | 触覚フィードバックを有効化 |
| `GlobalLuaName` | `string` | `DEFAULT_GLOBAL_LUA_NAME` | 選択されたグローバルLuaスクリプト |
| `DspBufferSize` | `int` | `256` | オーディオDSPバッファサイズ |

#### ヘルパーメソッド

```mermaid
flowchart TD

JTO["JudgeTimeOption"]
GHT["GetHitTime() 最長判定時間を返す"]
GLEHT["GetLongEndHitTime() ロング終端補正を含む 最長時間を返す"]
GCHT["GetComboHitTime() コンボ継続可能な 最長時間を返す"]

JTO -.->|"メソッド"| GHT
JTO -.->|"メソッド"| GLEHT
JTO -.->|"メソッド"| GCHT
```



---

## ストレージメカニズム 

### ファイルパス生成 

システムは`ExternalDirectory`を使用してプラットフォーム固有のパスを提供します：

| パスプロパティ | 目的 | プラットフォームメモ |
| --- | --- | --- |
| `RootFolder` | ベースディレクトリ | Editor: カレントディレクトリAndroid/iOS: persistentDataPath |
| `SongsPath` | ユーザー楽曲譜面 | `{Root}/Songs` |
| `SavePath` | セーブデータファイル | `{Root}/Save` |
| `NoteSkinsPath` | カスタムノートスキン | `{Root}/NoteSkins` |
| `SoundEffectsPath` | カスタムタッチ音 | `{Root}/SoundEffects` |
| `GlobalLuaPath` | カスタムLuaスクリプト | `{Root}/GlobalLua` |
| `RivalDataPath` | ライバルプレイヤーデータ | `{Root}/RivalData` |



#### プラットフォーム固有のパス解決

```mermaid
flowchart TD

ROOT["プラットフォーム?"]
EDITOR["Unity Editor Directory.GetCurrentDirectory()"]
ANDROID["Android Application.persistentDataPath"]
IOS["iOS Application.persistentDataPath"]
NORMALIZE["バックスラッシュを スラッシュに置換"]

ROOT -.->|"UNITY_EDITOR"| EDITOR
ROOT -.->|"UNITY_ANDROID"| ANDROID
ROOT -.->|"UNITY_IOS"| IOS
EDITOR -.-> NORMALIZE
ANDROID -.-> NORMALIZE
IOS -.-> NORMALIZE
```



### ストレージフォーマット比較 

| フォーマット | 暗号化 | サイズ | パフォーマンス | 用途 |
| --- | --- | --- | --- | --- |
| JSON | なし | 大きい | 高速 | 開発、デバッグ |
| Binary | BinaryFormatter + Cryptography | 小さい | 低速 | 本番、機密データ |

フォーマットは`Device.instance.encrypt`で制御されます：

```sql
switch (Device.instance.encrypt){    case true:        // 暗号化付きBinaryFormatterを使用        using (FileStream fs = File.Open(path, FileMode.Create))        {            string cryptor = Cryptography.Encrypt(JsonUtility.ToJson(file));            bf.Serialize(fs, cryptor);        }        break;            case false:        // プレーンJSONを使用        string data = JsonUtility.ToJson(file);        File.WriteAllText(file.path, data, Encoding.UTF8);        break;}
```



---

## 保存イベントライフサイクル 

### 自動保存登録 

`File.Open<T>()`メソッドは、設定された保存イベントに基づいて保存コールバックを登録します：

```mermaid
flowchart TD

OPEN["File.Open<T>()"]
REGISTER["FileDelegate.openedFilesに 登録"]
CHECK_QUIT["SaveEvent.OnQuit 有効?"]
CHECK_PAUSE["SaveEvent.OnPause 有効?"]
REG_QUIT["FileDelegate.onQuit コールバック登録"]
REG_PAUSE["FileDelegate.onPause コールバック登録"]
QUIT_CALLBACK["OnApplicationQuit() → Save()"]
PAUSE_CALLBACK["OnApplicationPause(true) → Save()"]
END["完了"]

OPEN -.->|"はい"| REGISTER
REGISTER -.->|"いいえ"| CHECK_QUIT
```



### 手動保存操作 

設定は重要なポイントで手動でも保存されます：

```c#
_closeButton.onClick.AddListener(() =>
{    
    try    
    {        
        GameSettingsPrefas.instance.NotesOption = GameManager.Instance.NotesOption;        
        GameSettingsPrefas.instance.DisplayOption = GameManager.Instance.DisplayOption;        
        GameSettingsPrefas.instance.VolumeOption = GameManager.Instance.VolumeOption;        
        GameSettingsPrefas.instance.JudgeTimeOption = GameManager.Instance.JudgeTimeOption;        
        GameSettingsPrefas.Save();    
    }    
    catch (Exception ex)    
    {        
        // ダイアログによるエラー処理    
    }
});
```

## GameManager統合 

### ランタイム状態管理 

`GameManager`はすべてのオプションオブジェクトのランタイムコピーを保持し、永続ストレージと同期されます：

```mermaid
flowchart TD

MODIFY["ユーザーが設定を変更"]
COPY["GameSettingsPrefasにコピー"]
PERSIST["GameSettingsPrefas.Save()"]
INIT["GameManager初期化"]
LOAD["GameSettingsPrefas.instanceから読込"]
CACHE["GameManagerプロパティに キャッシュ"]
GM["GameManager.Instance"]
NO_RT["NotesOption (ランタイム)"]
DO_RT["DisplayOption (ランタイム)"]
VO_RT["VolumeOption (ランタイム)"]
JTO_RT["JudgeTimeOption (ランタイム)"]

CACHE -.->|"保持"| GM

subgraph ランタイム ["ランタイム"]
    GM
    NO_RT
    DO_RT
    VO_RT
    JTO_RT
    GM -.-> NO_RT
    GM -.->|"保持"| DO_RT
    GM -.-> VO_RT
    GM -.-> JTO_RT
end

subgraph アプリケーション起動 ["アプリケーション起動"]
    INIT
    LOAD
    CACHE
    INIT -.->|"保持"| LOAD
    LOAD -.->|"保持"| CACHE
end

subgraph 保存トリガー ["保存トリガー"]
    MODIFY
    COPY
    PERSIST
    MODIFY -.-> COPY
    COPY -.-> PERSIST
end
```



---

## エラー処理 

### 読込エラーリカバリー 

システムは、破損したファイルに対するユーザーインタラクションを含むエラー処理を備えています：

```mermaid
flowchart TD

LOAD_START["File.Open<T>"]
TRY["デシリアライズ試行"]
SUCCESS["成功?"]
USE["読み込んだデータを使用"]
DIALOG["例外詳細を含む エラーダイアログを表示"]
USER_CHOICE["ユーザー選択"]
DELETE["破損ファイルを削除"]
RETRY["File.Open<T>を再試行"]
CANCEL["キャンセル、デフォルトを使用"]

TRY -.->|"いいえ"| SUCCESS
SUCCESS -.->|"はい"| USE
SUCCESS -.-> DIALOG
DIALOG -.->|"キャンセル"| USER_CHOICE
DELETE -.->|"OK"| RETRY
```

## ディレクトリ管理 

### 自動ディレクトリ作成 

システムは必要なディレクトリの存在を保証します：

| メソッド | ディレクトリ | 目的 |
| --- | --- | --- |
| `CreateSongsDirectory()` | `/Songs` | ユーザー追加譜面 |
| `CreateNoteSkinsDirectory()` | `/NoteSkins` | カスタムノートスキン |
| `CreateTouchSoundEffectsDirectory()` | `/SoundEffects` | カスタムタッチ音 |
| `CreateGlobalLuaDirectory()` | `/GlobalLua` | カスタムLuaスクリプト |
| `CreateSaveDirectory()` | `/Save` | セーブデータファイル |
| `CreateRivalDataDirectory()` | `/RivalData` | ライバルプレイヤーデータ |

### レガシー保存データ移行 

システムは古い場所からのセーブファイル移行をサポートします
---

## ファイル命名規則 

### 命名パターン 

セーブファイルは次のパターンに従います：`({完全型名}){fileName}{fileType}`

例：

* `(ThirtySec.GameSettingsPrefas).json`
* `(ThirtySec.ScoreDataPrefas).json`
* `(ThirtySec.OnlineSettingsPrefas).json`

この命名により、異なるデータ型間の衝突を防ぎ、ファイル内容を簡単に識別できます。

 

---

## まとめ 

データ永続化システムは、以下の主要機能を備えた堅牢で型安全なゲームデータの保存・読み込みフレームワークを提供します：

| 機能 | 実装 |
| --- | --- |
| **汎用シリアライゼーション** | `File<T>`と`Serializable<T>`パターン |
| **複数フォーマット** | JSON（開発用）と暗号化バイナリ（本番用） |
| **遅延読み込み** | オンデマンド初期化を伴うシングルトンパターン |
| **自動保存** | 終了/一時停止時のライフサイクルコールバック |
| **プラットフォーム抽象化** | クロスプラットフォームパスのための`ExternalDirectory` |
| **エラーリカバリー** | 破損ファイル用のユーザーダイアログ |
| **スレッドセーフ** | バックグラウンドスレッドI/O操作 |

このアーキテクチャは、ランタイム状態（GameManager）、永続化ロジック（Serializableクラス）、ストレージメカニズム（ファイルシステム）の間で関心を分離し、新しい永続データ型の追加やストレージフォーマットの変更を容易にします。

### On this page

* [データ永続化システム](#2.3-)
* [目的と範囲](#2.3--1)
* [アーキテクチャ概要](#2.3--2)
* [3層アーキテクチャ](#2.3-3)
* [コアシリアライゼーションシステム](#2.3--3)
* [File システム](#2.3-file-)
* [Serializable パターン](#2.3-serializable-)
* [オプションクラス](#2.3--4)
* [オプションクラス階層](#2.3--5)
* [JudgeTimeOption 構造](#2.3-judgetimeoption-)
* [ストレージメカニズム](#2.3--6)
* [ファイルパス生成](#2.3--7)
* [ストレージフォーマット比較](#2.3--8)
* [保存イベントライフサイクル](#2.3--9)
* [自動保存登録](#2.3--10)
* [手動保存操作](#2.3--11)
* [GameManager統合](#2.3-gamemanager)
* [ランタイム状態管理](#2.3--12)
* [エラー処理](#2.3--13)
* [読込エラーリカバリー](#2.3--14)
* [エラーダイアログの例](#2.3--15)
* [ディレクトリ管理](#2.3--16)
* [自動ディレクトリ作成](#2.3--17)
* [レガシー保存データ移行](#2.3--18)
* [ファイル命名規則](#2.3--19)
* [命名パターン](#2.3--20)
* [まとめ](#2.3--21)

