

# ノートと譜面管理 

本ドキュメントでは、譜面データ構造、解析パイプライン、ノート生成ロジック、および位置計算システムについて説明します。譜面ファイルがディスクから読み込まれ、ランタイムデータ構造に変換され、ゲームプレイ中にノートオブジェクトを生成するために使用される仕組みを解説します。ノートインスタンスを再利用するオブジェクトプーリングメカニズムについては[オブジェクトプーリングシステム](#3.3)を参照してください。入力処理と判定ロジックについては[入力システム](#3.4)と[判定メカニクス](#4.1)を参照してください。

---

## 譜面データモデル 

譜面システムは**メタデータ**（楽曲情報）と**シーケンスデータ**（実際のノートパターン）を分離しています。この分離により、楽曲選択シーンでは完全な譜面ファイルを解析せずに軽量なメタデータのみを読み込むことができます。

### コアデータ構造 

```mermaid
classDiagram
    class SongInfo {
        +byte Version
        +string Title
        +string Artist
        +string FolderName
        +string MusicFileName
        +BpmData Bpm
        +SpeedData Speed
        +ScrollData Scroll
        +DifficultyLevelSet DifficultyLevel
        +Texture2D JacketTexture
    }
    class Sequence {
        +List<double> BeatPositions
        +List<int> Lanes
        +List<NoteType> NoteTypes
        +List<bool> IsAttacks
        +List<LongInfo> LongInfo
        +BpmData Bpm
        +SpeedData Speed
        +ScrollData Scroll
        +string Credit
    }
    class LongInfo {
        +List<double> BeatPositions
        +List<int> Lanes
        +List<int> NoteIndex
        +LongType LongType
        +double StartTime
        +double EndTime
        +int StartNoteIndex
    }
    class NoteType {
        «enumeration»
        None
        Tap
        Fuzzy
        LongStart
        LongRelay
        LongEnd
        FuzzyLongStart
        FuzzyLongRelay
        FuzzyLongEnd
    }
    SongInfo ..> Sequence : "解析される"
    Sequence *-- LongInfo : "含む"
    Sequence --> NoteType : "参照"

```

`Sequence`クラスはノートデータをノート位置でインデックス付けされた並列配列として整理します。各ノートには以下があります:

* **BeatPosition**: 拍単位のタイミング（拍位置）
* **Lane**: 水平位置（7レーンの0-6）
* **NoteType**: タップ、ファジー、ロング開始/中継/終了
* **IsAttack**: 視覚効果フラグ

ロングノートは`LongInfo`構造体として別途表現されます。これにはロングノートのパスを定義する拍位置、レーン、ノートインデックスの順序付きリストが含まれます。

---

## 譜面ファイル形式 

ゲームは2つの譜面フォーマットバージョンをサポートします:

| バージョン | 形式 | ノート表現 |
| --- | --- | --- |
| 1 | ロングの識別が連続したアルファベット | ABC,XYZ |
| 2 | ロングの識別が大文字と小文字 | AAa,ZZz |

### バージョン2形式（主要） 

バージョン2は効率的な解析のために1文字エンコーディングを使用します:

| 文字 | 意味 |
| --- | --- |
| `0` | 空 |
| `1` | タップノート |
| `2` | ファジーノート |
| `A-J` | ロングノート開始/中継（通常） |
| `a-j` | ロングノート終了（通常） |
| `Q-Z` | ファジーロング開始/中継 |
| `q-z` | ファジーロング終了 |

**小節例:**

```
1000000  // レーン0にタップ
0000001  // レーン6にタップ
0A00000  // レーン1にロングノート'A'開始
```



---

## 譜面解析パイプライン 

### 高レベルフロー 

```mermaid
flowchart TD

SIL["SongInfoLoader"]
META["楽曲メタデータのみ"]
SR["SequenceReader"]
PARSE["完全な譜面を解析"]
SEQ["Sequenceオブジェクト"]
BPMH["BpmHelper 拍↔時間変換"]
SCROLLH["ScrollHelper スクロール速度計算"]
MG["MusicGame.CallUpdate"]
SPAWN["ノート生成ロジック"]

META -.->|"GameManagerに 保存"| SR
SEQ -.-> BPMH
SEQ -.-> SCROLLH
SEQ -.-> MG
BPMH -.-> SPAWN
SCROLLH -.-> SPAWN

subgraph ランタイム ["ランタイム"]
    MG
    SPAWN
    MG -.-> SPAWN
end

subgraph ヘルパー ["ヘルパー"]
    BPMH
    SCROLLH
end

subgraph ゲームプレイシーン初期化 ["ゲームプレイシーン初期化"]
    SR
    PARSE
    SEQ
    SR -.->|"Read() 完全解析"| PARSE
    PARSE -.-> SEQ
end

subgraph 楽曲選択シーン ["楽曲選択シーン"]
    SIL
    META
    SIL -.->|"ReadAsync() 軽量スキャン"| META
end
```

### SongInfoLoader: メタデータスキャン 

`SongInfoLoader`はディレクトリスキャンを実行して、楽曲選択シーンで楽曲リストを構築します。完全なノートデータではなく、ヘッダータグのみを読み込みます:

1. **ディレクトリ走査**: `ExternalDirectory.SongsPath`を再帰的に検索して`.dl`または`.txt`ファイルを探す
2. **タグ解析**: メタデータタグ（`#TITLE`、`#ARTIST`、`#BPMS`など）を抽出
3. **ジャケット読込**: バナー画像を非同期に読み込む
4. **グループ化**: 楽曲をグループフォルダに整理

```mermaid
flowchart TD

DIR["Songsディレクトリ"]
SCAN["ReadFileText()"]
TAG["LoadSongInfo() タグのみ解析"]
JACKET["CreateJacketTexture() バナー画像読込"]
CACHE["SongInfoCache"]

DIR -.-> SCAN
SCAN -.-> TAG
TAG -.-> JACKET
JACKET -.-> CACHE
```

重要な最適化: `SongInfoLoader`はメタデータ読込中に`#NOTES:`セクションを完全にスキップし、数千のノート位置の高コストな解析を回避します。

### SequenceReader: 完全な譜面解析 

ゲームプレイに入るとき、`SequenceReader`が完全な解析を実行します:

**バージョン2解析アルゴリズム** 

1. **ルックアップテーブル初期化**: 文字→ノートタイプマッピングを事前構築
2. **ステートマシン**: 解析状態を追跡（タグ検索、ノート読込など）
3. **小節処理**: 各小節文字列を個別のノートに解析
4. **ロングノートリンク**: 同じ文字のロングノート開始/中継/終了をマッチング
5. **アタック注釈**: 別個のアタックフラグデータを処理

```mermaid
flowchart TD

START["ファイルテキスト読込"]
INIT["InitLookupTable()"]
STATE1["状態0: #NOTESタグ検索"]
STATE2["状態1: 難易度検索"]
STATE3["状態2: 小節解析"]
MEASURE["ProcessMeasure()"]
CHARS["文字を反復処理"]
LOOKUP["_lookup[char]"]
NOTE["BeatPositions, Lanes, NoteTypesに追加"]
LONG["ロングノートをリンク"]
CONNECT["A-a, B-bなどをマッチング"]
LONGINFO["LongInfoを構築"]
SEQ["Sequenceオブジェクト"]

START -.-> INIT
INIT -.-> STATE1
STATE1 -.-> STATE2
STATE2 -.-> STATE3
STATE3 -.-> MEASURE
MEASURE -.-> CHARS
CHARS -.-> LOOKUP
LOOKUP -.-> NOTE
STATE3 -.-> LONG
LONG -.-> CONNECT
CONNECT -.-> LONGINFO
NOTE -.-> SEQ
LONGINFO -.-> SEQ
```



**ルックアップテーブル最適化**: `_lookup`配列はO(1)の文字からノートタイプへの変換を提供します:

```
_lookup['1'] = { noteType: Tap, ... }
_lookup['A'] = { noteType: LongStart, longIndex: 0, ... }
_lookup['a'] = { noteType: LongEnd, longIndex: 0, ... }
```

これにより、数千のノートを解析する際の繰り返し条件チェックを回避します。

---

## ノート生成システム 

### MusicGameでの生成ロジック 

`MusicGame`クラスはゲームループ中のノート作成を統括します。ノートは画面上に表示されるようになったときに生成されます:

**生成条件** 

:

```mermaid
flowchart TD

UPDATE["MusicGame.CallUpdate(musicTime)"]
BEAT["視覚拍を計算"]
CHECK["NeedsCreateNote()?"]
GET["Pool.Get()"]
SKIP["待機"]
PARAM["SetParam() beatPosition, lane, justTime, noteType"]
CALLBACK["OnSpawnNoteLuaイベント"]
INDEX["_noteIndex++"]
LOOP["このフレームで さらにノート?"]
END["ゲームループ継続"]

UPDATE -.-> BEAT
BEAT -.->|"いいえ"| CHECK
CHECK -.->|"はい: 表示範囲内"| GET
CHECK -.->|"< 32ノート"| SKIP
GET -.-> PARAM
PARAM -.-> CALLBACK
CALLBACK -.-> INDEX
INDEX -.->|"完了"| LOOP
LOOP -.-> CHECK
LOOP -.-> END
```
 

**フレーム予算**: システムは密集したセクション中のフレームドロップを防ぐため、フレームあたり最大`CREATABLE_NOTES_PER_FRAME = 32`ノートを生成します。

### C-MOD vs 標準スクロール 

ゲームは2つのスクロールモードをサポートします:

| モード | 距離計算 | 用途 |
| --- | --- | --- |
| **標準** | 拍ベース（`GameParam.VisibleBeat`） | デフォルトモード、BPM変化に対応 |
| **C-MOD** | 時間ベース（`GameParam.VisibleTime`） | 一定スクロール速度、BPMを無視 |

**可視性チェック** 

```
標準:  visualBeat > noteScrolledBeat - VisibleBeat
C-MOD: musicTime > noteJustTime - VisibleTime
```

ノートが表示されるようになると、`CreateNoteFromObjectPool()`がオブジェクトプールから`NoteController`を取得し、以下で初期化します:

* **beatPosition**: スクロール調整された拍位置
* **justTime**: ノートがヒットされるべき正確な時間
* **lane**: 水平レーン（0-6）
* **noteType**: タップ、ファジー、ロング開始/中継/終了
* **noteIndex**: 判定追跡用のシーケンスインデックス

---

## 位置計算システム 

### 座標変換 

ノートは複数の座標変換を経ます:

```mermaid
flowchart TD

BEAT["拍位置 (double)"]
SCROLL["ScrollHelper"]
VBEAT["視覚拍 (double)"]
CALC["位置計算"]
WORLD["ワールド位置 (Vector3)"]
TIME["楽曲時間 (double)"]
BPMH["BpmHelper"]
STRETCH["SpeedStretchRatio"]
PARAM["GameParam.NoteSpeed"]

BEAT -.-> SCROLL
SCROLL -.-> VBEAT
VBEAT -.-> CALC
CALC -.-> WORLD
TIME -.-> BPMH
BPMH -.-> BEAT
STRETCH -.-> CALC
PARAM -.-> CALC
```



### NoteControllerの位置更新 

**標準モードの位置** 

```c#
diff = beatPosition - currentBeat
posZ = diff * BEAT_DISTANCE * normalizedSpeed * individualSpeed * gameSpeed * speedStretchRatio - (visualOffset + OFFSET_Z)
posX = lane * LANE_DISTANCE - OFFSET_X
```

**C-MODの位置**:

```c#
diff = justTime - musicTime
posZ = diff * TIME_DISTANCE * gameSpeed * speedStretchRatio - offset
```

定数

* `BEAT_DISTANCE = 1.5f`: 拍あたりの単位
* `TIME_DISTANCE = 3f`: 秒あたりの単位
* `LANE_DISTANCE = 0.5f`: レーン間隔
* `OFFSET_X = 1.5f`: 0レーン目の位置オフセット
* `OFFSET_Z`: 判定ライン前後位置のオフセット

**減速カーブ**: `NotesScrollType == Decelerate`のとき、Z位置はカーブアニメーションを通じて再マッピングされ、判定ラインに向かう減速効果を作成します。



### BpmHelper: 拍-時間変換 

`BpmHelper`は可変BPM譜面を処理します:

```mermaid
flowchart TD

BPMDATA["BpmData Positions + BPMs"]
INIT["BpmHelper.Init()"]
BUILD["累積時間 配列を構築"]
CONV1["BeatToTime(beat)"]
INTERP1["二分探索 + 線形補間"]
CONV2["TimeToBeat(time)"]
INTERP2["二分探索 + 線形補間"]

BPMDATA -.-> INIT
INIT -.-> BUILD
CONV1 -.-> INTERP1
CONV2 -.-> INTERP2
```

BPM変化のある譜面では、`BpmHelper`は各BPM変更点で累積時間値を事前計算し、拍と時間ドメイン間の効率的なO(log n)変換を可能にします。



で参照

### ScrollHelper: 速度修飾子 

`ScrollHelper`はギミックベースのスクロール速度変更を適用します:

* **速度変更**: `#SPEEDS:`タグが時間経過に伴う乗数を定義
* **スクロールオフセット**: `#SCROLLS:`タグが位置シフトを定義
* **計算**: `ApplyScroll()`が速度積分とオフセットを累積

これにより、突然の停止、加速、ワープ効果などの譜面ギミックが可能になります。

 

で参照

---

## ロングノート管理 

### LongControllerアーキテクチャ 

ロングノートは複数のノート位置を接続する動的メッシュとしてレンダリングされます:

```mermaid
flowchart TD

LONGINFO["LongInfo BeatPositions[n] Lanes[n] NoteIndex[n]"]
CREATE["CreateMesh()"]
VERTS["頂点生成 位置ごとに2つ (左右エッジ)"]
TRI["三角形生成 セグメントごとに2つ"]
UV["UV生成 長さに沿って0→1"]
UPDATE["CallUpdate(beat)"]
CHECK["範囲内?"]
JUDGE["ホールド状態チェック"]
SKIP["スキップ"]
STRETCH["ApplySpeedStretchRatio()"]
TRANSFORM["メッシュ頂点を更新"]
RENDER["メッシュをレンダリング"]

LONGINFO -.-> CREATE
CREATE -.-> VERTS
VERTS -.-> TRI
TRI -.-> UV
UPDATE -.->|"はい"| CHECK
CHECK -.->|"いいえ"| JUDGE
CHECK -.-> SKIP
JUDGE -.-> STRETCH
STRETCH -.-> TRANSFORM
TRANSFORM -.-> RENDER
```



### メッシュ生成 

**頂点レイアウト** 

N個の位置を持つロングノートの場合、メッシュには以下があります:

* **頂点**: 2N個（位置ごとに左右のエッジ）
* **三角形**: (N-1) × 2 × 3インデックス（セグメントごとに2つの三角形）
* **UV**: X座標はパスに沿った位置にマッピング（0→1）、Y座標は0（左）または1（右）

メッシュは以下のときに再生成されます:

1. ロングノートが最初に生成されたとき
2. プレイヤーが途中セクションでリリースしたとき（後続セグメントを削除）

**ArrayPool最適化**: 頂点配列は`ArrayPool<Vector3>.Shared`から借用され、繰り返しの割り当てを回避します。

### ホールド状態管理 

ロングノートは以下を通じてホールド状態を追跡します:

**状態追跡** 

* `_touchId`: どの指がホールドしているか（-1 = なし）
* `_isHoldState`: 現在ホールド中かどうか
* `_isReleased`: ロングノートが終了したかどうか
* マテリアル: `_disableStencilMaterial`（非ホールド）と`_enableStencilMaterial`（ホールド）を切り替え

**ステンシルマスキング**: ホールド時、ロングノートはステンシルバッファに書き込み、`VisibleHoldController`がステンシルテストを使用して判定ラインに視覚的なインジケータをレンダリングできるようにします。



 

### ロングノートリリース処理 

**リリースロジック**

プレイヤーがロングノート中にリリースしたとき:

**通常ロング（青）**:

* 開始と最後から2番目のセグメント間でリリース: 2つの前方セグメントを削除、中間中継ノートをミスとしてマーク
* 最後から2番目と最後の間でリリース: 最終ノートをミスとしてマーク、ロング完了
* ロングノートはリリース後に再グラブできない

**ファジーロング（緑）**:

* 任意の地点でリリース: 現在のセグメントのみを削除、ノートスプライトは残る
* 任意の後続中継/終了位置で再グラブ可能
* プレイヤーのミスに対してより寛容

---

## ノート状態ライフサイクル 

### NoteControllerステートマシン 

```mermaid
stateDiagram-v2
    [*] --> プール済み

    プール済み --> 生成 : Pool.Get()
    生成 --> アクティブ : Show()

    アクティブ --> 表示中 : 表示開始
    表示中 --> 判定済み : ヒット判定
    表示中 --> ミス : ヒット判定時間を過ぎる

    判定済み --> リリース済み : Release()
    ミス --> リリース済み : Release()

    リリース済み --> 非表示 : Hide()
    非表示 --> プール済み : Pool.Release()
```



**主要な状態フラグ**:

* `_isReleased`: プールに返されたかどうか
* `IsMissed`: このノートがミスされたかどうか（リザルト追跡用）
* `_enableDefaultMove`: ゲームが位置を更新するかどうか（Luaで無効化可能）
* `UpTouchId`: ロング終了ノートの場合、どのタッチがリリースしなければならないか

### SameTimeBar: 同時ノート検出 

`SameTimeBar`システムは同時ノートを検出して視覚化します:

**検出** 

```
OnCreateNote(noteIndex):
  if (beatPosition == previousBeatPosition):
    同時としてマーク
  ノートを接続する水平線を作成
```

これにより、プレイヤーが和音や同時押しを視覚的に識別しやすくなります。


## ゲームループとの統合 

### フレームごとの更新シーケンス 

```mermaid
sequenceDiagram
  participant p1 as MusicGame
  participant p2 as MusicManager
  participant p3 as NoteObjectPool
  participant p4 as LongObjectPool
  participant p5 as NoteController
  participant p6 as LongController

  p1->>p2: GetMusicTime()
  p2-->>p1: musicTime
  p1->>p1: TimeToBeat(musicTime)
  loop 最大32ノート
    p1->>p1: NeedsCreateNote()?
    p1->>p3: Pool.Get()
    p3-->>p1: NoteController
    p1->>p5: SetParam(beat | lane | time)
  end
  p1->>p3: CallUpdate(beat | musicTime)
  p3->>p5: CallUpdate(beat | musicTime)
  p5->>p5: UpdatePosition()
  loop すべてのアクティブなロング
    p1->>p4: CallUpdate(beat | musicTime)
    p4->>p6: CallUpdate(beat | musicTime)
    p6->>p6: ApplySpeedStretchRatio()
  end
```



ゲームループはこの順序でノートを更新します:

1. **新しいノートを生成**: 可視性をチェック、プールから取得、初期化
2. **ノート位置を更新**: 拍/時間をワールド座標に変換
3. **ロングノートを生成**: ロング開始ノートが作成されたとき
4. **ロング位置を更新**: メッシュ頂点を再計算
5. **ロング終了条件をチェック**: 終了拍で自動完了

この順序により、ロングノートが最初のフレームで正しくレンダリングされ、1フレームの位置エラーを防ぎます。

---

## 譜面データアクセスパターン 

### 読み取り専用アクセス 

解析後、`Sequence`データはゲームプレイ中に読み取り専用です:

**インデックスアクセス** 

```
sequence.BeatPositions[_noteIndex]  // O(1)
sequence.Lanes[_noteIndex]          // O(1)
sequence.NoteTypes[_noteIndex]      // O(1)
sequence.IsAttacks[_noteIndex]      // O(1)
```

並列配列構造により、`_noteIndex`がインクリメントされるにつれてキャッシュフレンドリーな順次アクセスが可能になります。

**ロングノート検索**:
ロングノートは`Dictionary<int, int>`を使用して、中継ノートインデックスから開始ノートインデックスへマッピングします

```
_relayLongStartIndex[relayNoteIndex] → startNoteIndex
```

これにより、判定ロジックが中継/終了ノートがどのロングノートに属するかを識別できます。

## ミラーモード 

システムはプレイヤーの好みに応じてレーンミラーリングをサポートします:

**ミラー変換** 

```
各ノートについて:
  newLane = (LANE_COUNT - 1) - oldLane
  
レーン0 ↔ レーン6
レーン1 ↔ レーン5
レーン2 ↔ レーン4
レーン3はレーン3のまま
```

ミラーリングは初期化中、ノートが生成される前に適用され、判定と視覚的な一貫性を保証します。

## まとめ 

ノートと譜面管理システムは、ディスクファイルからレンダリングされたゲームプレイオブジェクトまでの複数段階パイプラインを実装しています:

1. **メタデータ読込**: `SongInfoLoader`がディレクトリをスキャンし、楽曲選択UIのためのヘッダーを解析
2. **完全解析**: `SequenceReader`が最適化されたルックアップテーブルを使用して譜面ファイルを`Sequence`データ構造に変換
3. **生成**: `MusicGame`がノートが表示範囲に入ったときにオブジェクトプールからノートを生成
4. **位置決定**: `NoteController`と`LongController`が拍-時間変換とスクロール修飾子を使用してワールド位置を計算
5. **ロングノートレンダリング**: 動的メッシュ生成が接続されたロングノートの視覚化を作成

システムはパフォーマンス（並列配列、O(1)ルックアップ、オブジェクトプーリング）と柔軟性（Luaコールバック、ギミックサポート、可変BPM）のバランスを取り、60+ FPSで数千のノートを持つ譜面を処理します。


### On this page

* [ノートと譜面管理](#3.2-)
* [譜面データモデル](#3.2--1)
* [コアデータ構造](#3.2--2)
* [譜面ファイル形式](#3.2--3)
* [バージョン2形式（主要）](#3.2-2)
* [譜面解析パイプライン](#3.2--4)
* [高レベルフロー](#3.2--5)
* [SongInfoLoader: メタデータスキャン](#3.2-songinfoloader-)
* [SequenceReader: 完全な譜面解析](#3.2-sequencereader-)
* [ノート生成システム](#3.2--6)
* [MusicGameでの生成ロジック](#3.2-musicgame)
* [C-MOD vs 標準スクロール](#3.2-c-mod-vs-)
* [位置計算システム](#3.2--7)
* [座標変換](#3.2--8)
* [NoteControllerの位置更新](#3.2-notecontroller)
* [BpmHelper: 拍-時間変換](#3.2-bpmhelper--)
* [ScrollHelper: 速度修飾子](#3.2-scrollhelper-)
* [ロングノート管理](#3.2--9)
* [LongControllerアーキテクチャ](#3.2-longcontroller)
* [メッシュ生成](#3.2--10)
* [ホールド状態管理](#3.2--11)
* [ロングノートリリース処理](#3.2--12)
* [ノート状態ライフサイクル](#3.2--13)
* [NoteControllerステートマシン](#3.2-notecontroller-1)
* [SameTimeBar: 同時ノート検出](#3.2-sametimebar-)
* [ゲームループとの統合](#3.2--14)
* [フレームごとの更新シーケンス](#3.2--15)
* [譜面データアクセスパターン](#3.2--16)
* [読み取り専用アクセス](#3.2--17)
* [ミラーモード](#3.2--18)
* [まとめ](#3.2--19)

