

# パッケージ依存関係 

## 目的と範囲 

本ドキュメントでは、プロジェクトで使用されるすべてのUnity Package Manager（UPM）依存関係、そのソース、バージョン指定、プラットフォーム固有の設定について説明します。パッケージマニフェストの構造、依存関係の解決、スコープドレジストリ、スクリプト定義シンボルをカバーします。CRIミドルウェア統合については、[CRIミドルウェア](#10.1)を参照してください。一般的なアセット読込パターンについては、[アセット管理](#9)を参照してください。

---

## パッケージ管理アーキテクチャ 

プロジェクトでは、Unity公式レジストリ、サードパーティスコープドレジストリ（OpenUPM）、Gitリポジトリ、埋め込みローカルパッケージという複数の依存関係ソースを持つUnityのPackage Managerを使用しています。すべての依存関係は`packages-lock.json`によってバージョンロックされ、再現可能なビルドを保証します。

**図: パッケージ依存関係のソース**

```mermaid
flowchart TD

UNITY_REG["Unity公式レジストリ packages.unity.com"]
OPENUPM["OpenUPMレジストリ package.openupm.com"]
GIT["Gitリポジトリ GitHub"]
EMBEDDED["埋め込みパッケージ Packages/フォルダ"]
MANIFEST["manifest.json 依存関係宣言"]
LOCK["packages-lock.json 解決されたバージョン"]
UI["UIフレームワーク TextMeshPro FancyScrollView UIParticle"]
ASSET["アセット管理 Addressables"]
INPUT["入力システム Enhanced Touch"]
LOC["ローカライゼーション"]
DEV["開発ツール Memory Profiler Heap Explorer"]
ANALYTICS["アナリティクス"]

OPENUPM -.->|"提供"| MANIFEST
GIT -.->|"提供"| MANIFEST
EMBEDDED -.->|"提供"| MANIFEST
LOCK -.->|"インストール"| UI
LOCK -.->|"インストール"| ASSET
LOCK -.->|"インストール"| INPUT
LOCK -.->|"インストール"| LOC
LOCK -.->|"インストール"| DEV
LOCK -.-> ANALYTICS

subgraph パッケージカテゴリ ["パッケージカテゴリ"]
    UI
    ASSET
    INPUT
    LOC
    DEV
    ANALYTICS
end

subgraph パッケージマニフェスト ["パッケージマニフェスト"]
    MANIFEST
    LOCK
    MANIFEST -.->|"解決"| LOCK
end

subgraph パッケージソース ["パッケージソース"]
    UNITY_REG
    OPENUPM
    GIT
    EMBEDDED
end
```

## Unity公式パッケージ 

Unityの公式パッケージは、基本的なフレームワーク機能を提供します。これらは`packages.unity.com`から提供され、Unityのバージョニング方式に従います。

### 必須フレームワークパッケージ 

| パッケージ | バージョン | 目的 | 主な依存関係 |
| --- | --- | --- | --- |
| `com.unity.addressables` | 1.21.20 | アセット管理システム | scriptablebuildpipeline, assetbundle, unitywebrequest |
| `com.unity.textmeshpro` | 3.0.9 | 高度なテキストレンダリング | ugui |
| `com.unity.inputsystem` | 1.7.0 | モダンな入力処理 | uielements |
| `com.unity.localization` | 1.3.2 | 多言語サポート | addressables, newtonsoft-json |
| `com.unity.ugui` | 1.0.0 | UIフレームワーク（ビルトイン） | ui, imgui modules |
| `com.unity.timeline` | 1.6.5 | アニメーションシーケンス | audio, director, animation |

### パフォーマンスと開発ツール 

| パッケージ | バージョン | 目的 |
| --- | --- | --- |
| `com.unity.burst` | 1.8.18 | HPC#コードコンパイラ |
| `com.unity.memoryprofiler` | 0.7.1-preview.1 | メモリ分析ツール |
| `com.unity.test-framework` | 1.1.33 | ユニットテストフレームワーク |
| `com.unity.services.analytics` | 6.0.2 | Unity Analytics統合 |

### IDE統合 

```
com.unity.ide.visualstudio: 2.0.26
com.unity.ide.vscode: 1.2.5
```

これらはVisual StudioとVS Codeのスクリプトエディタ統合を提供し、デバッグとIntelliSenseサポートを可能にします。



## サードパーティパッケージ 

### OpenUPMレジストリパッケージ 

プロジェクトでは、スコープドレジストリ設定を使用してOpenUPM（オープンソースUnityパッケージレジストリ）からパッケージを取得します。

**図: OpenUPM統合**

```mermaid
flowchart TD

REGISTRY["OpenUPMレジストリ package.openupm.com"]
UI_PARTICLE["com.coffee.ui-particle 3.3.9"]
FANCY["jp.setchi.fancyscrollview 1.9.0"]
PARTICLE_USAGE["UIパーティクルエフェクト ビジュアルポリッシュ"]
SCROLL_USAGE["楽曲リストスクロール FancyScrollViewベース"]

REGISTRY -.->|"提供"| UI_PARTICLE
REGISTRY -.->|"提供"| FANCY
FANCY -.->|"使用"| SCROLL_USAGE

subgraph コードベースでの使用 ["コードベースでの使用"]
    PARTICLE_USAGE
    SCROLL_USAGE
end

subgraph スコープドパッケージ ["スコープドパッケージ"]
    UI_PARTICLE
    FANCY
end
```

**レジストリ設定:**

```
"scopedRegistries": [  {    "name": "package.openupm.com",    "url": "https://package.openupm.com",    "scopes": [      "com.coffee.ui-particle",      "com.openupm",      "jp.setchi.fancyscrollview"    ]  }]
```

**パッケージ詳細:**

* **`com.coffee.ui-particle` (3.3.9)**: Unity UI（uGUI）上でパーティクルシステムのレンダリングを可能にします。UI要素のビジュアルエフェクトに使用されます。
* **`jp.setchi.fancyscrollview` (1.9.0)**: オブジェクトプーリングとビューポートカリングを備えた最適化されたスクロール可能なリスト実装。楽曲選択スクロールの基礎となります（[楽曲読込と表示](#5.1)参照）。


### Gitリポジトリパッケージ 

2つのパッケージは、安定性のためコミットハッシュをピン留めしてGitリポジトリから直接インストールされます。

**`net.gree.unity-webview`** (コミット: c01a265)

Git URL: `https://github.com/gree/unity-webview.git?path=/dist/package`

Android、iOS、その他のプラットフォーム向けの埋め込みWebブラウザ機能を提供します。アプリケーション内でWebコンテンツを表示するために使用されます（例：オンライン機能、ドキュメント）。

**`com.oddworm.heapexplorer`** (4.1.1, コミット: ed5f4c7)

Git URL: `https://github.com/pschraut/UnityHeapExplorer.git#4.1.1`

ネイティブおよびマネージドメモリ割り当てを分析するためのエディタ専用ツール。パフォーマンスプロファイリングとメモリリーク検出の開発中に使用されます。


## 埋め込みパッケージ 

埋め込みパッケージは`Packages/`ディレクトリに配置され、プロジェクトソースの一部として管理されます。

**図: 埋め込みパッケージ構造**

```mermaid
flowchart TD

PACKAGES_DIR["Packages/ディレクトリ"]
AHP["com.heurekagames.assethunterpro 埋め込みパッケージ"]
UTILS["com.heurekagames.utils 埋め込みパッケージ"]
AHP_FUNC["Asset Hunter Pro 未使用アセット検出"]
UTILS_FUNC["共有ユーティリティ ヘルパー関数"]

AHP -.->|"提供"| AHP_FUNC
UTILS -.->|"提供"| UTILS_FUNC
```

**`com.heurekagames.assethunterpro`**

ソース: `file:com.heurekagames.assethunterpro`

Asset Hunter Proはプロジェクト内の未使用アセットを識別します。ビルド前の肥大化を解消するためのエディタ専用ツールです。

**`com.heurekagames.utils`**

ソース: `file:com.heurekagames.utils`

共有ユーティリティパッケージ。Asset Hunter Proで使用されるヘルパー関数を含んでいると思われます。



---

## Unityモジュール依存関係 

プロジェクトでは、どの機能が利用可能かを制御するために、多くのUnityビルトインモジュールを明示的に宣言しています。

**図: Unityモジュールカテゴリ**

```mermaid
flowchart TD

WEBREQUEST["com.unity.modules.unitywebrequest"]
WEBREQ_AUDIO["com.unity.modules.unitywebrequestaudio"]
WEBREQ_TEXTURE["com.unity.modules.unitywebrequesttexture"]
ANDROID["com.unity.modules.androidjni"]
DIRECTOR["com.unity.modules.director"]
PHYSICS["com.unity.modules.physics"]
PHYSICS2D["com.unity.modules.physics2d"]
XR["com.unity.modules.xr"]
VR["com.unity.modules.vr"]
AUDIO["com.unity.modules.audio"]
VIDEO["com.unity.modules.video"]
ANIMATION["com.unity.modules.animation"]
PARTICLE["com.unity.modules.particlesystem"]
ASSETBUNDLE["com.unity.modules.assetbundle"]
JSON["com.unity.modules.jsonserialize"]
IMAGE["com.unity.modules.imageconversion"]
UI_MOD["com.unity.modules.ui"]
UIELEMENTS["com.unity.modules.uielements"]
IMGUI["com.unity.modules.imgui"]

subgraph Webモジュール ["Webモジュール"]
    WEBREQUEST
    WEBREQ_AUDIO
    WEBREQ_TEXTURE
end

subgraph プラットフォームモジュール ["プラットフォームモジュール"]
    ANDROID
    DIRECTOR
end

subgraph 物理とXR ["物理とXR"]
    PHYSICS
    PHYSICS2D
    XR
    VR
end

subgraph メディアモジュール ["メディアモジュール"]
    AUDIO
    VIDEO
    ANIMATION
    PARTICLE
end

subgraph アセットモジュール ["アセットモジュール"]
    ASSETBUNDLE
    JSON
    IMAGE
end

subgraph コアモジュール ["コアモジュール"]
    UI_MOD
    UIELEMENTS
    IMGUI
end
```

すべてのモジュールはバージョン1.0.0で、`builtin`ソースとしてマークされています。このリズムゲームの主要モジュール:

* **UI**: `ui`, `uielements`, `imgui` - UIレンダリングとエディタツール
* **Audio**: `audio` - コアオーディオ再生（CRIミドルウェアで補完）
* **Video**: `video` - CriManaによる背景動画再生
* **Animation**: `animation`, `director` - タイムラインアニメーション
* **Particles**: `particlesystem` - ビジュアルエフェクト
* **Android**: `androidjni` - Android Java Native Interface


## 依存関係チェーン分析 

一部のパッケージは複雑な推移的依存関係を持っています。これらのチェーンを理解することは、ビルドサイズと互換性にとって重要です。

**図: 主要な依存関係チェーン**

```mermaid
flowchart TD

ADDRESSABLES["com.unity.addressables 1.21.20"]
LOCALIZATION["com.unity.localization 1.3.2"]
ANALYTICS["com.unity.services.analytics 6.0.2"]
SBP["com.unity.scriptablebuildpipeline 1.21.22"]
NEWTONSOFT["com.unity.nuget.newtonsoft-json 3.2.1"]
SERVICES_CORE["com.unity.services.core 1.12.5"]
MOD_ASSETBUNDLE["com.unity.modules.assetbundle"]
MOD_JSON["com.unity.modules.jsonserialize"]
MOD_WEBREQUEST["com.unity.modules.unitywebrequest"]
MOD_ANDROID["com.unity.modules.androidjni"]

ADDRESSABLES -.->|"必要"| SBP
ADDRESSABLES -.->|"必要"| MOD_ASSETBUNDLE
ADDRESSABLES -.->|"必要"| MOD_JSON
ADDRESSABLES -.->|"必要"| MOD_WEBREQUEST
LOCALIZATION -.->|"必要"| ADDRESSABLES
LOCALIZATION -.->|"必要"| NEWTONSOFT
ANALYTICS -.->|"必要"| SERVICES_CORE
ANALYTICS -.->|"必要"| MOD_JSON
```

**主要な依存関係の注意点:**

* **Addressables**はLocalizationとカスタムアセット読込システムにとって重要な依存関係です
* **Newtonsoft.Json**（バージョン3.2.1）はLocalizationパッケージとServicesパッケージの両方によって導入されます
* **Services.Core**はUnityのクラウドサービスの共有依存関係です



---

## プラットフォーム固有の設定 

### スクリプト定義シンボル 

プロジェクトでは、コンパイル時にコードパスを有効/無効にするために、プラットフォーム固有のスクリプト定義を使用しています。

**図: プラットフォームごとのスクリプト定義**

```mermaid
flowchart TD

AND_DEFINES["TMPro DOTWEEN UNITYWEBVIEW_ANDROID_USES_CLEARTEXT_TRAFFIC ELEBEAT_PRODUCT"]
IOS_DEFINES["ELEBEAT_PRODUCT TMPro DOTWEEN"]
PC_DEFINES["ELEBEAT_STAGING DOTWEEN"]
OTHER_DEFINES["DOTWEEN"]
BUILD_CONFIG["ProjectSettings.asset scriptingDefineSymbols"]

subgraph その他のプラットフォーム ["その他のプラットフォーム"]
    OTHER_DEFINES
end

subgraph スタンドアロンPC ["スタンドアロンPC"]
    PC_DEFINES
end

subgraph iOS/tvOS ["iOS/tvOS"]
    IOS_DEFINES
end

subgraph Android ["Android"]
    AND_DEFINES
end
```

**定義シンボルの内訳:**

| シンボル | プラットフォーム | 目的 |
| --- | --- | --- |
| `DOTWEEN` | すべて | DOTweenアニメーションライブラリ統合を有効化 |
| `TMPro` | Android, iOS | TextMeshPro統合（パッケージによって自動定義） |
| `ELEBEAT_PRODUCT` | Android, iOS | プロダクションビルド構成 |
| `ELEBEAT_STAGING` | スタンドアロン | ステージング/開発ビルド構成 |
| `UNITYWEBVIEW_ANDROID_USES_CLEARTEXT_TRAFFIC` | Android | WebViewでHTTP（非HTTPS）を許可 |

**コードでの使用:**

スクリプト定義は条件付きコンパイルを制御します。例:

```
#if ELEBEAT_PRODUCT    // プロダクション専用コード#elif ELEBEAT_STAGING    // ステージング専用コード#endif
```

 

### スクリプティングバックエンド設定 

**Android:** IL2CPPと積極的なストリッピング（レベル4）

```yaml
scriptingBackend:
  Android: 1  // IL2CPP
managedStrippingLevel:
  Android: 4  // 高ストリッピング
```

IL2CPPはC#をC++にコンパイルして、パフォーマンス向上とビルドサイズ削減を実現します。高ストリッピングレベルは未使用コードを積極的に削除します。

**iOS:** IL2CPPとマネージドストリッピング（レベル1）

```yaml
scriptingBackend:
  (iOSではデフォルトでIL2CPP)
managedStrippingLevel:
  iPhone: 1  // 低ストリッピング
```

 

### グラフィックスAPI設定 

**Android:** OpenGL ES 3.0

```yaml
m_BuildTargetGraphicsAPIs:
  - m_BuildTarget: AndroidPlayer
    m_APIs: 0b000000  // OpenGL ES 3.0
    m_Automatic: 0
```

**iOS:** Metal（自動）

```yaml
m_BuildTargetGraphicsAPIs:
  - m_BuildTarget: iOSSupport
    m_APIs: 10000000  // Metal
    m_Automatic: 1
```

MetalはiOSで必須です。OpenGL ES 3.0は、必要な機能をサポートしながらAndroidでの良好な互換性を提供します。

 

---

## コードベースにおける統合ポイント 

### ローカライゼーションシステム統合 

Localizationパッケージは、型安全な文字列キー定数を作成するためのコード生成ツールと統合されています。

**`LocalizationConstantCreator.cs`**は、ローカライゼーション文字列テーブルから定数クラスを生成します:



```sql
CreateConstantClass() -> CreateConstantClassAsync() ->
  GetTableAsync("DKLIKEStringTable") ->
  Create<T>("LocalizationConstant", variableDict, PATH, "")
```

生成された`LocalizationConstant`クラスは、文字列リテラルの代わりにコンパイル時チェックされたキーを提供します。



### Addressables読込 

`AddressableLoader`クラスは、グループベースのアセットライフサイクル管理のためにUnityのAddressables APIをラップしています（[Addressableアセット](#9.1)参照）:

* アセットグループを非同期に読込
* `_assetGroupHandleList`で読込済みグループを追跡
* シーンのアンロード時にグループを解放
* プレハブ、テクスチャ、オーディオのすべてのシーンで使用

 高レベル図、[Addressableアセット](#9.1)

### DOTween統合 

`DOTWEEN`定義は、UI全体でのDOTweenアニメーションライブラリ統合を有効にします:

* UIトランジションとフェード
* リザルトシーンアニメーション
* ノートアニメーション
* メニューパネルアニメーション

DOTweenは、スムーズなUIアニメーションとビジュアルポリッシュにとって重要な依存関係です。

 

### CRIミドルウェア依存関係 

CRIミドルウェア（CriAtom、CriMana）には、UPMを使用しない独自の初期化システムがあります。以下の詳細については[CRIミドルウェア](#10.1)を参照してください:

* `CriWareInitializer`設定
* オーディオとビデオプラグイン統合
* StreamingAssets要件



## ビルドとコンパイル設定 

### コードコンパイル設定 

```yaml
allowUnsafeCode: 1
suppressCommonWarnings: 1
useDeterministicCompilation: 1
enableRoslynAnalyzers: 1
scriptingRuntimeVersion: 1
```

* **`allowUnsafeCode`**: unsafe C#コードを有効化（一部のネイティブプラグインで必要）
* **`suppressCommonWarnings`**: 開発中の警告ノイズを削減
* **`useDeterministicCompilation`**: 同一入力に対して同一出力を保証
* **`enableRoslynAnalyzers`**: より良いコード品質のための静的コード分析

 

### インクリメンタルGC設定 

```yaml
gcIncremental: 1
```

インクリメンタルガベージコレクションは、GC作業を複数のフレームに分散し、リズムゲームの重要なタイミングパスでのヒッチを削減します。


## シェーダーバリアントとグラフィックス 

プロジェクトには、シェーダーをプリロードしてランタイムコンパイルのヒッチを回避するためのカスタムシェーダーバリアントコレクションが含まれています。



は以下のシェーダーバリアントを定義しています:

* ノートレンダリングシェーダー
* インスタンシングサポート付きUIシェーダー
* エミッション付きエフェクトシェーダー

これらは、ゲームプレイ中にシェーダーが最初に表示されたときのフレームドロップを防ぐためにプリロードされます。


## パッケージ更新戦略 

**バージョンロック:** すべてのパッケージは`packages-lock.json`で特定のバージョンにロックされ、Git依存関係にはコミットハッシュが付いています。これにより以下が保証されます:

* 異なるマシン間での再現可能なビルド
* パッケージ更新からの予期しない破壊的変更がない
* 依存関係のアップグレードに対する明示的な制御

**更新プロセス:**

1. `manifest.json`を変更してバージョン制約を変更
2. Unityが新しいバージョンを解決し、`packages-lock.json`を更新
3. ロックファイルの変更をコミットする前に十分にテスト
4. Gitベースのパッケージは手動でハッシュ更新が必要



---

## まとめ表: すべてのパッケージ依存関係 

| パッケージ | バージョン | ソース | カテゴリ |
| --- | --- | --- | --- |
| com.coffee.ui-particle | 3.3.9 | OpenUPM | UI |
| com.oddworm.heapexplorer | 4.1.1 | Git | 開発ツール |
| net.gree.unity-webview | (コミット) | Git | UI |
| com.unity.addressables | 1.21.20 | Unity | アセット管理 |
| com.unity.burst | 1.8.18 | Unity | パフォーマンス |
| com.unity.inputsystem | 1.7.0 | Unity | 入力 |
| com.unity.localization | 1.3.2 | Unity | ローカライゼーション |
| com.unity.memoryprofiler | 0.7.1-preview.1 | Unity | 開発ツール |
| com.unity.services.analytics | 6.0.2 | Unity | アナリティクス |
| com.unity.test-framework | 1.1.33 | Unity | テスト |
| com.unity.textmeshpro | 3.0.9 | Unity | UI |
| com.unity.timeline | 1.6.5 | Unity | アニメーション |
| com.unity.ugui | 1.0.0 | Unityビルトイン | UI |
| jp.setchi.fancyscrollview | 1.9.0 | OpenUPM | UI |
| com.heurekagames.assethunterpro | 埋め込み | 埋め込み | 開発ツール |
| com.heurekagames.utils | 埋め込み | 埋め込み | 開発ツール |
| *(35以上のUnityモジュール)* | 1.0.0 | Unityビルトイン | フレームワーク |

### On this page

* [パッケージ依存関係](#10.2-)
* [目的と範囲](#10.2--1)
* [パッケージ管理アーキテクチャ](#10.2--2)
* [Unity公式パッケージ](#10.2-unity)
* [必須フレームワークパッケージ](#10.2--3)
* [パフォーマンスと開発ツール](#10.2--4)
* [IDE統合](#10.2-ide)
* [サードパーティパッケージ](#10.2--5)
* [OpenUPMレジストリパッケージ](#10.2-openupm)
* [Gitリポジトリパッケージ](#10.2-git)
* [埋め込みパッケージ](#10.2--6)
* [Unityモジュール依存関係](#10.2-unity-1)
* [依存関係チェーン分析](#10.2--7)
* [プラットフォーム固有の設定](#10.2--8)
* [スクリプト定義シンボル](#10.2--9)
* [スクリプティングバックエンド設定](#10.2--10)
* [グラフィックスAPI設定](#10.2-api)
* [コードベースにおける統合ポイント](#10.2--11)
* [ローカライゼーションシステム統合](#10.2--12)
* [Addressables読込](#10.2-addressables)
* [DOTween統合](#10.2-dotween)
* [CRIミドルウェア依存関係](#10.2-cri)
* [プリロードアセット](#10.2--13)
* [ビルドとコンパイル設定](#10.2--14)
* [コードコンパイル設定](#10.2--15)
* [インクリメンタルGC設定](#10.2-gc)
* [シェーダーバリアントとグラフィックス](#10.2--16)
* [パッケージ更新戦略](#10.2--17)
* [まとめ表: すべてのパッケージ依存関係](#10.2--)

