

# フォルダとソートシステム 

## 目的と範囲 

本ドキュメントは、楽曲選択シーン内のフォルダ閲覧および楽曲ソート機能について説明します。これらのシステムにより、ユーザーは楽曲をフォルダにグループ化して整理し、様々なソート条件を適用して楽曲ライブラリをフィルタリングできます。楽曲読込と表示インフラストラクチャについては、[楽曲読込と表示](#5.1)を参照してください。譜面メタデータ解析の詳細については、[譜面情報パネル](#5.3)を参照してください。

フォルダシステムは、ユーザー定義のグループへの階層的な楽曲整理を提供し、ソートシステムは楽曲リストを並べ替えるための複数の基準（タイトル、アーティスト、難易度、スコアなど）を提供します。両システムともスコアデータベースと統合され、フィルタリングと集計統計の表示を可能にします。

---

## システムアーキテクチャ概要 

フォルダシステムとソートシステムは、表示される楽曲リストを変更する並列フィルタリング機構として動作します。フォルダシステムは楽曲をグループ割り当てによってフィルタリングし、ソートシステムはフィルタリングされた結果を並べ替えます。

```mermaid
flowchart TD

%% データソース
SONG_CACHE["SongInfoCache<br/>Instance.Data"]
SCORE_DB["ScoreDataPrefabs<br/>Instance"]
GM["GameManager<br/>GroupFolderNameList"]

%% フォルダ系
FSP["FolderSelectPanel"]
FSM["FolderSelectPanelModel"]
FSV["FolderScrollView"]
FSCORE_VIEW["FolderScoreView"]
FSCORE_CACHE["FolderScoreCache"]
FTEX_LOADER["FolderTextureLoader"]
FTEX_CACHE["FolderTextureCache"]

%% 検索・ソート
SPC["SortPanelController"]
MSORT["MusicSort"]
SORT_OPT["SortOption<br/>CurrentOption"]
CHART_LOADER["ChartInfoLoader"]

MSEARCH["MusicSearch<br/>CurrentOption"]
SEARCH_OPT["SearchOption<br/>FolderIndex"]

%% 出力
SONG_LIST["List<br/>フィルタ & ソート済"]
MSP["MusicSelectScenePresenter"]

%% データ供給
SONG_CACHE --> MSP
SCORE_DB --> MSP
GM --> FSM
GM --> FTEX_LOADER

%% フォルダシステム
FSP -->|使用| FSM
FSP -->|表示| FSV
FSP -->|フォルダ名| FSCORE_VIEW
FSM -->|スコア取得| FSCORE_CACHE
FSM -->|読込| FTEX_LOADER
FTEX_LOADER --> FTEX_CACHE

%% 検索・フィルタ
FSP -->|OnSearch| MSEARCH
MSEARCH -->|FolderIndex| SEARCH_OPT
SEARCH_OPT --> MSP

%% ソートシステム
SPC -->|設定| SORT_OPT
SORT_OPT --> MSORT
SPC -->|トリガー| CHART_LOADER
SPC -->|コールバック| MSORT

%% 楽曲処理
MSORT -->|SortSongs| SONG_LIST
SONG_LIST --> MSP

subgraph データソース ["データソース"]
    SONG_CACHE
    SCORE_DB
    GM
end

subgraph フォルダシステム ["フォルダシステム"]
    FSP
    FSM
    FSV
    FSCORE_VIEW
    FSCORE_CACHE
    FTEX_LOADER
    FTEX_CACHE
end

subgraph 検索/フィルタ ["検索 / フィルタ"]
    MSEARCH
    SEARCH_OPT
end

subgraph ソートシステム ["ソートシステム"]
    SPC
    SORT_OPT
    CHART_LOADER
    MSORT
end

subgraph 出力 ["出力"]
    SONG_LIST
    MSP
end
```



 

 

---

## フォルダ選択システム 

### フォルダ構造と整理 

楽曲は、特殊なシステムフォルダとユーザー定義グループを含む階層的なフォルダ構造に整理されます：

| フォルダタイプ | インデックス | 説明 | テクスチャソース |
| --- | --- | --- | --- |
| All Songs | -1 | 全楽曲を含む仮想フォルダ | Addressable: `TEXTUREALL_SONGS` |
| No Group | 0 (条件付) | グループ割り当てのない楽曲 | Addressable: `TEXTURENO_GROUP` |
| ユーザーフォルダ | 0+ | ユーザー定義フォルダグループ | ファイルシステム: `folder.png/jpg` |

各`SongInfo`オブジェクトには、特定のフォルダにマップする`GroupFolderIndex`フィールドが含まれています。フォルダリストは`GameManager.Instance.GroupFolderNameList`に格納され、グループ化されていない楽曲の有無は`GameManager.Instance.HasNoGroup`で追跡されます。
 

### FolderSelectPanelアーキテクチャ 

フォルダ選択UIは、サポートするキャッシュおよびローダーコンポーネントを持つModel-Viewパターンに従います：

**主要クラス:**

* **FolderSelectPanel**: フォルダ選択UIライフサイクルを管理するメインコントローラー
* **FolderItem**: フォルダ名、楽曲数、テクスチャを含むデータ構造
* **FolderScrollView**: フォルダアイテムの効率的なスクロールのために`FancyScrollView`を拡張
* **FolderScoreView**: 難易度ごとの集計クリア統計（AB/FC/Clearカウント）を表示
 

### フォルダ初期化フロー 

```mermaid
sequenceDiagram
  participant p1 as MusicSelectScenePresenter
  participant p2 as FolderSelectPanel
  participant p3 as FolderTextureLoader
  participant p4 as AddressableLoader
  participant p5 as ファイルシステム
  participant p6 as FolderScrollView

  p1->>p2: InitAsync(onClose | ct)
  p2->>p2: _groupFolderIndex = MusicSearch.CurrentOption.FolderIndex
  p2->>p2: InitFolderScore()
  p2->>p3: LoadTextureAsync(ct)
  loop 各ユーザーフォルダ
    p3->>p5: Directory.GetFiles(folder | "*.png|*.jpg")
  alt 画像ファイルあり
    p5-->>p3: 画像パス
    p3->>p3: TextureLoader.Load(path)
  else 画像なし
    p3->>p4: LoadAsync<Texture>(TEXTURENO_IMAGE)
    p4-->>p3: デフォルトテクスチャ
  end
  end
  p3-->>p2: List<(Texture | bool)>
  p2->>p4: LoadAsync<Texture>(TEXTUREALL_SONGS)
  p4-->>p2: all songsテクスチャ
  opt グループなし楽曲あり
    p2->>p4: LoadAsync<Texture>(TEXTURENO_GROUP)
    p4-->>p2: no groupテクスチャ
  end
  p2->>p2: _folderItemList構築
  p2->>p6: UpdateData(_folderItemList)
  p2->>p6: SelectCellNoScroll(_groupFolderIndex + 1)
```
 

### フォルダスコア集計 

`FolderScoreCache`は、各フォルダ内の全楽曲のスコアデータを集計してフォルダごとの統計を計算します：

```mermaid
flowchart TD

%% 入力データ
SCORE_LIST["ScoreDataPrefabs<br/>ScoreDataList"]
SONG_CACHE["SongInfoCache<br/>Data配列"]

%% 処理ステップ
STEP1["1. songInfoDict 作成<br/>FolderName → GroupFolderIndex"]
STEP2["2. ScoreData 処理<br/>フォルダ名・難易度抽出"]
STEP3["3. MusicScoreData 作成<br/>AB / FC / Clear フラグ付"]
STEP4["4. FolderIndex でグループ化"]
STEP5["5. 難易度ごとカウント集計"]
STEP6["6. 合計計算<br/>All Songs 用 (-1)"]

%% FolderScore
AB["AB<br/>int[5]"]
FC["FC<br/>int[5]"]
CLEAR["Clear<br/>int[5]"]

%% 出力
DICT["Dictionary<br/>FolderScoreDict"]

%% 入力 → 処理
SCORE_LIST --> STEP2
SONG_CACHE --> STEP1
STEP1 --> STEP2
STEP2 --> STEP3
STEP3 --> STEP4
STEP4 --> STEP5
STEP5 --> STEP6

%% FolderScore 集計
STEP5 -->|難易度ごと| AB
STEP5 -->|難易度ごと| FC
STEP5 -->|難易度ごと| CLEAR

%% All Songs 集計
STEP6 -->|key = -1| AB
STEP6 -->|key = -1| FC
STEP6 -->|key = -1| CLEAR

%% 出力生成
AB --> DICT
FC --> DICT
CLEAR --> DICT

subgraph 入力データ ["入力データ"]
    SCORE_LIST
    SONG_CACHE
end

subgraph FolderScoreCache_SetCache ["FolderScoreCache.SetCache()"]
    STEP1
    STEP2
    STEP3
    STEP4
    STEP5
    STEP6
end

subgraph FolderScore ["FolderScore"]
    AB
    FC
    CLEAR
end

subgraph 出力 ["出力"]
    DICT
end

```

**スコア閾値定数:**

| クリア状態 | 閾値 | 説明 |
| --- | --- | --- |
| All Brilliant | `AB_THRESHOLD` (3) | 全てBrilliant判定での完全クリア |
| Full Combo | `FC_THRESHOLD` (2) | ミスなし、コンボ維持 |
| Clear | `CLEAR_THRESHOLD` (1) | 楽曲を正常にクリア |

キャッシュは、フォルダインデックスを`FolderScore`オブジェクトにマップする辞書を構築します。各オブジェクトには3つの配列（AB、FC、Clear）があり、それぞれ長さ5（難易度ごとに1つ）です。特殊キー`-1`は"All Songs"の集計を表します。



 

### テクスチャ読込とキャッシング 

フォルダテクスチャはファイルシステムから読み込まれ、繰り返しのI/Oを避けるためにキャッシュされます：

```mermaid
flowchart TD

LOAD["LoadTextureAsync(ct)"]
FOLDER_DIR["ExternalDirectory.SongsPath/ GroupFolderName/"]
IMG_FILES["*.png, *.jpg, *.jpeg"]
NO_IMG["TEXTURENO_IMAGE フォールバックテクスチャ"]
CACHE["_cache List<(Texture, bool)>"]
HAS_CACHE["HasCacheプロパティ"]
TEX_LOAD["TextureLoader.Load(path)"]
SKIP["再読込スキップ"]

LOAD -.->|"Directory.GetFiles"| FOLDER_DIR

subgraph FolderTextureCache ["FolderTextureCache"]
    CACHE
    HAS_CACHE
    CACHE -.->|"チェック"| HAS_CACHE
end

subgraph Addressables ["Addressables"]
    NO_IMG
end

subgraph ファイルシステム ["ファイルシステム"]
    FOLDER_DIR
    IMG_FILES
end

subgraph FolderTextureLoader ["FolderTextureLoader"]
    LOAD
end
```

各タプルのブール値は、カスタム画像が見つかったか（`true`）、フォールバックが使用されているか（`false`）を示します。これにより、キャッシュクリア時にユーザー読み込みテクスチャのみを適切に破棄できます。



 

---

## ソートシステム 

### ソートタイプと設定 

ソートシステムは、カテゴリに整理された12種類のソート基準をサポートします：

**ソートタイプ列挙:**

| Enum値 | 名前 | 難易度必須 | 譜面情報必須 |
| --- | --- | --- | --- |
| 0 | Folder | いいえ | いいえ |
| 1 | Title | いいえ | いいえ |
| 2 | Artist | いいえ | いいえ |
| 3 | Bpm | いいえ | いいえ |
| 4 | ChartArtist | いいえ | いいえ |
| 5 | Difficulty | はい | いいえ |
| 6 | HighScore | はい | いいえ |
| 7 | LastWriteTime | いいえ | いいえ |
| 8 | TotalNoteCount | はい | はい |
| 9 | YellowNoteCount | はい | はい |
| 10 | BlueNoteCount | はい | はい |
| 11 | GreenNoteCount | はい | はい |

**SortOption構造:**

```
SortOption
├── SortType: SortSongType
├── Difficulty: DifficultyType (Easy/Normal/Hard/Extra/Lunatic)
└── Order: SortUpDownType (Up/Down)
```

静的な`MusicSort.CurrentOption`プロパティは、セッション全体でアクティブなソート設定を維持します。



 

### MusicSortアルゴリズム実装 

`MusicSort`クラスは、楽曲リストへの参照を操作するスイッチベースのソートアルゴリズムを実装します：

```mermaid
flowchart TD

SORT_SONGS["SortSongs(ref songInfoList, nextSortOption)"]
UPDATE_OPT["CurrentOption = nextSortOption"]
USE_CURRENT["CurrentOption使用"]
SWITCH["switch (sortOption.SortType)"]
FOLDER["_songInfos.ToList()"]
TITLE["List.Sort((a,b) => a.Title.CompareTo(b.Title))"]
ARTIST["List.Sort((a,b) => a.Artist.CompareTo(b.Artist))"]
BPM["List.Sort((a,b) => a.BaseBpm.CompareTo(b.BaseBpm))"]
CHART_ART["List.Sort((a,b) => a.ChartArtist.CompareTo(b.ChartArtist))"]
DIFF["a.Difficulty[sortOption.Difficulty]でList.Sort"]
SCORE["songScoreDict検索でOrderBy"]
TIME["a.LastWriteTimeでList.Sort"]
TOTAL["ChartInfoList[difficulty].TotalNoteCountでList.Sort"]
YELLOW["ChartInfoList[difficulty].TapNoteCountでList.Sort"]
BLUE["ChartInfoList[difficulty].LongNoteCountでList.Sort"]
GREEN["ChartInfoList[difficulty].FuzzyNoteCountでList.Sort"]
CHECK_ORDER["Order == Downの場合"]
REVERSE["songInfoList.Reverse()"]
DONE["完了"]

SWITCH -.->|"Bpm"| FOLDER
SWITCH -.->|"ChartArtist"| TITLE
SWITCH -.->|"Difficulty"| ARTIST
SWITCH -.->|"nextSortOption != null"| BPM
SWITCH -.->|"false"| CHART_ART
SWITCH -.->|"HighScore"| DIFF
SWITCH -.->|"else"| SCORE
SWITCH -.->|"LastWriteTime"| TIME
SWITCH -.->|"TotalNoteCount"| TOTAL
SWITCH -.->|"YellowNoteCount"| YELLOW
SWITCH -.->|"BlueNoteCount"| BLUE
SWITCH -.->|"GreenNoteCount"| GREEN
FOLDER -.->|"Artist"| CHECK_ORDER
TITLE -.->|"Title"| CHECK_ORDER
ARTIST -.->|"true"| CHECK_ORDER
BPM -.-> CHECK_ORDER
DIFF -.-> CHECK_ORDER
SCORE -.-> CHECK_ORDER
TIME -.-> CHECK_ORDER
TOTAL -.-> CHECK_ORDER
YELLOW -.-> CHECK_ORDER
BLUE -.-> CHECK_ORDER
GREEN -.-> CHECK_ORDER
REVERSE -.-> DONE
```

**パフォーマンス注記:** 実装は、

のインラインコメントに記載されているように、パフォーマンス向上のためLINQではなく`List.Sort()`を使用します。



### 特殊なソートケース 

**Folderソート:**
楽曲を元の読み込み順序（ファイルシステムトラバーサル順序）で返します。これはシーン読み込み時のデフォルトソートです。

**HighScoreソート:**
`ScoreDataPrefas.GetSongScoreDict(difficulty)`をクエリしてフォルダ名をスコアにマップする辞書を構築し、LINQの`OrderBy`を使用してスコア検索によってソートします：

```c#
// 78-89行
var songScoreDict = ScoreDataPrefas.instance.GetSongScoreDict(sortOption.Difficulty);
_songInfoList = _songInfos.OrderBy(item =>
{    
    var folderName = item.FolderName;    
    if (songScoreDict.TryGetValue(folderName, out int value))    
    {        
        return value;    
    }    
    return 0;
}).ToList();
```

スコアデータがない楽曲には値0が割り当てられ、昇順で最初に表示されます。

**ノート数ソート:**
`ChartInfoList[difficulty]`プロパティ（`TotalNoteCount`、`TapNoteCount`、`LongNoteCount`、`FuzzyNoteCount`）にアクセスします。これらは、`ChartInfoLoader`を介して譜面データを事前に読み込む必要があります。



 

### SortPanelController UI 

ソート設定パネルは、ソートオプションを選択するためのトグルベースのUIを提供します：

```mermaid
flowchart TD

T_FOLDER["_folderToggle"]
T_TITLE["_titleToggle"]
T_ARTIST["_artistToggle"]
T_BPM["_bpmToggle"]
T_CHART_ART["_chartArtistToggle"]
T_DIFF["_difficultyToggle"]
T_SCORE["_highScoreToggle"]
T_TIME["_lastWriteTimeToggle"]
T_TOTAL["_totalNoteCountToggle"]
T_YELLOW["_yellowNoteCountToggle"]
T_BLUE["_blueNoteCountToggle"]
T_GREEN["_greenNoteCountToggle"]
DIFF_OBJ["_difficultyObj GameObject"]
DIFF_TOGGLES["_difficultyToggles Toggle[5]"]
T_UP["_upToggle (昇順)"]
T_DOWN["_downToggle (降順)"]
LOAD_BTN["_loadAllChartInfoButton"]
PROGRESS["_loadingProgressBar _loadingProgressText"]
PANELS["LoadChartPanelType LoadAllChart | Loading | Complete"]
CANCEL["_cancelButton"]
OK["_okButton"]
SORT_OPT_LOCAL["_sortOption (ローカルコピー)"]
SHOW_DIFF["DIFF_OBJ.SetActive(true)"]
CHART_LOAD["ChartInfoLoader LoadAllChartInfoAsync"]
CALLBACK["_onSort?.Invoke(_sortOption)"]
DESTROY["Destroy(gameObject)"]

OK -.->|"onClick"| CALLBACK
CALLBACK -.-> DESTROY

subgraph 状態 ["状態"]
    SORT_OPT_LOCAL
end

subgraph subGraph5 ["SortPanelController UI要素"]

subgraph アクション ["アクション"]
    CANCEL
    OK
end

subgraph 譜面読込 ["譜面読込"]
    LOAD_BTN
    PROGRESS
    PANELS
end

subgraph 順序選択 ["順序選択"]
    T_UP
    T_DOWN
end

subgraph 難易度選択 ["難易度選択"]
    DIFF_OBJ
    DIFF_TOGGLES
end

subgraph ソートタイプトグル ["ソートタイプトグル"]
    T_FOLDER
    T_TITLE
    T_ARTIST
    T_BPM
    T_CHART_ART
    T_DIFF
    T_SCORE
    T_TIME
    T_TOTAL
    T_YELLOW
    T_BLUE
    T_GREEN
end
end
```

**難易度表示ロジック:**

難易度選択UIは、ソートタイプに基づいて表示/非表示が切り替わります。難易度選択が必要なタイプは`SHOW_DIFFICULTY_SET`で定義されています：

```
// 99-107行readonly HashSet<SortSongType> SHOW_DIFFICULTY_SET = new HashSet<SortSongType>(){    SortSongType.Difficulty,    SortSongType.HighScore,    SortSongType.TotalNoteCount,    SortSongType.YellowNoteCount,    SortSongType.BlueNoteCount,    SortSongType.GreenNoteCount,};
```



### 譜面情報読込フロー 

ノート数によるソートには完全な譜面解析が必要です。UIは非同期読み込み機構を提供します：

```mermaid
sequenceDiagram
  participant p1 as ユーザー
  participant p2 as SortPanelController
  participant p3 as ChartInfoLoader
  participant p4 as SongInfoCache
  participant p5 as SequenceReader
  participant p6 as 進捗UI

  p1->>p2: "_loadAllChartInfoButton"クリック
  p2->>p2: SetActiveLoadChartPanel(LoadingChart)
  p2->>p3: LoadAllChartInfoAsync(ct | OnLoadedSong)
  loop 各楽曲
    p3->>p5: ParseChartFile()
    p5-->>p3: ChartInfo (ノート数)
    p3->>p4: ChartInfoListに格納
    p3->>p2: OnLoadedSong(count)
    p2->>p6: 進捗バーとテキスト更新
  end
  p3-->>p2: 完了
  p2->>p2: SetActiveLoadChartPanel(LoadChartComplete)
  p2->>p2: ノート数ソートトグル有効化
  alt ユーザーがキャンセル
    p1->>p2: 操作キャンセル
    p2->>p3: ct.Cancel()でキャンセル
    p3-->>p2: OperationCanceledException
  end
```

進捗は"count / total"として表示され、各楽曲の処理後に更新されます。譜面情報は各`SongInfo`オブジェクトの`ChartInfoList`プロパティに格納され、セッション中キャッシュされたままです。



---

## データフローと統合 

### 楽曲リスト更新パイプライン 

ユーザーインタラクションから楽曲表示の更新までの完全なフロー：

```mermaid
flowchart TD

FOLDER_SEL["フォルダ選択<br/>or<br/>絞り込み"]
SORT_SEL["ソート設定"]

SEARCH_OPT["SearchOption"]
SORT_OPT["SortOption"]

SEARCH_SONGS["SearchSongs()"]
SORT_SONGS["SortSongs()"]

FILTERED["List<br/>フィルタ済"]
SORTED["List<br/>フィルタ & ソート済"]

SCROLL["ScrollView"]
CELL["アクティブセル"]

%% ユーザー操作
FOLDER_SEL --> SEARCH_OPT
SORT_SEL --> SORT_OPT

%% オプション反映
SEARCH_OPT --> SEARCH_SONGS
SORT_OPT --> SORT_SONGS

%% データ処理
SEARCH_SONGS --> FILTERED
FILTERED -->|ソート適用| SORT_SONGS
SORT_SONGS --> SORTED

%% 表示更新
SORTED -->|UpdateData| SCROLL
SORTED -->|SelectCell| CELL

subgraph ユーザーアクション ["ユーザーアクション"]
    FOLDER_SEL
    SORT_SEL
end

subgraph オプション更新 ["オプション更新"]
    SEARCH_OPT
    SORT_OPT
end

subgraph MusicSelectScenePresenter ["MusicSelectScenePresenter"]
    SEARCH_SONGS
    SORT_SONGS
    FILTERED
    SORTED
end

subgraph 表示更新 ["表示更新"]
    SCROLL
    CELL
end
```
 

### ソートオプションリセットロジック 

ソートタイプ間の切り替え時、無効な状態を防ぐために特定のオプションがリセットされます

このリセットは、ノート数ソートがアクティブだが譜面情報が利用できなくなった場合（例：楽曲リストの更新時）に発生します。ソートはデフォルトの`Folder`ソートに`Up`順序で戻ります。

### スコアデータベースとの統合 

両システムは異なる目的で`ScoreDataPrefas`をクエリします：

**フォルダシステム:**

* `FolderScoreCache`は`ScoreDataList`を反復処理してフォルダごとの集計を計算
* スコアIDを解析してフォルダ名と難易度接尾辞を抽出
* `SongInfoCache`検索を介して`GroupFolderIndex`でスコアをグループ化

**ソートシステム:**

* `MusicSort.SortSongs`はHighScoreソート用に`GetSongScoreDict(difficulty)`を呼び出し
* 効率的な検索のためフォルダ名をスコアにマップする辞書を返す
* 存在しないエントリはスコア0にデフォルト設定

スコアIDの形式は`{FolderName}{DifficultyString}`（例："MySongLunatic"）で、これを解析して集計用のフォルダと難易度の両方を決定します。



 

### メモリ管理 

両システムはメモリリークを防ぐためのクリーンアップを実装します

フォルダシステムは自動クリーンアップのためハッシュベースのアドレサブルグループ化を使用し、ソートシステムは非同期操作のためキャンセレーショントークンを管理します。

### On this page

* [フォルダとソートシステム](#5.2-)
* [目的と範囲](#5.2--1)
* [システムアーキテクチャ概要](#5.2--2)
* [フォルダ選択システム](#5.2--3)
* [フォルダ構造と整理](#5.2--4)
* [FolderSelectPanelアーキテクチャ](#5.2-folderselectpanel)
* [フォルダ初期化フロー](#5.2--5)
* [フォルダスコア集計](#5.2--6)
* [テクスチャ読込とキャッシング](#5.2--7)
* [ソートシステム](#5.2--8)
* [ソートタイプと設定](#5.2--9)
* [MusicSortアルゴリズム実装](#5.2-musicsort)
* [特殊なソートケース](#5.2--10)
* [SortPanelController UI](#5.2-sortpanelcontroller-ui)
* [譜面情報読込フロー](#5.2--11)
* [データフローと統合](#5.2--12)
* [楽曲リスト更新パイプライン](#5.2--13)
* [ソートオプションリセットロジック](#5.2--14)
* [スコアデータベースとの統合](#5.2--15)
* [メモリ管理](#5.2--16)

