

# プロジェクト設定 

## 目的と範囲 

このページでは、`ProjectSettings/`および`Packages/`ディレクトリに保存されているUnityプロジェクトレベルの設定について説明します。これらの設定は、ビルドパラメータ、プラットフォーム固有の動作、スクリプトコンパイル、およびサードパーティパッケージの依存関係を制御します。

ランタイムゲーム設定とオプション（ノート速度、表示設定、音量）については、[ゲーム設定管理](#6.1)を参照してください。判定タイミング設定については、[判定タイミング設定](#6.2)を参照してください。

---

## 設定ファイル概要 

プロジェクト設定システムは、Unityがビルド動作と依存関係を制御するために使用する3つの主要なファイルタイプで構成されています。

**設定ファイルとその役割**

| ファイル | 目的 | フォーマット | 変更されるタイミング |
| --- | --- | --- | --- |
| `ProjectSettings.asset` | Unityプロジェクト設定 | YAML | Project Settingsウィンドウまたは手動で |
| `manifest.json` | パッケージ依存関係 | JSON | Package Managerまたは手動で |
| `packages-lock.json` | ロックされたパッケージバージョン | JSON | Unityによって自動的に |
| `GraphicsSettings.asset` | レンダリング設定 | YAML | Graphics Settingsウィンドウで |
| `*.shadervariants` | シェーダープリロードリスト | YAML | ShaderVariantCollectionで |

---

## アプリケーションID設定 

アプリケーションIDは、エンドユーザーとプラットフォームストアに表示される製品メタデータを定義します。

### 製品情報 


```yaml
companyName: ELEBEATproductName: "DKLIKE"
```


```yaml
bundleVersion: 1.1.8
```

### プラットフォーム固有の識別子 

アプリケーションはすべてのプラットフォームで同じバンドル識別子を使用します：


```yaml
applicationIdentifier:  Android: com.ELEBEAT.DKLIKE  Standalone: com.ELEBEAT.DKLIKE  iPhone: com.ELEBEAT.DKLIKE
```

### バージョンコード管理 


```yaml
buildNumber:  Standalone: 0  VisionOS: 0  iPhone: 1.0.0  tvOS: 0AndroidBundleVersionCode: 71
```

**Androidバージョンコード**: Play Storeのリリースごとに増加する必要がある増分整数。現在71。

**iOSビルド番号**: セマンティックバージョニングパターンに従う文字列ベースのバージョン。

---

## プラットフォームビルド設定 

```mermaid
flowchart TD

PS["ProjectSettings Root"]
ANDROID["Android設定"]
IOS["iOS設定"]
STANDALONE["Standalone設定"]
AND_SDK["AndroidMinSdkVersion: 26"]
AND_TARGET["AndroidTargetSdkVersion: 0 (自動)"]
AND_ARCH["AndroidTargetArchitectures: 2 (ARM64)"]
AND_BACKEND["scriptingBackend: 1 (IL2CPP)"]
AND_STRIP["managedStrippingLevel: 4 (高)"]
IOS_SDK["iPhoneSdkVersion: 988"]
IOS_TARGET["iOSTargetOSVersionString: 13.0"]
IOS_STRIP["managedStrippingLevel: 1"]
IOS_ORIENT["横画面のみ"]
STANDALONE_ORIENT["横画面のみ"]
STANDALONE_SCREEN["defaultScreenWidth: 1024 defaultScreenHeight: 768"]

ANDROID -.-> AND_SDK
ANDROID -.-> AND_TARGET
ANDROID -.-> AND_ARCH
ANDROID -.-> AND_BACKEND
ANDROID -.-> AND_STRIP
IOS -.-> IOS_SDK
IOS -.-> IOS_TARGET
IOS -.-> IOS_STRIP
IOS -.-> IOS_ORIENT
STANDALONE -.-> STANDALONE_ORIENT
STANDALONE -.-> STANDALONE_SCREEN

subgraph Standalone設定 ["Standalone設定"]
    STANDALONE_ORIENT
    STANDALONE_SCREEN
end

subgraph iOS設定 ["iOS設定"]
    IOS_SDK
    IOS_TARGET
    IOS_STRIP
    IOS_ORIENT
end

subgraph Android設定 ["Android設定"]
    AND_SDK
    AND_TARGET
    AND_ARCH
    AND_BACKEND
    AND_STRIP
end

subgraph ProjectSettings.asset ["ProjectSettings.asset"]
    PS
    ANDROID
    IOS
    STANDALONE
    PS -.-> ANDROID
    PS -.-> IOS
    PS -.-> STANDALONE
end
```
### Androidプラットフォーム設定 

**最小SDKとアーキテクチャ**

* `AndroidMinSdkVersion: 26` - Android 8.0 Oreo以上をターゲット
* `AndroidTargetSdkVersion: 0` - 自動的に最新の互換APIレベルを使用
* `AndroidTargetArchitectures: 2` - ARM64のみ（32ビットサポートなし）

**ビルドバックエンド**

```yaml
scriptingBackend:  Android: 1il2cppCompilerConfiguration:  Android: 1managedStrippingLevel:  Android: 4
```

* `scriptingBackend: 1` = IL2CPP（Monoではない）
* `il2cppCompilerConfiguration: 1` = リリース設定
* `managedStrippingLevel: 4` = バイナリサイズを最小化するための高レベルストリッピング

**インストール設定**


```yaml
AndroidPreferredInstallLocation: 1
```

値`1` = 利用可能な場合は外部ストレージを優先。

### iOSプラットフォーム設定 

```yaml
iPhoneSdkVersion: 988iOSTargetOSVersionString: 13.0
```

* `iPhoneSdkVersion: 988` = デバイスSDK（シミュレータではない）
* 最小デプロイメントターゲット: iOS 13.0


```yaml
uIRequiresFullScreen: 1uIStatusBarHidden: 1
```

* アプリはステータスバーなしでフルスクリーン実行
* マルチタスク分割画面サポートなし

### 画面向き 

すべてのプラットフォームで横画面専用に設定されています：

```yaml
defaultScreenOrientation: 4allowedAutorotateToPortrait: 0allowedAutorotateToPortraitUpsideDown: 0allowedAutorotateToLandscapeRight: 1allowedAutorotateToLandscapeLeft: 1useOSAutorotation: 1
```

* `defaultScreenOrientation: 4` = 横画面左（デフォルト）
* 縦画面モード無効
* 両方の横画面向きをOS自動回転で有効化

---

## スクリプト定義シンボル 

```mermaid
flowchart TD

ANDROID["Android TMPro;DOTWEEN; UNITYWEBVIEW_ANDROID_USES_CLEARTEXT_TRAFFIC; ELEBEAT_PRODUCT"]
IOS["iPhone ELEBEAT_PRODUCT; TMPro;DOTWEEN"]
STANDALONE["Standalone ELEBEAT_STAGING; DOTWEEN"]
OTHER["その他のプラットフォーム DOTWEEN"]
TMP["TMPro TextMeshPro統合"]
DOT["DOTWEEN Tweenライブラリ"]
WEBVIEW["UNITYWEBVIEW_ANDROID_USES_CLEARTEXT_TRAFFIC HTTPサポート"]
PRODUCT["ELEBEAT_PRODUCT 本番ビルド"]
STAGING["ELEBEAT_STAGING ステージングビルド"]

ANDROID -.-> TMP
ANDROID -.-> DOT
ANDROID -.-> WEBVIEW
ANDROID -.-> PRODUCT
IOS -.-> TMP
IOS -.-> DOT
IOS -.-> PRODUCT
STANDALONE -.-> DOT
STANDALONE -.-> STAGING
OTHER -.-> DOT

subgraph 定義シンボルの目的 ["定義シンボルの目的"]
    TMP
    DOT
    WEBVIEW
    PRODUCT
    STAGING
end

subgraph プラットフォーム定義 ["プラットフォーム定義"]
    ANDROID
    IOS
    STANDALONE
    OTHER
end
```

### 定義シンボルの目的 

| シンボル | プラットフォーム | 目的 |
| --- | --- | --- |
| `DOTWEEN` | すべて | DOTweenトゥイーンアニメーションライブラリ統合を有効化 |
| `TMPro` | Android, iOS | TextMeshProテキストレンダリングシステム |
| `ELEBEAT_PRODUCT` | Android, iOS | 本番ビルド設定 |
| `ELEBEAT_STAGING` | Standalone | ステージング/開発ビルド設定 |
| `UNITYWEBVIEW_ANDROID_USES_CLEARTEXT_TRAFFIC` | Android | WebViewでHTTP（HTTPS以外）接続を許可 |

**ビルド環境の差別化**

`ELEBEAT_PRODUCT`と`ELEBEAT_STAGING`シンボルにより、デプロイメントターゲットに基づいてコードの動作を変えることができます：

* モバイルプラットフォーム（Android/iOS）はアプリストアリリース用に`ELEBEAT_PRODUCT`を使用
* Standaloneビルドは内部テスト用に`ELEBEAT_STAGING`を使用

このパターンは、コードベース全体で条件付きコンパイルに使用されています（例：異なるサーバーURL、デバッグ機能）。

## コンパイラとコードストリッピング設定 

### IL2CPPバックエンド設定 

```yaml
scriptingBackend:  Android: 1il2cppCompilerConfiguration:  Android: 1
```

* `scriptingBackend: 1` = IL2CPP（C#をC++に変換してパフォーマンスとプラットフォームサポートを向上）
* `il2cppCompilerConfiguration: 1` = リリース設定（最適化されたビルド）

### マネージドコードストリッピング 

```yaml
managedStrippingLevel:  Android: 4  EmbeddedLinux: 1  GameCoreScarlett: 1  GameCoreXboxOne: 1  Lumin: 1  Nintendo Switch: 1  PS4: 1  PS5: 1  Stadia: 1  WebGL: 1  Windows Store Apps: 1  XboxOne: 1  iPhone: 1  tvOS: 1
```

**ストリッピングレベル：**

* レベル1 = 低（最小限のストリッピング、ほとんどのコードを保持）
* レベル4 = 高（バイナリサイズを最小化するための積極的なストリッピング）

AndroidはAPKサイズを最小化するためにレベル4（最高）を使用。iOSとその他のプラットフォームは互換性のためにレベル1を使用。

### その他のコンパイラ設定 

```yaml
suppressCommonWarnings: 1allowUnsafeCode: 1useDeterministicCompilation: 1enableRoslynAnalyzers: 1
```

* `allowUnsafeCode: 1` - `unsafe` C#コードブロックを有効化（低レベル相互運用に必要）
* `useDeterministicCompilation: 1` - 一貫したビルド出力を保証
* `enableRoslynAnalyzers: 1` - より良い診断のためにRoslynコードアナライザーを有効化


## グラフィックス設定 

### レンダリングパイプライン 

```yaml
m_RenderingPath: 1m_MobileRenderingPath: 1
```

デスクトップとモバイルの両方で値`1` = フォワードレンダリング（ディファードではない）を使用。これは、シンプルなライティングニーズを持つモバイル向けリズムゲームに適しています。

### グラフィックスAPI選択 

```yaml
m_BuildTargetGraphicsAPIs:  - m_BuildTarget: iOSSupport    m_APIs: 10000000    m_Automatic: 1  - m_BuildTarget: AndroidPlayer    m_APIs: 0b000000    m_Automatic: 0
```

**Android:** OpenGL ES 3.0を使用するように手動設定（値`0b000000` = 16進数で11 = OpenGL ES 3.0）

**iOS:** 自動選択有効（最新デバイスでMetalを使用）

### シェーダープリロード 

プロジェクトは`ShaderVariantCollection`を使用して、起動時に一般的に使用されるシェーダーをプリロードし、ランタイムのヒッチを回避します


このコレクションには以下のバリアントが含まれます：

* ベースシェーダー（キーワードなし）
* インスタンス化レンダリングバリアント（`INSTANCING_ON`）
* エミッシブバリアント（`_EMIT_ON`）

## 入力システム設定 

```yaml
activeInputHandler: 2
```

* `activeInputHandler: 2` = 新しいInput Systemのみ（レガシーInput Managerではない）

これは`com.unity.inputsystem`パッケージ依存関係と、コードベース全体でのタッチ入力処理のための`EnhancedTouch` APIの使用に対応しています。

## パッケージ管理 

```mermaid
flowchart TD

UNITY_REG["Unityレジストリ packages.unity.com"]
OPENUPM["OpenUPMレジストリ package.openupm.com"]
GIT_REPOS["Gitリポジトリ GitHub"]
EMBEDDED["埋め込みパッケージ Packages/フォルダ"]
ADDR["Addressables 1.21.20"]
TMP["TextMeshPro 3.0.9"]
LOC["Localization 1.3.2"]
INPUT["Input System 1.7.0"]
FANCY["FancyScrollView 1.9.0"]
UI_PARTICLE["UI Particle 3.3.9"]
WEBVIEW["Unity WebView"]
HEAP["Heap Explorer 4.1.1"]
ASSET_HUNTER["Asset Hunter Pro"]

OPENUPM -.-> FANCY
OPENUPM -.-> UI_PARTICLE
EMBEDDED -.-> ASSET_HUNTER

subgraph 開発ツール ["開発ツール"]
    HEAP
    ASSET_HUNTER
end

subgraph サードパーティUI ["サードパーティUI"]
    FANCY
    UI_PARTICLE
    WEBVIEW
end

subgraph コアパッケージ ["コアパッケージ"]
    ADDR
    TMP
    LOC
    INPUT
end

subgraph パッケージソース ["パッケージソース"]
    UNITY_REG
    OPENUPM
    GIT_REPOS
    EMBEDDED
end
```
### パッケージ依存関係 
プロジェクトはUnity Package Manager（UPM）を使用して依存関係を管理します。主なカテゴリ：

**Unity公式パッケージ：**

* `com.unity.addressables: 1.21.20` - アセットロードとメモリ管理
* `com.unity.textmeshpro: 3.0.9` - 高度なテキストレンダリング
* `com.unity.localization: 1.3.2` - 多言語サポート
* `com.unity.inputsystem: 1.7.0` - タッチ処理用の新しい入力システム
* `com.unity.burst: 1.8.18` - 高性能コードコンパイル
* `com.unity.timeline: 1.6.5` - カットシーンとアニメーションシーケンシング

**サードパーティUIパッケージ：**

* `jp.setchi.fancyscrollview: 1.9.0` - 最適化されたスクロール可能リスト
* `com.coffee.ui-particle: 3.3.9` - UIでのパーティクルエフェクト
* `net.gree.unity-webview` - 埋め込みウェブブラウザ

**開発ツール：**

* `com.oddworm.heapexplorer: 4.1.1` - メモリプロファイリング（Gitソース）
* `com.unity.memoryprofiler: 0.7.1-preview.1` - メモリ分析
* `com.unity.services.analytics: 6.0.2` - アナリティクス統合


### スコープレジストリ 

OpenUPMは、Unityの公式レジストリで利用できないコミュニティパッケージにアクセスするためのスコープレジストリとして設定されています。これらのスコープに一致するパッケージは、デフォルトレジストリの代わりにOpenUPMから取得されます。

### Gitベースのパッケージ 

2つのパッケージがGitリポジトリから直接ロードされます：

```
"com.oddworm.heapexplorer": "https://github.com/pschraut/UnityHeapExplorer.git#4.1.1","net.gree.unity-webview": "https://github.com/gree/unity-webview.git?path=/dist/package"
```

Gitベースのパッケージは特定のコミットにロックされます：

* HeapExplorer: コミットハッシュ`ed5f4c7e25d796915853fd70ef682c1e2a34a878`
* Unity WebView: コミットハッシュ`c01a265480314a23cd0eb1362eeb5089209bee3e`


### 埋め込みパッケージ 

```
"com.heurekagames.assethunterpro": {  "version": "file:com.heurekagames.assethunterpro",  "depth": 0,  "source": "embedded",  "dependencies": {}},"com.heurekagames.utils": {  "version": "file:com.heurekagames.utils",  "depth": 0,  "source": "embedded",  "dependencies": {}}
```

2つのパッケージが`Packages/`フォルダに直接埋め込まれています：

* Asset Hunter Pro - 未使用アセットを見つけるツール
* Heureka Games Utils - ユーティリティライブラリ

埋め込みパッケージはプロジェクトとともにバージョン管理され、外部から取得されません。


## CRIミドルウェア設定 

プロジェクトはオーディオとビデオ再生にCRIミドルウェアを使用します。設定はProjectSettingsではなく`CriWareInitializer`コンポーネントを通じて処理されます。

### CRI File System設定 



```
public class CriFsConfig {    public int numberOfLoaders    = 16;    public int numberOfBinders    = 8;    public int numberOfInstallers = 2;    public int installBufferSize  = CriFsPlugin.defaultInstallBufferSize / 1024;    public int maxPath            = 256;    public string userAgentString = "";    public bool minimizeFileDescriptorUsage = false;    public bool enableCrcCheck = false;    public int androidDeviceReadBitrate = defaultAndroidDeviceReadBitrate;}
```

主なパラメータ：

* **Loaders:** 16個の同時ファイルロード操作
* **Binders:** 8個のCPKファイルバインディング
* **Android読み込みビットレート:** 50 Mbpsのデフォルトデバイス速度仮定

**ボイスプール設定：**

* 16個のメモリボイス（RAMにロード）
* 8個のストリーミングボイス（ストレージからストリーム）

**プラットフォームバッファ時間：**

* iOS: 50msレイテンシ
* Android: 133msレイテンシ（プラットフォームオーディオスタックのため高い）


* **Decoders:** 8個の同時ビデオデコードストリーム
* **Max Entries:** 4個の連結ビデオセグメント
* **Multithreading:** テクスチャ更新のために常に有効

 

---

## ローカライゼーションコード生成 

プロジェクトは、ローカライゼーションキーのための型安全な定数を作成するコード生成システムを使用します。

### ジェネレータースクリプト 

**処理：**

1. メニューアイテム: `Tools/Create Constant/Localize Key`
2. Play モード中に実行する必要がある
3. Localizationシステムから`DKLIKEStringTable`をロード
4. `Assets/MyProject/Scripts/Constants`に`LocalizationConstant.cs`を生成
5. 各ローカライゼーションキーに対して`public const long`フィールドを作成

**生成されるコードパターン：**

```
public static class LocalizationConstant
{    
    public const long MENU_START = 123456789L;
    public const long MENU_OPTIONS = 123456790L;    
    // ... など
}
```

これにより、文字列リテラルの代わりに、型安全でコンパイル時にチェックされるローカライゼーションキーへの参照が可能になります。

 

---

## プラットフォーム固有設定のまとめ 

### Android固有 

| 設定 | 値 | 目的 |
| --- | --- | --- |
| Min SDK | 26 (Android 8.0) | サポートされる最小OSバージョン |
| ターゲットアーキテクチャ | ARM64のみ | 32ビットサポートなし |
| スクリプティングバックエンド | IL2CPP | パフォーマンスとプラットフォームサポート |
| コードストリッピング | レベル4（高） | APKサイズを最小化 |
| グラフィックスAPI | OpenGL ES 3.0 | 手動選択 |
| CRIオーディオバッファ | 133ms | オーディオ出力レイテンシ |
| Fast Mixer | 有効 | オーディオレイテンシを削減 |

### iOS固有 

| 設定 | 値 | 目的 |
| --- | --- | --- |
| ターゲットOS | 13.0+ | 最小iOSバージョン |
| SDKバージョン | 988（デバイスSDK） | ビルドターゲット |
| フルスクリーン | 必須 | 分割画面サポートなし |
| ステータスバー | 非表示 | 没入型体験 |
| グラフィックスAPI | 自動（Metal） | 最新デバイスでMetalを使用 |
| CRIオーディオバッファ | 50ms | Androidより低レイテンシ |

### Standalone固有 

| 設定 | 値 | 目的 |
| --- | --- | --- |
| デフォルト解像度 | 1024x768 | ウィンドウモードサイズ |
| フルスクリーンモード | フルスクリーンウィンドウ | 排他的フルスクリーンではない |
| ビルド定義 | `ELEBEAT_STAGING` | 開発設定 |
| グラフィックスジョブ | 無効 | 古いGPUとの互換性 |


## 設定管理ワークフロー 

```mermaid
flowchart TD

INSPECTOR["Unity Inspector Project Settingsウィンドウ"]
MANIFEST["manifest.jsonを編集 パッケージの追加/削除"]
UNITY_AUTO["Unity Package Manager packages-lock.jsonを自動更新"]
BUILD_PROCESS["ビルドプロセス ProjectSettings.assetを使用"]
GIT["Gitリポジトリ .assetと.jsonファイルを追跡"]
PS["ProjectSettings.asset"]
LOCK["packages-lock.json"]
BINARY["プラットフォーム固有ビルド APK, IPA, EXE"]

INSPECTOR -.->|"変更"| PS
MANIFEST -.->|"変更"| LOCK
PS -.->|"解決時に更新"| BUILD_PROCESS
LOCK -.-> BUILD_PROCESS
PS -.->|"生成"| GIT
LOCK -.-> GIT
MANIFEST -.-> GIT

subgraph バージョン管理 ["バージョン管理"]
    GIT
end

subgraph 自動更新 ["自動更新"]
    UNITY_AUTO
    BUILD_PROCESS
end

subgraph 手動設定 ["手動設定"]
    INSPECTOR
    MANIFEST
end
```

### 設定ファイルの変更追跡 

**頻繁に変更：**

* `ProjectSettings.asset` - ビルド設定、バージョン番号、またはプラットフォーム設定を変更する時に変更
* `manifest.json` - パッケージ依存関係を追加/削除/更新する時に変更

**自動生成（編集不可）：**

* `packages-lock.json` - パッケージ依存関係を解決する時にUnityが再生成

**まれに変更：**

* `GraphicsSettings.asset` - レンダリング設定やシェーダープリロードを変更する時のみ変更
* `*.shadervariants` - シェーダー使用パターンが変更された時に更新

すべての設定ファイルはバージョン管理に保存され、開発マシンとCI/CDパイプライン間で一貫したビルドを保証します。


### On this page

* [プロジェクト設定](#6.3-)
* [目的と範囲](#6.3--1)
* [設定ファイル概要](#6.3--2)
* [アプリケーションID設定](#6.3-id)
* [製品情報](#6.3--3)
* [プラットフォーム固有の識別子](#6.3--4)
* [バージョンコード管理](#6.3--5)
* [プラットフォームビルド設定](#6.3--6)
* [Androidプラットフォーム設定](#6.3-android)
* [iOSプラットフォーム設定](#6.3-ios)
* [画面向き](#6.3--7)
* [スクリプト定義シンボル](#6.3--8)
* [定義シンボル設定](#6.3--9)
* [定義シンボルの目的](#6.3--10)
* [コンパイラとコードストリッピング設定](#6.3--11)
* [IL2CPPバックエンド設定](#6.3-il2cpp)
* [マネージドコードストリッピング](#6.3--12)
* [その他のコンパイラ設定](#6.3--13)
* [グラフィックス設定](#6.3--14)
* [レンダリングパイプライン](#6.3--15)
* [グラフィックスAPI選択](#6.3-api)
* [シェーダープリロード](#6.3--16)
* [常に含まれるシェーダー](#6.3--17)
* [入力システム設定](#6.3--18)
* [パッケージ管理](#6.3--19)
* [パッケージ依存関係](#6.3--20)
* [スコープレジストリ](#6.3--21)
* [Gitベースのパッケージ](#6.3-git)
* [埋め込みパッケージ](#6.3--22)
* [CRIミドルウェア設定](#6.3-cri)
* [CRI File System設定](#6.3-cri-file-system)
* [CRI Atomオーディオ設定](#6.3-cri-atom)
* [CRI Manaビデオ設定](#6.3-cri-mana)
* [ローカライゼーションコード生成](#6.3--23)
* [ジェネレータースクリプト](#6.3--24)
* [プラットフォーム固有設定のまとめ](#6.3--25)
* [Android固有](#6.3-android-1)
* [iOS固有](#6.3-ios-1)
* [Standalone固有](#6.3-standalone)
* [設定管理ワークフロー](#6.3--26)
* [設定ファイルの変更追跡](#6.3--27)

