

# ライフとスコア管理 

## 目的と範囲 

このドキュメントでは、ゲームプレイ中にプレイヤーのパフォーマンスを追跡するライフゲージ（体力）とスコアリングシステムについて説明します。これらのシステムは`JudgeManager`から判定結果を受け取り、プレイヤーに表示されるリアルタイムフィードバックを計算します。判定の決定方法については、[判定メカニクス](#4.1)を参照してください。ゲームプレイ後の結果の収集と表示については、[リザルトデータ収集](#4.3)を参照してください。

## システム概要 

ライフとスコア管理システムは、ゲームプレイ中の判定イベントに応答するイベント駆動型コンポーネントとして動作します。これらは関心事を分離して管理します：`LifeManager`はプレイヤーの体力と失敗条件を追跡し、`ScoreManager`はパフォーマンススコアとランクを計算し、`ComboManager`（ここでは詳述しない）は連続ヒットを追跡します。3つのシステムはすべてイベントサブスクリプションを通じて判定データを受け取り、独立して状態を更新します。

```mermaid
flowchart TD

JM["JudgeManager"]
OnJudge["OnJudge Event (JudgeType)"]
OnAfterJudge["OnAfterJudge Event (Judge構造体)"]
LM["LifeManager"]
LifeValue["_life: float 0-500の範囲"]
LifeSlider["UI Slider"]
DangerState["_isDanger: bool _isDead: bool"]
LifeHist["LifeHistory 秒単位の記録"]
SM["ScoreManager"]
ScoreCalc["スコア計算 0-1,000,000"]
RankCalc["ランク判定 S+/S/A/B/C"]
ScoreUI["UI表示 Text + Slider + Image"]
SubScore["減算スコア (オプション)"]
CM["ComboManager (詳細は省略)"]
ComboCount["コンボカウンター"]
RD["ResultData"]

OnJudge -.->|"UpdateRecord"| LM
OnAfterJudge -.->|"OnDead event"| SM
OnAfterJudge -.->|"購読"| CM
DangerState -.-> JM
LM -.-> RD
SM -.-> RD
CM -.-> RD
LifeHist -.-> RD

subgraph 出力 ["出力"]
    RD
end

subgraph コンボシステム ["コンボシステム"]
    CM
    ComboCount
end

subgraph スコアシステム ["スコアシステム"]
    SM
    ScoreCalc
    RankCalc
    ScoreUI
    SubScore
    SM -.-> ScoreCalc
    ScoreCalc -.-> RankCalc
    SM -.-> ScoreUI
    SM -.-> SubScore
end

subgraph ライフシステム ["ライフシステム"]
    LM
    LifeValue
    LifeSlider
    DangerState
    LifeHist
    LM -.->|"購読"| LifeValue
    LifeValue -.->|"購読"| LifeSlider
    LifeValue -.-> DangerState
    LM -.-> LifeHist
end

subgraph イベントソース ["イベントソース"]
    JM
    OnJudge
    OnAfterJudge
    JM -.->|"トリガー"| OnJudge
    JM -.->|"トリガー"| OnAfterJudge
end
```



 

 

## ライフ管理システム 

### LifeManagerコンポーネント 

`LifeManager`クラスは0から500の範囲の浮動小数点ライフ値を管理し、プレイヤーは250（半分のライフ）から開始します。ライフは判定の質に基づいて変更され、Unity UIの`Slider`コンポーネントを通じて表示されます。

| 定数 | 値 | 説明 |
| --- | --- | --- |
| `MAX_LIFE` | 500.0 | 最大ライフ値 |
| `DANGER_LIFE` | 100.0 | デンジャー状態の閾値 |
| 開始ライフ | 250.0 | 初期値（MAX_LIFE / 2） |



### ライフ値の計算 

ライフの変化は判定タイプによって決定され、ミスに対しては段階的なペナルティが適用されます。BadとMissedの判定は、現在のライフに比例して増加する動的ペナルティを適用し、すでに低体力の場合は失敗しにくくなります。

```mermaid
flowchart TD

Judge["JudgeType"]
Calc["JudgeTypeToLifeValue"]
Perfect["Perfect/Brilliant +2.0"]
Great["Great +1.0"]
Fast["Fast/Slow +0.0"]
Bad["Bad -10 × (1 + 0.5 × life/500)"]
Missed["Missed -30 × (1 + 0.5 × life/500)"]
Update["UpdateLife"]
Clamp["0-500にクランプ"]
UI["スライダー更新"]

Judge -.-> Calc
Calc -.-> Perfect
Calc -.-> Great
Calc -.-> Fast
Calc -.-> Bad
Calc -.-> Missed
Perfect -.-> Update
Great -.-> Update
Fast -.-> Update
Bad -.-> Update
Missed -.-> Update
Update -.-> Clamp
Clamp -.-> UI
```

ペナルティのスケーリング式は動的な難易度曲線を実装しています：

* 満タン（500）の場合：Bad = -15、Missed = -45
* 半分（250）の場合：Bad = -12.5、Missed = -37.5
* 瀕死（50）の場合：Bad = -10.5、Missed = -31.5

これにより1つのミスで即座に失敗することを防ぎつつ、楽曲全体を通じてプレッシャーを維持します。



 

### 死亡とデンジャー状態 

ライフシステムは2つの重要な状態を追跡します：デンジャー（life ≤ 100）と死亡（life ≤ 0）。デンジャー状態はDOTweenを使用してライフゲージに赤色の点滅アニメーションをトリガーし、死亡時は`OnDead`イベントを即座に発行して`MusicGameSceneController`にゲームオーバーを通知します。

デンジャーアニメーションは、白と赤の間で点滅するループDOTweenカラートゥイーンで実装されています。デンジャー状態を抜けると、トゥイーンは強制終了され、色は白にリセットされます。

### ライフ履歴の記録 

`LifeManager`はリザルト可視化のために時系列でライフ値を記録します。`UpdateRecord`メソッドは毎秒複数回ライフ値をサンプリングし、それらを1秒単位のバケットに平均化して`LifeHistory`に格納します。

```mermaid
flowchart TD

Update["UpdateRecord(musicTime)"]
CheckTime["musicTime >= _second?"]
HasSamples["_secondLifeCache.Count > 0?"]
AddSample["_secondLifeCache.Add(_life)"]
Average["平均を計算 secondTotal / count"]
Skip["Skip"]
Store["_lifeHistory.Add(_second, avg)"]
Clear["_secondLifeCache.Clear()"]
Inc["_second++"]
End["戻る"]

Update -.->|"Yes"| CheckTime
CheckTime -.-> HasSamples
CheckTime -.->|"No"| AddSample
HasSamples -.->|"Yes"| Average
HasSamples -.->|"No"| Skip
Average -.-> Store
Store -.-> Clear
Clear -.-> Inc
Inc -.-> End
AddSample -.-> End
Skip -.-> Inc
```

このアプローチはフレーム間のライフ変動を平滑化し、リザルト画面用のクリーンなグラフを生成します。`LifeHistory`データ構造は、タイムスタンプとライフ値の並列リストを格納します。



 

## スコア管理システム 

### ScoreManagerコンポーネント 

`ScoreManager`は判定の分布に基づいて0から1,000,000のスコアを計算し、ランク指標（S+、S、A、B、C）とともに表示します。スコア更新は、デルタタイム補間を使用して視覚的な魅力のために滑らかにされます。

| 定数 | 値 | 目的 |
| --- | --- | --- |
| `MAX_SCORE` | 1,000,000 | 理論上の満点 |
| `DIGITS` | 7 | ゼロ埋め表示桁数 |
| ランクS+境界 | 990,000 | `Constant.RankBoundary.S_PLUS`から |
| ランクS境界 | 950,000 | `Constant.RankBoundary.S`から |
| ランクA境界 | 900,000 | `Constant.RankBoundary.A`から |
| ランクB境界 | 800,000 | `Constant.RankBoundary.B`から |
| ランクC境界 | 700,000 | `Constant.RankBoundary.C`から |



### スコア計算式 

スコアは、判定タイプの加重平均に最大スコアを乗じて計算されます。各判定タイプは「完璧な」ノートの一部を貢献します。

| 判定 | 比率 | 貢献度 |
| --- | --- | --- |
| Perfect / Brilliant | 1.00 | フルクレジット |
| Great | 0.75 | 4分の3クレジット |
| Fast / Slow | 0.25 | 4分の1クレジット |
| Bad | 0.25 | 4分の1クレジット |
| Missed | 0.00 | クレジットなし |

計算式の実装：

```
score = floor(
    (
        (Perfect + Brilliant) × 1.00 +
        Great × 0.75 +
        (Fast + Slow) × 0.25 +
        Bad × 0.25 +
        Missed × 0.00
    ) / totalNotes × 1,000,000
)
```

これは各判定後に累積`Judge`構造体を受け取る`CalculateScore`で計算されます。



 

### ランク判定 

ランクはスコアの閾値に基づいて割り当てられます。`JudgeRank`メソッドは`RANK_BOUNDARY`配列を反復処理して、スコアが適格となる最高ランクを見つけます。ランクが上昇すると、ランク画像スプライトがスケールアップアニメーションとフェードイン効果で変更されます。

```mermaid
flowchart TD

Score["現在のスコア"]
CheckSP["score >= 990000?"]
SP["ランク0: S+"]
CheckS["score >= 950000?"]
S["ランク1: S"]
CheckA["score >= 900000?"]
A["ランク2: A"]
CheckB["score >= 800000?"]
B["ランク3: B"]
CheckC["score >= 700000?"]
C["ランク4: C"]
D["ランク5: D"]
UpdateUI["ランク画像を更新 アニメーション付き"]

Score -.->|"No"| CheckSP
CheckSP -.->|"Yes"| SP
CheckSP -.->|"No"| CheckS
CheckS -.->|"Yes"| S
CheckS -.->|"No"| CheckA
CheckA -.->|"Yes"| A
CheckA -.->|"No"| CheckB
CheckB -.->|"Yes"| B
CheckB -.->|"No"| CheckC
CheckC -.-> C
CheckC -.-> D
SP -.-> UpdateUI
S -.-> UpdateUI
A -.-> UpdateUI
B -.-> UpdateUI
C -.-> UpdateUI
D -.-> UpdateUI
```

ランク更新アニメーションは、画像を3倍のサイズにスケールし、0.5秒かけて通常サイズにトゥイーンしながら透明から不透明にフェードインします。



 

 

### 減算スコア表示 

システムは`DisplayOption.SubtractedScoreType`で設定可能な2つの減算スコア表示モードをサポートします：

#### タイプ1：最大スコアからのカウントダウン

`1,000,000 - penalty_score`を表示し、ペナルティは次のように計算されます：

```
penalty = ceil(
    (
        (Perfect + Brilliant) × 0.00 +
        Great × 0.25 +
        (Fast + Slow) × 0.75 +
        Bad × 0.75 +
        Missed × 1.00
    ) / totalNotes × 1,000,000
)
```

これは完璧なプレイから「失った」スコアを示します。

#### タイプ2：損失パーセンテージ

次のいずれかを表示：

* Great判定のみが存在する場合（コンボ切れなし）：`-{count}`
* Fast/Slow/Bad/Missedが存在する場合（コンボが切れている）：`-{percent}%`

パーセンテージは同じペナルティ比率式を使用して計算されますが、パーセンテージとして表示されます。



 

 

### ビジュアル更新システム 

スコア表示の更新は、カウントアップアニメーションを作成するためにデルタタイム補間を使用して滑らかにされます。`UpdateViewScore`メソッドは、`_beforeScore < _score`のときに毎フレーム（`CallUpdate`経由で）実行されます：

```mermaid
flowchart TD

Frame["CallUpdateフレーム"]
Check["_beforeScore < _score?"]
Skip["スキップ"]
Calc["diff = _score - _beforeScore _viewScore += diff × deltaTime × 3"]
CheckComplete["_viewScore >= _score?"]
Complete["_viewScore = _score _beforeScore = _score ランク変化を確認"]
Update["_viewScoreを表示"]
RankCheck["ランクが向上?"]
Anim["スケール/フェードアニメ ランクスプライト更新"]
Done["フレーム終了"]

Frame -.-> Check
Check -.->|"No"| Skip
Check -.->|"Yes"| Calc
Calc -.->|"Yes"| CheckComplete
CheckComplete -.->|"No"| Complete
CheckComplete -.->|"No"| Update
Complete -.->|"Yes"| RankCheck
RankCheck -.-> Anim
RankCheck -.-> Update
Anim -.-> Update
Update -.-> Done
Skip -.-> Done
```

補間係数`deltaTime × 3`は、表示されるスコアが実際のスコアに約0.33秒かけて追いつくことを意味し、滑らかなカウント効果を生み出します。



 

## 判定システムとの統合 

ライフとスコアマネージャーは、初期化中に確立されたイベントサブスクリプションを通じて`JudgeManager`と統合します。イベントフローは関心事のクリーンな分離を示しています：

```mermaid
sequenceDiagram
  participant p1 as MusicGame
  participant p2 as JudgeManager
  participant p3 as LifeManager
  participant p4 as ScoreManager
  participant p5 as ComboManager

  note over p1: プレイヤーがノートをヒット
  p1->>p2: JudgeTiming(diffTime | phase | isFuzzy)
  p2->>p2: JudgeTypeを計算
  p2->>p2: OnJudgeEvent(type)
  p2->>p3: OnJudge Event (JudgeType)
  p2->>p2: AddJudge(type)
  p2->>p4: OnAfterJudge Event (Judge)
  p2->>p5: OnAfterJudge Event (Judge)
  p3->>p3: UpdateLife(type)
  p3->>p3: 死亡条件チェック
  alt Life <= 0
    p3->>p2: OnDead Event
  end
  p4->>p4: CalculateScore(judge)
  p4->>p4: 変更されていればランク更新
  p5->>p5: コンボカウンター更新
```

`OnJudge`イベントは判定が記録される前に単一の`JudgeType`で発火し、`LifeManager`などのシステムが即座に反応できるようにします。`OnAfterJudge`イベントは記録後に完全な累積`Judge`構造体で発火し、`ScoreManager`がすべての判定から合計スコアを再計算できるようにします。



 

 

## リザルトデータ構造 

すべてのゲームプレイメトリクスは、ゲームプレイシーンを超えて永続化される`ResultData`オブジェクトに集約されます。この構造はすべてのマネージャーコンポーネントからデータを集約します：

```mermaid
classDiagram
    class ResultData {
        +int Score
        +Judge Judge
        +EarlyLate EarlyLate
        +bool IsDead
        +bool IsFullCombo
        +bool IsAllBrilliant
        +int MaxCombo
        +TimingHistory TimingHistory
        +LifeHistory LifeHistory
        +bool DisableRanking
    }
    class Judge {
        +int Perfect
        +int Brilliant
        +int Great
        +int Fast
        +int Slow
        +int Bad
        +int Missed
    }
    class EarlyLate {
        +int Early
        +int Late
    }
    class TimingHistory {
        +IReadOnlyList<float> MusicTime
        +IReadOnlyList<float> Timing
        +IReadOnlyList<JudgeType> JudgeTypes
        +IReadOnlyList<NoteType> NoteTypes
        +Init(Sequence)
        +Add(musicTime, timing, judgeType, noteType)
    }
    class LifeHistory {
        +List<float> MusicTime
        +List<float> Life
        +Add(second, life)
    }
    ResultData --> Judge
    ResultData --> EarlyLate
    ResultData --> TimingHistory
    ResultData --> LifeHistory
```

`Judge`構造体は各判定タイプのカウントを含み、`TimingHistory`はすべてのノートヒットの正確なタイミングと判定を記録します。`LifeHistory`には秒単位で平均化されたライフゲージの時系列データが含まれます。



 

 

## パフォーマンスの可視化 

### ResultGraphのライフ表示 

リザルトシーンの`ResultGraph`コンポーネントは、タイミング散布図上にオーバーレイされた白い折れ線グラフとしてライフ履歴をレンダリングします。ライフ値はテクスチャの高さに正規化され、アンチエイリアス付きのブレゼンハムの直線アルゴリズムを使用して描画されます。

レンダリングパイプライン：

1. **初期化**：`RawImage`の寸法に合わせた`Texture2D`を作成
2. **背景**：黒で塗りつぶし、ゼロと完璧なタイミングのための灰色のガイドラインを描画
3. **タイミングポイント**：各判定を色付きピクセルとしてプロット（散布図）
4. **ミスライン**：ミスしたノートに対して垂直の赤線を描画
5. **ライフライン**：ライフ履歴データから接続された白い線分を描画
6. **補間**：最初のサンプルが原点から始まらない場合はx=0の点を挿入

ライフデータは生の0-500スケールを使用し、テクスチャの高さに正規化されます：

```
yPixel = clamp(lifeValue / 500.0 × height, 0, height-1)
```



 

### オートタイミング調整 

`ResultAutoTimingPanel`は`TimingHistory`データを使用して平均タイミングオフセットと中央値タイミングオフセットを計算し、自動音声同期キャリブレーションを可能にします。これは2つのモードでタイミングデータを処理します：

| モード | フィルタリング |
| --- | --- |
| ファジー含む | ヒットウィンドウ内のすべてのノートタイプ |
| ファジー除外 | Fuzzy、FuzzyLong*、LongRelayノートを除外 |

ファジーノートの除外により、キャリブレーション計算から寛容な判定が削除され、厳格なプレイヤーに対してより正確なタイミング測定が提供されます。

計算は次の手順を実行します：

1. 有効なヒットウィンドウ内のタイミングをフィルター：`-hitTime < t < hitTime`
2. 各サンプルに現在のタイミングオフセットを追加
3. 平均を計算：`sum(timings) / count`
4. 中央値を計算：`sorted(timings)[count/2]`
5. 両方の値をミリ秒単位で表示
6. ユーザーが平均または中央値を新しいタイミングオフセットとして適用できるようにする



 

 

## APIサーフェス 

### LifeManagerのパブリックメソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `Init()` | - | ライフを250に初期化、UIスライダーをセットアップ |
| `UpdateLife(JudgeType)` | `type` | 判定タイプに基づいてライフを更新 |
| `UpdateRecord(double)` | `musicTime` | 指定時刻の履歴にライフを記録 |
| `GetCurrentLife()` | - | 現在のライフをintで返す |
| `GetMaxLife()` | - | MAX_LIFE定数（500）を返す |
| `SetLife(float)` | `lifeRate` | ライフを最大値のパーセンテージに設定（0.0-1.0） |
| `ReceiveDamage(int)` | `damage` | 固定ダメージ量を減算 |
| `OnFinalize()` | - | トゥイーンをクリーンアップし、キャッシュをクリア |



### ScoreManagerのパブリックメソッド 

| メソッド | パラメータ | 説明 |
| --- | --- | --- |
| `Init()` | - | スコアをリセット、UIをセットアップ、表示オプションをロード |
| `SetTotalNote(int)` | `totalNote` | スコア計算用の総ノート数を設定 |
| `CallUpdate()` | - | 滑らかなスコアカウントのためのフレーム更新 |
| `OnAfterJudge(Judge)` | `judge` | 判定分布からスコアを計算 |



### 主要プロパティ 

```c#
float LifeRate => _life / _maxLifeValue; 
public bool IsDanger => _isDanger;         
bool IsDead => _isDead;     
public LifeHistory LifeHistory => _lifeHistory;
public int Score => _score;         
public int CurrentRank => _currentRank;        
```

### On this page

* [ライフとスコア管理](#4.2-)
* [目的と範囲](#4.2--1)
* [システム概要](#4.2--2)
* [ライフ管理システム](#4.2--3)
* [LifeManagerコンポーネント](#4.2-lifemanager)
* [ライフ値の計算](#4.2--4)
* [死亡とデンジャー状態](#4.2--5)
* [ライフ履歴の記録](#4.2--6)
* [スコア管理システム](#4.2--7)
* [ScoreManagerコンポーネント](#4.2-scoremanager)
* [スコア計算式](#4.2--8)
* [ランク判定](#4.2--9)
* [減算スコア表示](#4.2--10)
* [ビジュアル更新システム](#4.2--11)
* [判定システムとの統合](#4.2--12)
* [リザルトデータ構造](#4.2--13)
* [パフォーマンスの可視化](#4.2--14)
* [ResultGraphのライフ表示](#4.2-resultgraph)
* [オートタイミング調整](#4.2--15)
* [APIサーフェス](#4.2-api)
* [LifeManagerのパブリックメソッド](#4.2-lifemanager-1)
* [ScoreManagerのパブリックメソッド](#4.2-scoremanager-1)
* [主要プロパティ](#4.2--16)

