

# リザルトシーン 

## 目的と範囲 

このドキュメントでは、譜面のクリアまたは失敗後にゲームプレイのパフォーマンスデータを表示する**リザルトシーン**について説明します。このシーンは、スコア、判定、コンボ統計、ランクグレード、およびパフォーマンスの視覚化をアニメーション演出シーケンスを通じて提示します。ローカルスコアの永続化、オンラインランキング送信、およびヒストグラムを通じた詳細なタイミング分析を処理します。

このリザルトデータを生成するゲームプレイシステムについては、[コアゲームプレイシステム](#3)を参照してください。タイトルおよび共有UIコンポーネントについては、[タイトルシーン](#8.1)および[共有UIコンポーネント](#8.3)を参照してください。

---

## シーンアーキテクチャ 

リザルトシーンはMVPパターンに従っており、`ResultLifetimeScope`エントリポイントがプレゼンターをインスタンス化し、依存関係を配線します。

**図: リザルトシーンMVP構造**

```mermaid
flowchart TD

RLS["ResultLifetimeScope (MonoBehaviour)"]
RSP["ResultScenePresenter PresenterBase"]
RSM["ResultSceneModel"]
RSV["ResultSceneView ViewBase"]
RAC["ResultAnimationController"]
RG["ResultGraph"]
RATP["ResultAutoTimingPanel"]
RBGM["ResultBgmController"]
ROP["ResultOnlinePanel"]
RTHC["ResultTimingHistogramController"]
RSHP["ResultScoreHistoryPanel"]
GM["GameManager.Instance"]
RD["ResultData"]
SD["ScoreDataPrefas"]
SDBC["ScoreDataBaseConnector"]

RLS -.->|"制御"| RSP
RLS -.->|"提供"| RSV
RLS -.->|"提供"| RG
RLS -.->|"提供"| RATP
RLS -.->|"提供"| RBGM
RSP -.->|"含む"| RG
RSP -.->|"制御"| RATP
RSP -.->|"含む"| RBGM
RSV -.->|"含む"| RAC
RSV -.->|"含む"| ROP
RSV -.->|"生成"| RTHC
RSV -.-> RSHP
RSM -.->|"読込"| GM
RSM -.->|"アクセス"| RD
RSM -.->|"保存"| SD
RSM -.->|"照会"| SDBC

subgraph データソース ["データソース"]
    GM
    RD
    SD
    SDBC
    GM -.->|"提供"| RD
end

subgraph コントローラーとパネル ["コントローラーとパネル"]
    RAC
    RG
    RATP
    RBGM
    ROP
    RTHC
    RSHP
end

subgraph MVPコア ["MVPコア"]
    RSP
    RSM
    RSV
    RSP -.->|"制御"| RSM
    RSP -.->|"制御"| RSV
end

subgraph シーンエントリ ["シーンエントリ"]
    RLS
end
```



 

 

---

## プレゼンターフロー 

`ResultScenePresenter`は、非同期パイプラインを通じてリザルト演出シーケンス全体を制御します。

**図: リザルト演出シーケンス**

```mermaid
sequenceDiagram
  participant p1 as ResultLifetimeScope
  participant p2 as ResultScenePresenter
  participant p3 as ResultSceneModel
  participant p4 as ResultSceneView
  participant p5 as ResultGraph
  participant p6 as ResultAutoTimingPanel
  participant p7 as ResultBgmController
  participant p8 as FadeManager
  participant p9 as PostRankingtApi

  p1->>p2: Start()
  p2->>p2: RunResultSequenceAsync()
  note over p2: 1. 初期化フェーズ
  p2->>p3: Init()
  p3->>p3: SaveScore()
  p2->>p4: Init()
  p2->>p5: Init()
  p2->>p6: Init()
  p2->>p2: SetEvents()
  note over p2: 2. フェードイン
  p2->>p8: StartFadeInAsync()
  p8-->>p2: 完了
  p2->>p7: Play()
  note over p2: 3. パネルアニメーション
  p2->>p4: ShowMainPanel()
  p4->>p4: ResultAnimationController.ShowMainPanel()
  p4-->>p2: onComplete
  note over p2: 4. スコアアニメーション
  p2->>p4: ShowHighScore()
  p2->>p4: ShowJudge()
  p2->>p4: ShowEarlyLate()
  p2->>p4: ShowRank()
  p2->>p4: PlayScoreAnimation()
  p4->>p4: ResultAnimationController.PlayScoreAnimation()
  p4-->>p2: onComplete
  note over p2: 5. グラフとタイミング
  p2->>p6: SetUp()
  p2->>p6: Open()
  p2->>p5: DrawGraphAsync()
  p5-->>p2: 完了
  note over p2: 6. ランキング送信
  p2->>p9: SendAsync()
  p9-->>p2: onSuccess/onError
  note over p2: 7. 終了
  p2->>p4: NextPanelObj.SetActive(true)
  p2->>p4: SetInteractable_BackSelectMusicButton(true)
```



### 主要プレゼンターメソッド 

| メソッド | 目的 |
| --- | --- |
| `RunResultSequenceAsync()` | すべてのリザルト演出ステップを調整するメイン非同期パイプライン |
| `InitializeModel()` | モデルを初期化し、ローカルデータベースにスコアを保存 |
| `InitializeView()` | 静的UI要素（ジャケット、難易度、クリア状態）をセットアップ |
| `InitializeControllers()` | グラフとタイミングパネルコンポーネントを初期化 |
| `ShowMainPanelAsync()` | メインパネルのフェードインアニメーションを待機 |
| `ShowScoreAnimationAsync()` | スコアカウントアップと判定表示を待機 |
| `SendRankingAsync()` | 条件を満たす場合、オンラインランキングサーバーにスコアを送信 |
| `FinishSceneAsync()` | フェードアウトしてSelectMusicシーンに遷移 |



 

---

## Viewコンポーネント 

`ResultSceneView`は複数のUIパネルとその表示状態を管理します。

**図: Viewコンポーネント階層**

```mermaid
flowchart TD

RSV["ResultSceneView"]
RAC["ResultAnimationController _resultAnimationController"]
MP["_mainPanel (CanvasGroup)"]
SP["_scorePanel (CanvasGroup)"]
JP["_judgePanel (CanvasGroup)"]
UP["_underJudgePanel (CanvasGroup)"]
CP["_comboPanel (CanvasGroup)"]
JOP["ResultJudgeOptionPanel _judgeOptionPanel"]
RTHC["ResultTimingHistogramController _timingHistogramController"]
RSHP["ResultScoreHistoryPanel _scoreHistoryPanel"]
GTC["GroupToggleTextColorController _groupToggleTextColorController"]
ROP["ResultOnlinePanel _resultOnlinePanel"]
RMP["ResultMusicRatePanel _musicRatePanel"]
CSV["ClearStateViewController _clearStateViewController"]
RRP["ResultRankingResultPanel _rankingResultPanel"]
JI["AspectRatioImage _jacketImage"]
TTS["TextScroll _titleTextScroll"]
ATS["TextScroll _artistTextScroll"]
ST["TextMeshProUGUI _scoreText"]
RI["Image _rankImage"]

RSV -.-> RAC
RSV -.-> JOP
RSV -.-> RTHC
RSV -.-> RSHP
RSV -.-> GTC
RSV -.-> ROP
RSV -.-> RMP
RSV -.-> CSV
RSV -.-> RRP
RSV -.-> JI
RSV -.-> TTS
RSV -.-> ATS
RSV -.-> ST
RSV -.-> RI

subgraph 表示要素 ["表示要素"]
    JI
    TTS
    ATS
    ST
    RI
end

subgraph 追加パネル ["追加パネル"]
    ROP
    RMP
    CSV
    RRP
end

subgraph ジャケットエリアパネル ["ジャケットエリアパネル"]
    JOP
    RTHC
    RSHP
    GTC
end

subgraph アニメーションシステム ["アニメーションシステム"]
    RAC
    MP
    SP
    JP
    UP
    CP
    RAC -.-> MP
    RAC -.-> SP
    RAC -.-> JP
    RAC -.-> UP
    RAC -.-> CP
end
```



### ジャケットエリアパネルシステム 

ジャケットエリアは、トグルボタンで制御される3つの切り替え可能なパネルをサポートします：

| パネルタイプ | 目的 | フィールド名 |
| --- | --- | --- |
| JudgeOption (1) | 現在の判定時間設定を表示 | `_judgeOptionPanel` |
| ScoreHistory (2) | トップ10スコアまたはライバルスコアを表示 | `_scoreHistoryPanel` |
| TimingHistogram (3) | KDEを使用したタイミング分布を視覚化 | `_timingHistogramController` |

で管理されます：

```yaml
_jacketAreaIndex: 現在のパネルインデックス (0-3)
ChangeJacketAreaPanel_Next(): 次のパネルに循環
ChangeJacketAreaByIndex(int): 特定のインデックスに切り替え
UpdatePanelVisibility(int): パネルの表示/非表示
```



---

## アニメーションコントローラー 

`ResultAnimationController`は、リザルトパネルの順次フェードインアニメーションを管理します。

**図: アニメーションシーケンス**

```mermaid
flowchart TD

A["MainPanel フェードイン 1.0秒"]
B["ScorePanel スライド + フェード 0.5秒 + 1.0秒"]
C["JudgePanel スライド + フェード 0.5秒 + 1.0秒"]
D["UnderJudgePanel スライド + フェード (並列)"]
E["ComboPanel スライド + フェード 0.5秒 + 1.0秒"]
F["onComplete コールバック"]
G["CountUpScore 1.0秒間"]

A -.-> B
B -.->|"並列"| C
C -.-> D
D -.-> E
E -.-> F
B -.-> G
```



### アニメーションタイムライン 

1. **Main Panel (1.0秒)**: リザルトエリア全体をアルファ0から1へフェード
2. **Score Panel (1.5秒)**: 右から+100pxスライド、フェードイン、スコアカウントアップ開始
3. **Judge Panel (1.5秒)**: 右から+100pxスライド、判定カウントをフェードイン
4. **Under Judge Panel (並列)**: Early/Lateカウントを同時にフェードイン
5. **Combo Panel (1.5秒)**: 右から+100pxスライド、コンボ表示をフェードイン

スコアカウントアップアニメーションは、`UniTask.Yield()`を使用してフレームごとの更新で`CountUpScore()`を介して並列実行されます。



---

## データモデルと永続化 

`ResultSceneModel`は、スコア計算、検証、およびストレージを処理します。

**図: スコア保存フロー**

```mermaid
flowchart TD

RSM["ResultSceneModel"]
GM["GameManager.Instance"]
RD["ResultData"]
SDP["ScoreDataPrefas (LiteDB)"]
SDBC["ScoreDataBaseConnector (player.db)"]
CS["CanSave() 検証"]
JR["JudgeRank() S+/S/A/B/C/F"]
SS["SaveScore()"]
L1["ScoreDataPrefas ベストスコアのみ (JSON)"]
L2["ScoreDataBaseConnector トップ10履歴 (LiteDB)"]

RSM -.->|"Init()"| GM
RSM -.->|"SaveScore()"| CS
SS -.->|"書込"| L1
SS -.->|"書込"| L2
L1 -.->|"保存"| SDP
L2 -.-> SDBC

subgraph 永続化レイヤー ["永続化レイヤー"]
    L1
    L2
end

subgraph 保存ロジック ["保存ロジック"]
    CS
    JR
    SS
    CS -.->|"検証"| SS
    SS -.->|"計算"| JR
end

subgraph データソース ["データソース"]
    GM
    RD
    SDP
    SDBC
    GM -.->|"提供"| RD
end
```



### 保存検証ロジック 

スコア保存には`CanSave()`

のすべての条件が必要です：

```
PlayMode == Normal OR Online
AND ResultData.IsDead == false
AND _canSaveCustomJudgent == true
```

`_canSaveCustomJudgent`が真となるのは：

```
(JudgeTimeOption.IsCustom == false OR JudgeTimeOption.CanSave == true)
AND JudgeTimeOption.MusicRate >= 0.99999f
```



### ランク判定 

ランクは`JudgeRank()`

で境界定数を使用して計算されます：

| ランク | スコア閾値 | 定数 |
| --- | --- | --- |
| S+ | ≥ 950,000 | `Constant.RankBoundary.S_PLUS` |
| S | ≥ 900,000 | `Constant.RankBoundary.S` |
| A | ≥ 800,000 | `Constant.RankBoundary.A` |
| B | ≥ 700,000 | `Constant.RankBoundary.B` |
| C | ≥ 600,000 | `Constant.RankBoundary.C` |
| F | < 600,000 または死亡 | (デフォルト) |



 

---

## スコア履歴システム 

`ScoreDataBaseConnector`は、暗号化されたLiteDBを使用してプレイヤースコア履歴を管理します。

**図: データベーススキーマと操作**

```mermaid
flowchart TD

DB["player.db (LiteDB) パスワード: zXd4hn3fzQBC"]
PS["PlayerScore - Id: int - FolderName: string - Difficulty: int - Score: int - ClearState: int - Date: string"]
GPS["GetPlayerScores() フォルダ+難易度の トップ10を返す"]
SPS["SetPlayerScore() 新しいスコアを挿入 10件超過時削除"]
GRS["GetRivalScores() rival_*.dbファイルを読込 ライバルごとにベストを返す"]

DB -.-> PS
PS -.-> GPS
PS -.-> SPS
PS -.-> GRS

subgraph 操作 ["操作"]
    GPS
    SPS
    GRS
end

subgraph subGraph1 ["コレクション: player_score"]
    PS
end

subgraph データベースファイル ["データベースファイル"]
    DB
end
```



 

### データベース定数 

```
DB_NAME = "player.db"
TABLE_NAME = "player_score"
ENCRYPT_PASSWORD = "zXd4hn3fzQBC"
MAX_SCORE_DATA_COUNT = 10
```



### スコア挿入ロジック 

`SetPlayerScore()`

を介してスコアを保存する場合：

1. この曲/難易度の既存スコアを照会
2. 件数が10以上の場合、新しいスコア > 最小スコアを確認（そうでない場合は拒否）
3. `ScoreDataPrefas`から歴代ベストスコアを挿入（初回のみ）
4. タイムスタンプ付きで現在のプレイスコアを挿入
5. 合計が10を超える場合、最低スコアを削除

日付フィールドは、現在のプレイには`DateTime.UtcNow.ToString()`を使用し、移行された従来のデータには`"[History score]"`を使用します。



---

## タイミングヒストグラム視覚化 

`ResultTimingHistogramController`は、カーネル密度推定（KDE）を使用してタイミングエラー分布を表示します。

**図: ヒストグラム生成パイプライン**

```mermaid
flowchart TD

TH["TimingHistory List<float> Timing List<JudgeType> JudgeTypes"]
RTH["ResultTimingHistogramController"]
HKR["HistogramKDERenderer"]
MED["中央値"]
MODE["最頻値"]
MAE["平均絶対誤差"]
MINMAX["最小/最大"]
BIN["ビンデータ 50-100ビン"]
KDE["KDE曲線 Silverman帯域幅"]
REF["参照線 0ms, ±BrilliantTime"]
TEX["Texture2D RawImage"]

TH -.->|"SetData()"| RTH
HKR -.->|"計算"| MED
HKR -.->|"計算"| MODE
HKR -.->|"計算"| MAE
HKR -.->|"計算"| MINMAX
HKR -.->|"Rebuild()"| BIN

subgraph レンダリング ["レンダリング"]
    BIN
    KDE
    REF
    TEX
    BIN -.-> KDE
    KDE -.-> REF
    REF -.-> TEX
end

subgraph 統計 ["統計"]
    MED
    MODE
    MAE
    MINMAX
end

subgraph 処理 ["処理"]
    RTH
    HKR
    RTH -.->|"RefreshHistogram()"| HKR
end

subgraph 入力 ["入力"]
    TH
end
```



 

### HistogramKDERendererの機能 

レンダラーは高度な統計視覚化を実装します

| 機能 | 実装 |
| --- | --- |
| **ビニング** | データ数に基づく適応的20-100ビン |
| **KDE** | 帯域幅の自動推定にSilvermanの経験則を使用したガウシアンカーネル |
| **カラーコーディング** | `ColorDefine`にマップされた判定タイプ（Brilliant=シアン、Great=黄色、Fast/Slow=緑、Bad=青） |
| **統計** | 中央値、最頻値、平均、標準偏差、平均絶対誤差 |
| **参照線** | 0msで白線、±BrilliantTimeでシアン線 |
| **最適化** | ビンのスタック割り当て、事前計算されたビン→ピクセルマッピング |



 

### KDE帯域幅計算 

Silvermanの経験則

```
σ = min(stdDev, IQR/1.349)
h = 1.06 × σ × n^(-0.2)
```

ここで：

* `stdDev` = タイミングデータの標準偏差
* `IQR` = 四分位範囲（Q75 - Q25）
* `n` = サンプル数

### 判定色付きスタックヒストグラム 

ヒストグラムは判定タイプをスタックバーとしてレンダリングします

1. ビンごとに判定を4カテゴリーにカウント（Bad=0、Fast/Slow=1、Great=2、Brilliant/Perfect=3）
2. 各カテゴリーの密度を計算：`count / (totalCount × binWidth)`
3. ピクセル高さに正規化：`density × scaleFactor`
4. 下から上にスタックレイヤーを描画：青 → 緑 → 黄色 → シアン



---

## オンラインランキング送信 

プレゼンターは、条件を満たす場合にランキングサーバーにスコアを送信します。

**図: ランキング送信フロー**

```mermaid
flowchart TD

V1["GameManager.IsLogin == true"]
V2["GameManager.CanRanking == true"]
V3["Account.accountId HasValue()"]
V4["Model.CanRanking() == true"]
C1["PlayMode == Normal OR Online"]
C2["IsDead == false"]
C3["MusicRate >= 0.999999"]
C4["すべてのJudgeTime値 ≤ デフォルト"]
API["PostRankingtApi"]
MULT["Score × 1000000"]
SEND["SendAsync()"]
SUCC["onSuccess: ShowRankingResult()"]
ERR["onError: ShowRankingErrorDialog()"]

V4 -.->|"合格"| C1
C4 -.->|"有効"| API
SEND -.-> SUCC
SEND -.-> ERR

subgraph レスポンス ["レスポンス"]
    SUCC
    ERR
end

subgraph APIリクエスト ["APIリクエスト"]
    API
    MULT
    SEND
    API -.-> MULT
    MULT -.-> SEND
end

subgraph ランキング条件 ["ランキング条件"]
    C1
    C2
    C3
    C4
    C1 -.->|"AND"| C2
    C2 -.->|"AND"| C3
    C3 -.->|"AND"| C4
end

subgraph 検証チェック ["検証チェック"]
    V1
    V2
    V3
    V4
    V1 -.->|"AND"| V2
    V2 -.->|"AND"| V3
    V3 -.->|"AND"| V4
end
```
 

### スコア乗数 

ランキングスコアは、送信前に`RankingScoreMultiplier = 1000000`で乗算され、0-1,000,000の範囲をサーバー側処理用のより大きな整数に変換します。

---

## 主要ファイルリファレンス 

| ファイルパス | 目的 |
| --- | --- |
| `Assets/MyProject/Scenes/Result.unity` | UI階層を持つシーン構成 |
| `Assets/MyProject/Scripts/ResultScene/MVP/ResultScenePresenter.cs` | メイン演出フローの制御 |
| `Assets/MyProject/Scripts/ResultScene/MVP/ResultSceneView.cs` | パネル管理を持つViewコンポーネント |
| `Assets/MyProject/Scripts/ResultScene/MVP/ResultSceneModel.cs` | データ管理と保存ロジック |
| `Assets/MyProject/Scripts/ResultScene/ResultAnimationController.cs` | 順次パネルアニメーション |
| `Assets/MyProject/Scripts/ResultScene/ScoreDataBaseConnector.cs` | LiteDBスコア履歴操作 |
| `Assets/MyProject/Scripts/ResultScene/ResultTimingHistogramController.cs` | ヒストグラム表示コントローラー |
| `Assets/MyProject/Scripts/ResultScene/HistogramKDERenderer.cs` | KDEベースのヒストグラムレンダリング |
| `Assets/MyProject/Scripts/ResultScene/ResultScoreHistoryPanel.cs` | スコア履歴パネル表示 |
| `Assets/MyProject/Scripts/Model/PlayerScore.cs` | PlayerScoreデータモデル |


### On this page

* [リザルトシーン](#8.2-)
* [目的と範囲](#8.2--1)
* [シーンアーキテクチャ](#8.2--2)
* [プレゼンターフロー](#8.2--3)
* [主要プレゼンターメソッド](#8.2--4)
* [Viewコンポーネント](#8.2-view)
* [ジャケットエリアパネルシステム](#8.2--5)
* [アニメーションコントローラー](#8.2--6)
* [アニメーションタイムライン](#8.2--7)
* [データモデルと永続化](#8.2--8)
* [保存検証ロジック](#8.2--9)
* [ランク判定](#8.2--10)
* [スコア履歴システム](#8.2--11)
* [データベース定数](#8.2--12)
* [スコア挿入ロジック](#8.2--13)
* [タイミングヒストグラム視覚化](#8.2--14)
* [HistogramKDERendererの機能](#8.2-histogramkderenderer)
* [KDE帯域幅計算](#8.2-kde)
* [判定色付きスタックヒストグラム](#8.2--15)
* [オンラインランキング送信](#8.2--16)
* [スコア乗数](#8.2--17)
* [シーンライフサイクルサマリー](#8.2--18)
* [主要ファイルリファレンス](#8.2--19)

