

# リザルトデータ収集 

## 目的と範囲 

このページは、プレイセッション中にゲームプレイのパフォーマンスデータを収集および集約するシステムについて説明します。リザルトデータ収集システムは、詳細なタイミング情報、判定カウント、ライフ履歴、スコア、およびコンボ統計を複数のゲームプレイマネージャーから収集し、それらをリザルトシーンで表示するための統一された`ResultData`オブジェクトにパッケージ化します。

判定タイプの決定方法については、[判定メカニクス](#4.1)を参照してください。ライフとスコアの計算については、[ライフとスコア管理](#4.2)を参照してください。

---

## 概要 

リザルトデータ収集システムは、プレイセッション全体を通して継続的に動作し、以下の用途に使用される詳細なパフォーマンス指標を記録します：

* リザルト画面の可視化
* スコア履歴の追跡
* オートタイミング調整
* パフォーマンス分析
* ランキング送信

**データフロー：ゲームプレイシーンからリザルトシーンへ**

```mermaid
flowchart TD

JM["JudgeManager 判定カウント"]
LM["LifeManager ライフ値"]
SM["ScoreManager スコア計算"]
CM["ComboManager コンボ追跡"]
TH["TimingHistory ノート毎のタイミング"]
LH["LifeHistory 秒毎のライフ"]
RD["ResultData 統一リザルトオブジェクト"]
GM["GameManager.Instance .ResultData"]
RSP["ResultScenePresenter"]
RG["ResultGraph"]
ATP["ResultAutoTimingPanel"]
THC["ResultTimingHistogramController"]

JM -.->|"死亡状態, ライフ履歴"| RD
LM -.->|"スコア"| RD
SM -.->|"保存される"| RD
CM -.->|"最大コンボ"| RD
TH -.->|"詳細タイミングデータ"| RD
LH -.->|"時間経過のライフ"| RD
RD -.->|"取得される"| GM
GM -.->|"取得される"| RSP
GM -.->|"取得される"| RG
GM -.->|"取得される"| ATP
GM -.-> THC

subgraph リザルトシーン ["リザルトシーン"]
    RSP
    RG
    ATP
    THC
end

subgraph 永続化 ["永続化"]
    GM
end

subgraph データ集約 ["データ集約"]
    RD
end

subgraph ゲームプレイシーン ["ゲームプレイシーン"]
    JM
    LM
    SM
    CM
    TH
    LH
end
```

 High-level Diagram 2, 

 

---

## コアデータ構造 

### ResultData 

すべてのゲームプレイリザルト情報の主要なコンテナです。このオブジェクトはプレイセッションの終了時に設定され、リザルトシーンがアクセスするために`GameManager.Instance`に保持されます。

| フィールド | 型 | 説明 |
| --- | --- | --- |
| `Score` | `int` | 最終計算スコア（0-1,000,000） |
| `Judge` | `Judge` | 判定カウントの内訳 |
| `EarlyLate` | `EarlyLate` | 早打ち/遅打ちのカウント |
| `IsDead` | `bool` | プレイヤーのライフが尽きたかどうか |
| `IsFullCombo` | `bool` | すべてのノートをコンボを切らずにヒットしたかどうか |
| `IsAllBrilliant` | `bool` | すべての判定がBrilliantだったかどうか |
| `MaxCombo` | `int` | 達成した最高コンボ数 |
| `TimingHistory` | `TimingHistory` | ノート毎の詳細タイミングデータ |
| `LifeHistory` | `LifeHistory` | 時間経過のライフゲージ値 |
| `DisableRanking` | `bool` | ランキング送信を防止するかどうか |



### Judge構造体 

ゲームプレイ中に受けた各判定タイプのカウントを保存します。

```c#
public struct Judge
{    
    public int Perfect;    
    public int Brilliant;    
    public int Great;    
    public int Fast;    
    public int Slow;    
    public int Bad;    
    public int Missed;
}
```

`Judge`構造体は、ノートが判定されるたびに`JudgeManager`によってインクリメントされ、プレイセッション全体を通じて累積カウントを提供します。

### EarlyLate構造体 

判定が早かったか遅かったかを追跡し、タイミング調整とパフォーマンス分析に使用されます。

```c#
public struct EarlyLate
{    
    public int Early;    
    public int Late;
}
```

これらのカウントは、表示オプションで早打ち/遅打ち表示機能が有効になっており、タイミング差が設定された閾値を超えた場合にのみインクリメントされます。


---

## タイミング履歴の収集 

### TimingHistoryクラス 

ゲームプレイ中にヒットしたすべてのノートについて詳細なタイミング情報を記録し、ゲーム後の分析と可視化を可能にします。

**データ構造**

| リスト | データ型 | 目的 |
| --- | --- | --- |
| `MusicTime` | `float` | 曲の開始からの絶対時間（秒） |
| `Timing` | `float` | タイミング誤差（秒単位、負=早い、正=遅い） |
| `JudgeTypes` | `JudgeType` | 判定結果（Brilliant、Great、Fast、Slow、Bad、Missed） |
| `NoteTypes` | `NoteType` | ノートタイプ（Tap、Fuzzy、LongStart、LongRelay、LongEnd等） |



### 初期化 

`TimingHistory`は、ゲームプレイの開始時に譜面内のノートの総数に一致する容量で初期化され、ゲームプレイ中の動的割り当てを最小限に抑えます：


### タイミングデータの記録 

ノートが判定されるたびに、完全なタイミングコンテキストを記録するために`Add`メソッドが呼び出されます：

timing値は、プレイヤーがノートをヒットしたタイミングと理想的なタイミングとの差を表し、負の値は早打ちを、正の値は遅打ちを示します。

---

## ライフ履歴の収集 

### LifeHistoryクラス 

曲全体を通して1秒間隔でプレイヤーのライフゲージ値を記録し、リザルトグラフでのライフ変化の可視化を可能にします。

**内部記録メカニズム**

```mermaid
flowchart TD

UpdateLife["LifeManager.UpdateLife()"]
Cache["_secondLifeCache List<float>"]
UpdateRecord["LifeManager.UpdateRecord()"]
Average["キャッシュから 平均値を計算"]
LH["LifeHistory.Add() musicTime, avgLife"]

Average -.->|"キャッシュをクリア"| Cache

subgraph 秒毎の集約 ["秒毎の集約"]
    UpdateRecord
    Average
    LH
    UpdateRecord -.->|"毎秒"| Average
    Average -.-> LH
end

subgraph フレーム毎の更新 ["フレーム毎の更新"]
    UpdateLife
    Cache
    UpdateLife -.->|"現在のライフを追加"| Cache
end
```



### LifeManagerでの実装 

`LifeManager`は、各秒内のライフ値の一時キャッシュを維持し、次に平均値を`LifeHistory`に記録します：

このアプローチは、フレーム毎のライフ値の変動を平滑化し、リザルトグラフでよりクリーンな可視化を提供します。

---

## 判定カウントの追跡 

### JudgeManagerの統合 

`JudgeManager`は、ゲームプレイ全体を通じて各判定タイプの実行カウントを維持します。ノートが判定されるたびに、対応するカウンターがインクリメントされます

### 早打ち/遅打ちの追跡 

早打ち/遅打ち表示機能が有効になっている場合、`JudgeManager`は判定が早かったか遅かったかも追跡します：

「早い」または「遅い」としてカウントされる閾値は設定可能で、楽曲レート設定を尊重します。



---

## スコアとコンボの集約 

### ScoreManager 

`ScoreManager`は`JudgeManager.OnAfterJudge`イベントをサブスクライブし、判定カウントに基づいて現在のスコアを維持します：

最終スコアは、各判定タイプに対する重み付けされた比率を使用して計算され、最大可能スコアは1,000,000点です。

### ComboManager 

`ComboManager`は現在のコンボを追跡し、プレイセッション中に到達した最大コンボを記録します。この最大コンボ値は`ResultData`に含まれます。

## リザルトデータの組み立て 

### データ集約フロー 

```mermaid
flowchart TD

JM["JudgeManager _judge: Judge _earlyLate: EarlyLate"]
LM["LifeManager _isDead: bool _lifeHistory: LifeHistory"]
SM["ScoreManager _score: int"]
CM["ComboManager _maxCombo: int"]
MG["MusicGame _timingHistory: TimingHistory"]
MGSC["MusicGameSceneController OnGameComplete()"]
RD["ResultDataオブジェクト"]
RD_Score["Score"]
RD_Judge["Judge"]
RD_EL["EarlyLate"]
RD_Dead["IsDead"]
RD_FC["IsFullCombo"]
RD_AB["IsAllBrilliant"]
RD_Combo["MaxCombo"]
RD_TH["TimingHistory"]
RD_LH["LifeHistory"]
GM["GameManager.Instance .ResultData"]

JM -.->|"早/遅カウント"| MGSC
JM -.->|"死亡状態"| MGSC
LM -.->|"ライフ履歴"| MGSC
LM -.->|"最終スコア"| MGSC
SM -.->|"最大コンボ"| MGSC
CM -.->|"タイミング履歴"| MGSC
MG -.->|"割り当てられる"| MGSC
MGSC -.->|"判定カウント"| RD
RD -.-> GM

subgraph ストレージ ["ストレージ"]
    GM
end

subgraph リザルトデータ ["リザルトデータ"]
    RD
    RD_Score
    RD_Judge
    RD_EL
    RD_Dead
    RD_FC
    RD_AB
    RD_Combo
    RD_TH
    RD_LH
    RD -.-> RD_Score
    RD -.-> RD_Judge
    RD -.-> RD_EL
    RD -.-> RD_Dead
    RD -.-> RD_FC
    RD -.-> RD_AB
    RD -.-> RD_Combo
    RD -.-> RD_TH
    RD -.-> RD_LH
end

subgraph ゲーム終了 ["ゲーム終了"]
    MGSC
end

subgraph 個別マネージャー ["個別マネージャー"]
    JM
    LM
    SM
    CM
    MG
end
```

 High-level Diagram 2, 

### クリア状態フラグ 

`ResultData`オブジェクトには、プレイセッションの結果を要約するブール型フラグが含まれています：

| フラグ | 条件 |
| --- | --- |
| `IsDead` | プレイ中にライフゲージがゼロに達した |
| `IsFullCombo` | コンボを切らずにすべてのノートをヒットした |
| `IsAllBrilliant` | すべての判定がBrilliantだった（完璧なプレイ） |

これらのフラグは、リザルトシーンで適切なクリア状態インジケーターを表示し、スコア保存の適格性を決定するために使用されます。



---

## リザルトシーンでの使用 

### アクセスパターン 

リザルトシーンは、`GameManager.Instance.ResultData`から収集されたデータを取得します

### 可視化コンポーネント 

複数のリザルトシーンコンポーネントが、収集されたデータの異なる部分を使用します：

**ResultGraph**

タイミングとライフ履歴を可視化します

**ResultAutoTimingPanel**

タイミング履歴を使用してオートタイミング調整の提案を計算します：

**ResultTimingHistogramController**

ヒストグラムと統計分析を生成します

---

## 永続化ストレージ 

### スコアデータベース統合 

リザルトシーンでの表示後、`ResultData`の関連部分は、スコア履歴追跡のために永続化ストレージに保存されます

`TimingHistory`と`LifeHistory`はデータベースに永続化されません。要約統計（スコア、コンボ、クリア状態）のみが長期保存されます。

---

## パフォーマンスに関する考慮事項 

### メモリ割り当て戦略 

ゲームプレイ中のガベージコレクションを最小限に抑えるため、データ収集システムは譜面サイズに基づいてコレクションを事前割り当てします：

* `TimingHistory`のリストは`sequence.BeatPositions.Count`に一致するようにサイズ設定されます
* `LifeHistory`は毎秒クリアされる小さなキャッシュを使用します
* 判定カウンターは値型（`Judge`、`EarlyLate`構造体）を使用してヒープ割り当てを回避します

### データアクセスパターン 

リザルトシーンは、読み取り専用プロパティを通じて`ResultData`にアクセスします：

```c#
public IReadOnlyList<float> MusicTime => _musicTime;
public IReadOnlyList<float> Timing => _timing;
public IReadOnlyList<JudgeType> JudgeTypes => _judgeTypes;
public IReadOnlyList<NoteType> NoteTypes => _noteTypes;
```

**注意:** これらの`IReadOnlyList`インターフェースは、`foreach`で使用するとガベージを生成します。コードベースのドキュメントでは、パフォーマンスが重要なコードでこれらのコレクションを反復処理する場合は、`for`ループを使用することを推奨しています。

---

## サマリーテーブル 

| コンポーネント | 責任 | ResultDataに提供されるデータ |
| --- | --- | --- |
| `JudgeManager` | 判定カウントと早/遅統計の追跡 | `Judge`、`EarlyLate` |
| `LifeManager` | ライフゲージの監視と履歴記録 | `IsDead`、`LifeHistory` |
| `ScoreManager` | 判定からのスコア計算 | `Score` |
| `ComboManager` | コンボチェーンの追跡 | `MaxCombo` |
| `TimingHistory` | ノート毎のタイミング詳細の記録 | `TimingHistory` |
| `MusicGame` | クリア状態フラグの決定 | `IsFullCombo`、`IsAllBrilliant` |

### On this page

* [リザルトデータ収集](#4.3-)
* [目的と範囲](#4.3--1)
* [概要](#4.3--2)
* [コアデータ構造](#4.3--3)
* [ResultData](#4.3-resultdata)
* [Judge構造体](#4.3-judge)
* [EarlyLate構造体](#4.3-earlylate)
* [タイミング履歴の収集](#4.3--4)
* [TimingHistoryクラス](#4.3-timinghistory)
* [初期化](#4.3--5)
* [タイミングデータの記録](#4.3--6)
* [ライフ履歴の収集](#4.3--7)
* [LifeHistoryクラス](#4.3-lifehistory)
* [LifeManagerでの実装](#4.3-lifemanager)
* [判定カウントの追跡](#4.3--8)
* [JudgeManagerの統合](#4.3-judgemanager)
* [早打ち/遅打ちの追跡](#4.3--9)
* [スコアとコンボの集約](#4.3--10)
* [ScoreManager](#4.3-scoremanager)
* [ComboManager](#4.3-combomanager)
* [リザルトデータの組み立て](#4.3--11)
* [データ集約フロー](#4.3--12)
* [クリア状態フラグ](#4.3--13)
* [リザルトシーンでの使用](#4.3--14)
* [アクセスパターン](#4.3--15)
* [可視化コンポーネント](#4.3--16)
* [永続化ストレージ](#4.3--17)
* [スコアデータベース統合](#4.3--18)
* [パフォーマンスに関する考慮事項](#4.3--19)
* [メモリ割り当て戦略](#4.3--20)
* [データアクセスパターン](#4.3--21)
* [サマリーテーブル](#4.3--22)

