

# 入力システム 

## 目的と範囲 

入力システムは、ゲームプレイ中のすべてのプレイヤー入力を処理し、手動タッチ入力と自動プレイモードの両方をサポートする抽象化レイヤーを提供します。このシステムはタッチイベントを処理し、ゲーム互換の入力データに変換し、判定システムと統合します。

入力が判定にどのように影響するかについては、[判定メカニクス](#4.1)を参照してください。ゲームループ全体のオーケストレーションについては、[ゲームループとシーンコントローラー](#3.1)を参照してください。

---

## アーキテクチャ概要 

入力システムは戦略パターンを実装しており、`InputBase`が抽象インターフェースとして機能し、`TouchArea`と`AutoPlay`が具体的な実装として機能します。ゲームループは、ソースに関係なく入力データを均一に消費します。

```mermaid
flowchart TD

IB["InputBase (抽象基底)"]
TA["TouchArea (手動入力)"]
AP["AutoPlay (生成入力)"]
TD["TouchData Dictionary"]
STP["ScreenTouchPhase (Tap/Hold/Up)"]
MGSC["MusicGameSceneController"]
MG["MusicGame"]
ET["EnhancedTouchSupport Unity Input System"]
TOUCH["Touch.onFingerDown/Move/Up"]

TA -.->|"生成"| TD
AP -.->|"生成"| TD
MGSC -.->|"選択"| IB
MGSC -.->|"_isAuto? _autoPlay : _touchArea"| IB
MG -.->|"読込"| TD
TOUCH -.->|"継承"| TA
IB -.->|"_touchData"| TD

subgraph Unity入力 ["Unity入力"]
    ET
    TOUCH
    ET -.->|"有効化"| TOUCH
end

subgraph ゲーム統合 ["ゲーム統合"]
    MGSC
    MG
end

subgraph 入力データフロー ["入力データフロー"]
    TD
    STP
    TD -.->|"含む"| STP
end

subgraph 入力システムアーキテクチャ ["入力システムアーキテクチャ"]
    IB
    TA
    AP
    IB -.->|"供給"| TA
    IB -.->|"継承"| AP
    TA -.->|"CallUpdate実装"| IB
    AP -.->|"CallUpdate実装"| IB
end
```

## コアデータ構造 

### TouchData構造体 

`TouchData`構造体は、単一のタッチイベントに関するすべての情報をカプセル化します：

| フィールド | 型 | 説明 |
| --- | --- | --- |
| `Phase` | `ScreenTouchPhase` | タッチの現在の状態（Tap/Hold/Up） |
| `PosX` | `float` | ゲーム空間での水平位置 |
| `TouchTime` | `double` | タッチイベントの正確な時刻 |
| `AutoIndex` | `int` | オートプレイ識別用のインデックス |

### ScreenTouchPhase列挙型 

```mermaid
flowchart TD

None["None (0)"]
Tap["Tap (1) 初期タッチ"]
Hold["Hold (2) 継続タッチ"]
Up["Up (3) リリース"]

None -.-> Tap
Tap -.-> Hold
Hold -.-> Up
Up -.-> Up
Up -.-> Hold
Hold -.-> Up
Up -.-> None
```

**列挙値:**

* `None = 0` - アクティブなタッチなし
* `Tap = 1` - 初期タッチダウンイベント
* `Hold = 2` - タップ後の継続保持
* `Up = 3` - タッチリリースイベント



---

## InputBase抽象化 

`InputBase`クラスは、すべての入力ソースに対する共通インターフェースを定義します：

```mermaid
classDiagram
    class InputBase {
        «abstract»
        +Dictionary<int, TouchData> TouchData
        +CallUpdate(double musicTime)
        +ClearInputData()
    }
    class TouchArea {
        -Transform _transform
        -Camera _mainCamera
        -Dictionary<int, int> _touchArea
        +bool Enable
        +Init(bool isEnable, MusicManager)
        +CallUpdate(double musicTime)
        +OnFingerDown(Finger)
        +OnFingerMove(Finger)
        +OnFingerUp(Finger)
    }
    class AutoPlay {
        -Sequence _sequence
        -BpmHelper _bpmHelper
        -int _noteIndex
        -Dictionary<int, int> _holdNoteIndexDict
        +Init(Sequence, BpmHelper, NoteObjectPool, int)
        +CallUpdate(double musicTime)
    }
    InputBase <|-- TouchArea
    InputBase <|-- AutoPlay
```

**主要メソッド:**

* `CallUpdate(double musicTime)` - 現在のフレームの入力を処理し、`TouchData`ディクショナリを入力
* `ClearInputData()` - ゲームロジックによる消費後にタッチデータをクリア



 

---

## 手動タッチ入力（TouchArea） 

### 初期化とUnity入力システム 

`TouchArea`はマルチタッチ処理にUnityの**Enhanced Touch Support** APIを使用します：

```mermaid
flowchart TD

Init["Init(isEnable,<br/>musicManager)"]
Enable["EnhancedTouchSupport<br/>Enable()"]
Subscribe["Touch イベントを購読"]
Update["CallUpdate(musicTime)"]
Process["タッチイベントを処理"]
Disable["OnDisable()"]
Cleanup["EnhancedTouchSupport<br/>Disable()"]

Init --> Enable
Enable --> Subscribe

Subscribe -->|onFingerDown| Update
Subscribe -->|onFingerMove| Update
Subscribe -->|onFingerUp| Update

Update --> Process

Disable --> Cleanup

subgraph TouchAreaライフサイクル ["TouchArea ライフサイクル"]
    Init
    Enable
    Subscribe
    Update
    Process
    Disable
    Cleanup
end

```

**初期化手順:**

1. Enhanced Touch Supportを有効化 
2. フィンガーイベントを購読 
3. 判定エリアパラメータを初期化 
4. カメラとトランスフォーム参照をキャッシュ 



### 判定エリアタイプ 

TouchAreaは、ヒット検出用の2つの座標空間モードをサポートします：

| モード | 説明 | ユースケース |
| --- | --- | --- |
| `JudgeAreaType.Screen` | スクリーン空間座標を使用 | デフォルト、パフォーマンス向上 |
| `JudgeAreaType.World` | 3Dワールドコライダーへレイキャスト | パースペクティブカメラサポート |

**スクリーン空間処理:**

```mermaid
flowchart TD

Touch["タッチ位置 (スクリーン座標)"]
Transform["判定空間へ 変換"]
Judge["判定エリア 境界チェック"]
PosX["PosX計算 ゲーム座標"]

Touch -.-> Transform
Transform -.->|"内部"| Judge
Judge -.-> PosX
```

**ワールド空間処理:**

```mermaid
flowchart TD

Touch["タッチ位置"]
Raycast["カメラから レイキャスト"]
Collider["BoxColliderヒット"]
World["ワールド位置"]
PosX["PosX計算"]

Touch -.-> Raycast
Raycast -.-> Collider
Collider -.-> World
World -.-> PosX
```



### タッチイベント処理 

タッチ処理パイプラインは、Unityのタッチイベントをゲーム互換の`TouchData`に変換します：

```mermaid
sequenceDiagram
  participant p1 as Unity入力
  participant p2 as TouchArea
  participant p3 as _touchDataディクショナリ
  participant p4 as MusicGame

  p1->>p2: onFingerDown(finger)
  p2->>p2: GetPosX(screenPosition)
  p2->>p3: Tap TouchDataを追加
  p2->>p2: OnInputDownを発火
  p1->>p2: onFingerMove(finger)
  p2->>p2: GetPosX(screenPosition)
  p2->>p3: Hold TouchDataを更新
  p2->>p2: OnInputMoveを発火
  p1->>p2: onFingerUp(finger)
  p2->>p2: GetPosX(screenPosition)
  p2->>p3: Up TouchDataを更新
  p2->>p2: OnInputUpを発火
  note over p2,p4: ゲームループがデータを読込
  p4->>p3: すべてのTouchDataを読込
  p4->>p2: ClearInputData()
  p2->>p3: Clear()
```

**イベントハンドラ:**

* `OnFingerDown(Finger finger)` - `Tap`フェーズのTouchDataを作成 
* `OnFingerMove(Finger finger)` - `Hold`フェーズに更新 
* `OnFingerUp(Finger finger)` - `Up`フェーズに変更 



### 位置計算 

スクリーン/ワールド座標をゲームレーン位置に変換：

**スクリーン空間アルゴリズム:**

```
1. タッチのスクリーン位置を取得
2. 判定エリア中心に対する相対変換
3. アスペクト比補正を適用
4. ゲーム座標系にスケーリング
5. フレームベースの位置補正を適用
```

**ワールド空間アルゴリズム:**

```
1. タッチポイントを通してカメラからレイキャスト
2. 判定エリアのBoxColliderに対してヒットテスト
3. ワールドX座標を抽出
4. ゲーム座標系に変換
```



### レーンカバー統合 

TouchAreaは、視覚的フィードバックのためにレーンカバーシステムと統合します：

```mermaid
flowchart TD

Touch["タッチ入力"]
Calc["PosX計算"]
Cover["LaneCoverController"]
Visual["ビジュアルインジケータ更新"]

Touch -.-> Calc
Calc -.-> Cover
Cover -.-> Visual
```



---

## 自動入力（AutoPlay） 

### アーキテクチャ 

`AutoPlay`は譜面データを直接読み取ることで完璧なタイミングの入力を生成します：

```mermaid
flowchart TD

Seq["Sequence (譜面データ)"]
BPM["BpmHelper (タイミング)"]
Pool["NoteObjectPool (アクティブノート)"]
AP["AutoPlay"]
NoteIdx["_noteIndex (現在のノート)"]
Check["ノート時刻が経過したかチェック"]
Generate["TouchDataを生成"]
LongHold["ロングノートホールドを追跡"]
TD["TouchDataディクショナリ"]

AP -.-> NoteIdx
Generate -.-> TD
LongHold -.-> TD

subgraph 出力 ["出力"]
    TD
end

subgraph 入力生成 ["入力生成"]
    NoteIdx
    Check
    Generate
    LongHold
    NoteIdx -.->|"はい"| Check
    Check -.->|"ロング"| Generate
    Check -.-> LongHold
end

subgraph AutoPlayコンポーネント ["AutoPlayコンポーネント"]
    Seq
    BPM
    Pool
    AP
    Seq -.->|"ノート位置"| AP
    BPM -.->|"ビートから時間へ"| AP
    Pool -.->|"ノート画面位置"| AP
end
```



### ノート追跡 

AutoPlayは、どのノートをプレイするかを追跡するための状態を維持します：

| 状態変数 | 型 | 目的 |
| --- | --- | --- |
| `_noteIndex` | `int` | 現在処理中のノート |
| `_holdNoteIndexDict` | `Dictionary<int,int>` | タッチIDごとにアクティブなロングノートを追跡 |
| `_sequence` | `Sequence` | 譜面データ参照 |
| `_bpmHelper` | `BpmHelper` | ビートを時間に変換 |



### 更新サイクル 

```mermaid
flowchart TD

Start["CallUpdate(musicTime)"]
Clear["_touchDataをクリア _holdNoteIndexDictをクリア"]
Beat["musicTimeをビートに変換"]
CheckNotes["ノートビート < 現在ビートをチェック"]
CreateTap["Tap TouchDataを作成 レーンまたはノート位置からposX"]
IncrementNote["_noteIndex++"]
CheckLongs["アクティブなロングノートを反復"]
CheckLongEnd["終了位置にあるかチェック"]
CreateUp["Up TouchDataを作成"]
CreateHold["Hold TouchDataを作成"]

Start -.-> Clear
Clear -.-> Beat
Beat -.->|"はい"| CheckNotes
CheckNotes -.-> CreateTap
CreateTap -.->|"はい"| IncrementNote
IncrementNote -.->|"いいえ"| CheckNotes
CheckNotes -.-> CheckLongs
CheckLongs -.->|"いいえ"| CheckLongEnd
CheckLongEnd -.-> CreateUp
CheckLongEnd -.-> CreateHold
```

**ノート入力生成ロジック:**

1. 現在のノートのビート時刻が経過したかチェック 
2. レーンデータまたは実際のノートオブジェクトから位置を取得 
3. `Tap`フェーズのTouchDataを作成 
4. ノートインデックスをインクリメント 

**ロングノート処理:**

1. アクティブなロングノートをディクショナリで追跡 
2. 各ロングノートの終了位置を現在のビートと比較チェック 
3. 終了に達したら`Up`フェーズを生成 
4. 進行中の間は`Hold`フェーズを生成 



### 位置ソース 

AutoPlayは、ノートのX位置を決定するために2つの異なる方法を使用できます：

| モード | ソース | 有効化方法 |
| --- | --- | --- |
| レーンベース | `_sequence.Lanes[noteIndex]` | デフォルトモード |
| ノートベース | プールからの`NoteController.PosX` | Luaスクリプト`EnableNotePosition(true)` |

ノートベースモードでは、Luaスクリプトがノートを動的に移動できるようになり、AutoPlayは事前に決定されたレーン位置ではなく、実際の画面位置でノートをヒットします。



---

## 入力モード選択 

`MusicGameSceneController`は、プレイモードに基づいて使用する入力実装を決定します：

```mermaid
flowchart TD

Start["MusicGameSceneController.Start()"]
CheckMode["PlayModeをチェック"]
Auto["PlayMode.Auto"]
Manual["PlayMode.Normal/Online/Rehearsal"]
SetAuto["_input = _autoPlay"]
SetManual["_input = _touchArea"]
InitAuto["_autoPlay.Init(...)"]
InitTouch["_touchArea.Init(...)"]

Start -.-> CheckMode
CheckMode -.-> Auto
CheckMode -.-> Manual
Auto -.-> SetAuto
Manual -.-> SetManual
SetAuto -.-> InitAuto
SetManual -.-> InitTouch
```

**選択ロジック:**

```
_isAuto = (GameManager.Instance.PlayModeOption.PlayMode == PlayMode.Auto)
_input = _isAuto ? _autoPlay : _touchArea;
```

**初期化:**

* **AutoPlay:** `Sequence`、`BpmHelper`、`NoteObjectPool`、最大同時ロング数が必要 
* **TouchArea:** 有効化フラグと`MusicManager`参照が必要 



---

## ゲームループとの統合 

### フレーム更新サイクル 

入力システムは、厳密な更新順序でメインゲームループに統合されます：

```mermaid
sequenceDiagram
  participant p1 as MusicGameSceneController
  participant p2 as MusicManager
  participant p3 as InputBase
  participant p4 as MusicGame
  participant p5 as JudgeManager

  note over p1: Unity Update()
  p1->>p2: CallUpdate()
  p2-->>p1: musicTime
  p1->>p3: CallUpdate(musicTime)
  note over p3: TouchDataを生成/処理
  p1->>p4: CallUpdate(musicTime)
  note over p4: Input.TouchDataを読込
  p4->>p5: JudgeTap/Hold/Up
  p1->>p3: ClearInputData()
  note over p3: 次フレーム用にディクショナリをクリア
```

**更新順序（`MusicGameSceneController.Update`内）:**

1. `_musicManager.CallUpdate()` - 音楽時間を更新 
2. `_input.CallUpdate(musicTime)` - 入力を処理 
3. `_musicGame.CallUpdate(musicTime)` - ゲームロジックを処理 
4. `_input.ClearInputData()` - 消費された入力をクリア 



### MusicGame入力消費 

`MusicGame`は更新中に入力データを読み取り、ノート判定を実行します：

```mermaid
flowchart TD

JudgeTap["JudgeTap(touch, touchId) Tapフェーズをチェック"]
Sort["SortTouchIdList() タッチをIDで順序付け"]
JudgeUp["JudgeUp(touch, touchId) Upフェーズをチェック"]
JudgeHold["JudgeHold(touch, touchId) Holdフェーズをチェック"]
JudgeLong["JudgeLong(beat, musicTime, touchId, touch) ロングノートホールド"]

subgraph MusicGame.CallUpdate ["MusicGame.CallUpdate"]
    Sort
    Sort -.-> JudgeTap

subgraph タッチごとの処理 ["タッチごとの処理"]
    JudgeTap
    JudgeUp
    JudgeHold
    JudgeLong
    JudgeTap -.-> JudgeUp
    JudgeUp -.-> JudgeHold
    JudgeHold -.-> JudgeLong
end
end
```

**入力読込パターン:**

1. 一貫した処理順序のためにタッチIDをソート 
2. ソートされたタッチを反復 
3. `_input.TouchData[key]`経由でタッチデータにアクセス 
4. フェーズに基づいて判定メソッドを呼び出し 



### ポーズ処理 

ゲームがポーズすると、古いデータを防ぐために入力がクリアされます：

```mermaid
flowchart TD

Pause["ポーズボタン押下"]
Stop["_musicManager.Pause()"]
Clear["_input.ClearInputData()"]
Resume["再開"]
ClearAgain["_input.ClearInputData()"]

Pause -.-> Stop
Stop -.-> Clear
Resume -.-> ClearAgain
```



---

## Luaスクリプト用タッチイベント 

TouchAreaは、カスタムゲームプレイメカニクスのためにLuaスクリプトが購読できる入力イベントを公開します：

```mermaid
flowchart TD

Down["OnInputDown"]
Move["OnInputMove"]
Up["OnInputUp"]
LDown["_luaManager.OnInputDown"]
LMove["_luaManager.OnInputMove"]
LUp["_luaManager.OnInputUp"]

Down -.->|"購読"| LDown
Move -.->|"購読"| LMove
Up -.->|"購読"| LUp

subgraph LuaManagerバインディング ["LuaManagerバインディング"]
    LDown
    LMove
    LUp
end

subgraph TouchAreaイベント ["TouchAreaイベント"]
    Down
    Move
    Up
end
```

**イベントシグネチャ:**

```
public delegate void ActionInput(int touchId, float posX, double touchTime);
```

**MusicGameSceneControllerでのバインディング:**

```
_touchArea.OnInputDown += _luaManager.OnInputDown;
_touchArea.OnInputMove += _luaManager.OnInputMove;
_touchArea.OnInputUp += _luaManager.OnInputUp;
```

これらのイベントは、実際のタッチイベントがないため、オートプレイモードでは**トリガーされません**。



 

---

## 設定 

### 入力関連オプション 

入力システムの動作は、いくつかのオプションクラスを通じて設定されます：

| オプションクラス | プロパティ | 影響 |
| --- | --- | --- |
| `NotesOption` | `FrameRevision` | タッチ遅延の位置調整 |
| `NotesOption` | `JudgeAreaType` | スクリーンとワールド座標モード |
| `JudgeTimeOption` | `JudgeDistance` | 水平ヒット検出幅 |
| `JudgeTimeOption` | `LongRevisionDistance` | ロングノートホールドの追加幅|
| `JudgeTimeOption` | `MusicRate` | オートプレイタイミングの時間スケーリング |



 

### 有効/無効制御 

TouchAreaには、入力が処理されるかどうかを制御する`Enable`プロパティがあります：

```
_touchArea.Enable = _musicManager.IsPlay || _pausePanelController.IsShowResume;
```

これにより、以下の間は入力が防止されます：

* ロード/初期化フェーズ
* ポーズメニュー（再開カウントダウンを除く）
* ゲーム終了状態

 

---

## パフォーマンスに関する考慮事項 

### タッチデータディクショナリ 

`TouchArea`と`AutoPlay`の両方は、タッチIDによるO(1)ルックアップのために`Dictionary<int, TouchData>`を使用します。ディクショナリは、メモリの蓄積を防ぐために、消費後の各フレームでクリアされます。

### ソート最適化 

`MusicGame`は、決定論的な動作を保証するために、処理前にタッチIDをソートします。ソートラムダは、GC割り当てを回避するためにランタイムによってキャッシュされます：

```c#
// ランタイムによってキャッシュ - GCなし
_sortedKeyList.Sort((a, b) => a - b);
```



### Unity入力システム統合 

`TouchArea`は、以下の理由から、レガシーの`Input.touches`の代わりにUnityのEnhanced Touch APIを使用します：

* より良いマルチタッチサポート
* プラットフォーム間での一貫した動作
* 適切なタッチID追跡
* ジェスチャー認識の可能性

システムは、必要ないときのランタイムオーバーヘッドを回避するために、`OnEnable`/`OnDisable`でEnhanced Touch Supportを有効化/無効化します。

### On this page

* [入力システム](#3.4-)
* [目的と範囲](#3.4--1)
* [アーキテクチャ概要](#3.4--2)
* [コアデータ構造](#3.4--3)
* [TouchData構造体](#3.4-touchdata)
* [ScreenTouchPhase列挙型](#3.4-screentouchphase)
* [InputBase抽象化](#3.4-inputbase)
* [手動タッチ入力（TouchArea）](#3.4-toucharea)
* [初期化とUnity入力システム](#3.4-unity)
* [判定エリアタイプ](#3.4--4)
* [タッチイベント処理](#3.4--5)
* [位置計算](#3.4--6)
* [レーンカバー統合](#3.4--7)
* [自動入力（AutoPlay）](#3.4-autoplay)
* [アーキテクチャ](#3.4--8)
* [ノート追跡](#3.4--9)
* [更新サイクル](#3.4--10)
* [位置ソース](#3.4--11)
* [入力モード選択](#3.4--12)
* [ゲームループとの統合](#3.4--13)
* [フレーム更新サイクル](#3.4--14)
* [MusicGame入力消費](#3.4-musicgame)
* [ポーズ処理](#3.4--15)
* [Luaスクリプト用タッチイベント](#3.4-lua)
* [設定](#3.4--16)
* [入力関連オプション](#3.4--17)
* [有効/無効制御](#3.4--18)
* [パフォーマンスに関する考慮事項](#3.4--19)
* [タッチデータディクショナリ](#3.4--20)
* [ソート最適化](#3.4--21)
* [Unity入力システム統合](#3.4-unity-1)

