

# 共有UIコンポーネント 

## 目的と範囲 

このページでは、アプリケーション内の複数のシーンで使用される共有UIコンポーネントについて説明します。これらのコンポーネントは、ダイアログ管理、シーン遷移、ローカライゼーション、カスタムスクロール動作、およびローディングインジケーターなどの共通機能を提供します。

シーン固有のUI実装については、[タイトルシーン](#8.1)および[リザルトシーン](#8.2)を参照してください。UI全体のアーキテクチャとMVPパターンについては、[MVPパターンの実装](#2.2)を参照してください。

---

## コンポーネント概要 

共有UIシステムは、すべてのシーンで一貫した動作を提供する複数のシングルトンマネージャーと再利用可能なコンポーネントで構成されています：

```mermaid
flowchart TD

%% シングルトンマネージャー
DIALOG["DialogManager<br/>優先度ベースのダイアログ"]
FADE["FadeManager<br/>シーン遷移"]
BG["BgManager<br/>背景制御"]
SE["SystemSEManager<br/>UI効果音"]
LOCALIZE["LocalizeManager<br/>文字列テーブル"]

%% 再利用可能コンポーネント
SCROLLER["SingleTouchScroller<br/>カスタムタッチ処理"]
TAP_BAR["TapMovableScrollBar<br/>拡張スクロールバー"]
LOADING["RotateLoadingController<br/>ローディング表示"]
NETWORK["NetworkChecker<br/>ネットワーク状態"]

%% シーンプレゼンター
TITLE_P["TitleScenePresenter"]
SELECT_P["MusicSelectScenePresenter"]
RESULT_P["ResultScenePresenter"]

%% Presenter → Singleton
TITLE_P --> DIALOG
TITLE_P --> FADE
TITLE_P --> BG
TITLE_P --> SE
TITLE_P --> LOCALIZE

SELECT_P --> DIALOG
SELECT_P --> FADE
SELECT_P --> BG
SELECT_P --> SE
SELECT_P --> LOCALIZE

RESULT_P --> DIALOG
RESULT_P --> FADE
RESULT_P --> BG
RESULT_P --> SE
RESULT_P --> LOCALIZE

%% Presenter → 再利用コンポーネント
SELECT_P --> SCROLLER
SELECT_P --> TAP_BAR
SELECT_P --> LOADING
SELECT_P --> NETWORK

TITLE_P --> LOADING
RESULT_P --> LOADING
RESULT_P --> NETWORK

subgraph シーンプレゼンター ["シーンプレゼンター"]
    TITLE_P
    SELECT_P
    RESULT_P
end

subgraph シングルトンマネージャー ["シングルトンマネージャー"]
    DIALOG
    FADE
    BG
    SE
    LOCALIZE
end

subgraph 再利用可能コンポーネント ["再利用可能コンポーネント"]
    SCROLLER
    TAP_BAR
    LOADING
    NETWORK
end

```

## ダイアログシステム 

### DialogManager 

`DialogManager`は優先度ベースのダイアログシステムを実装し、適切なダイアログのスタック管理と複数の重複ダイアログの防止を保証します。具体的な実装ファイルは提供されたソースには直接含まれていませんが、アーキテクチャ図はすべてのシーンプレゼンターからアクセスされるシングルトンコンポーネントであることを示しています。

**主な責務：**

* 優先度レベルを持つダイアログ表示キューの管理
* 複数の同時ダイアログの防止
* ダイアログ終了コールバックの処理
* シーン遷移との調整

**使用パターン：**
シーンプレゼンターはシングルトンインスタンスを通じてダイアログメソッドを呼び出します。ダイアログは設定可能なテキスト、ボタン、コールバックで表示されます。

## シーン遷移システム 

### FadeManager 

`FadeManager`はシーン間のスムーズなフェードイン/アウト遷移を提供します。シーン変更時に`GameManager`と連携して視覚的な連続性を提供します。

**主な機能：**

* 黒へのフェード遷移
* 設定可能なフェード時間
* async/await対応
* 遷移中の入力ブロック

**シーンフローとの統合：**

```mermaid
sequenceDiagram
  participant p1 as Presenter
  participant p2 as FadeManager
  participant p3 as GameManager
  participant p4 as SceneManager

  p1->>p2: FadeOut()
  p2->>p2: 黒へのフェードアニメーション
  p2-->>p1: フェード完了
  p1->>p3: ChangeSceneAsync(index)
  p3->>p4: LoadSceneAsync(index)
  p4-->>p3: シーン読込完了
  p3->>p2: FadeIn()
  p2->>p2: 黒からのフェードアニメーション
  p2-->>p1: 準備完了
```

## 背景管理 

### BgManager 

`BgManager`シングルトンはシーン全体の背景画像表示を制御し、一貫した背景状態またはシーン固有の背景を可能にします。

**機能：**

* Addressablesからの背景画像の読込
* 背景テクスチャのキャッシング
* ゲームプレイの視認性のためのディマー効果の適用
* シーン間の背景遷移

## 効果音システム 

### SystemSEManager 

`SystemSEManager`はすべてのシーンでUI操作音（ボタンクリック、選択など）を一貫して処理します。

**機能：**

* `VolumeOption`による音量制御
* パフォーマンスのための効果音プーリング
* CRI Atom統合によるオーディオ再生
* シーンに依存しない音管理

## ローカライゼーションシステム 

### LocalizeManagerと文字列テーブル 

ローカライゼーションシステムはUnityのLocalizationパッケージを使用し、型安全な文字列キーアクセスのための自動生成定数クラスを提供します。

```mermaid
flowchart TD

CSV["localize.csv マスター文字列データ"]
JA["DKLIKEStringTable_ja.asset 日本語文字列"]
EN["DKLIKEStringTable_en.asset 英語文字列"]
SHARED["DKLIKEStringTable Shared Data キー定義"]
CONST["LocalizationConstant.cs 自動生成定数"]
MANAGER["LocalizeManager シングルトンマネージャー"]
UI["UIコンポーネント TextMeshProUGUIなど"]

CSV -.->|"読込"| CONST
MANAGER -.->|"クエリ"| SHARED
MANAGER -.->|"クエリ"| JA
MANAGER -.->|"文字列取得"| EN
UI -.-> CONST

subgraph ランタイム ["ランタイム"]
    MANAGER
    UI
    UI -.->|"キー使用"| MANAGER
end

subgraph 生成コード ["生成コード"]
    CONST
end

subgraph ローカライゼーションアセット ["ローカライゼーションアセット"]
    CSV
    JA
    EN
    SHARED
    CSV -.->|"生成"| JA
    CSV -.->|"生成"| EN
    CSV -.->|"生成"| SHARED
    SHARED -.->|"参照"| JA
    SHARED -.->|"参照"| EN
end
```

### 文字列テーブル構造 

ローカライゼーションシステムは、効率的な検索のために数値IDを持つ文字列テーブルにすべてのUIテキストを格納します：

| 定数名 | ID | 日本語 | 英語 |
| --- | --- | --- | --- |
| `CloseButton` | 44982853632 | 閉じる | Close |
| `BackButton` | 429172711424 | 戻る | Back |
| `SelectButton` | 530922332160 | 決定 | Select |
| `OkButton` | 640209117184 | OK | OK |
| `CancelButton` | 727698104320 | キャンセル | Cancel |

### 使用パターン 

```
// 型安全な文字列キーアクセス
long keyId = LocalizationConstant.CloseButton;
string localizedText = LocalizeManager.GetLocalizedString(keyId);
```

### 自動生成定数 

`LocalizationConstant`クラス

には、セマンティック名を数値文字列IDにマッピングする300以上の自動生成定数フィールドが含まれています。これにより、ローカライズされた文字列にアクセスする際のコンパイル時の安全性が提供され、文字列キー名のタイプミスが防止されます。

**主な機能：**

* 型安全な文字列キーアクセス
* 日本語と英語のロケールをサポート
* CSVマスターデータから自動生成
* すべてのUIコンポーネントで使用

## スクロールコンポーネント 

### SingleTouchScroller 

`SingleTouchScroller`は、FancyScrollViewライブラリの上に構築されたスクロール可能なリスト用のカスタムタッチ入力ハンドラーです。タッチデバイス向けに最適化されたスムーズな慣性ベースのスクロールを提供します。

**機能：**

* 慣性を持つ慣性スクロール
* セルへのスナップ機能
* タッチとドラッグの検出
* 設定可能なイージング関数

**統合：**
`ScrollView`と連携して楽曲選択リストのスクロール動作を提供します。

### TapMovableScrollBar 

`TapMovableScrollBar`は標準のスクロールバーをタップ位置機能で拡張し、ユーザーがスクロールバーをタップしてリスト位置に直接ジャンプできるようにします。

```mermaid
flowchart TD

GRAPHIC["Graphic スクロールバー背景"]
TRIGGER["EventTrigger ポインターダウン検出"]
CURSOR["RectTransform 位置カーソル"]
TAP["ユーザータップ"]
CALC["タップ位置を計算"]
CONVERT["リストインデックスに変換"]
SCROLL["スクロールイベント発火"]

TAP -.->|"pointer down"| TRIGGER
TRIGGER -.->|"画面座標からローカル座標へ"| CALC
CALC -.->|"更新"| GRAPHIC
CURSOR -.-> SCROLL

subgraph 動作 ["動作"]
    TAP
    CALC
    CONVERT
    SCROLL
    CALC -.-> CONVERT
    CONVERT -.-> SCROLL
end

subgraph TapMovableScrollBarコンポーネント ["TapMovableScrollBarコンポーネント"]
    GRAPHIC
    TRIGGER
    CURSOR
end
```

### 実装詳細 

スクロールバーはタップされた位置を計算し、リストインデックスに変換します：

**位置計算：** 

* スクロールバー内の画面タップ位置をローカル座標に変換
* 位置を0-1の範囲に正規化
* 正規化された位置をコンテンツインデックスにマッピング

**カーソル更新：** 

* 現在のスクロール位置を反映するように視覚的なカーソル位置を更新
* スクロールビューの中心インデックス変更と同期

**イベント処理：**

```
public event Action<int> OnTapScrollBar;
```



スクロールバーは、`ScrollView`がタップベースのナビゲーションを処理するためにサブスクライブするイベントを公開します。

### ScrollViewとCellアーキテクチャ 

スクロールシステムは、パフォーマンスのために再利用可能なセルを持つFancyScrollViewパターンを使用します：

```mermaid
flowchart TD

SV["ScrollView FancyScrollView実装"]
SCROLLER["SingleTouchScroller 入力ハンドラー"]
TAPBAR["TapMovableScrollBar 視覚的インジケーター"]
CONTEXT["Context 共有状態"]
CELL_POOL["Cell Pool 再利用可能GameObjects"]
CELL["Cell 表示コンポーネント"]
ITEM_DATA["ItemData 楽曲情報"]

SV -.->|"リサイクル"| CELL_POOL
CELL -.->|"クリックイベント"| CONTEXT

subgraph セル管理 ["セル管理"]
    CELL_POOL
    CELL
    ITEM_DATA
    CELL -.->|"表示"| ITEM_DATA
end

subgraph ScrollViewシステム ["ScrollViewシステム"]
    SV
    SCROLLER
    TAPBAR
    CONTEXT
    SCROLLER -.->|"スクロールイベント"| SV
    TAPBAR -.->|"タップイベント"| SV
    SV -.->|"更新"| CONTEXT
    CONTEXT -.->|"選択"| SV
end
```

**ScrollViewの責務：** 

* セルのライフサイクルとリサイクルの管理
* スクローラーとスクロールバーの調整
* 選択変更の処理
* プレゼンターへのイベントのディスパッチ

**Cellの責務：** 

* 楽曲情報の表示（タイトル、サブタイトル、クリア状態）
* クリック操作の処理
* ハイライトアニメーションの管理
* 異なる表示モード（AB/FCマーク）への適応


## ローディングインジケーター 

### RotateLoadingController 

アプリケーション全体でバックグラウンド操作を示すために使用される、シンプルで再利用可能な回転ローディングインジケーターです。

```mermaid
flowchart TD

RT["RectTransform 回転ターゲット"]
IMG["Image 視覚的アイコン"]
START["StartLoading()"]
STOP["StopLoading()"]
TWEEN["DOTween回転"]

START -.->|"フェードイン + 回転"| IMG
TWEEN -.->|"アニメーション"| RT
STOP -.->|"フェードアウト + 停止"| IMG

subgraph アニメーション制御 ["アニメーション制御"]
    START
    STOP
    TWEEN
    START -.->|"無限ループ"| TWEEN
end

subgraph RotateLoadingController ["RotateLoadingController"]
    RT
    IMG
end
```

### 実装 

**初期化：** 

* 画像の色をキャッシュ
* 初期アルファを0に設定

**ローディング開始：** 

* アイコンをフェードイン
* DOTweenを使用して無限回転アニメーションを開始

**ローディング停止：** 

* アイコンをフェードアウト
* 回転トゥイーンを停止

**使用例：**

```
// MenuPanelControllerで
_rotateLoadingController.Init();
_rotateLoadingController.StartLoading(); // ローディング時に表示
_rotateLoadingController.StopLoading();  // 完了時に非表示
```


## ネットワークユーティリティ 

### NetworkChecker 

`NetworkChecker`は、ネットワーク接続を確認し、ユーザーに適切な警告を表示するユーティリティメソッドを提供します。

**機能：**

* モバイルデータとWiFi接続の検出
* モバイルデータ使用時の警告ダイアログ表示
* オフライン時のネットワーク操作の防止
* `DialogManager`との統合によるユーザー通知

**使用パターン：**

```
if (CanUseNetWork())
{
    // ネットワーク操作を続行
}
```

## フォルダ選択コンポーネント 

### FolderScrollView 

`FolderScrollView`は、メインの`ScrollView`と同様ですが、フォルダブラウジング用に最適化された、フォルダ選択パネルで使用される特殊なスクロールビューです。

**コンポーネント：**

* フォルダ情報用の`FolderItem`データ構造を使用
* フォルダ固有の状態のためのカスタム`FolderContext`
* ナビゲーション用の`TapMovableScrollBar`との統合

**データ構造：**

```c#
public class FolderItem
{
    public string FolderName;
    public int SongCount;
    public Texture Texture;
}
```

## コンポーネントライフサイクル統合 

すべての共有UIコンポーネントは、MVPアーキテクチャと統合する一貫した初期化とクリーンアップパターンに従います：

```mermaid
flowchart TD

SCOPE["LifetimeScope シーンエントリーポイント"]
PRESENTER["PresenterBase ビジネスロジック"]
VIEW["ViewBase UIコンテナ"]
INIT["Init()メソッド"]
SETUP["イベント登録"]
DIALOG["DialogManager.Instance"]
FADE["FadeManager.Instance"]
LOCALIZE["LocalizeManager.Instance"]

VIEW -.->|"アクセス"| INIT
PRESENTER -.->|"アクセス"| DIALOG
PRESENTER -.->|"アクセス"| FADE
VIEW -.-> LOCALIZE

subgraph シングルトンアクセス ["シングルトンアクセス"]
    DIALOG
    FADE
    LOCALIZE
end

subgraph コンポーネント初期化 ["コンポーネント初期化"]
    INIT
    SETUP
    INIT -.-> SETUP
end

subgraph シーンライフサイクル ["シーンライフサイクル"]
    SCOPE
    PRESENTER
    VIEW
    SCOPE -.->|"Awake"| PRESENTER
    PRESENTER -.->|"Start"| VIEW
end
```

### 初期化パターン 

**LifetimeScopeエントリー：** 

```c#
void Awake()
{
    _presenter = new TitleScenePresenter(_view);
}
```

**View初期化：** 

```c#
public override void Init()
{
    // コンポーネントの初期化
    _tapEffect.Init();
    _menuPanelController.Init();
}
```

**Presenter開始：** 

プレゼンターの`Start()`メソッドは`LifetimeScope`から呼び出され、次にビューの`Init()`メソッドを呼び出します。

---

## まとめ 

共有UIコンポーネントは、アプリケーションのユーザーインターフェースに一貫性のある再利用可能な基盤を提供します：

| コンポーネント | タイプ | 主な目的 |
| --- | --- | --- |
| `DialogManager` | シングルトンマネージャー | 優先度ベースのダイアログシステム |
| `FadeManager` | シングルトンマネージャー | シーン遷移フェード |
| `BgManager` | シングルトンマネージャー | 背景画像管理 |
| `SystemSEManager` | シングルトンマネージャー | UI効果音 |
| `LocalizeManager` | シングルトンマネージャー | 多言語文字列テーブル |
| `SingleTouchScroller` | 再利用可能コンポーネント | タッチベースのスクロール |
| `TapMovableScrollBar` | 再利用可能コンポーネント | タップ位置機能付き拡張スクロールバー |
| `RotateLoadingController` | 再利用可能コンポーネント | ローディングインジケーターアニメーション |
| `NetworkChecker` | ユーティリティクラス | ネットワーク接続確認 |
| `FolderScrollView` | 特殊コンポーネント | フォルダブラウジングスクロールビュー |

これらのコンポーネントは、MVPパターンとシームレスに連携し、アプリケーション内のすべてのシーンで一貫した動作を提供するように設計されています。

**出典：** 提供されたすべてのソースファイルとシステムアーキテクチャ図の分析に基づく

### On this page

* [共有UIコンポーネント](#8.3-ui)
* [目的と範囲](#8.3-)
* [コンポーネント概要](#8.3--1)
* [ダイアログシステム](#8.3--2)
* [DialogManager](#8.3-dialogmanager)
* [シーン遷移システム](#8.3--3)
* [FadeManager](#8.3-fademanager)
* [背景管理](#8.3--4)
* [BgManager](#8.3-bgmanager)
* [効果音システム](#8.3--5)
* [SystemSEManager](#8.3-systemsemanager)
* [ローカライゼーションシステム](#8.3--6)
* [LocalizeManagerと文字列テーブル](#8.3-localizemanager)
* [文字列テーブル構造](#8.3--7)
* [使用パターン](#8.3--8)
* [自動生成定数](#8.3--9)
* [スクロールコンポーネント](#8.3--10)
* [SingleTouchScroller](#8.3-singletouchscroller)
* [TapMovableScrollBar](#8.3-tapmovablescrollbar)
* [実装詳細](#8.3--11)
* [ScrollViewとCellアーキテクチャ](#8.3-scrollviewcell)
* [ローディングインジケーター](#8.3--12)
* [RotateLoadingController](#8.3-rotateloadingcontroller)
* [実装](#8.3--13)
* [ネットワークユーティリティ](#8.3--14)
* [NetworkChecker](#8.3-networkchecker)
* [フォルダ選択コンポーネント](#8.3--15)
* [FolderScrollView](#8.3-folderscrollview)
* [コンポーネントライフサイクル統合](#8.3--16)
* [初期化パターン](#8.3--17)
* [まとめ](#8.3--18)

