

# 判定とスコアリングシステム 

## 目的と範囲 

判定とスコアリングシステムは、ゲームプレイ中にプレイヤーの入力精度を評価し、パフォーマンスに基づいてスコアを計算し、ライフゲージを管理し、ゲーム後の分析のために詳細なゲームプレイデータを記録します。本ドキュメントでは、ノート判定の決定方法、スコアとライフ値の計算方法、およびパフォーマンスデータの収集方法について包括的な概要を提供します。

各サブシステムの実装の詳細については以下を参照してください：

* タイミングウィンドウの計算とファジー判定ロジック：[判定メカニクス](#4.1)を参照
* ライフゲージの追跡とスコア計算アルゴリズム：[ライフとスコア管理](#4.2)を参照
* パフォーマンスデータの記録と集約：[リザルトデータ収集](#4.3)を参照

より広いゲームプレイのコンテキストについては、[コアゲームプレイシステム](#3)を参照してください。

---

## システムアーキテクチャ 

判定とスコアリングシステムは、ゲームプレイ中に連携して動作する4つの主要なマネージャーで構成されています：

```mermaid
flowchart TD

INPUT["InputBase (TouchArea/AutoPlay)"]
MG["MusicGame.CallUpdate メインゲームループ"]
JM["JudgeManager"]
JUIC["JudgeUIController"]
TIMING_OPT["JudgeTimeOption タイミングウィンドウ"]
LM["LifeManager"]
SM["ScoreManager"]
CM["ComboManager"]
TH["TimingHistory"]
LH["LifeHistory"]
RD["ResultData"]

MG -.->|"JudgeTap/JudgeHold/等"| JM
JM -.->|"OnJudgeイベント"| LM
JM -.->|"OnAfterJudgeイベント"| SM
JM -.->|"OnAfterJudgeイベント"| CM
JM -.->|"最大コンボ"| TH
LM -.->|"毎秒ライフ記録"| LH
LM -.->|"OnDeadイベント"| MG
TH -.->|"追加"| RD
LH -.->|"追加"| RD
JM -.->|"タイミング記録"| RD
SM -.->|"スコア＆ランク"| RD
CM -.-> RD

subgraph リザルト出力 ["リザルト出力"]
    RD
end

subgraph データ記録 ["データ記録"]
    TH
    LH
end

subgraph 進行マネージャー ["進行マネージャー"]
    LM
    SM
    CM
end

subgraph 判定コア ["判定コア"]
    JM
    JUIC
    TIMING_OPT
    JM -.->|"ShowJudge"| JUIC
end

subgraph 入力処理 ["入力処理"]
    INPUT
    MG
    INPUT -.->|"タッチ/オート入力"| MG
end
```



 

 

---

## 判定タイプとデータ構造 

### JudgeType列挙型 

システムは、ノートのタイミング精度を分類する7つの判定タイプを定義しています：

| JudgeType | 説明 | スコアへの影響 | ライフへの影響 | コンボへの影響 |
| --- | --- | --- | --- | --- |
| `Perfect` | 完璧なタイミング（視覚表示のみ） | +100% | +2 | 継続 |
| `Brilliant` | 優秀なタイミング | +100% | +2 | 継続 |
| `Great` | 良好なタイミング | +75% | +1 | 継続 |
| `Fast` | 早いタイミング（Greatウィンドウ外） | +25% | 0 | 中断 |
| `Slow` | 遅いタイミング（Greatウィンドウ外） | +25% | 0 | 中断 |
| `Bad` | 不良なタイミング | +25% | -10～-15 | 中断 |
| `Missed` | 入力なし、または遅すぎ | 0% | -30～-45 | 中断 |



 

 

### Judge構造体 

`Judge`構造体は、ゲームプレイ中の判定カウントを集計します：

```
public struct Judge
{    
    public int Perfect;
    public int Brilliant;
    public int Great;
    public int Fast;
    public int Slow;
    public int Bad;
    public int Missed;
}
```

この構造体は各判定時に更新され、`OnAfterJudge`イベントを通じて下流のシステムに渡されます。

### EarlyLate追跡 

システムはオプションでプレイヤーフィードバック用に早い/遅いタイミングを追跡します：

```
public struct EarlyLate
{    
    // 早い入力のカウント   
    public int Early;
    // 遅い入力のカウント
    public int Late;
}
```

表示閾値は`DisplayOption.EarlyLateDisplayThreshold`で設定可能です。



 

---

## 判定フロー 

以下の図は、ノートが判定システムを通過する過程を示しています：

```mermaid
sequenceDiagram
  participant p1 as MusicGame
  participant p2 as JudgeManager
  participant p3 as JudgeUIController
  participant p4 as LifeManager
  participant p5 as ScoreManager
  participant p6 as ComboManager
  participant p7 as TimingHistory

  p1->>p2: JudgeTiming(diffTime | touchPhase | isFuzzy)
  p2->>p2: 音楽レートと補正を 考慮したタイミングウィンドウを計算
  alt タイミングウィンドウ内
    p2->>p2: JudgeTypeを決定 (Brilliant/Great/Fast/Slow/Bad)
    p2->>p3: ShowJudge(type | isPerfect)
    p2->>p2: AddJudge(type)
    p2->>p7: タイミングデータを記録
    p2->>p4: OnJudgeイベント(type)
    p2->>p5: OnAfterJudgeイベント(judge)
    p2->>p6: OnAfterJudgeイベント(judge)
  else タイミングウィンドウ外
  end
  p4->>p4: UpdateLife(type)
  p5->>p5: CalculateScore(judge)
  p6->>p6: UpdateCombo(type)
```



 

---

## タイミングウィンドウの設定 

タイミングウィンドウは`JudgeTimeOption`から読み込まれ、音楽レートに応じて調整されます：

```mermaid
flowchart TD

JTO["JudgeTimeOption"]
DO["DisplayOption"]
PERF["_perfectTime (PerfectJudgeTime * 0.001 * rate)"]
FPERF["_fuzzyPerfectTime (max(16ms, PerfectTime) * rate)"]
BRIL["_brilliantTime (BrilliantTime * rate)"]
GREAT["_greatTime (GreatTime * rate)"]
FAST["_fastTime (FastTime * rate)"]
BAD["_badTime (BadTime * rate)"]
HIT["_hitTime (GetHitTime() * rate)"]
LONG["_longHitTime (GetLongEndHitTime() * rate)"]

JTO -.->|"PerfectJudgeTime"| PERF
DO -.->|"PerfectJudgeTime"| PERF
DO -.->|"Init()で読込"| FPERF
JTO -.-> BRIL
JTO -.-> GREAT
JTO -.-> FAST
JTO -.-> BAD
JTO -.-> HIT
JTO -.-> LONG

subgraph JudgeManagerキャッシュ値 ["JudgeManagerキャッシュ値"]
    PERF
    FPERF
    BRIL
    GREAT
    FAST
    BAD
    HIT
    LONG
end

subgraph 設定ソース ["設定ソース"]
    JTO
    DO
end
```

### タイミングウィンドウ表 

実際のタイミングウィンドウは設定に依存しますが、典型的なデフォルト値は以下の通りです：

| ウィンドウタイプ | デフォルト値 | 音楽レート調整 | 用途 |
| --- | --- | --- | --- |
| Perfect | 16 ms | あり | 視覚的な「Perfect」インジケータ |
| Brilliant | ~50 ms | あり | Brilliant判定 |
| Great | ~100 ms | あり | Great判定 |
| Fast/Slow | ~150 ms | あり | Fast/Slow境界 |
| Bad | ~200 ms | あり | Bad判定境界 |
| Hit Time | 上記の最大値 | あり | 一般的なミス検出 |
| Long Hit Time | Hit + ロング補正 | あり | ロングノート終了検出 |



### 補正パラメータ 

ロングノートとアップアクションはタイミング調整を受けます：

* **Long Revision Time**（`_upRevisionTime`）：ロングノート終了判定のタイミングウィンドウに追加
* **Long Distance Revision**（`_longDistanceRevision`）：ロングノートの水平判定距離に追加
* **Fuzzy Start Time**（`_holdStartTime`）：ファジーノートのホールド検出を早めに許可



 

---

## ファジー判定緩和 

システムは「ファジー判定緩和」を実装し、ファジーノートなど、叩きやすいノートのタイミングを改善します：

```mermaid
flowchart TD

JT["JudgeTiming(diffTime,<br/>touchPhase,<br/>isFuzzy)"]

CHECK_FUZZ["isFuzzyJudgeMitigation<br/>かつ isFuzzy ?"]

%% 判定条件
CHECK_BRIL["abs(diffTime)<br/>< brilliantTime ?"]
CHECK_GREAT["abs(diffTime)<br/>< greatTime ?"]
CHECK_FAST["fastTime<br/>境界内 ?"]
CHECK_BAD["abs(diffTime)<br/>< badTime ?"]

%% ファジー判定結果
BRIL["JudgeType.Brilliant"]
GREAT_FUZZY["JudgeType.Brilliant<br/>(Great から昇格)"]
FAST_FUZZY["JudgeType.Great<br/>(Fast / Slow から昇格)"]
BAD_FUZZY["JudgeType.Great<br/>(Bad から昇格)"]

%% 通常判定結果
NORMAL_BRIL["JudgeType.Brilliant"]
NORMAL_GREAT["JudgeType.Great"]
NORMAL_FAST["JudgeType.Fast / Slow"]
NORMAL_BAD["JudgeType.Bad"]

%% 開始
JT --> CHECK_FUZZ

%% ファジー有効ルート
CHECK_FUZZ -->|Yes| CHECK_BRIL
CHECK_BRIL -->|Yes| BRIL
CHECK_BRIL -->|No| CHECK_GREAT
CHECK_GREAT -->|Yes| GREAT_FUZZY
CHECK_GREAT -->|No| CHECK_FAST
CHECK_FAST -->|Yes| FAST_FUZZY
CHECK_FAST -->|No| CHECK_BAD
CHECK_BAD -->|Yes| BAD_FUZZY
CHECK_BAD -->|No| NORMAL_BAD

%% ファジー無効ルート
CHECK_FUZZ -->|No| CHECK_BRIL
CHECK_BRIL -->|Yes| NORMAL_BRIL
CHECK_BRIL -->|No| CHECK_GREAT
CHECK_GREAT -->|Yes| NORMAL_GREAT
CHECK_GREAT -->|No| CHECK_FAST
CHECK_FAST -->|Yes| NORMAL_FAST
CHECK_FAST -->|No| NORMAL_BAD

```

ファジー判定緩和が有効な場合、Brilliant未満の判定はBrilliantまたはGreatにアップグレードされます。これは以下に適用されます：

* 同時押しノート（`SameTimeBar`グループ化）
* ロングノート開始および中継点
* ホールド開始判定



---

## スコア計算アルゴリズム 

`ScoreManager`は重み付け比率システムを使用してスコアを計算します：

### スコア公式 

```
score = floor(
    (
        (Perfect + Brilliant) × 1.0 +
        Great × 0.75 +
        (Fast + Slow) × 0.25 +
        Bad × 0.25 +
        Missed × 0.0
    ) / totalNotes × 1,000,000
)
```

達成可能な最大スコアは**1,000,000点**（すべてBrilliant/Perfect判定）です。



### ランク決定 

スコアは固定境界を使用して文字ランクにマッピングされます：

| ランク | 最小スコア | 定数参照 |
| --- | --- | --- |
| S+ | 990,000 | `Constant.RankBoundary.S_PLUS` |
| S | 950,000 | `Constant.RankBoundary.S` |
| A | 900,000 | `Constant.RankBoundary.A` |
| B | 800,000 | `Constant.RankBoundary.B` |
| C | 0 | `Constant.RankBoundary.C` |



 

### 減算スコア表示 

システムは「失った」ポイントを表示するための2つの表示モードを提供します：

#### タイプ1：直接減算

```
subtractedScore = 1,000,000 - ceil(subtractedRate × 1,000,000)

ここでsubtractedRate = (
    (Perfect + Brilliant) × (1 - 1.0) +
    Great × (1 - 0.75) +
    (Fast + Slow) × (1 - 0.25) +
    Bad × (1 - 0.25) +
    Missed × (1 - 0.0)
) / totalNotes
```

#### タイプ2：パーセンテージ損失

以下のいずれかを表示：

* Great判定の数（コンボが途切れていない場合）
* 失ったポイントのパーセンテージ（コンボが途切れた場合）：`-X.XX%`



 

 

---

## ライフゲージシステム 

`LifeManager`は、最大値の半分から始まり、判定に基づいて変化するヘルス値を追跡します。

### ライフ値定数 

| 定数 | 値 | 説明 |
| --- | --- | --- |
| `MAX_LIFE` | 500 | 最大ライフ値 |
| `DANGER_LIFE` | 100 | デンジャーアニメーションの閾値 |
| 開始ライフ | 250 | 最大値の半分 |



### 判定ごとのライフ変化 

```mermaid
flowchart TD

JUDGE["判定結果"]

BAD["Bad<br/>-10 ～ -15<br/>(現在ライフでスケール)"]
MISS["Missed<br/>-30 ～ -45<br/>(現在ライフでスケール)"]

FAST["Fast / Slow<br/>+0"]

PERF["Perfect / Brilliant<br/>+2"]
GREAT["Great<br/>+1"]

LIFE["ライフ値を更新"]

%% 判定分岐
JUDGE --> BAD
JUDGE --> MISS
JUDGE --> FAST
JUDGE --> PERF
JUDGE --> GREAT

%% ライフ更新
BAD --> LIFE
MISS --> LIFE
FAST --> LIFE
PERF --> LIFE
GREAT --> LIFE

subgraph マイナス判定 ["マイナス判定"]
    BAD
    MISS
end

subgraph 中立判定 ["中立判定"]
    FAST
end

subgraph プラス判定 ["プラス判定"]
    PERF
    GREAT
end

```

マイナスのライフ値は現在のライフパーセンテージに基づいてスケーリングされます：

```
BadLife = -10 × (1 + 0.5 × (currentLife / MAX_LIFE))
MissLife = -30 × (1 + 0.5 × (currentLife / MAX_LIFE))
```

このスケーリングにより、ライフが高いときにより大きなペナルティが発生し、動的な難易度調整が提供されます。



### ゲームオーバー条件 

ライフがゼロ以下になった場合：

* `_isDead`フラグが`true`に設定される
* `OnDead`イベントが`MusicGameSceneController`に発火される
* ゲームプレイが早期に終了する



### デンジャー状態 

ライフが`DANGER_LIFE`（100）を下回った場合：

* `_isDanger`フラグが設定される
* ライフゲージUIがDOTweenアニメーションを使用して赤く点滅する
* ライフが閾値を超えると状態が元に戻る



---

## データ収集システム 

判定システムは、ゲーム後の分析と自動キャリブレーションのために詳細なパフォーマンスデータを記録します。

### TimingHistory 

`TimingHistory`は、4つの同期されたリストで各判定イベントを記録します：

| リスト | 型 | 内容 |
| --- | --- | --- |
| `_musicTime` | `List<float>` | 判定時の音楽再生時間（秒） |
| `_timing` | `List<float>` | 完璧なタイミングからの時間差（秒） |
| `_judgeTypes` | `List<JudgeType>` | 付与された判定タイプ |
| `_noteTypes` | `List<NoteType>` | ノートタイプ（Tap/Hold/Long/Fuzzy/等） |

ゲームプレイ中のアロケーションを最小限に抑えるため、容量は総ノート数に基づいて事前に割り当てられます。



### LifeHistory 

`LifeHistory`は1秒間隔でライフ値を記録します：

これにより、各秒内のサンプルを平均化することで、滑らかなライフグラフが生成されます。

### ResultDataへのデータフロー 

```mermaid
flowchart TD

JM["JudgeManager"]
LM["LifeManager"]
SM["ScoreManager"]
CM["ComboManager"]
TH["TimingHistory"]
LH["LifeHistory"]
RD["ResultData"]
RG["ResultGraph タイミング＆ライフを可視化"]
RAT["ResultAutoTimingPanel オフセット補正を計算"]

JM -.->|"スコア＆ランク"| RD
SM -.->|"最大コンボ"| RD
CM -.->|"TimingHistory"| RD
TH -.->|"平均/中央値を計算"| RD
LH -.->|"LifeHistory"| RD
RD -.->|"履歴データを読取"| RG
RD -.-> RAT

subgraph リザルトシーン ["リザルトシーン"]
    RG
    RAT
end

subgraph リザルト集約 ["リザルト集約"]
    RD
end

subgraph ゲームプレイフェーズ ["ゲームプレイフェーズ"]
    JM
    LM
    SM
    CM
    TH
    LH
    JM -.->|"タイミングデータを追加"| TH
    LM -.->|"毎秒ライフ記録"| LH
end
```



---

## ResultData構造 

`ResultData`クラスはすべてのゲームプレイ結果を集約します：

```
public class ResultData
{    
    public int Score;                    // 最終スコア（0-1,000,000）
    public Judge Judge;                  // 判定カウント
    public EarlyLate EarlyLate;          // 早い/遅いカウント
    public bool IsDead;                  // ゲームオーバーフラグ
    public bool IsFullCombo;             // コンボ中断なし
    public bool IsAllBrilliant;          // すべてのノートがBrilliant    
    public int MaxCombo;                 // 達成した最高コンボ
    public TimingHistory TimingHistory;  // ノートごとのタイミングデータ
    public LifeHistory LifeHistory;      // 毎秒のライフデータ
    public bool DisableRanking;          // ランキング投稿無効
}

```

この構造体は、ゲームプレイ終了時に`MusicGameSceneController`によって設定され、リザルトシーンからのアクセスのために`GameManager.Instance.ResultData`に保存されます。



---

## リザルト可視化 

### ResultGraph 

`ResultGraph`コンポーネントは、収集されたデータを2Dテクスチャとしてレンダリングします：

```mermaid
flowchart TD

RG["ResultGraph.DrawGraphAsync()"]
BG["背景 (タイミングガイド付き黒)"]
MISS["ミスライン (垂直赤線)"]
TIMING["タイミングドット (判定で色分け)"]
LIFE["ライフライン (白い折れ線グラフ)"]
CYAN["Brilliant/Perfect → シアン"]
YELLOW["Great → 黄色"]
GREEN["Fast/Slow → 緑"]
BLUE["Bad → 青"]
RED["Missed → 赤"]

RG -.-> BG
TIMING -.-> CYAN
TIMING -.-> YELLOW
TIMING -.-> GREEN
TIMING -.-> BLUE
TIMING -.-> RED

subgraph 色マッピング ["色マッピング"]
    CYAN
    YELLOW
    GREEN
    BLUE
    RED
end

subgraph レンダリングレイヤー ["レンダリングレイヤー"]
    BG
    MISS
    TIMING
    LIFE
    BG -.-> MISS
    MISS -.-> TIMING
    TIMING -.-> LIFE
end
```

グラフはUIからテクスチャ寸法を使用し、以下をプロットします：

* **X軸**：音楽再生時間（0から曲終了まで）
* **Y軸**：完璧なタイミングからの時間差（-hitTimeから+hitTime）

実装は効率的なピクセル操作のために`NativeArray<Color32>`を使用し、重い計算のためにバックグラウンドスレッドに切り替えます。



### 自動タイミングキャリブレーション 

`ResultAutoTimingPanel`は`TimingHistory`を分析し、タイミングオフセット補正を提案します：

#### 計算方法

1. **平均オフセット**：すべてのタイミング差の平均
2. **中央値オフセット**：ソートされたタイミング差の中央値
3. **ファジーフィルタリング**：計算からファジーノートを除外するオプション

#### 実装

```
TimingHistory内の各タイミングについて：
    -hitTime < timing < hitTimeの場合：
        adjustedTiming = timing + currentOffset
        リストに追加

平均 = Sum(adjustedTimings) / Count
中央値 = adjustedTimings[Count / 2]（ソート済み）
```

パネルはプレイヤーに以下を許可します：

* グローバルタイミング（`NotesOption.Timing`）またはローカルタイミング（`LocalTimingPrefas`）の選択
* ファジーノートフィルタリングの切り替え
* 平均または中央値補正の適用



---

## 設定依存関係 

判定システムは複数の設定ソースから読み取ります：

```mermaid
flowchart TD

JTO["JudgeTimeOption"]
DO["DisplayOption"]
NO["NotesOption"]
PMO["PlayModeOption"]
WINDOWS["タイミングウィンドウ (Brilliant/Great/Fast/Bad)"]
RATE["音楽レート"]
DIST["判定距離"]
REVISIONS["ロング補正"]
FUZZY["ファジー緩和"]
VIB["バイブレーション"]
EARLY["早い/遅い表示"]
PERF["Perfect表示"]
THRESH["早い/遅い閾値"]

JTO -.->|"MusicRate"| WINDOWS
JTO -.->|"JudgeDistance"| RATE
JTO -.->|"ロング補正値"| DIST
JTO -.->|"FuzzyJudgeMitigation"| REVISIONS
JTO -.->|"Vibration"| FUZZY
JTO -.-> VIB
DO -.->|"IsShowPerfectJudge"| EARLY
DO -.->|"EarlyLateDisplayThreshold"| PERF
DO -.->|"PerfectJudgeTime"| THRESH
DO -.->|"タイミング値"| WINDOWS

subgraph 表示設定 ["表示設定"]
    EARLY
    PERF
    THRESH
end

subgraph JudgeManager設定 ["JudgeManager設定"]
    WINDOWS
    RATE
    DIST
    REVISIONS
    FUZZY
    VIB
end

subgraph GameManager.Instance ["GameManager.Instance"]
    JTO
    DO
    NO
    PMO
end
```

すべての設定は`JudgeManager.Init()`中に一度読み込まれ、パフォーマンスのためにプライベートフィールドにキャッシュされます。



---

## 統合ポイント 

判定システムは他のゲームプレイシステムと統合されます：

### イベント駆動アーキテクチャ 

* **`OnJudge`イベント**：判定時に即座に発火され、以下によってサブスクライブされます：
* `LifeManager.UpdateLife()`
* `LuaManager`（カスタムスクリプト用）
* **`OnAfterJudge`イベント**：判定処理後に発火され、以下によってサブスクライブされます：
* `ScoreManager.OnAfterJudge()`
* `ComboManager.UpdateCombo()`

この分離により、システムは密結合なしに独立して反応できます。



 

### 空間判定 

ノートは時間的および空間的の両方で評価されます：

```
public bool IsHitArea(float diffPosX, double diffTime, bool isRevision)
{    
    double revision = isRevision ? _upRevisionTime : 0d;
            
    if (
        diffPosX < (_judgeDistance + _longDistanceRevision) && 
        diffTime < (_greatTime + revision)) 
    {        
        return true;    
    }

    // 外側のタイミングウィンドウの線形補間    
    float area = Mathf.Clamp01(
        (float)((diffTime - (_greatTime + revision)) / 
        (_badTime - (_greatTime + revision)))
    );

    return diffPosX < Mathf.Lerp(
        (_judgeDistance + _longDistanceRevision), 
        0f, 
        area
    );
}
```

これにより、以下のような台形の判定エリアが作成されます：

* タイミングラインに近いノートは水平方向により遠くからヒット可能
* タイミングが悪いノートは水平方向により正確にヒットする必要がある


### On this page

* [判定とスコアリングシステム](#4-)
* [目的と範囲](#4--1)
* [システムアーキテクチャ](#4--2)
* [判定タイプとデータ構造](#4--3)
* [JudgeType列挙型](#4-judgetype)
* [Judge構造体](#4-judge)
* [EarlyLate追跡](#4-earlylate)
* [判定フロー](#4--4)
* [タイミングウィンドウの設定](#4--5)
* [タイミングウィンドウ表](#4--6)
* [補正パラメータ](#4--7)
* [ファジー判定緩和](#4--8)
* [スコア計算アルゴリズム](#4--9)
* [スコア公式](#4--10)
* [ランク決定](#4--11)
* [減算スコア表示](#4--12)
* [ライフゲージシステム](#4--13)
* [ライフ値定数](#4--14)
* [判定ごとのライフ変化](#4--15)
* [ゲームオーバー条件](#4--16)
* [デンジャー状態](#4--17)
* [データ収集システム](#4--18)
* [TimingHistory](#4-timinghistory)
* [LifeHistory](#4-lifehistory)
* [ResultDataへのデータフロー](#4-resultdata)
* [ResultData構造](#4-resultdata-1)
* [リザルト可視化](#4--19)
* [ResultGraph](#4-resultgraph)
* [自動タイミングキャリブレーション](#4--20)
* [設定依存関係](#4--21)
* [統合ポイント](#4--22)
* [イベント駆動アーキテクチャ](#4--23)
* [空間判定](#4--24)

