

# 判定タイミング設定 

## 目的と範囲 

このドキュメントでは、プレイヤーがノート判定のタイミングウィンドウ、ロングノートの動作、および各種ゲームプレイモディファイアをカスタマイズできる判定タイミング設定システムについて詳しく説明します。このシステムは`JudgeTimeSettingsPanel` UIコントローラーと`JudgeTimeOption`データモデルを通じて実装されています。

一般的なゲーム設定管理と永続化メカニズムについては、[ゲーム設定管理](#6.1)を参照してください。これらのタイミングウィンドウがゲームプレイ中に実際にどのように使用されるかについては、[判定メカニクス](#4.1)を参照してください。

---

## システム概要 

判定タイミング設定システムは、3つのカテゴリの設定を提供します：

1. **判定タイミングウィンドウ** - Brilliant、Great、Fast、Bad判定の設定可能なタイムウィンドウ
2. **特殊オプション** - 楽曲速度、ミラーモード、カスタムLuaスクリプトを含むゲームプレイモディファイア
3. **オーディオ設定** - DSPバッファサイズと空打ち音抑制

```mermaid
flowchart TD

JTSP["JudgeTimeSettingsPanel"]
JTP["JudgeTimePanel (タイムスライダーコンポーネント)"]
JDP["JudgeDistancePanel (距離スライダー)"]
MRP["MusicRatePanel"]
FJMP["FuzzyJudgeMitigationPanel"]
MP["MirrorPanel"]
VP["VibrationPanel"]
PLPP["PauseLongPressPanel"]
GLP["GlobalLuaPanel"]
NTP["NullTapPanel"]
DSBP["DspBufferSizePanel"]
JTO["JudgeTimeOption"]
GM["GameManager.Instance"]
GSP["GameSettingsPrefas"]
GLC["GlobalLuaCache"]
ED["ExternalDirectory.LoadGlobalLua()"]

JTSP -.->|"読取/書込"| JTO
GM -.->|"永続化"| GSP
GLP -.->|"OnChangeValue"| GLC
JTSP -.-> JTO
JTSP -.-> JTO

subgraph 外部リソース ["外部リソース"]
    GLC
    ED
    GLC -.->|"Init() 読取元"| ED
end

subgraph 永続化 ["永続化"]
    GSP
end

subgraph データモデル ["データモデル"]
    JTO
    GM
    JTO -.->|"保存先"| GM
end

subgraph UIレイヤー ["UIレイヤー"]
    JTSP
    JTP
    JDP
    MRP
    FJMP
    MP
    VP
    PLPP
    GLP
    NTP
    DSBP
    JTSP -.->|"含む"| JTP
    JTSP -.->|"含む"| JDP
    JTSP -.->|"含む"| MRP
    JTSP -.->|"含む"| FJMP
    JTSP -.->|"含む"| MP
    JTSP -.->|"含む"| VP
    JTSP -.->|"読込元"| PLPP
    JTSP -.->|"含む"| GLP
    JTSP -.->|"スキャン"| NTP
    JTSP -.->|"含む"| DSBP
end
```

---

## データモデル: JudgeTimeOption 

`JudgeTimeOption`クラスは、すべての判定タイミング設定値をシリアライズ可能なフィールドとして保存します。これは`GameManager.Instance.JudgeTimeOption`に存在し、`GameSettingsPrefas`を介して永続化されます。

### コアタイミングフィールド 

| フィールド | 型 | デフォルト値 | 説明 |
| --- | --- | --- | --- |
| `BrilliantTime` | `float` | `Constant.JudgeTime.BRILLIANT_TIME` | Brilliant判定のタイムウィンドウ（ms） |
| `GreatTime` | `float` | `Constant.JudgeTime.GREAT_TIME` | Great判定のタイムウィンドウ（ms） |
| `FastTime` | `float` | `Constant.JudgeTime.FAST_TIME` | Fast判定のタイムウィンドウ（ms） |
| `BadTime` | `float` | `Constant.JudgeTime.BAD_TIME` | Bad判定のタイムウィンドウ（ms） |
| `JudgeDistance` | `float` | `Constant.JudgeTime.JUDGE_DISTANCE` | 位置ベース判定の閾値 |
| `LongRevisionTime` | `float` | `Constant.JudgeTime.LONG_REVISION_TIME` | ロングノート終端タイミング調整（ms） |
| `LongRevisionDistance` | `float` | `Constant.JudgeTime.LONG_REVISION_DISTANCE` | ロングノート位置調整 |
| `FuzzyStartTime` | `float` | `Constant.JudgeTime.FUZZY_START_TIME` | ファジー判定開始ウィンドウ（ms） |

### 特殊オプション 

| フィールド | 型 | デフォルト値 | 説明 |
| --- | --- | --- | --- |
| `CanSave` | `bool` | `false` | カスタムタイミングが保存可能かどうか |
| `MusicRate` | `float` | `1.0f` | 楽曲再生速度倍率 |
| `FuzzyJudgeMitigation` | `bool` | `true` | ファジー判定緩和を有効化 |
| `Mirror` | `bool` | `false` | ミラーモード（左右反転） |
| `Vibration` | `bool` | `false` | ノートヒット時の触覚フィードバック |
| `PauseLongPress` | `bool` | `false` | 長押しでポーズを有効化 |
| `GlobalLuaName` | `string` | Default | アクティブなグローバルLuaスクリプトの名前 |
| `NullTapNoSoundTime` | `float` | `0.2f` | N秒間空打ちSEを抑制（秒） |
| `DspBufferSize` | `int` | `256` | オーディオDSPバッファサイズ（サンプル） |

### プロパティ 

このクラスは、有効なタイミングウィンドウを計算するためのユーティリティメソッドを提供します：

```
// 最長の判定幅を返す
public float GetHitTime()
// ロングノート補正を含む最長幅を返す
public float GetLongEndHitTime()
// コンボを維持する最長幅を返す
public float GetComboHitTime()
// いずれかの設定がデフォルトと異なるかチェック
public bool IsCustom
```


## UIコントローラー: JudgeTimeSettingsPanel 

`JudgeTimeSettingsPanel` MonoBehaviourは、設定UIを統括し、UIコンポーネントを`JudgeTimeOption`フィールドにバインドし、ユーザーインタラクションを処理します。

### コンポーネントアーキテクチャ 

```mermaid
flowchart TD

RSO["_resetSpecialOptionSettingButton"]
Main["JudgeTimeSettingsPanel"]
JBP["_judgeBrilliantPanel"]
JGP["_judgeGreatPanel"]
JFP["_judgeFastPanel"]
JBAD["_judgeBadPanel"]
JDP["_judgeDistancePanel"]
JLRT["_judgeLongRevisionTimePanel"]
JLRD["_judgeLongRevisionDistancePanel"]
JFST["_judgeFuzzyStartTimePanel"]
MR["_musicRatePanel"]
FJM["_fuzzyJudgeMitigationPanel"]
MIR["_mirrorPanel"]
VIB["_vibrationPanel"]
PLP["_pauseLongPressPanel"]
GL["_globalLuaPanel"]
NT["_nullTapPanel"]
DSP["_dspBufferSizePanel"]
RSYS["_resetSystemOptionSettingButton"]
RELOAD["_reloadSongButton"]

subgraph JudgeTimeSettingsPanel構造 ["JudgeTimeSettingsPanel構造"]
    Main
    Main -.->|"含む"| JBP
    Main -.->|"含む"| JGP
    Main -.->|"含む"| JFP
    Main -.->|"含む"| JBAD
    Main -.->|"含む"| JDP
    Main -.->|"含む"| JLRT
    Main -.->|"含む"| JLRD
    Main -.->|"含む"| JFST
    Main -.->|"含む"| MR
    Main -.->|"含む"| FJM
    Main -.->|"含む"| MIR
    Main -.->|"含む"| VIB
    Main -.-> PLP
    Main -.->|"含む"| GL
    Main -.-> NT
    Main -.-> DSP
    Main -.->|"含む"| RSO
    Main -.->|"含む"| RSYS
    Main -.->|"含む"| RELOAD

subgraph コントロールボタン ["コントロールボタン"]
    RSO
    RSYS
    RELOAD
end

subgraph オーディオ設定 ["オーディオ設定（2パネル）"]
    NT
    DSP
end

subgraph 特殊オプション ["特殊オプション（6パネル）"]
    MR
    FJM
    MIR
    VIB
    PLP
    GL
end

subgraph 判定タイミング ["判定タイミング（8パネル）"]
    JBP
    JGP
    JFP
    JBAD
    JDP
    JLRT
    JLRD
    JFST
end
end
```

### 内部パネルタイプ 

このパネルは、異なるUIコントロールタイプのために、いくつかのネストされたシリアライズ可能なクラスを使用します：

1. **`JudgeTimePanel`** - スライダー付きタイム調整（±1msボタン、スライダー、テキスト表示）
2. **`JudgeDistancePanel`** - スライダー付き距離調整（±0.01ステップ）
3. **`MusicRatePanel`** - リセット付き速度調整（50%-200%、±1%ステップ）
4. **`JudgeOtherPanel`** - リセットボタン付きブールトグル
5. **`GlobalLuaPanel`** - Luaスクリプトのサイクリックセレクター
6. **`FuzzyJudgeMitigationPanel` / `MirrorPanel` / `VibrationPanel` / `PauseLongPressPanel`** - シンプルなYes/Noトグル
7. **`NullTapPanel`** - 空打ち抑制のタイムスライダー（0-5秒、0.1秒ステップ）
8. **`DspBufferSizePanel`** - 256/512サンプル間のトグル（iOSは常に256）

---

## タイミングウィンドウ設定 

### 判定タイムウィンドウ 

このシステムは、4つのタイミングウィンドウのミリ秒精度の調整を可能にします：

```mermaid
flowchart TD

BAD["Badウィンドウ (±BadTime)"]
MISS["Miss"]
FAST["Fastウィンドウ (±FastTime)"]
GREAT["Greatウィンドウ (±GreatTime)"]
BRIL["Brilliantウィンドウ (±BrilliantTime)"]

subgraph タイミングウィンドウ階層 ["タイミングウィンドウ階層"]
    BAD
    MISS
    FAST
    GREAT
    BRIL
    MISS -.->|"内側"| BAD
    BAD -.->|"内側"| FAST
    FAST -.->|"内側"| GREAT
    GREAT -.->|"内側"| BRIL
end
```

各タイミングパネル（`JudgeTimePanel`）は以下を提供します：

* **Downボタン** - 値を1ms減少
* **Upボタン** - 値を1ms増加
* **スライダー** - 設定された最小/最大内での連続調整
* **テキスト表示** - 現在の値をミリ秒で表示

### 初期化と更新フロー 

```mermaid
sequenceDiagram
  participant p1 as JudgeTimeSettingsPanel
  participant p2 as JudgeTimeOption
  participant p3 as JudgeTimePanel

  p1->>p2: BrilliantTimeを読取
  p1->>p3: Init(BrilliantTime)
  p3->>p3: スライダー値を設定 (time * 1000)
  p3->>p3: テキストを設定 "Xms"
  note over p3: ユーザーがスライダーを調整
  p3->>p1: OnChangeValue(intValue)
  p1->>p2: BrilliantTime = value / 1000f
  p1->>p1: CheckCustomJudgement(IsCustom)
```

**実装の詳細:**

`Init()`メソッドは秒をミリ秒に変換して表示します：

```
_timeSilder.value = (int)((decimal)time * 1000);
_timeText.SetText(ZString.Concat((int)((decimal)time * 1000), "ms"));
```

`OnChangeValue`コールバックは秒に戻して`JudgeTimeOption`を更新します：

```
judgeTimeOption.BrilliantTime = value / 1000f;
CheckCustomJudgement(judgeTimeOption.IsCustom);
```

### カスタム判定インジケーター 

いずれかのタイミング値がそのデフォルト定数と異なる場合、`IsCustom`プロパティが`true`になり、視覚的インジケーター（`_customJudgement` GameObject）が表示されます：


## 判定距離設定 

タイムベースの判定に加えて、このシステムは位置ベースの「判定距離」閾値をサポートしています。

### 距離パネル 

2つの`JudgeDistancePanel`インスタンスが制御します：

1. **`_judgeDistancePanel`** - 基本位置判定閾値（0.0-2.0、ステップ0.01）
2. **`_judgeLongRevisionDistancePanel`** - ロングノート位置調整（0.0-2.0、ステップ0.01）

パネルは内部的に値を整数として（100倍して）保存します：

```
_silder.value = (int)((decimal)revision * 100);
_valueText.SetText(ZString.Concat(revision, ""));
```

値変更時：

```
judgeTimeOption.JudgeDistance = value / 100f;
```

## ロングノート補正設定 

ロングノート（ホールドノート）には、終端判定に適用される別個のタイミング調整があります：

### ロング補正タイム 

`_judgeLongRevisionTimePanel`は、ロングノートリリースのタイミングウィンドウを調整します。この値は、ロングノート終端を判定する際にBrilliant/Greatウィンドウに**追加**されます

### ロング補正距離 

`_judgeLongRevisionDistancePanel`は、基本の`JudgeDistance`とは別に、ロングノート終端検出の位置ベース閾値を調整します。

## ファジー判定設定 

ファジー判定システムは2つの設定を提供します：

### ファジー開始タイム 

`_judgeFuzzyStartTimePanel`は、譜面の冒頭でファジー判定ロジックが適用されるタイムウィンドウを設定します。これは譜面開始時の救済メカニズムです。

### ファジー判定緩和 

`_fuzzyJudgeMitigationPanel`は、ファジー判定緩和アルゴリズムを有効/無効にします。有効な場合（`FuzzyJudgeMitigation = true`）、システムは同時押しノートパターン中の誤ったミスを防ぐための特別なロジックを適用します。

## 特殊ゲームプレイオプション 

### 楽曲速度 

`_musicRatePanel`（`MusicRatePanel`）は、50%から200%までの再生速度を制御します

```mermaid
flowchart TD

MRP["MusicRatePanel"]
RESET["リセットボタン (100%)"]
DOWN["Downボタン (-1%)"]
UP["Upボタン (+1%)"]
SLIDER["スライダー (50-200)"]
UPDATE["JudgeTimeOption.MusicRateを更新"]
PREVIEW["PreviewMusic.Instance"]

MRP -.->|"含む"| RESET
MRP -.->|"含む"| DOWN
MRP -.->|"含む"| UP
MRP -.->|"含む"| SLIDER
SLIDER -.->|"OnValueChanged"| UPDATE
UPDATE -.->|"SetMusicRate()"| PREVIEW
```

値が変更されると、即座にプレビュー音楽の再生を更新します

### ミラーモード 

`_mirrorPanel`は、ノート譜面の水平ミラーリングを有効にします。`Mirror = true`の場合、ノートは左右反転して表示されます。

### バイブレーション 

`_vibrationPanel`は、ノートヒット時の触覚フィードバックを有効にします。このパネルは`SystemInfo.supportsVibration`をチェックし、サポートされていないデバイスでは自身を非表示にします

### ポーズ長押し 

`_pauseLongPressPanel`は、ゲームプレイ中に画面の任意の場所を長押しすることでゲームを一時停止できるようにします。

### グローバルLuaスクリプト選択 

`_globalLuaPanel`（`GlobalLuaPanel`）は、すべての楽曲中に実行されるグローバルLuaスクリプトを選択できます。これは最も複雑な特殊オプションです。

**スクリプト読込プロセス:**

1. `GlobalLuaCache.Instance.HasCache`が真かチェック
2. キャッシュされていない場合：
* デフォルトスクリプトを追加：`DEFAULT_GLOBAL_LUA_NAME` / `DEFAULT_GLOBAL_LUA_FILENAME`
* `ExternalDirectory.LoadGlobalLua()`でカスタムスクリプトを読込
* `GlobalLuaCache`にリストをキャッシュ
3. `_globalLuaInfoList`に`GlobalLuaInfo`エントリを入力
4. 保存された`JudgeTimeOption.GlobalLuaName`で現在のスクリプトを名前から検索
5. `_globalLuaNameText.SetText()`で表示を更新

**ナビゲーション:**

* Downボタン：`_currentIndex--`、0未満の場合は末尾にラップ
* Upボタン：`_currentIndex++`、カウント以上の場合は0にラップ
* 両方ともテキストを更新し、`OnChangeValue`を呼び出す


## オーディオ設定 

### 空打ち音無再生時間 

`_nullTapPanel`（`NullTapPanel`）は、最後のノート後に空打ち音SEを抑制する時間を設定します。これにより、休符期間中の過剰なSE再生を防ぎます。

* **範囲:** 0.0秒から5.0秒
* **ステップ:** 0.1秒（スライダーは10分の1を表す）
* **デフォルト:** 0.2秒

### DSPバッファサイズ 

`_dspBufferSizePanel`（`DspBufferSizePanel`）は、UnityのオーディオDSPバッファサイズを制御し、これがオーディオレイテンシーに影響します：

* **オプション:** 256サンプルまたは512サンプル
* **デフォルト:** 256サンプル
* **iOS:** 常に256を使用、iOSデバイスではパネルが非表示

**バッファサイズ変更手順:**

```mermaid
sequenceDiagram
  participant p1 as ユーザー
  participant p2 as DspBufferSizePanel
  participant p3 as JudgeTimeOption
  participant p4 as AudioSettings
  participant p5 as PreviewMusic

  p1->>p2: 256/512をトグル
  p2->>p3: DspBufferSize = 256 または 512
  p2->>p4: AudioSettings.GetConfiguration()
  p2->>p4: ac.dspBufferSize = value
  p2->>p4: AudioSettings.Reset(ac)
  p2->>p5: await UniTask.Yield()
  p2->>p5: ClearClipCache()
  p2->>p5: SetMusicRate()
  p2->>p5: 再生中だった場合 PlayPreview(songInfo)
```

**プラットフォーム処理:**

* **iOS:** パネル非表示（`_togglePanel.SetActive(false)`）、説明テキストを表示
* **Android/Windows:** 256/512トグルが利用可能
* **エディター:** 開発用に常に1024を使用


## リセットとリロード機能 

### 特殊オプションリセットボタン 

`_resetSpecialOptionSettingButton`は、すべての特殊オプションをデフォルトにリセットします：

### システムオプションリセットボタン 

`_resetSystemOptionSettingButton`は、オーディオ設定をリセットします：

### 楽曲リロードボタン 

`_reloadSongButton`は、完全なキャッシュクリアとシーンリロードを実行します：

```mermaid
flowchart TD

BTN["_reloadSongButton クリック"]
SAVE["すべての設定を保存 GameSettingsPrefas.Save()"]
CLEAR1["NoteSkinCache.Instance.Clear()"]
CLEAR2["TouchSeCache.Instance.Clear()"]
CLEAR3["GlobalLuaCache.Instance.Clear()"]
CLEAR4["GameManager.Instance.ClearSongsCache()"]
EVENT["OnBeforeReload イベント"]
SCENE["ChangeScene(SelectMusic)"]

BTN -.-> SAVE
SAVE -.-> CLEAR1
CLEAR1 -.-> CLEAR2
CLEAR2 -.-> CLEAR3
CLEAR3 -.-> CLEAR4
CLEAR4 -.-> EVENT
EVENT -.-> SCENE
```

**目的:** アプリケーションを再起動せずに、すべての外部コンテンツ（ノートスキン、タッチSE、グローバルLua、楽曲リスト）をリロードします。新しいコンテンツファイルを追加した後に便利です。

## 初期化フロー 

設定パネルが開かれたときの完全な初期化シーケンス：

```mermaid
sequenceDiagram
  participant p1 as 呼出元
  participant p2 as JudgeTimeSettingsPanel
  participant p3 as JudgeTimeOption
  participant p4 as 各種サブパネル

  p1->>p2: Init()
  p2->>p3: var judgeTimeOption = GameManager.Instance.JudgeTimeOption
  note over p2: コールバックをセットアップ (OnChangeValue)
  p2->>p2: すべてのパネルコールバックをJTOフィールドにバインド
  note over p2: パネルを初期化
  p2->>p4: _judgeBrilliantPanel.Init(JTO.BrilliantTime)
  p2->>p4: _judgeGreatPanel.Init(JTO.GreatTime)
  p2->>p4: _judgeFastPanel.Init(JTO.FastTime)
  p2->>p4: _judgeBadPanel.Init(JTO.BadTime)
  p2->>p4: _judgeDistancePanel.Init(JTO.JudgeDistance)
  p2->>p4: _judgeLongRevisionTimePanel.Init(...)
  p2->>p4: _judgeLongRevisionDistancePanel.Init(...)
  p2->>p4: _judgeFuzzyStartTimePanel.Init(...)
  p2->>p4: _judgeOtherPanel.Init(JTO.CanSave)
  p2->>p4: _musicRatePanel.Init(JTO.MusicRate)
  p2->>p4: _fuzzyJudgeMitigationPanel.Init(...)
  p2->>p4: _mirrorPanel.Init(JTO.Mirror)
  p2->>p4: _vibrationPanel.Init(JTO.Vibration)
  p2->>p4: _pauseLongPressPanel.Init(...)
  p2->>p4: _globalLuaPanel.Init(JTO.GlobalLuaName)
  p2->>p4: _nullTapPanel.Init(JTO.NullTapNoSoundTime)
  p2->>p4: _dspBufferSizePanel.Init(JTO.DspBufferSize == 512)
  p2->>p2: CheckCustomJudgement(JTO.IsCustom)
```

**主要ステップ:**

1. **参照を取得:** `GameManager.Instance`から`JudgeTimeOption`を取得
2. **コールバックをバインド:** すべてのパネルの`OnChangeValue`デリゲートを`JudgeTimeOption`フィールドを更新するように設定
3. **UIを初期化:** 各サブパネルで`JudgeTimeOption`の現在値を使用して`Init()`を呼び出す
4. **カスタム状態をチェック:** 値がデフォルトと異なる場合、カスタム判定インジケーターを表示


## 永続化統合 

判定タイミング設定は、`GameSettingsPrefas`システムを通じて自動的に永続化されます：

### 保存トリガー 

設定は2つのシナリオで保存されます：

1. **アプリケーション終了時の自動保存** - `GameSettingsPrefas`ライフサイクル経由
2. **リロード時の手動保存** - `_reloadSongButton`クリック経由：


### 読込トリガー 

設定は、`GameManager`が永続化データからオプションを初期化するアプリケーション起動時に読み込まれます。

永続化メカニズムの詳細については、[データ永続化システム](#2.3)を参照してください。

### On this page

* [判定タイミング設定](#6.2-)
* [目的と範囲](#6.2--1)
* [システム概要](#6.2--2)
* [データモデル: JudgeTimeOption](#6.2--judgetimeoption)
* [コアタイミングフィールド](#6.2--3)
* [特殊オプション](#6.2--4)
* [計算されたプロパティ](#6.2--5)
* [UIコントローラー: JudgeTimeSettingsPanel](#6.2-ui-judgetimesettingspanel)
* [コンポーネントアーキテクチャ](#6.2--6)
* [内部パネルタイプ](#6.2--7)
* [タイミングウィンドウ設定](#6.2--8)
* [判定タイムウィンドウ](#6.2--9)
* [初期化と更新フロー](#6.2--10)
* [カスタム判定インジケーター](#6.2--11)
* [判定距離設定](#6.2--12)
* [距離パネル](#6.2--13)
* [ロングノート補正設定](#6.2--14)
* [ロング補正タイム](#6.2--15)
* [ロング補正距離](#6.2--16)
* [ファジー判定設定](#6.2--17)
* [ファジー開始タイム](#6.2--18)
* [ファジー判定緩和](#6.2--19)
* [特殊ゲームプレイオプション](#6.2--20)
* [楽曲速度](#6.2--21)
* [ミラーモード](#6.2--22)
* [バイブレーション](#6.2--23)
* [ポーズ長押し](#6.2--24)
* [グローバルLuaスクリプト選択](#6.2-lua)
* [オーディオ設定](#6.2--25)
* [空打ち音無再生時間](#6.2--26)
* [DSPバッファサイズ](#6.2-dsp)
* [リセットとリロード機能](#6.2--27)
* [特殊オプションリセットボタン](#6.2--28)
* [システムオプションリセットボタン](#6.2--29)
* [楽曲リロードボタン](#6.2--30)
* [初期化フロー](#6.2--31)
* [永続化統合](#6.2--32)
* [保存トリガー](#6.2--33)
* [読込トリガー](#6.2--34)

