

# 判定メカニクス 

このドキュメントは、ゲームプレイ中にプレイヤー入力の精度をリアルタイムで評価する判定システムについて説明します。このシステムは、タイミングと空間的な近接性に基づいて、ノーツヒットがPerfect、Brilliant、Great、Fast、Slow、Bad、またはMissedであるかを判定します。また、ファジー判定緩和やロングノート補正などの特殊ケースも処理します。

判定結果がライフとスコアリングにどのように影響するかについては、[ライフとスコア管理](#4.2)を参照してください。判定データがゲーム後の分析のためにどのように記録されるかの詳細については、[リザルトデータ収集](#4.3)を参照してください。

---

## 判定タイプの概要 

判定システムは、各プレイヤー入力を`JudgeType`列挙型で表される離散的なカテゴリに分類します。

### JudgeType 列挙型 

| JudgeType | 値 | 説明 |
| --- | --- | --- |
| `Brilliant` | 0 | 最高判定、ほぼ完璧なタイミング |
| `Great` | 1 | 良好なタイミング、コンボは維持される |
| `Fast` | 2 | 早すぎるヒット、コンボが途切れる |
| `Slow` | 3 | 遅すぎるヒット、コンボが途切れる |
| `Bad` | 4 | 大幅にタイミングがずれている |
| `Missed` | 5 | タイミングウィンドウ内にヒットしなかった |
| `Perfect` | 6 | 表示目的の特殊フラグ |
| `None` | 7 | 判定なし（内部状態） |

`Judge`構造体は、楽曲全体を通じて各判定タイプの累積カウントを追跡します：

```
Judge {
    int Perfect
    int Brilliant
    int Great
    int Fast
    int Slow
    int Bad
    int Missed
}
```



---

## タイミングウィンドウのアーキテクチャ 

判定システムは、複数の重なり合う時間ウィンドウを使用して入力精度を評価します。各ウィンドウは、ノーツの完璧なタイミングとプレイヤーの入力との間の最大許容時間差を表します。

### タイミングウィンドウの階層構造 

```mermaid
flowchart TD

MISS_LEFT["Miss (-BadTime)"]
BAD_LEFT["Bad (-BadTime から -GreatTime)"]
FAST["Fast (-FastTime から -GreatTime)"]
GREAT_LEFT["Great (-GreatTime から -BrilliantTime)"]
BRILLIANT["Brilliant (-BrilliantTime から +BrilliantTime)"]
GREAT_RIGHT["Great (+BrilliantTime から +GreatTime)"]
SLOW["Slow (+GreatTime から +FastTime)"]
BAD_RIGHT["Bad (+GreatTime から +BadTime)"]
MISS_RIGHT["Miss (+BadTime)"]

subgraph 時間軸 ["時間軸（ノーツタイミングを中心）"]
    MISS_LEFT
    BAD_LEFT
    FAST
    GREAT_LEFT
    BRILLIANT
    GREAT_RIGHT
    SLOW
    BAD_RIGHT
    MISS_RIGHT
    FAST -.-> GREAT_LEFT
    BRILLIANT -.-> GREAT_RIGHT
    SLOW -.-> BAD_RIGHT
end
```

### デフォルトタイミング値 

デフォルトのタイミングウィンドウは`Constant.JudgeTime`で定義されています：

| ウィンドウ | フィールド | デフォルト値（秒） |
| --- | --- | --- |
| Brilliant | `BrilliantTime` | 0.050 |
| Great | `GreatTime` | 0.100 |
| Fast | `FastTime` | 0.120 |
| Bad | `BadTime` | 0.150 |
| Perfect表示 | `PerfectJudgeTime` | 0.030 |

### 楽曲速度スケーリング 

すべてのタイミングウィンドウは`MusicRate`で乗算され、異なる再生速度でも一貫した判定フィーリングを維持します：

```
effectiveTime = configuredTime * musicRate
```

例えば、1.5倍速では、30msのBrilliantウィンドウが45msになり、より速いノーツの動きを補正します。

---

## 判定計算プロセス 

コア判定ロジックは`JudgeManager.JudgeTiming()`に存在し、ノーツの完璧なタイミングとプレイヤーの入力との時間差を評価します。

### JudgeTiming メソッドシグネチャ 

```
public JudgeType JudgeTiming(double diffTime, ScreenTouchPhase touchPhase, bool isFuzzy)
```

**パラメータ:**

* `diffTime`: 時間差（秒単位、負 = 早い、正 = 遅い）
* `touchPhase`: タップ、ホールド、またはリリースか（ロングノート補正に影響）
* `isFuzzy`: このノーツがファジー判定緩和の対象か

### 判定フロー図 

```mermaid
flowchart TD

START["JudgeTiming<br/>(diffTime, touchPhase, isFuzzy)"]
CALC_ABS["absDiffTime = Abs(diffTime)"]
CALC_REVISION["revision を計算<br/>(touchPhase == Up の場合<br/>+ LongRevisionTime)"]

CHECK_FUZZY["Fuzzy Judge Mitigation<br/>AND isFuzzy ?"]

%% Fuzzy 判定
FUZZY_BRILLIANT["absDiffTime < brilliantTime + revision ?"]
FUZZY_GREAT["absDiffTime < greatTime + revision ?"]
FUZZY_FAST["diffTime が<br/>(-fastTime, fastTime)<br/>の範囲内 ?"]
FUZZY_BAD["absDiffTime < badTime ?"]

%% Normal 判定
NORMAL_BRILLIANT["absDiffTime < brilliantTime + revision ?"]
NORMAL_GREAT["absDiffTime < greatTime + revision ?"]
NORMAL_FAST["diffTime < 0 ?<br/>(Fast)"]
NORMAL_SLOW["diffTime > 0 ?<br/>(Slow)"]
NORMAL_BAD["absDiffTime < badTime ?"]

%% Return
RETURN_BRILLIANT["Brilliant を返す<br/>(Perfect フラグ判定あり)"]
RETURN_GREAT["Great を返す"]
RETURN_FAST["Fast を返す"]
RETURN_SLOW["Slow を返す"]
RETURN_BAD["Bad を返す"]
RETURN_NONE["None を返す"]

START --> CALC_ABS
CALC_ABS --> CALC_REVISION
CALC_REVISION --> CHECK_FUZZY

CHECK_FUZZY -->|Yes| FUZZY_BRILLIANT
CHECK_FUZZY -->|No| NORMAL_BRILLIANT

%% Fuzzy flow
FUZZY_BRILLIANT -->|Yes| RETURN_BRILLIANT
FUZZY_BRILLIANT -->|No| FUZZY_GREAT
FUZZY_GREAT -->|Yes| RETURN_GREAT
FUZZY_GREAT -->|No| FUZZY_FAST
FUZZY_FAST -->|Yes| RETURN_GREAT
FUZZY_FAST -->|No| FUZZY_BAD
FUZZY_BAD -->|Yes| RETURN_GREAT
FUZZY_BAD -->|No| RETURN_NONE

%% Normal flow
NORMAL_BRILLIANT -->|Yes| RETURN_BRILLIANT
NORMAL_BRILLIANT -->|No| NORMAL_GREAT
NORMAL_GREAT -->|Yes| RETURN_GREAT
NORMAL_GREAT -->|No| NORMAL_FAST
NORMAL_FAST -->|Yes| RETURN_FAST
NORMAL_FAST -->|No| NORMAL_SLOW
NORMAL_SLOW -->|Yes| RETURN_SLOW
NORMAL_SLOW -->|No| NORMAL_BAD
NORMAL_BAD -->|Yes| RETURN_BAD
NORMAL_BAD -->|No| RETURN_NONE

```

### Perfect vs Brilliant 表示 

システムは、非常に正確なヒットに対してオプションで「Perfect」インジケータを表示できます：

* `IsShowPerfectJudge`が有効な場合、`_perfectTime`または`_fuzzyPerfectTime`（適用される方）以内のヒットでPerfectビジュアルが表示される
* 判定カウントは`Perfect`ではなく`Brilliant`が増加する
* `_fuzzyPerfectTime`は最小16msを持ち、ファジーノートでもPerfect表示を達成できるようにする



---

## 空間的ヒットエリア検証 

時間的判定が行われる前に、システムは`IsHitArea()`を使用してタッチがノーツに十分空間的に近いかを検証します。

### IsHitArea メソッド 

```mermaid
flowchart TD

START["IsHitArea<br/>(diffPosX, diffTime, isRevision)"]

CALC_REV["revision = isRevision ?<br/>upRevisionTime : 0"]

SIMPLE_CHECK["diffPosX < judgeDistance + longDistanceRevision<br/>AND diffTime < greatTime + revision ?"]

CALC_AREA["area = Clamp01(<br/>(diffTime - (greatTime + revision))<br/>/ (badTime - (greatTime + revision))<br/>)"]

LERP_CHECK["diffPosX < Lerp(<br/>judgeDistance + longDistanceRevision,<br/>0,<br/>area<br/>) ?"]

RETURN_TRUE["true を返す"]
RETURN_FALSE["false を返す"]

%% 基本フロー
START --> CALC_REV
CALC_REV --> SIMPLE_CHECK

%% 即時判定
SIMPLE_CHECK -->|Yes| RETURN_TRUE
SIMPLE_CHECK -->|No| CALC_AREA

%% 時間依存の空間判定
CALC_AREA --> LERP_CHECK
LERP_CHECK -->|Yes| RETURN_TRUE
LERP_CHECK -->|No| RETURN_FALSE

```

### 主要な空間パラメータ 

| パラメータ | フィールド | 説明 |
| --- | --- | --- |
| 判定距離 | `_judgeDistance` | ゲーム単位での水平距離閾値 |
| ロング距離補正 | `_longDistanceRevision` | ロングノートのための追加の空間的余裕 |

空間的ヒットエリアは、ノーツが完璧なタイミングから離れるにつれて線形に縮小し、時空間座標で台形のヒット領域を作成します。



---

## ファジー判定緩和 

ファジー判定は、同時マルチノート押しやホールド開始など、フレーム完璧なタイミングでヒットすることが困難なノーツに対する緩和メカニクスです。

### ファジーロジックの動作 

`FuzzyJudgeMitigation`が有効で、ノーツがファジーとマークされている場合：

1. **Brilliant ウィンドウが Great ウィンドウまで拡張**: Great タイミング内のヒットはBrilliant判定になる
2. **Fast/Slow が Great に変換**: 通常FastまたはSlowになるタイミングがGreatになる
3. **Bad が Great に変換**: BadタイミングでさえもGreatになる

これにより、事実上、すべての非Miss判定がBrilliantまたはGreatのいずれかになります。

### ファジー Perfect 閾値 

Perfect表示目的では、ファジーノートは特別な閾値を使用します：

```
_fuzzyPerfectTime = max(16ms, DisplayOption.PerfectJudgeTime) * musicRate
```

これにより、拡張されたBrilliantウィンドウでも、ファジーノートがPerfect表示を達成するための合理的なウィンドウを持つことが保証されます。

### 実装の詳細 

```mermaid
flowchart TD

CHECK["isFuzzyJudgeMitigation AND isFuzzy?"]
NORMAL["厳密なタイミングに基づく Brilliant/Great/Fast/Slow/Bad"]
FUZZY_B["absDiffTime < greatTime → Brilliant"]
FUZZY_G["それ以外 fastTime または badTime 内 → Great"]

CHECK -.->|"いいえ"| NORMAL
CHECK -.->|"はい"| FUZZY_B
CHECK -.->|"はい"| FUZZY_G

subgraph ファジーパス ["ファジーパス"]
    FUZZY_B
    FUZZY_G
end

subgraph 通常パス ["通常パス"]
    NORMAL
end
```



 

---

## ロングノートの特殊処理 

ロングノート（ホールドノート）は、ホールド終了時のタイミングウィンドウを拡張する補正パラメータを通じて特別な扱いを受けます。

### ロングノート補正 

| パラメータ | フィールド | デフォルト | 説明 |
| --- | --- | --- | --- |
| ロング補正時間 | `LongRevisionTime` | 0.025秒 | ロング終了/アップ判定のタイミングウィンドウに追加される |
| ロング補正距離 | `LongRevisionDistance` | 1.5ユニット | ロングノートの空間的ヒットエリアに追加される |

### ホールド開始タイミング 

システムは、完璧なタイミングより少し前からホールド入力のチェックを開始します：

```
HoldStart = (_holdStartTime < -_brilliantTime) ? -_brilliantTime : _holdStartTime
```

デフォルトの`FuzzyStartTime`は-0.020秒で、プレイヤーは20ms早くホールドを開始できます。

### 補正の適用 

`_upRevisionTime`は、`touchPhase == ScreenTouchPhase.Up`の場合のみタイミングウィンドウに追加されます：

```
double revision = (touchPhase == ScreenTouchPhase.Up) ? _upRevisionTime : 0d;
```

これにより、ロングノートのリリースは通常のノーツタップよりも寛容になります。

### GetLongEndHitTime 計算 

`JudgeTimeOption.GetLongEndHitTime()`メソッドは、ロング補正を含む最大時間ウィンドウを計算します：

```
hitTime = max(BadTime, FastTime, GreatTime + LongRevisionTime, BrilliantTime + LongRevisionTime)
```

 

 

---

## 早い/遅い表示システム 

判定システムは、プレイヤーがタイミングを調整するのを助けるために、ヒットが早かったか遅かったかをオプションで表示できます。

### EarlyLateDisplay 列挙型 

```
enum EarlyLateDisplay {
    None,
    Early,  // 早すぎるヒット
    Late    // 遅すぎるヒット
}
```

### 設定 

| 設定 | フィールド | デフォルト | 説明 |
| --- | --- | --- | --- |
| 表示を表示 | `_isShowEarlyLateDisplay` | false | 早い/遅いインジケータを有効化 |
| 閾値 | `_earlyLateThreshold` | 0.050秒 | 表示するための最小タイミング偏差 |
| Great閾値モード | `_isGreatThresholdEarlyLate` | false | Greatまたはそれ以下の判定のみ表示 |

### 表示ロジック 

```mermaid
flowchart TD

CHECK_ENABLED["IsShowEarlyLateDisplay?"]
CHECK_THRESHOLD["isGreatThresholdEarlyLate?"]
FILTER_ALL["Brilliant/Great/Fast/Slow/Bad で表示"]
FILTER_GREAT["Great/Fast/Slow/Bad のみ表示"]
CHECK_TIMING["abs(diffTime) > earlyLateThreshold?"]
DETERMINE["diffTime < -threshold → Early diffTime > +threshold → Late それ以外 → None"]
DISPLAY["EarlyLateDisplay を表示"]
NO_DISPLAY["表示なし"]

DETERMINE -.->|"はい"| DISPLAY
```

`_earlyLate`構造体は、リザルト表示のための早い・遅いの合計カウントを累積します。



 

---

## JudgeManager 統合 

`JudgeManager`クラスは、すべての判定ロジックを統括し、イベントを通じて他のゲームプレイシステムと統合します。

### 主要コンポーネント 

```mermaid
flowchart TD

JM["JudgeManager"]
JUIC["JudgeUIController （ビジュアルフィードバック）"]
OPTIONS["JudgeTimeOption （設定）"]
DISPLAY["DisplayOption （UI設定）"]
OJ["OnJudge event Action"]
OAJ["OnAfterJudge event Action"]
LIFE["LifeManager"]
SCORE["ScoreManager"]
COMBO["ComboManager"]

JM -.->|"制御"| JUIC
JM -.->|"設定を読み込む"| OPTIONS
JM -.->|"設定を読み込む"| DISPLAY
JM -.->|"発火"| OJ
JM -.->|"更新"| OAJ
OJ -.->|"更新"| LIFE
OAJ -.->|"更新"| SCORE
OAJ -.->|"発火"| COMBO

subgraph サブスクライバー ["サブスクライバー"]
    LIFE
    SCORE
    COMBO
end

subgraph イベント ["イベント"]
    OJ
    OAJ
end
```

### 初期化フロー 

```mermaid
sequenceDiagram
  participant p1 as MusicGameSceneController
  participant p2 as JudgeManager
  participant p3 as JudgeUIController
  participant p4 as GameManager

  p1->>p2: Init()
  p2->>p3: Init()
  p2->>p4: JudgeTimeOption を取得
  p2->>p4: DisplayOption を取得
  note over p2: 楽曲速度スケーリングで タイミングウィンドウを計算
  note over p2: 早い/遅い表示 バイブレーション、Perfect判定を設定
```

### ランタイム更新 

`CallUpdate()`メソッドは`JudgeUIController`に委譲します

### 判定中のイベントフロー 

```mermaid
sequenceDiagram
  participant p1 as MusicGame
  participant p2 as JudgeManager
  participant p3 as JudgeUIController
  participant p4 as LifeManager
  participant p5 as ScoreManager
  participant p6 as ComboManager
  participant p7 as TimingHistory

  p1->>p2: JudgeTiming(diffTime | touchPhase | isFuzzy)
  p2->>p2: 判定タイプを計算
  p2->>p2: OnJudgeEvent(judgeType)
  p2->>p3: ShowJudge(judgeType | isPerfect)
  p2->>p2: OnJudge イベントを発火
  p2->>p4: OnJudge → UpdateLife()
  p2->>p2: AddJudge(judgeType)
  p2->>p2: OnAfterJudge イベントを発火
  p2->>p5: OnAfterJudge → OnAfterJudge()
  p2->>p6: OnAfterJudge → UpdateCombo()
  p1->>p7: タイミングデータを記録
```



---

## 設定UI 

`JudgeTimeSettingsPanel`は、プレイヤーが判定タイミングをカスタマイズするためのUIコントロールを提供します。

### 設定可能なパラメータ 

```mermaid
flowchart TD

NTP["Null Tap No Sound Time<br/>(NullTapPanel)"]
DSP["DSP Buffer Size<br/>(DspBufferSizePanel)"]

MRP["Music Rate<br/>(MusicRatePanel)"]
FJMP["Fuzzy Judge Mitigation<br/>(FuzzyJudgeMitigationPanel)"]
VIB["Vibration<br/>(VibrationPanel)"]

LRTP["Long Revision Time<br/>(JudgeTimePanel)"]
LRDP["Long Revision Distance<br/>(JudgeDistancePanel)"]
FSTP["Fuzzy Start Time<br/>(JudgeTimePanel)"]

JBP["Brilliant Time<br/>(JudgeTimePanel)"]
JGP["Great Time<br/>(JudgeTimePanel)"]
JFP["Fast Time<br/>(JudgeTimePanel)"]
JBADP["Bad Time<br/>(JudgeTimePanel)"]
JDP["Judge Distance<br/>(JudgeDistancePanel)"]

subgraph オーディオ設定 ["オーディオ設定"]
    NTP
    DSP
end

subgraph 特殊オプション ["特殊オプション"]
    MRP
    FJMP
    VIB
end

subgraph ロングノート補正 ["ロングノート補正"]
    LRTP
    LRDP
    FSTP
end

subgraph 判定タイミング ["判定タイミング"]
    JBP
    JGP
    JFP
    JBADP
    JDP
end

```

### パネルコンポーネント 

各設定は専用のパネルコンポーネントを使用します：

* **JudgeTimePanel**: スライダー（ミリ秒単位の最小/最大）、上/下ボタン、「Xms」として表示
* **JudgeDistancePanel**: スライダー（100分の1単位）、浮動小数点として表示
* **MusicRatePanel**: スライダー（50-200%）、「x1.50」形式で表示、オーディオ再生に影響
* **FuzzyJudgeMitigationPanel**: トグル（はい/いいえ）

### カスタム判定検出 

パネルは設定がデフォルトと異なるかどうかを追跡します：

```c#
public bool IsCustom => 
BrilliantTime != Constant.JudgeTime.BRILLIANT_TIME ||    
GreatTime != Constant.JudgeTime.GREAT_TIME ||    
FastTime != Constant.JudgeTime.FAST_TIME ||    
BadTime != Constant.JudgeTime.BAD_TIME ||    
JudgeDistance != Constant.JudgeTime.JUDGE_DISTANCE ||    
LongRevisionTime != Constant.JudgeTime.LONG_REVISION_TIME ||    
LongRevisionDistance != Constant.JudgeTime.LONG_REVISION_DISTANCE ||    
FuzzyStartTime != Constant.JudgeTime.FUZZY_START_TIME;
```

カスタム設定が検出されると、プレイヤーに警告するためのビジュアルインジケータが表示されます。



 

---

## タイミングの可視化 

`ResultGraph`は、ゲームプレイ後に判定タイミングデータを可視化し、プレイヤーがパフォーマンスを分析できるようにします。

### グラフコンポーネント 

```mermaid
flowchart TD

RG["ResultGraph"]
TEX["Texture2D （動的レンダリング）"]
TH["TimingHistory （ResultData から）"]
LH["LifeHistory （ResultData から）"]
BG["背景 （黒 + ガイドライン）"]
MISS["ミスインジケータ （縦線）"]
JUDGE["判定ドット （タイプ別色分け）"]
LIFE["ライフライン （白いライングラフ）"]

RG -.->|"ライフデータを提供"| TEX
TH -.->|"タイミングデータを提供"| RG
LH -.-> RG
RG -.-> BG
RG -.-> MISS
RG -.-> JUDGE
RG -.->|"レンダリング先"| LIFE

subgraph グラフレイヤー ["グラフレイヤー"]
    BG
    MISS
    JUDGE
    LIFE
end
```

### タイミング軸のスケーリング 

Y軸はタイミング偏差を表し、`hitTime`でスケーリングされます：

```
y = (timing / yScale) * (height / 2) + (height / 2)

ここで yScale = JudgeTimeOption.GetLongEndHitTime() * musicRate
```

ガイドラインは以下の位置に描画されます：

* **中央線**（y = height/2）: 完璧なタイミング
* **Perfect境界**（y = height/2 ± perfectScaleY）: Perfect判定ウィンドウ

### 色マッピング 

```
JudgeType → Color32 
{    
    Perfect/Brilliant → Cyan    
    Great → Yellow    
    Fast/Slow → Green    
    Bad → Blue    
    Missed → Red
}
```

Y軸範囲外に落ちるミスノートは、高さ全体にわたる縦線として描画されます。

---

## 自動タイミング調整

`ResultAutoTimingPanel`は、タイミングデータを分析して最適なタイミングオフセット調整を提案します。

### 計算方法 

```mermaid
flowchart TD

START["ResultAutoTimingPanel<br/>SetUp()"]
LOAD["ResultData から<br/>TimingHistory を読み込む"]
FILTER["hitTime 範囲内の<br/>タイミングをフィルタ"]

FUZZY_CHECK["ファジーノートを<br/>含めて計算する？"]

FUZZY_FILTER["すべてのノートを含む"]
NO_FUZZY_FILTER["ファジーノートを除外<br/>(FuzzyLongStart / FuzzyLongRelay など)"]

CALC_AVG["平均タイミングを計算"]
CALC_MED["中央値タイミングを計算"]

DISPLAY["オフセット調整案を表示"]

%% 基本フロー
START --> LOAD
LOAD --> FILTER
FILTER --> FUZZY_CHECK

%% 分岐
FUZZY_CHECK -->|Yes| FUZZY_FILTER
FUZZY_CHECK -->|No| NO_FUZZY_FILTER

%% 計算フェーズ
FUZZY_FILTER --> CALC_AVG
NO_FUZZY_FILTER --> CALC_AVG

CALC_AVG --> CALC_MED
CALC_MED --> DISPLAY

```

### タイミング調整式 

システムは、各タイミング偏差に現在のオフセットを追加します：

```
adjustedTiming = recordedTiming + currentOffset
```

次に計算します：

* **平均**: すべての調整されたタイミングの合計 / カウント
* **中央値**: ソート後の中央値

### ファジー除外フィルタ 

「ファジーなし」モードが有効な場合、システムはこれらのノートタイプを除外します：

```
NoteBitFrag fuzzyBitFrag =    
    NoteBitFrag.Fuzzy |    
    NoteBitFrag.FuzzyLongStart |    
    NoteBitFrag.FuzzyLongRelay |    
    NoteBitFrag.FuzzyLongEnd |    
    NoteBitFrag.LongRelay;
```

これにより、寛容な判定ウィンドウを持つノートを除外することで、より正確な調整が可能になります。

---

## 主要クラスリファレンス 

### JudgeManager 

| メソッド/プロパティ | 目的 |
| --- | --- |
| `Init()` | 設定を読み込み、楽曲速度スケーリングでタイミングウィンドウを初期化 |
| `JudgeTiming(diffTime, touchPhase, isFuzzy)` | コア判定評価、`JudgeType`を返す |
| `IsHitArea(diffPosX, diffTime, isRevision)` | 判定前に空間的近接性を検証 |
| `AddMissedJudge()` | 期限切れのノートに対してMissed判定を手動で追加 |
| `HitTime` | 任意の判定の最大時間ウィンドウ |
| `LongHitTime` | ロングノート補正を含む最大時間ウィンドウ |
| `ComboHitTime` | コンボを維持する最大時間ウィンドウ |
| `HoldStart` | ホールドチェックが開始される完璧なタイミングより前の時間 |
| `Judge` | 現在の累積判定カウント |
| `EarlyLate` | 現在の累積早い/遅いカウント |
| `IsAllBrilliant` | Great/Fast/Slow/Bad/Missed判定がない場合true |
| `OnJudge` | 任意の判定が発生したときに発火するイベント（タイプを含む） |
| `OnAfterJudge` | 判定が記録された後に発火するイベント（完全なカウントを含む） |

### JudgeTimeOption 

| メソッド/プロパティ | 目的 |
| --- | --- |
| `GetHitTime()` | すべてのタイミングウィンドウの最大値を返す |
| `GetLongEndHitTime()` | ロング補正時間を含む最大値を返す |
| `GetComboHitTime()` | コンボを維持する最大値を返す（BrilliantまたはGreat） |
| `IsCustom` | いずれかのタイミングがデフォルト定数と異なる場合true |
| `MusicRate` | 再生速度倍率（すべてのタイミングウィンドウに影響） |
| `FuzzyJudgeMitigation` | ファジーノートに対する寛容な判定を有効化 |

### On this page

* [判定メカニクス](#4.1-)
* [判定タイプの概要](#4.1--1)
* [JudgeType 列挙型](#4.1-judgetype-)
* [タイミングウィンドウのアーキテクチャ](#4.1--2)
* [タイミングウィンドウの階層構造](#4.1--3)
* [デフォルトタイミング値](#4.1--4)
* [楽曲速度スケーリング](#4.1--5)
* [判定計算プロセス](#4.1--6)
* [JudgeTiming メソッドシグネチャ](#4.1-judgetiming-)
* [判定フロー図](#4.1--7)
* [Perfect vs Brilliant 表示](#4.1-perfect-vs-brilliant-)
* [空間的ヒットエリア検証](#4.1--8)
* [IsHitArea メソッド](#4.1-ishitarea-)
* [主要な空間パラメータ](#4.1--9)
* [ファジー判定緩和](#4.1--10)
* [ファジーロジックの動作](#4.1--11)
* [ファジー Perfect 閾値](#4.1--perfect-)
* [実装の詳細](#4.1--12)
* [ロングノートの特殊処理](#4.1--13)
* [ロングノート補正](#4.1--14)
* [ホールド開始タイミング](#4.1--15)
* [補正の適用](#4.1--16)
* [GetLongEndHitTime 計算](#4.1-getlongendhittime-)
* [早い/遅い表示システム](#4.1--17)
* [EarlyLateDisplay 列挙型](#4.1-earlylatedisplay-)
* [設定](#4.1--18)
* [表示ロジック](#4.1--19)
* [JudgeManager 統合](#4.1-judgemanager-)
* [主要コンポーネント](#4.1--20)
* [初期化フロー](#4.1--21)
* [ランタイム更新](#4.1--22)
* [判定中のイベントフロー](#4.1--23)
* [設定UI](#4.1-ui)
* [設定可能なパラメータ](#4.1--24)
* [パネルコンポーネント](#4.1--25)
* [カスタム判定検出](#4.1--26)
* [タイミングの可視化](#4.1--27)
* [グラフコンポーネント](#4.1--28)
* [タイミング軸のスケーリング](#4.1--29)
* [色マッピング](#4.1--30)
* [自動タイミング調整](#4.1--31)
* [計算方法](#4.1--32)
* [タイミング調整式](#4.1--33)
* [ファジー除外フィルタ](#4.1--34)
* [主要クラスリファレンス](#4.1--35)
* [JudgeManager](#4.1-judgemanager)
* [JudgeTimeOption](#4.1-judgetimeoption)

