

# 外部コンテンツ読込 

## 目的と範囲 

このドキュメントでは、リズムゲームがファイルシステムから**ユーザー追加コンテンツ**を読み込む方法について説明します。これには、楽曲譜面、音楽ファイル、ジャケット画像、カスタムリソースのスキャン、解析、読み込みが含まれます。

UnityのAddressablesシステムで管理される組み込みアセットについては、[Addressableアセット](#9.1)を参照してください。読み込まれたコンテンツへの繰り返しアクセスを最適化するキャッシュメカニズムについては、[キャッシュシステム](#9.3)を参照してください。

---

## システム概要 

外部コンテンツ読込システムは、**スキャン-解析-読込パイプライン**に従います：

1. **発見**：外部ディレクトリを再帰的にスキャンしてコンテンツを発見
2. **解析**：完全なデータを読み込まずに譜面ファイルヘッダーからメタデータを解析
3. **読込**：使用のために選択されたときにオンデマンドで完全なリソースを読み込む
4. **キャッシュ**：頻繁にアクセスされるデータをキャッシュして冗長なI/Oを回避

このアーキテクチャにより、ゲームは必要になるまで高コストな操作を延期することで、大規模な楽曲ライブラリを効率的に処理できます。

**図：外部コンテンツ読込アーキテクチャ**

```mermaid
flowchart TD

subgraph プラットフォーム層 ["プラットフォーム層"]
    ED["ExternalDirectory<br/>(プラットフォーム固有のパス)"]
end

subgraph ストレージ ["ストレージ"]
    SONGS["Songsフォルダ"]
    NOTESKIN["NoteSkinフォルダ"]
    TOUCHSE["TouchSeフォルダ"]
    GLOBALLUA["GlobalLuaフォルダ"]
end

subgraph 発見フェーズ ["発見フェーズ"]
    SIL["SongInfoLoader ReadFileText()"]
    SCAN["Directory.GetDirectories()<br/>Directory.GetFiles()"]
end

subgraph メタデータフェーズ ["メタデータフェーズ"]
    PARSE["SongInfoLoader LoadSongInfo()"]
    HEADER["譜面ヘッダーを解析<br/>(#VERSION, #TITLE, etc.)"]
    JACKET["CreateJacketTexture()"]
end

SongInfo["SongInfo"]

subgraph オンデマンド読込 ["オンデマンド読込"]
    SR["SequenceReader Read()"]
    ACL["AudioClipLoader LoadAsync()"]
    TL["TextureLoader LoadTexture()"]
end

ED -->|"パスを提供"| SONGS
ED -->|"パスを提供"| NOTESKIN
ED -->|"パスを提供"| TOUCHSE
ED --> GLOBALLUA
SONGS --> SCAN
SCAN --> SIL
SIL --> PARSE
PARSE -->|"読込"| HEADER
PARSE -->|"作成"| JACKET
HEADER -->|"選択時"| SongInfo
JACKET -->|"選択時"| SongInfo
SongInfo -->|"選択時"| SR
SongInfo --> ACL
SongInfo --> TL
SR -.->|"読込"| SONGS
ACL -.->|"読込"| SONGS
TL -.->|"読込"| SONGS
```


## プラットフォーム固有のディレクトリ管理 

`ExternalDirectory`クラスは、外部コンテンツディレクトリへのプラットフォーム固有のパスを提供し、Android、iOS、デスクトップ環境のプラットフォーム差異を抽象化します。

### 主要ディレクトリ 

| ディレクトリ | プロパティ | 目的 |
| --- | --- | --- |
| Songs | `SongsPath` | ユーザー追加の楽曲譜面と音楽ファイル |
| NoteSkin | `NoteSkinPath` | カスタムノートスプライトセット |
| TouchSe | `TouchSePath` | カスタムタッチ効果音 |
| GlobalLua | `GlobalLuaPath` | グローバルLuaスクリプト設定 |

### プラットフォームの違い 

システムはプラットフォーム固有のストレージ場所を処理します：

* **Android**: ファイルマネージャからアクセス可能な外部ストレージを使用
* **iOS**: ファイル共有用のDocumentsディレクトリを使用
* **Windows/エディタ**: `Application.persistentDataPath`サブディレクトリを使用

**図：ディレクトリ構造**

```mermaid
flowchart TD

APP["Application.persistentDataPath またはプラットフォーム固有のルート"]
SONGS["Songs/ (譜面ルート)"]
NOTESKIN["NoteSkin/"]
TOUCHSE["TouchSe/"]
GLOBALLUA["GlobalLua/"]
NOGROUP["個別の楽曲 (グループフォルダなし)"]
GROUP1["グループフォルダ1/"]
GROUP2["グループフォルダ2/"]
SONG1["楽曲A/ chart.dl music.ogg jacket.png"]
SONG2["楽曲B/"]
SONG3["楽曲C/"]
FILES2["chart.dl music.mp3 jacket.jpg"]

APP -.-> SONGS
APP -.-> NOTESKIN
APP -.-> TOUCHSE
APP -.-> GLOBALLUA
SONGS -.-> NOGROUP
SONGS -.-> GROUP1
SONGS -.-> GROUP2
NOGROUP -.-> SONG1
GROUP1 -.-> SONG2
GROUP1 -.-> SONG3
SONG2 -.-> FILES2
```

## 楽曲の発見とメタデータ読込 

`SongInfoLoader`クラスは、再帰的なディレクトリスキャンを実行してすべての譜面ファイルを発見し、完全な譜面データを読み込まずにメタデータを抽出します。

### 発見プロセス 

**ステップ1：ディレクトリスキャン**

`ReadFileText()`メソッドは、Songsディレクトリを再帰的にスキャンします：

```mermaid
flowchart TD

START["ReadFileText()"]
GET_DIRS["Directory.GetDirectories(SongsPath)"]
LOOP1["各ディレクトリについて"]
CHECK_DL[".dlまたは.txtを検索"]
FOUND["ファイルが<br/>見つかった？"]
NO_GROUP["グループなしリストに追加"]
MAY_GROUP["潜在的なグループフォルダとしてマーク"]
SCAN_GROUP["グループフォルダの<br/>サブディレクトリをスキャン"]
ADD_RESULT["(path, text, updateTime, groupIndex)を追加"]

START --> GET_DIRS
GET_DIRS --> LOOP1
LOOP1 --> CHECK_DL
CHECK_DL --> FOUND
FOUND -->|"はい"| NO_GROUP
FOUND -->|"いいえ"| MAY_GROUP
NO_GROUP --> ADD_RESULT
MAY_GROUP --> SCAN_GROUP
SCAN_GROUP --> ADD_RESULT
```

このメソッドは、以下を含むタプルのリストを返します：

* **Path**: 楽曲ディレクトリ名
* **Text**: 完全な譜面ファイルの内容
* **UpdateTime**: ファイル変更タイムスタンプ（キャッシュ検証用）
* **GroupFolderIndex**: `GameManager.GroupFolderNameList`へのインデックス

### メタデータ抽出 

**ステップ2：ヘッダー解析**

`LoadSongInfo()`メソッドは、譜面ファイルヘッダーを解析してメタデータを抽出します：

| タグ | プロパティ | 説明 |
| --- | --- | --- |
| `#VERSION:` | `Version` | 譜面フォーマットバージョン（1または2） |
| `#TITLE:` | `Title` | 楽曲タイトル |
| `#SUBTITLE:` | `SubTitle` | サブタイトルテキスト |
| `#ARTIST:` | `Artist` | アーティスト名 |
| `#MUSIC:` | `MusicFileName` | オーディオファイル名 |
| `#BANNER:` | `BannerFileName` | ジャケット画像ファイル名 |
| `#BPMS:` | `Bpm.Positions/Bpms` | BPM変化のタイムライン |
| `#DIFFICULTIES:` | `Difficulties` | 利用可能な難易度レベル |
| `#OFFSET:` | `Offset` | タイミングオフセット（秒） |
| `#SAMPLESTART:` | `SampleStart` | プレビュー開始時間 |
| `#SAMPLELENGTH:` | `SampleLength` | プレビュー期間 |

**図：SongInfo作成フロー**

```mermaid
flowchart TD

TEXT["譜面ファイルテキスト"]
SONGINFO["SongInfoオブジェクト"]

subgraph 解析ループ ["解析ループ"]
    READ["ReadLine()"]
    CHECK["タグプレフィックスをチェック"]
    EXTRACT["GetBetweenChars(':',';')"]
    ASSIGN["SongInfoプロパティに代入"]
end

TEXT --> READ
READ --> CHECK
CHECK -->|"タグ発見"| EXTRACT
EXTRACT --> ASSIGN
ASSIGN -->|"次の行"| READ
CHECK -->|"#NOTES到達"| SONGINFO
```

### ジャケットテクスチャ読込 

**ステップ3：画像読込**

ジャケット画像は、`OtherSettingPrefas.BannerLoadType`に基づいて2つの戦略のいずれかを使用して読み込まれます：

**Type1（順次）**:

* 初期化中にすべてのジャケットを同期的に読み込む
* シンプルだが読込中にUIがブロックされる
* 使用箇所: 

**Type2（非同期）**:

* `CreateJacketTextureAsync()`を使用して進行状況の更新とともに並列読込
* 大規模なライブラリに適している
* 使用箇所: 

`CreateJacketTexture()`メソッドは画像読込を処理します：

```mermaid
flowchart TD

START["CreateJacketTexture(songInfo)"]
PATH["ジャケットパスを構築: directoryPath + bannerFileName"]
EXISTS["ファイルが 存在する？"]
LOAD["StbImageSharp.LoadTexture()"]
DEFAULT["デフォルトテクスチャを返す"]
RETURN["Texture2Dを返す"]

START -.-> PATH
PATH -.-> EXISTS
EXISTS -.->|"はい"| LOAD
EXISTS -.->|"いいえ"| DEFAULT
LOAD -.-> RETURN
DEFAULT -.-> RETURN
```

このメソッドは`StbImageSharp`ライブラリを通じて複数の画像フォーマットをサポートします。

### エラーハンドリング 

ローダーは、失敗時にエラーダイアログを表示し、タイトルシーンにリダイレクトします：

* **楽曲が見つからない**: "ERROR_NOSONGS"ダイアログを表示
* **譜面解析エラー**: 例外メッセージ付きで"ERROR_LOAD_CHART"ダイアログを表示
* **ファイルアクセスエラー**: ファイルパスのコンテキスト付きで例外を伝播

---

## 譜面ファイル解析 

`SequenceReader`クラスは、楽曲がゲームプレイ用に選択されたときに、完全なノートデータを抽出するために譜面ファイルの詳細な解析を実行します。

### 解析パイプライン 

**図：譜面読込フロー**

```mermaid
flowchart TD

START["SequenceReader.Read(songInfo, difficulty)"]
READFILE["ReadFileText(directoryPath)"]
VERSION["songInfo.Version?"]
V1["LoadSequenceV1()"]
SEQUENCE["Sequenceオブジェクト"]

subgraph バージョン2解析 ["バージョン2解析"]
    V2["LoadSequenceV2()"]
    TAGS["#NOTESセクションを解析"]
    DIFFICULTY["難易度ブロックを検索"]
    MEASURES["小節（バー）を解析"]
    NOTES["ノート文字を解析"]
    LONGS["ロングノートチェーンを接続"]
end

START --> READFILE
READFILE --> VERSION
VERSION -->|"1"| V1
VERSION -->|"2"| V2
V1 --> SEQUENCE
V2 --> TAGS
TAGS --> DIFFICULTY
DIFFICULTY --> MEASURES
MEASURES --> NOTES
NOTES --> LONGS
LONGS --> SEQUENCE
```

### ルックアップテーブル最適化 

`SequenceReader`は、ノート文字をノートタイプにマッピングするために**O(1)ルックアップテーブル**を使用します：

* `_lookup[128]`: ASCII文字を`NoteParseResult`構造体にマッピング
* `_v2LongKind[128]`: ロングノートの開始/中継/終了文字を識別
* `_v2LongIndex[128]`: ロング文字をロングチェーンインデックス（0-9）にマッピング
* `_v2LongIsFuzzy[128]`: 通常とファジーのロングノートを区別

これらのテーブルは、文字配列を使用して静的コンストラクタで一度初期化されます：

| タイプ | 開始/中継 | 終了 |
| --- | --- | --- |
| 通常ロング | `A-J` | `a-j` |
| ファジーロング | `Z-Q`（逆順） | `z-q`（逆順） |
| タップ | `1` | N/A |
| ファジー | `2` | N/A |
| なし | `0` | N/A |

### バージョン2フォーマット 

バージョン2の譜面は、各文字がレーン内のノートを表すコンパクトな文字列フォーマットを使用します：

**小節文字列の例**: `"1010201"`

* 位置0（レーン0）: タップノート（`1`）
* 位置1（レーン1）: なし（`0`）
* 位置2（レーン2）: タップノート（`1`）
* 位置3（レーン3）: なし（`0`）
* 位置4（レーン4）: ファジーノート（`2`）
* 位置5（レーン5）: なし（`0`）
* 位置6（レーン6）: タップノート（`1`）

ロングノートは、開始/中継ポイントに大文字、終了ポイントに小文字を使用します。

### Sequenceデータ構造 

`Sequence`クラスには、解析されたすべての譜面データが含まれます：

```mermaid
classDiagram
    class Sequence {
        +List<double> BeatPositions
        +List<int> Lanes
        +List<NoteType> NoteTypes
        +List<bool> IsAttacks
        +List<LongInfo> LongInfo
        +BgChangeInfo BgChange
        +string Credit
    }
    class LongInfo {
        +List<double> BeatPositions
        +List<int> Lanes
        +List<int> NoteIndex
        +LongType LongType
        +int StartNoteIndex
        +double EndTime
    }
    class BgChangeInfo {
        +List<double> BeatPositions
        +List<string> ImageNames
    }
    Sequence --> LongInfo
    Sequence --> BgChangeInfo
```

## テクスチャ読込 

外部テクスチャは`TextureLoader`クラスを通じて読み込まれ、さまざまなキャッシュシステムにキャッシュされます。

### ジャケット画像 

ジャケット画像は、メタデータフェーズ中に`StbImageSharp`を使用して読み込まれます：

```mermaid
flowchart TD

FILE["画像ファイル (PNG, JPG, etc.)"]
STB["StbImageSharpForUnity LoadTexture()"]
TEX2D["Texture2D (RGBA32)"]
CACHE["FolderTextureCacheまたは SongInfo.JacketTexture"]

FILE -.-> STB
STB -.-> TEX2D
TEX2D -.-> CACHE
```

### カスタムノートスキン 

`NoteSkinCache`は、NoteSkinディレクトリからカスタムノートスプライトセットを読み込みます：

**期待されるディレクトリ構造**:

```
NoteSkin/
  MySkin/
    tap.png
    fuzzy.png
    long_start.png
    long_relay.png
    long_end.png
    fuzzy_long_start.png
    fuzzy_long_relay.png
    fuzzy_long_end.png
```

各スキンには、期待されるファイル名に一致する8つの特定のテクスチャファイルが必要です。

### 背景画像 

背景変更画像は、譜面が選択されたときにオンデマンドで読み込まれます：

```mermaid
flowchart TD

INIT["MusicGameSceneController.InitAsync()"]
BGMANAGER["BgManager.LoadBgChangeImages()"]
PARSE["songInfo.BgChange.ImageNamesを解析"]
LOOP["各画像名について"]
LOAD["ディレクトリからテクスチャを読込"]
CACHE["BgManagerキャッシュに保存"]

INIT -.-> BGMANAGER
BGMANAGER -.-> PARSE
PARSE -.-> LOOP
LOOP -.-> LOAD
LOAD -.-> CACHE
```

## オーディオ読込 

音楽ファイルとカスタム効果音は、Unityのオーディオ読込APIを使用して非同期に読み込まれます。

### 音楽ファイル読込 

`MusicManager`は`AudioClipLoader`を介してオーディオファイルを読み込みます：

**図：オーディオ読込パイプライン**

```mermaid
flowchart TD

INIT["MusicManager.InitAsync()"]
LOAD["AudioClipLoader.LoadAsync()"]
PATH["file:// URLを構築: directoryPath + musicFileName"]
UWR["UnityWebRequestMultimedia GetAudioClip()"]
AWAIT["await webrequest.SendWebRequest()"]
CLIP["AudioClip"]
ASSIGN["_audioSource.clip = clip"]

INIT -.-> LOAD
LOAD -.-> PATH
PATH -.-> UWR
UWR -.-> AWAIT
AWAIT -.-> CLIP
CLIP -.-> ASSIGN
```

ローダーは次のフォーマットをサポートします：**OGG、MP3、WAV**。

### カスタムタッチサウンド 

カスタムタッチ効果音は、`TouchSeCache`とCRI Atomシステムを通じて読み込まれます：

**読込プロセス**:

1. `TouchSeCache`が`TouchSePath`ディレクトリをスキャンしてACB/AWBファイルペアを検索
2. `MusicGameSceneController.LoadTouchSE()`が選択されたサウンドセットを読み込む
3. CRI AtomがACBファイルからキューシートを読み込む
4. サウンドIDがゲームイベント（タップ、ファジー、ロングホールドなど）にマッピングされる

**ACB内の期待されるサウンドID**:

* ID 0: タップサウンド
* ID 1: ファジーサウンド
* ID 2: ロング開始
* ID 3: ロング中継
* ID 4: ロング終了
* ID 5: ロングホールドループ（オプション）
* ID 6: ファジーロングホールドループ（オプション）

## カスタムコンテンツタイプ 

### NoteSkinシステム 

カスタムノートスキンはデフォルトのノートテクスチャを上書きします：

**キャッシュ構造**:

```mermaid
flowchart TD

CACHE["NoteSkinCache.Instance"]
INFO1["NoteSkinInfo Name: Default"]
INFO2["NoteSkinInfo Name: CustomSkin1"]
INFO3["NoteSkinInfo Name: CustomSkin2"]
TEXTURES1["8つのTexture2Dオブジェクト"]
TEXTURES2["8つのTexture2Dオブジェクト"]
TEXTURES3["8つのTexture2Dオブジェクト"]

CACHE -.-> INFO1
CACHE -.-> INFO2
CACHE -.-> INFO3
INFO1 -.-> TEXTURES1
INFO2 -.-> TEXTURES2
INFO3 -.-> TEXTURES3
```

使用箇所: 

### TouchSeシステム 

カスタムタッチ効果音セット：

**キャッシュ構造**:

* `TouchSeCache`が`TouchSeInfo`オブジェクトのリストを保存
* 各`TouchSeInfo`には：`TouchSeName`、`AcbFile`、`AwbFile`パスが含まれる
* `GameManager.Instance.NotesOption.TouchSeName`経由で選択

### GlobalLuaシステム 

グローバルLuaスクリプトはカスタムゲームプレイ動作を提供します：

**ディレクトリ構造**:

```
GlobalLua/
  DefaultScript/
    main.lua
    config.json
  CustomScript1/
    main.lua
    config.json
```

各グローバルLuaディレクトリには以下が含まれます：

* **main.lua**: Luaスクリプトファイル
* **config.json**: メタデータ（名前、説明）

`GlobalLuaCache`は起動時にこのディレクトリをスキャンし、利用可能なスクリプトのリストを作成します。

## 読込パイプラインフロー 

### アプリケーション起動フロー 

**図：完全な読込シーケンス**

```mermaid
sequenceDiagram
  participant p1 as アプリケーション
  participant p2 as ExternalDirectory
  participant p3 as SongInfoLoader
  participant p4 as SongInfoCache
  participant p5 as MusicSelectScene

  p1->>p2: パスを初期化
  p2-->>p1: プラットフォーム固有のパスが準備完了
  p1->>p3: ReadAsync(ct)
  p3->>p3: ReadFileText() - ディレクトリをスキャン
  p3->>p3: LoadSongInfo() - ヘッダーを解析
  p3->>p3: CreateJacketTexture() - 画像を読込
  p3-->>p1: SongInfo[]
  p1->>p4: SongInfo配列を保存
  p4-->>p1: 準備完了
  p1->>p5: シーンを初期化
  p5->>p4: 楽曲リストを取得
  p4-->>p5: フィルタ/ソート済み楽曲
  p5->>p5: ScrollViewに表示
```

### 楽曲選択からゲームプレイへのフロー 

**図：オンデマンド読込**

```mermaid
sequenceDiagram
  participant p1 as プレイヤー
  participant p2 as MusicSelectScene
  participant p3 as GameManager
  participant p4 as MusicGameSceneController
  participant p5 as SequenceReader
  participant p6 as MusicManager
  participant p7 as BgManager

  p1->>p2: 楽曲+難易度を選択
  p2->>p3: 選択を保存
  p2->>p2: ゲームシーンを読込
  p2->>p4: Start()
  p4->>p5: Read(songInfo | difficulty)
  p5->>p5: 完全な譜面ファイルを解析
  p5-->>p4: Sequence
  p4->>p6: InitAsync(directoryPath | musicFileName)
  p6->>p6: LoadAudioAsync()
  p6-->>p4: AudioClipが読み込まれた
  p4->>p7: LoadBgChangeImages(imagePaths)
  p7->>p7: テクスチャを読込
  p7-->>p4: 画像が準備完了
  p4-->>p1: ゲームプレイ開始
```

### エラー回復 

読込システムは複数のエラー回復戦略を実装しています：

**ファイルが見つからない**:

* ジャケット画像が見つからない場合はデフォルトテクスチャを使用
* カスタムTouchSeの読込に失敗した場合はデフォルトサウンドセットを使用
* エラーダイアログがユーザーを安全なシーンに誘導

**解析エラー**:

* 譜面解析例外はファイルパスとエラーメッセージを表示
* 楽曲選択またはタイトルシーンにリダイレクト
* 分析イベントがデバッグ用にエラータイプを追跡

**パフォーマンスの問題**:

* `LoadingCanvasController`を介して読込進行状況を表示
* フェーズインジケーターが現在の読込ステージを表示
* キャンセルトークンサポート付きの非同期読込

## パフォーマンスの考慮事項 

### 遅延読込戦略 

システムは**2フェーズ読込**を使用します：

1. **メタデータフェーズ**（起動時）: 譜面ヘッダーとジャケットサムネイルのみを読み込む
2. **完全データフェーズ**（オンデマンド）: 完全な譜面データ、音楽、背景画像を読み込む

これにより、数百曲の楽曲があっても高速な起動時間を実現します。

### メモリ管理 

* **テクスチャプーリング**: ジャケットテクスチャはキャッシュされるが、メモリが制約されている場合はアンロード可能
* **オーディオストリーミング**: 音楽ファイルはストリーミングモード（`AudioClipLoadType.Streaming`）を使用
* **譜面データ**: 完全な`Sequence`オブジェクトは現在プレイ中の楽曲についてのみ保持

### ファイルI/O最適化 

* **ファイル変更タイムスタンプ**: 古いキャッシュエントリを無効化するために使用
* **バッチ操作**: Type2モードではジャケット読込を並列化可能
* **ルックアップテーブル**: 文字からノートタイプへのマッピングは文字列解析ではなくO(1)配列ルックアップを使用

### On this page

* [外部コンテンツ読込](#9.2-)
* [目的と範囲](#9.2--1)
* [システム概要](#9.2--2)
* [プラットフォーム固有のディレクトリ管理](#9.2--3)
* [主要ディレクトリ](#9.2--4)
* [プラットフォームの違い](#9.2--5)
* [楽曲の発見とメタデータ読込](#9.2--6)
* [発見プロセス](#9.2--7)
* [メタデータ抽出](#9.2--8)
* [ジャケットテクスチャ読込](#9.2--9)
* [エラーハンドリング](#9.2--10)
* [譜面ファイル解析](#9.2--11)
* [解析パイプライン](#9.2--12)
* [ルックアップテーブル最適化](#9.2--13)
* [バージョン2フォーマット](#9.2-2)
* [Sequenceデータ構造](#9.2-sequence)
* [テクスチャ読込](#9.2--14)
* [ジャケット画像](#9.2--15)
* [カスタムノートスキン](#9.2--16)
* [背景画像](#9.2--17)
* [オーディオ読込](#9.2--18)
* [音楽ファイル読込](#9.2--19)
* [カスタムタッチサウンド](#9.2--20)
* [カスタムコンテンツタイプ](#9.2--21)
* [NoteSkinシステム](#9.2-noteskin)
* [TouchSeシステム](#9.2-touchse)
* [GlobalLuaシステム](#9.2-globallua)
* [読込パイプラインフロー](#9.2--22)
* [アプリケーション起動フロー](#9.2--23)
* [楽曲選択からゲームプレイへのフロー](#9.2--24)
* [エラー回復](#9.2--25)
* [パフォーマンスの考慮事項](#9.2--26)
* [遅延読込戦略](#9.2--27)
* [メモリ管理](#9.2--28)
* [ファイルI/O最適化](#9.2-io)

