

# 楽曲読込と表示 

## 目的と範囲 

このページは、楽曲選択シーンで使用される楽曲の検出、メタデータ読込、および表示システムについて説明します。アプリケーションがファイルシステムから譜面ファイルをスキャンし、楽曲メタデータを抽出し、ジャケット画像を読み込み、スクロール可能なインターフェースで楽曲リストを表示する方法を扱います。

**関連ページ:**

* フォルダ構成とソート機能については、[フォルダとソートシステム](#5.2)を参照してください
* 詳細な譜面分析と可視化については、[譜面情報パネル](#5.3)を参照してください
* スコアの基盤となるデータ永続化については、[データ永続化システム](#2.3)を参照してください

---

## システム概要 

楽曲読込と表示システムは、3つの異なるフェーズで動作します：

1. **検出フェーズ**: Songsディレクトリを再帰的にスキャンして`.dl`または`.txt`譜面ファイルを探す
2. **読込フェーズ**: 譜面ファイルのヘッダーからメタデータを解析し、ジャケット画像を読み込む
3. **表示フェーズ**: オブジェクトプーリングを使用してパフォーマンスの高いスクロール可能なリストで楽曲を表示する

```mermaid
flowchart TD

SCAN["Directory.GetDirectories() ExternalDirectory.SongsPath"]
DETECT[".dl/.txtファイルを検出"]
GROUP["グループフォルダを識別"]
LOADER["SongInfoLoader"]
PARSE["譜面ヘッダーを解析 (タグベースの解析)"]
JACKET["ジャケット画像を読込 (BannerLoadType)"]
CACHE["SongInfoCache"]
SCROLL["ScrollView (FancyScrollView)"]
CELL["Cellインスタンス (プールされた)"]
UI["ユーザーインターフェース"]

GROUP -.-> LOADER
CACHE -.-> SCROLL

subgraph 表示フェーズ ["表示フェーズ"]
    SCROLL
    CELL
    UI
    SCROLL -.-> CELL
    CELL -.-> UI
end

subgraph 読込フェーズ ["読込フェーズ"]
    LOADER
    PARSE
    JACKET
    CACHE
    LOADER -.-> PARSE
    LOADER -.-> JACKET
    PARSE -.-> CACHE
    JACKET -.-> CACHE
end

subgraph 検出フェーズ ["検出フェーズ"]
    SCAN
    DETECT
    GROUP
    SCAN -.-> DETECT
    DETECT -.-> GROUP
end
```



---

## 楽曲検出パイプライン 

### ディレクトリ構造 

システムは2つの組織パターンをサポートしています：

| パターン | 構造 | 使用例 |
| --- | --- | --- |
| **フラット構造** | `Songs/{SongFolder}/*.dl` | `NO_GROUP`にグループ化されていない楽曲 |
| **グループ化構造** | `Songs/{GroupFolder}/{SongFolder}/*.dl` | パック/アーティストごとに整理された楽曲 |

検出プロセスは、フォルダの関連付けを維持するために各楽曲に`GroupFolderIndex`を割り当てます。

```mermaid
flowchart TD

ROOT["ExternalDirectory.SongsPath"]
SONG1["SongA/ .dlファイル"]
SONG2["SongB/ .dlファイル"]
GRP["ArtistPack/"]
SONG3["Song1/ .dlファイル"]
SONG4["Song2/ .dlファイル"]
NOGRP["NO_GROUP"]
GRPNAME["ArtistPack"]

ROOT -.->|"GroupFolderIndex=0"| SONG1
ROOT -.->|"GroupFolderIndex=0"| SONG2
ROOT -.-> GRP
SONG1 -.-> NOGRP
SONG2 -.-> NOGRP
SONG3 -.->|"GroupFolderIndex=1"| GRPNAME
SONG4 -.->|"GroupFolderIndex=1"| GRPNAME

subgraph subGraph1 ["グループ: Artist Pack"]
    GRP
    SONG3
    SONG4
    GRP -.-> SONG3
    GRP -.-> SONG4
end

subgraph フラット楽曲 ["フラット楽曲"]
    SONG1
    SONG2
end
```

### ファイル検出ロジック 

`ReadFileText()`メソッドが検出を実行します：

**アルゴリズム:**

1. `ExternalDirectory.SongsPath`内のすべてのディレクトリを列挙する
2. 各ディレクトリについて、`*.dl`または`*.txt`ファイルを検索する（トップレベルのみ）
3. 見つかった場合、楽曲フォルダとして分類する（フラット構造）
4. 譜面ファイルが見つからない場合、潜在的なグループフォルダとして扱う
5. グループフォルダ内を再帰的に検索して楽曲ディレクトリを探す
6. 走査中に`GameManager.Instance.GroupFolderNameList`を構築する

**主要な実装の詳細:**

* まず`*.dl`を検索し、次に`*.txt`をフォールバックとして検索する
* `SearchOption.TopDirectoryOnly`を使用して深い再帰を避ける
* `IgnoreGroupFolder.instance`にリストされているフォルダを無視する
* 変更検出のために`File.GetLastWriteTime()`を記録する



---

## メタデータ読込プロセス 

### SongInfoLoaderアーキテクチャ 

`SongInfoLoader`クラスは、`ReadAsync()`メソッドを通じて完全な読込パイプラインを調整します：

```mermaid
sequenceDiagram
  participant p1 as SelectMusicシーン
  participant p2 as SongInfoLoader
  participant p3 as LoadingCanvasController
  participant p4 as LoadSongInfo
  participant p5 as CreateJacketTexture

  p1->>p2: ReadAsync(ct)
  p2->>p3: SetLoadingPhase(Search)
  p2->>p2: ReadFileText()
  note over p2: ファイルシステムをスキャン
  p2->>p3: SetLoadingPhase(MusicInfo)
  loop 各譜面ファイルについて
    p2->>p4: LoadSongInfo(path | text | ...)
    p4-->>p2: SongInfo
  end
  p2->>p3: SetLoadingPhase(ReadThumbnail)
  alt BannerLoadType.Type1
  loop 各SongInfoについて
    p2->>p5: CreateJacketTexture(songInfo)
    p5-->>p2: Texture2D
    p2->>p3: SetProgress(i | total)
  end
  else BannerLoadType.Type2
    p2->>p5: CreateJacketTextureAsync(batch)
    note over p5: 並列読込
    p5-->>p2: 成功/キャンセル
  end
  p2->>p3: SetLoadingPhase(Complete)
  p2-->>p1: SongInfo[]
```

### タグベースのメタデータ解析 

`LoadSongInfo()`メソッドは、フラグベースのタグ追跡を持つストリーミングパーサーを使用します：

**タグのカテゴリ:**

| カテゴリ | タグ | 目的 |
| --- | --- | --- |
| **識別情報** | `#TITLE`, `#SUBTITLE`, `#ARTIST` | 楽曲表示情報 |
| **オーディオ** | `#MUSIC`, `#OFFSET`, `#BPMS`, `#BASEBPM` | 音楽ファイルとタイミングデータ |
| **ビジュアル** | `#BANNER`, `#BACKGROUND`, `#ILLUST` | 画像ファイル参照 |
| **メタデータ** | `#CREDIT`, `#DESCRIPTION`, `#VERSION` | 追加情報 |
| **譜面** | `#DIFFICULTIES:` | レベルごとの難易度評価 |
| **高度** | `#SPEEDS`, `#SCROLLS`, `#BGCHANGES`, `#LUA` | ギミックとスクリプティング |

**解析戦略:**

```mermaid
flowchart TD

START["StringReaderを開始"]
READ["ReadLine()"]
CHECK["行は#で始まる?"]
TAG["既知のタグ?"]
EXTRACT["GetBetweenChars(':', ';')"]
STORE["SongInfoに保存"]
NOTES["#NOTES: タグ?"]
DONE["解析完了"]

START -.->|"いいえ"| READ
READ -.->|"いいえ"| CHECK
CHECK -.->|"はい"| READ
CHECK -.->|"はい"| TAG
TAG -.->|"いいえ"| EXTRACT
TAG -.-> READ
EXTRACT -.->|"はい"| STORE
STORE -.-> NOTES
NOTES -.-> READ
NOTES -.-> DONE
```

**タグ抽出の例:**

```
入力:  "#TITLE:Example Song Name;"
処理: GetBetweenChars(':', ';')
結果: "Example Song Name"
```

パーサーは`TagFlag`列挙型を使用してどのタグが読み込まれたかを追跡し、重複処理を防ぎます。

### バージョン処理 

システムは2つの譜面フォーマットバージョンをサポートしています：

| 側面 | バージョン1 | バージョン2 |
| --- | --- | --- |
| **タグプレフィックス** | `Split`プレフィックス（例：`SplitBPMS:`） | 直接タグ（例：`#BPMS:`） |
| **BPMフォーマット** | `SplitBPMS`と`SplitBASEBPM` | `#BPMS`のみ |
| **難易度タグ** | `SplitEASY`, `SplitNORMAL`など | `#DIFFICULTIES:`統一 |
| **解析場所** | `#NOTES:`ブロック内 | トップレベルタグ |

バージョン検出は`#VERSION:`タグを介して解析の早い段階で行われます。ローダーは`songInfo.Version`に基づいてフォーマット固有のロジックに分岐します。



---

## ジャケット画像読込 

### 読込戦略 

`OtherSettingPrefas.instance.BannerLoadType`によって制御される2つの読込戦略があります：

**Type1: 順次同期読込**

* メインスレッドでジャケットを1つずつ読み込む
* 各画像の後にプログレスバーを更新する
* シンプルだが大きな画像読込中にブロックする
* 互換性または少数の楽曲数に使用される

**Type2: 並列非同期読込**

* `UniTask`を使用して複数の画像を同時に読み込む
* キャンセルトークンサポート付きのバッチ処理
* メモリスパイクを避けるために`BANNER_SIZE_OVER_TYPE2`（500バイト）より大きい画像をスキップする
* 大規模なライブラリに推奨される

```mermaid
flowchart TD

T1_START["読込開始"]
T1_LOOP["i = 0からsongInfos.Lengthまで"]
T1_CREATE["CreateJacketTexture(songInfo)"]
T1_PROGRESS["SetProgress(i, total)"]
T1_YIELD["await UniTask.Yield()"]
T2_START["読込開始"]
T2_BATCH["CreateJacketTextureAsync(all)"]
T2_PARALLEL["並列UniTask.WhenAll"]
T2_CHECK["ct.IsCancellationRequestedをチェック"]
TYPE["BannerLoadType?"]

TYPE -.->|"Type1"| T1_START
TYPE -.->|"Type2"| T2_START

subgraph subGraph1 ["Type2: 非同期バッチ"]
    T2_START
    T2_BATCH
    T2_PARALLEL
    T2_CHECK
end

subgraph subGraph0 ["Type1: 順次"]
    T1_START
    T1_LOOP
    T1_CREATE
    T1_PROGRESS
    T1_YIELD
end
```

### 画像作成パイプライン 

`CreateJacketTexture()`メソッドは個々の画像読込を処理します：

**処理フロー:**

1. **パス解決**

* パスを構築: `{DirectoryPath}/{BannerFileName}`
* バナーがない場合は`{DirectoryPath}/{BackgroundFileName}`にフォールバック
* どちらも存在しない場合はnullを返す
2. **ファイル読込**

* `File.ReadAllBytes()`を使用して生データを取得
* サポートフォーマット: PNG, JPG, TGA, BMP, PSD, GIF
3. **デコード**

* `StbImageSharpForUnity`ライブラリを使用
* `ImageResult.FromMemory(bytes, ColorComponents.RedGreenBlueAlpha)`を呼び出す
* Unity `Texture2D`フォーマットに変換
4. **テクスチャ作成**

* デコードされた寸法で`Texture2D`を作成
* `filterMode = FilterMode.Bilinear`を設定
* `SetPixels32()`でピクセルデータを適用
* `Apply()`を呼び出してGPUにアップロード

**エラー処理:**

```mermaid
flowchart TD

LOAD["画像バイトを読込"]
DECODE["デコード成功?"]
CREATE["Texture2Dを作成"]
ERROR["警告をログ nullを返す"]
SUCCESS["Texture2Dを返す"]

LOAD -.-> DECODE
DECODE -.->|"はい"| CREATE
DECODE -.->|"いいえ"| ERROR
CREATE -.-> SUCCESS
```

画像読込の失敗はログに記録されますが、読込プロセスを停止しません。nullテクスチャはプレースホルダー表示になります。



### キャッシング戦略 

システムは複数のキャッシングレイヤーを採用しています：

| キャッシュタイプ | スコープ | 場所 | 目的 |
| --- | --- | --- | --- |
| **SongInfoCache** | グローバル | `GameManager.Instance` | 完全なメタデータ配列 |
| **JacketTexture** | 楽曲ごと | `SongInfo.JacketTexture` | デコード済みテクスチャ参照 |
| **FolderTextureCache** | フォルダごと | 外部ユーティリティ | 背景画像の再利用 |

ジャケットは初期シーン読込時に一度だけ読み込まれ、セッション中メモリに保持されます。`SongInfo.JacketTexture`プロパティはO(1)アクセスを提供します。



---

## 表示アーキテクチャ 

### ScrollViewコンポーネント階層 

楽曲リストは、カスタムタッチ処理を持つ修正された`FancyScrollView`実装を使用します：

```mermaid
flowchart TD

SV["ScrollView (FancyScrollView<ItemData, Context>)"]
SCROLLER["SingleTouchScroller (カスタムタッチ入力)"]
SCROLLBAR["TapMovableScrollBar (拡張スクロールバー)"]
CELLPOOL["Cellプール (再利用可能なインスタンス)"]
CELL["Cell (MonoBehaviour)"]
JACKET["AspectRatioRawImage (ジャケット表示)"]
TITLE["TextScroll (マーキータイトル)"]
DIFF["難易度インジケーター"]
SCORE["スコア表示"]
PRESENTER["MusicSelectScenePresenter"]

CELLPOOL -.-> CELL
PRESENTER -.-> SV
SV -.-> PRESENTER

subgraph Cell構造 ["Cell構造"]
    CELL
    JACKET
    TITLE
    DIFF
    SCORE
    CELL -.-> JACKET
    CELL -.-> TITLE
    CELL -.-> DIFF
    CELL -.-> SCORE
end

subgraph ScrollView階層 ["ScrollView階層"]
    SV
    SCROLLER
    SCROLLBAR
    CELLPOOL
    SV -.-> SCROLLER
    SV -.->|"OnSelectionChanged"| SCROLLBAR
    SV -.->|"UpdateData"| CELLPOOL
end
```

### FancyScrollView統合 

`ScrollView`クラスは`FancyScrollView<ItemData, Context>`を拡張して以下を継承します：

* **仮想スクロール**: 可視セルのみがインスタンス化される
* **位置計算**: スクロール位置に基づく自動レイアウト
* **スムーズスクロール**: ナビゲーション用のイージング関数
* **セル再利用**: パフォーマンスのためのオブジェクトプーリング

**主要メソッド:**

| メソッド | 目的 |
| --- | --- |
| `UpdateData(IList<ItemData> items)` | 楽曲リストでスクロールビューを設定 |
| `UpdateSelection(int index)` | 選択された楽曲をハイライト |
| `ScrollTo(int index, float duration)` | 特定の楽曲にアニメーション |
| `OnSelectionChanged(int index)` | ユーザーが楽曲を選択したときのイベント |



### Cellライフサイクルとデータバインディング 

各`Cell`インスタンスは管理されたライフサイクルを経ます：

**ライフサイクルフェーズ:**

1. **インスタンス化** (一度だけ)

* `FancyScrollView`によってプレハブがインスタンス化される
* `Awake()`で参照がキャッシュされる
* セルプールに追加される
2. **アクティブ化** (ビューにスクロールインする度)

* `UpdateContent(ItemData data)`が呼ばれる
* ジャケットテクスチャが`RawImage`に割り当てられる
* `SongInfo`からテキストフィールドが設定される
* 難易度パネルが構成される
* スコアデータが表示される
3. **更新** (可視中の毎フレーム)

* `UpdatePosition(float position)`がトランスフォームを調整
* 奥行き効果のためのイージングカーブが適用される
* 選択状態が更新される
4. **非アクティブ化** (ビューからスクロールアウトする度)

* セルがプールに返される
* 再利用のために状態がリセットされる

**データバインディング実装:**

```mermaid
sequenceDiagram
  participant p1 as Cellプール
  participant p2 as Cellインスタンス
  participant p3 as ItemData
  participant p4 as UI要素

  p1->>p2: GetOrCreate()
  note over p2: プールから再利用
  p2->>p3: UpdateContent(itemData)
  p3->>p2: songInfo参照
  p2->>p4: jacketImage.texture = songInfo.JacketTexture
  p2->>p4: titleText.text = songInfo.Title
  p2->>p4: artistText.text = songInfo.Artist
  loop 各難易度について
    p2->>p3: 難易度値を取得
    p3-->>p2: int level
    p2->>p4: 難易度パネルを更新
  end
  p2->>p3: ScoreDataを取得
  p3-->>p2: ベストスコア/ランク
  p2->>p4: スコア情報を表示
```

`ItemData`クラスは、追加の表示状態（選択、インデックス）を持つ`SongInfo`をラップします。この分離により、コアモデルはUI関連から独立したままになります。



### タッチ処理 

`SingleTouchScroller`はカスタムタッチ入力を提供します：

**機能:**

* シングルフィンガードラッグスクロール
* 慣性ベースの勢い
* 楽曲選択のためのタップ検出
* エッジバウンス効果
* `TapMovableScrollBar`との統合

スクローラーはタッチデルタをスクロール位置変更に変換し、`FancyScrollView`の位置計算システムにフィードバックします。



---

## パフォーマンス最適化 

### 読込フェーズの最適化 

| 手法 | 実装 | 影響 |
| --- | --- | --- |
| **ストリーミング解析** | 行ごと処理の`StringReader` | メモリ割り当てを削減 |
| **早期タグ終了** | `#NOTES:`境界で解析を停止 | 完全な譜面読込を回避 |
| **非同期Yield** | 読込間の`await UniTask.Yield()` | フレームドロップを防止 |
| **バッチ処理** | Type2並列画像読込 | 総読込時間を削減 |
| **サイズフィルタリング** | Type2モードで大きな画像をスキップ | メモリスパイクを防止 |

### 表示フェーズの最適化 

| 手法 | 実装 | 影響 |
| --- | --- | --- |
| **仮想スクロール** | FancyScrollViewセル再利用 | 一定のメモリ使用量 |
| **テクスチャキャッシング** | `SongInfo`内の事前読込ジャケット | ランタイムI/Oなし |
| **遅延初期化** | 必要に応じて成長するセルプール | 起動時間を削減 |
| **MaterialPropertyBlock** | インスタンスごとのプロパティを持つ共有マテリアル | ドローコールを削減 |
| **テキストプーリング** | TextScrollコンポーネントの再利用 | GC圧力を削減 |

**典型的なパフォーマンス指標:**

* **100曲**: 約2-3秒の読込時間（Type2）
* **メモリオーバーヘッド**: 100ジャケットあたり約5-10 MB（平均256x256）
* **スクロールパフォーマンス**: 1000曲以上で60 FPS

---

## 完全なデータフロー図 

```mermaid
flowchart TD

FS["ExternalDirectory.SongsPath /Songs/"]
DL[".dl譜面ファイル"]
IMG["バナー画像ファイル"]
SCAN["ReadFileText()"]
PARSE["LoadSongInfo()"]
TEXTURE["CreateJacketTexture()"]
ARRAY["SongInfo[]配列"]
CACHE["SongInfoCache.Instance"]
TEX_CACHE["SongInfo内のTexture2D"]
PRESENTER["MusicSelectScenePresenter"]
MODEL["MusicSelectSceneModel"]
ITEMS["List<ItemData>"]
SCROLLVIEW["ScrollView"]
CELLS["Cellインスタンス"]
RAWIMAGE["RawImageコンポーネント"]
TOUCH["タッチ入力"]
SELECT["楽曲選択"]
PLAY["ゲームシーンへ遷移"]

DL -.-> SCAN
IMG -.-> TEXTURE
ARRAY -.-> CACHE
CACHE -.-> PRESENTER
ITEMS -.-> SCROLLVIEW
TOUCH -.-> SCROLLVIEW
SCROLLVIEW -.-> SELECT
SELECT -.-> PRESENTER
PRESENTER -.-> PLAY

subgraph ユーザーインタラクション ["ユーザーインタラクション"]
    TOUCH
    SELECT
    PLAY
end

subgraph ビューレイヤー ["ビューレイヤー"]
    SCROLLVIEW
    CELLS
    RAWIMAGE
    SCROLLVIEW -.-> CELLS
    CELLS -.-> RAWIMAGE
end

subgraph プレゼンターレイヤー ["プレゼンターレイヤー"]
    PRESENTER
    MODEL
    ITEMS
    PRESENTER -.-> MODEL
    MODEL -.-> ITEMS
end

subgraph キャッシュレイヤー ["キャッシュレイヤー"]
    CACHE
    TEX_CACHE
    CACHE -.->|"参照"| TEX_CACHE
end

subgraph 読込パイプライン ["読込パイプライン"]
    SCAN
    PARSE
    TEXTURE
    ARRAY
    SCAN -.-> PARSE
    PARSE -.-> ARRAY
    TEXTURE -.-> ARRAY
end

subgraph ファイルシステム ["ファイルシステム"]
    FS
    DL
    IMG
    FS -.-> DL
    FS -.-> IMG
end
```
### On this page

* [楽曲読込と表示](#5.1-)
* [目的と範囲](#5.1--1)
* [システム概要](#5.1--2)
* [楽曲検出パイプライン](#5.1--3)
* [ディレクトリ構造](#5.1--4)
* [ファイル検出ロジック](#5.1--5)
* [メタデータ読込プロセス](#5.1--6)
* [SongInfoLoaderアーキテクチャ](#5.1-songinfoloader)
* [タグベースのメタデータ解析](#5.1--7)
* [バージョン処理](#5.1--8)
* [ジャケット画像読込](#5.1--9)
* [読込戦略](#5.1--10)
* [画像作成パイプライン](#5.1--11)
* [キャッシング戦略](#5.1--12)
* [表示アーキテクチャ](#5.1--13)
* [ScrollViewコンポーネント階層](#5.1-scrollview)
* [FancyScrollView統合](#5.1-fancyscrollview)
* [Cellライフサイクルとデータバインディング](#5.1-cell)
* [タッチ処理](#5.1--14)
* [パフォーマンス最適化](#5.1--15)
* [読込フェーズの最適化](#5.1--16)
* [表示フェーズの最適化](#5.1--17)
* [完全なデータフロー図](#5.1--18)

