

# 楽曲選択システム 

## 目的と範囲 

楽曲選択システムは、ユーザーが楽曲ライブラリを閲覧し、フィルタやソートを適用し、楽曲のメタデータとスコアを表示し、最終的にプレイする譜面を選択する楽曲ブラウジング・選択インターフェースを実装しています。このシステムは、楽曲リストの表示、フォルダ編成、ソートアルゴリズム、スコア表示、そしてゲームプレイ開始につながるユーザーインタラクションを統合します。

楽曲メタデータがディスクから最初に読み込まれる方法については、[外部コンテンツ読込](#9.2)を参照してください。譜面分析の視覚化の詳細については、[譜面情報パネル](#5.3)を参照してください。このシーンのプレゼンター層でのオーケストレーションについては、[MVPパターンの実装](#2.2)を参照してください。

---

## システムアーキテクチャ 

楽曲選択システムはMVPパターンに従っており、`SelectMusicSceneLifeTimeScope`がエントリーポイント、`SelectMusicScenePresenter`がオーケストレーター、`SelectMusicSceneView`がUIコンテナとなっています。このシステムは、スクロール可能な楽曲リスト、フォルダフィルタリング、多基準ソート、スコア表示といった複数のサブシステムを統合しています。

**アーキテクチャ概要**

```mermaid
flowchart TD

LSLS["SelectMusicSceneLifeTimeScope"]
LSSP["SelectMusicScenePresenter"]
LSSV["SelectMusicSceneView"]
SV["ScrollView FancyScrollViewベース"]
CELL["Cell 楽曲リストアイテム"]
STS["SingleTouchScroller"]
TMSB["TapMovableScrollBar"]
FSP["FolderSelectPanel"]
FSV["FolderScrollView"]
SPC["SortPanelController"]
MS["MusicSort"]
SO["SortOption"]
SIC["SongInfoCache.Instance"]
SDP["ScoreDataPrefas.instance"]
FSC["FolderScoreCache"]
SMSP["SelectMusicScorePanel"]
CSV["ClearStateViewController"]
RUI["RankUIController"]

LSSV -.->|"クエリ"| SV
LSSV -.->|"読み取り"| FSP
LSSV -.->|"表示"| SPC
SV -.-> SIC
MS -.-> SIC
MS -.-> SDP
FSP -.-> SIC
FSP -.-> FSC
LSSV -.-> SMSP
SMSP -.-> SDP

subgraph 表示コンポーネント ["表示コンポーネント"]
    SMSP
    CSV
    RUI
    SMSP -.-> CSV
    SMSP -.-> RUI
end

subgraph データソース ["データソース"]
    SIC
    SDP
    FSC
    FSC -.-> SDP
end

subgraph subGraph2 ["フィルタリング & ソート"]
    FSP
    FSV
    SPC
    MS
    SO
    FSP -.-> FSV
    SPC -.-> MS
    MS -.-> SO
end

subgraph 楽曲表示 ["楽曲表示"]
    SV
    CELL
    STS
    TMSB
    SV -.->|"読み取り"| CELL
    SV -.-> STS
    SV -.-> TMSB
end

subgraph シーンエントリー ["シーンエントリー"]
    LSLS
    LSSP
    LSSV
    LSLS -.->|"読み取り"| LSSP
    LSSP -.->|"読み取り"| LSSV
end
```

## 楽曲リスト表示システム 

楽曲選択インターフェースの中核は、サードパーティの`FancyScrollView`ライブラリを拡張した`ScrollView`クラスで実装されたスクロール可能なリストです。各楽曲は`Cell`コンポーネントとして表示され、タイトル、アーティスト、難易度インジケーター、クリア状態マークが表示されます。

### ScrollViewとCellのアーキテクチャ 

```mermaid
flowchart TD

SV["ScrollView 14行目"]
CTX["Context 選択インデックス & コールバック"]
ITEMSRC["ItemsSource List<ItemData>"]
CELL1["Cellインスタンス1"]
CELL2["Cellインスタンス2"]
CELLN["CellインスタンスN"]
TITLE["Title TextMeshProUGUI 15行目"]
SUBTITLE["SubTitle TextMeshProUGUI 16行目"]
HLIMG["Highlight Image 19行目"]
CSIMG["ClearState Images[5] 21行目"]
ABFC["AbFc Type Panels 23行目"]
STS["SingleTouchScroller 16行目"]
TMSB["TapMovableScrollBar 17行目"]
CG["CanvasGroup blocksRaycasts 19行目"]

SV -.->|"OnValueChanged"| STS
SV -.->|"生成/更新"| TMSB
SV -.-> CG
ITEMSRC -.->|"生成/更新"| CELL1
ITEMSRC -.-> CELL2
ITEMSRC -.-> CELLN
CELL1 -.-> TITLE
CELL1 -.-> SUBTITLE
CELL1 -.-> HLIMG
CELL1 -.-> CSIMG
CELL1 -.-> ABFC
STS -.-> SV
TMSB -.-> SV

subgraph 入力処理 ["入力処理"]
    STS
    TMSB
    CG
end

subgraph Cellコンテンツ ["Cellコンテンツ"]
    TITLE
    SUBTITLE
    HLIMG
    CSIMG
    ABFC
end

subgraph Cellプーリング ["Cellプーリング"]
    CELL1
    CELL2
    CELLN
end

subgraph ScrollViewコンポーネント ["ScrollViewコンポーネント"]
    SV
    CTX
    ITEMSRC
    SV -.->|"OnTapScrollBar"| CTX
    SV -.->|"生成/更新"| ITEMSRC
end
```

### ScrollViewの主要メソッド 

| メソッド | 目的 | 行参照 |
| --- | --- | --- |
| `UpdateData(IList<ItemData>, int)` | スクロールビューに楽曲リストを設定し、指定インデックスにジャンプ |  |
| `SelectCell(int)` | イージングアニメーションで選択インデックスにスクロール |  |
| `SelectCellNoScroll(int)` | アニメーションなしで瞬時にインデックスにジャンプ |  |
| `UpdateSelection(int)` | コンテキストの選択インデックスを更新してコールバックをトリガー |  |
| `CheckIsOneContent()` | 単一アイテムリストの場合、ループと操作を無効化 |  |

### Cell表示ロジック 

`Cell`クラスは各楽曲の視覚表現を管理します。メモリ使用量を最小化するため、クリア状態データを単一の整数に圧縮し、必要に応じて解凍します。

**クリア状態の圧縮:**

* 各難易度のクリア状態（0-6）は、剰余算術を使用して単一の`int`にパック
* 式: `clearStateCompress = Σ(clearState[i] * 6^i)` ここでiは難易度インデックスで解凍がこのプロセスを逆転

**表示モード:**

* **Type1 (AbFcMarkType.Type1)**: 5つの難易度すべてのクリア状態を横に表示
* **Type2 (AbFcMarkType.Type2)**: 現在の難易度のクリア状態のみを表示
* **None (AbFcMarkType.None)**: クリア状態インジケーターを完全に非表示

cellの`UpdatePosition()`メソッド

は、セルが中央ビューポート領域（位置0.5 ± 0.05）に入るタイミングを判定し、選択ハイライトアニメーションをトリガーします。

## ソートシステム 

ソートシステムにより、ユーザーは12種類の異なる基準で楽曲を整理でき、それぞれに昇順/降順のオプションがあります。`MusicSort`クラスにコアのソートロジックが含まれ、`SortPanelController`がUIを提供します。

### ソート基準 

```mermaid
flowchart TD

T0["Folder 0"]
T1["Title 1"]
T2["Artist 2"]
T3["Bpm 3"]
T4["ChartArtist 4"]
T5["Difficulty 5"]
T6["HighScore 6"]
T7["LastWriteTime 7"]
T8["TotalNoteCount 8"]
T9["YellowNoteCount 9"]
T10["BlueNoteCount 10"]
T11["GreenNoteCount 11"]
BASIC["SongInfoメタデータ"]
CHART["ChartInfo必須 97-115行目"]
SCORE["ScoreData必須 76-90行目"]

T0 -.-> BASIC
T1 -.-> BASIC
T2 -.-> BASIC
T3 -.-> BASIC
T4 -.-> BASIC
T5 -.-> BASIC
T7 -.-> BASIC
T6 -.-> SCORE
T8 -.-> CHART
T9 -.-> CHART
T10 -.-> CHART
T11 -.-> CHART

subgraph データ要件 ["データ要件"]
    BASIC
    CHART
    SCORE
end

subgraph SortSongType列挙型 ["SortSongType列挙型"]
    T0
    T1
    T2
    T3
    T4
    T5
    T6
    T7
    T8
    T9
    T10
    T11
end
```

**ソース:** 

 

### MusicSortの実装 

`MusicSort.SortSongs()`メソッド

は、各ソートタイプに対してswitch-case構造を実装しています。主な実装の詳細:

| ソートタイプ | 実装 | 特別な処理 |
| --- | --- | --- |
| **Folder** | ソートなし、元の配列順序を返す | |
| **Title/Artist/Bpm/ChartArtist** | `List.Sort()`を使用したプロパティの直接比較 ||
| **Difficulty** | `Difficulty[(int)sortOption.Difficulty]`にアクセス | 難易度選択が必要|
| **HighScore** | `ScoreDataPrefas.GetSongScoreDict()`から辞書を作成 | |
| **LastWriteTime** | ファイル変更タイムスタンプを比較 | |
| **TotalNoteCount** | `ChartInfoList[difficulty].TotalNoteCount`にアクセス | 譜面解析が必要 |
| **YellowNoteCount** | `ChartInfoList[difficulty].TapNoteCount`にアクセス | |
| **BlueNoteCount** | `ChartInfoList[difficulty].LongNoteCount`にアクセス |  |
| **GreenNoteCount** | `ChartInfoList[difficulty].FuzzyNoteCount`にアクセス | |

最後のステップでは、降順が選択されている場合、リストを反転します。

**ソース:** 

### 譜面情報読込の要件 

4つのソートタイプ（TotalNoteCount、YellowNoteCount、BlueNoteCount、GreenNoteCount）は、ノートタイプをカウントするために完全な譜面解析が必要です。`SongInfoCache.Instance.HasChartInfoCache`がfalseの場合、`SortPanelController`は「全譜面情報読込」ボタンを表示します。

読込プロセス
1. ユーザーが「全譜面情報読込」ボタンをクリック
2. `ChartInfoLoader.LoadAllChartInfoAsync()`がすべての譜面ファイルを解析
3. `OnLoadedSong(int count)`コールバックを介してプログレスバーが更新
4. 完了後、ノート数ソートが利用可能になる


## フォルダ選択システム 

フォルダシステムにより、ユーザーはグループフォルダで楽曲リストをフィルタリングできます。`FolderSelectPanel`は、楽曲数と集計されたクリア統計を含むスクロール可能なフォルダリストを表示します。

### フォルダデータフロー 

```mermaid
sequenceDiagram
  participant p1 as FolderSelectPanel
  participant p2 as FolderTextureLoader
  participant p3 as FolderTextureCache
  participant p4 as FolderScrollView
  participant p5 as FolderScoreCache
  participant p6 as SongInfoCache
  participant p7 as ScoreDataPrefas

  p1->>p1: InitAsync()
  p1->>p2: LoadTextureAsync()
  p2->>p3: SetCache()
  p1->>p1: GetFolderSongsCount()
  p1->>p6: 楽曲リストを取得
  p6-->>p1: SongInfo[]
  p1->>p1: GroupFolderIndexでグループ化
  p1->>p4: UpdateData(folderItemList)
  p1->>p5: SetCache()
  p5->>p6: 楽曲メタデータを取得
  p5->>p7: スコアデータを取得
  p5-->>p1: FolderScoreDict
  p1->>p1: SetFolderScore()
```

### フォルダテクスチャの読込 

システムは各フォルダのテクスチャをファイルシステムから読み込みます。読込階層

1. **「All Songs」フォルダ**: Addressablesから組み込みテクスチャ`AddressableAssetAddress.TEXTUREALL_SONGS`を使用
2. **「No Group」フォルダ（オプション）**: `GameManager.Instance.HasNoGroup`がtrueの場合、組み込みテクスチャ`AddressableAssetAddress.TEXTURENO_GROUP`を使用
3. **ユーザーフォルダ**: `FolderTextureLoader.LoadTextureAsync()`を介して外部ディレクトリから読み込み

`FolderTextureCache`は、後続のオープン時に再読込を避けるため、読み込まれたテクスチャをキャッシュします。

### フォルダスコアの集計 

`FolderScoreCache`は、各フォルダの集計されたクリア統計を計算します:

**集計プロセス:**

1. すべての`ScoreData`エントリを反復
2. スコアIDからフォルダ名と難易度を抽出（形式: `{folderName}{difficultyName}`）
3. 難易度ごとにAB（All Brilliant）、FC（Full Combo）、Clearの状態をカウント
4. `GroupFolderIndex`でグループ化して、フォルダごとの統計を作成
5. 「All Songs」フォルダ（インデックス-1）の合計統計を計算


## TapMovableScrollBar 

`TapMovableScrollBar`コンポーネントは、標準のスクロールバーにタップでジャンプする機能を追加します。ユーザーがスクロールバーの任意の場所をタップすると、スクロールビューが対応する位置にジャンプします。

### 位置計算 

タップからインデックスへの計算

1. `RectTransformUtility.ScreenPointToLocalPointInRectangle()`を使用して、画面上のタップ位置をローカルスクロールバー座標に変換
2. タップ位置に基づいて正規化された位置`t`を計算（0.0から1.0）
3. スクロール方向を判定（水平はX座標、垂直は反転したY座標を使用）
4. 正規化された位置をコンテンツインデックスにマッピング: `selectIndex = (int)Lerp(0, contentCount, t)`
5. 計算されたインデックスで`OnTapScrollBar`イベントをトリガー

カーソル位置インジケーターは、`SetCursorPosition(int dataIndex)`を介して更新され、現在のスクロール位置を視覚的に反映します。

## スコア表示の統合 

`SelectMusicScorePanel`コンポーネントは、現在選択されている楽曲のプレイヤーのスコア、クリア状態、ランクを表示します。保存されたスコアを取得するために`ScoreDataPrefas`と統合しています。

### スコアデータの取得 

```mermaid
flowchart TD

FN["Folder Name"]
DT["DifficultyType"]
ID["Score ID ZString.Concat"]
LIST["ScoreDataList"]
FIND["FindScore()"]
SMSP["SelectMusicScorePanel"]
SCORE["Score TextMeshProUGUI"]
CS["ClearStateViewController"]
RANK["RankUIController"]

ID -.-> FIND
FIND -.-> SMSP

subgraph 表示コンポーネント ["表示コンポーネント"]
    SMSP
    SCORE
    CS
    RANK
    SMSP -.-> SCORE
    SMSP -.-> CS
    SMSP -.-> RANK
end

subgraph ScoreDataPrefas ["ScoreDataPrefas"]
    LIST
    FIND
    LIST -.-> FIND
end

subgraph スコアID構築 ["スコアID構築"]
    FN
    DT
    ID
    FN -.-> ID
    DT -.-> ID
end
```

### UpdateScoreロジック 

`SelectMusicScorePanel.UpdateScore()`メソッド
は2つのケースを処理します:

**ケース1: スコアデータなし（null）**

* スコアを「0000000」として表示
* クリア状態インジケーターを非表示
* ランク表示を非表示

**ケース2: スコアデータあり**

* 7桁パディングでフォーマットされたスコアを表示
* `ClearState >= CLEAR_THRESHOLD`（値1）の場合: * クリア状態アイコンを表示（Clear/Full Combo/All Brilliant） * ランクバッジを表示（D/C/B/A/S/S+）

クリア状態の閾値定数

* `CLEAR_THRESHOLD = 1`: 最小クリア状態
* `FC_THRESHOLD = 2`: Full Combo
* `AB_THRESHOLD = 3`: All Brilliant

## アニメーションシステム 

`SelectMusicAnimationController`は、シーンの入場アニメーションを管理します。シーン読込時:

1. すべてのUIパネルは`alpha = 0`とオフセット位置で開始
2. `StartAnimation()`が3つの同時tweenをトリガー: * **Scroll View**: 左からスライドイン（-100px）でフェードイン、0.78秒 * **Left Side Panel**: 左からスライドイン（-100px）でフェードイン、0.78秒 * **Right Panel**: 右からスライドイン（+100px）でフェードイン、0.78秒
3. 右パネルの完了後、ジャケットキャンバスをピクセルパーフェクトモードに設定

すべてのアニメーションはDOTweenを使用し、GameObject破棄時の自動キャンセルのために`SetLink()`を使用します。

## データモデルの概要 

### 主要なデータ構造 

| クラス | 目的 | 主要フィールド |
| --- | --- | --- |
| `ItemData` | ScrollView用の楽曲表示データ | Title, SubTitle, ClearStateCompress, HasDifficulty |
| `SortOption` | 現在のソート設定 | SortType, Difficulty, Order |
| `FolderItem` | フォルダ表示データ | FolderName, SongCount, Texture |
| `FolderScore` | 集計されたフォルダ統計 | int[] AB, int[] FC, int[] Clear |
| `ScoreData` | 個別のスコアレコード | Id, Score, Combo, ClearState, Rank |

### シングルトンアクセスパターン 

システムは、データアクセスのためにいくつかのシングルトンインスタンスに依存しています:

```
SongInfoCache.Instance.Data              // SongInfo[]配列
ScoreDataPrefas.instance.ScoreDataList   // List<ScoreData>
GameManager.Instance.GroupFolderNameList // List<string>
GameManager.Instance.SelectDifficulty    // DifficultyType
```

これらのシングルトンは、依存性注入なしでソート、フィルタリング、表示コンポーネントによって直接アクセスされ、コードベース全体で使用されているグローバル状態パターンに従っています。

### On this page

* [楽曲選択システム](#5-)
* [目的と範囲](#5--1)
* [システムアーキテクチャ](#5--2)
* [楽曲リスト表示システム](#5--3)
* [ScrollViewとCellのアーキテクチャ](#5-scrollviewcell)
* [ScrollViewの主要メソッド](#5-scrollview)
* [Cell表示ロジック](#5-cell)
* [ソートシステム](#5--4)
* [ソート基準](#5--5)
* [MusicSortの実装](#5-musicsort)
* [譜面情報読込の要件](#5--6)
* [フォルダ選択システム](#5--7)
* [フォルダデータフロー](#5--8)
* [フォルダテクスチャの読込](#5--9)
* [フォルダスコアの集計](#5--10)
* [TapMovableScrollBar](#5-tapmovablescrollbar)
* [位置計算](#5--11)
* [スコア表示の統合](#5--12)
* [スコアデータの取得](#5--13)
* [UpdateScoreロジック](#5-updatescore)
* [アニメーションシステム](#5--14)
* [データモデルの概要](#5--15)
* [主要なデータ構造](#5--16)
* [シングルトンアクセスパターン](#5--17)

