

# 概要 

## 目的と範囲 

本ドキュメントは、リズムゲームに関する概要を提供します。Unityベースのモバイルリズムゲームであり、プレイヤーは音楽に合わせて、縦方向のレーンを下って判定ラインに向かって移動するノートをタップします。このゲームは、ユーザー提供のカスタム譜面、複数の難易度レベル、オンラインマルチプレイヤー、およびLuaスクリプティングによる広範なカスタマイズをサポートしています。

この概要では、アプリケーション構造、シーンフロー、主要なシステムコンポーネント、およびコードベース全体で使用されているアーキテクチャパターンについて説明します。特定のサブシステムの詳細情報については以下を参照してください:

* アプリケーション構造とMVPパターン: [アプリケーション構造](#2)を参照
* ゲームプレイメカニクスとノート判定: [コアゲームプレイシステム](#3)および[判定とスコアリングシステム](#4)を参照
* 楽曲選択と譜面読込: [楽曲選択システム](#5)を参照
* 設定と構成: [設定と構成](#6)を参照
* Luaスクリプト機能: [Luaスクリプトシステム](#7)を参照
* アセット読込とキャッシュ: [アセット管理](#9)を参照
* サードパーティ統合: [サードパーティ統合](#10)を参照

---

## プロジェクト構造 

プロジェクトは、異なるアプリケーション状態を表す4つの主要なUnityシーンに整理されています:

| シーン | ファイルパス | 目的 |
| --- | --- | --- |
| タイトル | `Title.unity` | メインメニュー、設定、パッケージ管理を含む初期シーン |
| 楽曲選択 | `SelectMusic.unity` | ゲームプレイ前の楽曲の閲覧、フィルタリング、ソート、設定 |
| ゲームプレイ | `Game.unity` | ノート判定を伴うリアルタイムリズムゲーム実行 |
| リザルト | `Result.unity` | ゲーム後のスコア表示、統計、パフォーマンス分析 |

各シーンはMVP（Model-View-Presenter）パターンに従い、`LifetimeScope`エントリーポイントがPresenterを初期化し、PresenterがViewとModelコンポーネントを調整します。

## アプリケーションフロー図 

```mermaid
flowchart TD

START["アプリケーション起動"]
GM["GameManager (シングルトン)"]
TITLE_SCENE["Title.unity"]
TLS["TitleLifetimeScope"]
TSP["TitleScenePresenter"]
TSV["TitleSceneView"]
MENU["MenuPanelController"]
SELECT_SCENE["SelectMusic.unity"]
MSLS["MusicSelectSceneLifeTimeScope"]
MSP["MusicSelectScenePresenter"]
MSV["MusicSelectSceneView"]
SIL["SongInfoLoader"]
GAME_SCENE["Game.unity"]
MGSC["MusicGameSceneController"]
MG["MusicGame"]
JUDGE["JudgeManager"]
LIFE["LifeManager"]
SCORE["ScoreManager"]
RESULT_SCENE["Result.unity"]
RLS["ResultLifetimeScope"]
RSP["ResultScenePresenter"]
RSV["ResultSceneView"]
RGRAPH["ResultGraph"]

GM -.->|"ChangeScene(Title)"| TITLE_SCENE
TSV -.->|"シーン間で永続化"| SELECT_SCENE
MSV -.-> GAME_SCENE
MGSC -.-> RESULT_SCENE
RSV -.-> SELECT_SCENE
GM -.-> TITLE_SCENE
GM -.-> SELECT_SCENE
GM -.-> GAME_SCENE
GM -.-> RESULT_SCENE

subgraph リザルトシーン ["リザルトシーン"]
    RESULT_SCENE
    RLS
    RSP
    RSV
    RGRAPH
    RLS -.-> RSP
    RSP -.-> RSV
    RSP -.-> RGRAPH
end

subgraph ゲームシーン ["ゲームシーン"]
    GAME_SCENE
    MGSC
    MG
    JUDGE
    LIFE
    SCORE
    MGSC -.-> MG
    MGSC -.-> JUDGE
    MGSC -.-> LIFE
    MGSC -.-> SCORE
end

subgraph 楽曲選択シーン ["楽曲選択シーン"]
    SELECT_SCENE
    MSLS
    MSP
    MSV
    SIL
    MSLS -.->|"選択した楽曲を再生"| MSP
    MSP -.->|"OnFinishMusic()"| MSV
    MSP -.->|"戻るボタン"| SIL
end

subgraph タイトルシーン ["タイトルシーン"]
    TITLE_SCENE
    TLS
    TSP
    TSV
    MENU
    TLS -.->|"スタートボタン"| TSP
    TSP -.->|"シーン間で永続化"| TSV
    TSP -.->|"シーン間で永続化"| MENU
end

subgraph アプリケーションライフサイクル ["アプリケーションライフサイクル"]
    START
    GM
    START -.->|"シーン間で永続化"| GM
end
```


## 主要なシングルトンマネージャー 

アプリケーションは、シーン間で永続化し、グローバルサービスを提供するいくつかのシングルトンマネージャーを維持します:

```mermaid
flowchart TD

GM["GameManager<br/>グローバル状態"]
BG["BgManager<br/>背景制御"]
FADE["FadeManager<br/>シーン遷移"]
DIALOG["DialogManager<br/>モーダルダイアログ"]
LOCALIZE["LocalizeManager<br/>i18n文字列"]
SE["SystemSEManager<br/>UI効果音"]

NOTES_OPT["NotesOption"]
DISPLAY_OPT["DisplayOption"]
VOLUME_OPT["VolumeOption"]
JUDGE_OPT["JudgeTimeOption"]
PLAYMODE_OPT["PlayModeOption"]

SETTINGS_PREFAS["GameSettingsPrefas<br/>Serializableパターン"]
SCORE_PREFAS["ScoreDataPrefas<br/>LiteDBストレージ"]

SONG_CACHE["SongInfoCache<br/>読込済み譜面メタデータ"]
NOTESKIN_CACHE["NoteSkinCache<br/>カスタムノートスキン"]
TOUCHSE_CACHE["TouchSeCache<br/>カスタムタッチサウンド"]

GM -.->|"含む"| NOTES_OPT
GM -.->|"含む"| DISPLAY_OPT
GM -.->|"永続化先"| VOLUME_OPT
GM -.->|"含む"| JUDGE_OPT
GM -.->|"含む"| PLAYMODE_OPT
GM -.->|"永続化先"| SCORE_PREFAS

subgraph アセットキャッシュ ["アセットキャッシュ"]
    SONG_CACHE
    NOTESKIN_CACHE
    TOUCHSE_CACHE
end

subgraph データストレージ ["データストレージ"]
    SETTINGS_PREFAS
    SCORE_PREFAS
end

subgraph ゲーム状態 ["ゲーム状態"]
    NOTES_OPT
    DISPLAY_OPT
    VOLUME_OPT
    JUDGE_OPT
    PLAYMODE_OPT
end

subgraph コアシングルトン ["コアシングルトン"]
    GM
    BG
    FADE
    DIALOG
    LOCALIZE
    SE
end

```


## コアゲームプレイアーキテクチャ 

ゲームプレイシステムは、`MusicGameSceneController`がすべてのサブシステムを調整する集中更新ループパターンに従います:

```mermaid
flowchart TD

MGSC["MusicGameSceneController.Update()"]
MG["MusicGame.CallUpdate(musicTime)"]
MM["MusicManager.CallUpdate()"]
INPUT["InputBase (TouchAreaまたはAutoPlay)"]
SEQ["Sequence (解析済み譜面データ)"]
NOTE_POOL["NoteObjectPool"]
LONG_POOL["LongObjectPool"]
BPM["BpmHelper"]
SCROLL["ScrollHelper"]
JUDGE_MGR["JudgeManager.CallUpdate()"]
LIFE_MGR["LifeManager.UpdateRecord()"]
SCORE_MGR["ScoreManager.CallUpdate()"]
COMBO_MGR["ComboManager.CallUpdate()"]
LUA_MGR["LuaManager.CallUpdate()"]

MGSC -.->|"musicTime"| MM
MGSC -.->|"使用"| INPUT
MGSC -.->|"JudgeTap/Hold/Up"| MG
MGSC -.->|"OnAfterJudgeイベント"| JUDGE_MGR
MGSC -.->|"OnJudgeイベント"| LIFE_MGR
MGSC -.->|"OnAfterJudgeイベント"| SCORE_MGR
MGSC -.-> COMBO_MGR
MGSC -.-> LUA_MGR
MG -.->|"生成元"| SEQ
MG -.->|"拍変換"| NOTE_POOL
MG -.->|"位置計算"| LONG_POOL
MG -.-> BPM
MG -.-> SCROLL
MG -.-> JUDGE_MGR

subgraph スクリプティング ["スクリプティング"]
    LUA_MGR
end

subgraph 判定とスコアリング ["判定とスコアリング"]
    JUDGE_MGR
    LIFE_MGR
    SCORE_MGR
    COMBO_MGR
end

subgraph ノートシステム ["ノートシステム"]
    SEQ
    NOTE_POOL
    LONG_POOL
    BPM
    SCROLL
end

subgraph コアゲームループ ["コアゲームループ"]
    MG
    MM
    INPUT
    MM -.->|"生成元"| MG
    INPUT -.->|"TouchData"| MG
end

subgraph シーンコントローラー ["シーンコントローラー"]
    MGSC
end
```

`MusicGameSceneController`はオーケストレーターとして機能し、すべてのサブシステムの`CallUpdate()`メソッドを特定の順序で呼び出して、適切な依存関係を確保します。`MusicGame`クラスはノートの生成と入力処理を処理し、個別のマネージャークラスが判定評価とスコア計算を処理します。

---

## アーキテクチャパターン 

### MVP（Model-View-Presenter）パターン 

すべてのシーンは、3つのコンポーネントを通じてMVPパターンを実装します:

1. **LifetimeScope**（MonoBehaviour）: UnityのライフサイクルをPresenterに橋渡しするシーンエントリーポイント
2. **Presenter**（IStartable, ITickable, IDisposable）: ビジネスロジックの調整
3. **View**（ICallUpdate）: UI更新とレンダリング

楽曲選択シーンの例:

* `MusicSelectSceneLifeTimeScope`が依存関係を作成し注入
* `MusicSelectScenePresenter`が楽曲読込、フィルタリング、ソートを調整
* `MusicSelectSceneView`がPresenterの状態に基づいてUI要素を更新



### 遅延初期化を伴うシングルトンパターン 

グローバルサービスは、ジェネリック基底クラスを使用したシングルトンパターンを使用します:

* `Singleton<T>` MonoBehaviourシングルトン用（例: `GameManager`、`FadeManager`）
* `Serializable<T>` 遅延読込を伴うデータ永続化用（例: `GameSettingsPrefas`）



### オブジェクトプーリング 

パフォーマンスクリティカルなゲームプレイオブジェクトは、フレームごとのアロケーションを避けるためにUnityの`ObjectPool<T>`を使用します:

* `NoteObjectPool`（32インスタンス）
* `LongObjectPool`（32インスタンス）
* `BeatBarObjectPool`（100インスタンス）
* `JudgeEffectPool`（32インスタンス）



### イベント駆動通信 

マネージャーは疎結合を維持するためにC#イベントを通じて通信します:

* `JudgeManager.OnJudge`が`LifeManager`と`ComboManager`に通知
* `JudgeManager.OnAfterJudge`が`ScoreManager`に通知
* `MusicManager.OnFinishMusic`がシーン遷移をトリガー
* `LifeManager.OnDead`がゲームオーバー状態を処理



---

## データ永続化アーキテクチャ 

```mermaid
flowchart TD

GM_INST["GameManager.Instance"]
NOTES["NotesOption (速度、サイズ、スキン)"]
DISPLAY["DisplayOption (FPS、エフェクト、UI)"]
VOLUME["VolumeOption (音楽、SE、動画)"]
JUDGE["JudgeTimeOption (タイミングウィンドウ)"]
FILE_SYS["Fileシステム (ジェネリックシリアライゼーション)"]
GSP["GameSettingsPrefas (シングルトンパターン)"]
SDP["ScoreDataPrefas (LiteDB統合)"]
JSON["JSONファイル (persistentDataPath)"]
LITEDB["player.db (LiteDB)"]

NOTES -.->|"読込/保存"| GSP
DISPLAY -.->|"含む"| GSP
VOLUME -.->|"読込/保存"| GSP
JUDGE -.->|"読込/保存"| GSP
SDP -.->|"クエリ/挿入"| LITEDB

subgraph ストレージ ["ストレージ"]
    JSON
    LITEDB
end

subgraph 永続化レイヤー ["永続化レイヤー"]
    FILE_SYS
    GSP
    SDP
    GSP -.->|"File.Open"| FILE_SYS
    SDP -.->|"File.Open"| FILE_SYS
end

subgraph ランタイム設定 ["ランタイム設定"]
    GM_INST
    NOTES
    DISPLAY
    VOLUME
    JUDGE
end
```

永続化システムは3層アーキテクチャを使用します:

1. **ランタイム状態**: 現在の設定を含む`GameManager`が保持するオプションオブジェクト
2. **永続化レイヤー**: 遅延読込と自動保存を処理する`Serializable<T>`シングルトン
3. **ストレージ**: 設定用のJSONファイル、構造化されたスコアデータ用のLiteDB

設定は、Unityの`OnApplicationQuit()`ライフサイクルフックを通じて、アプリケーション終了時に自動的に保存されます。スコアデータは、各ゲームプレイセッション後に`ScoreDataPrefas`を通じて即座に永続化されます。



---

## 譜面とアセット読込パイプライン 

```mermaid
flowchart TD

EXT_DIR["ExternalDirectory (プラットフォーム固有パス)"]
SONGS["Songsフォルダ (ユーザー提供譜面)"]
SIL["SongInfoLoader.ReadAsync()"]
SEQ_READER["SequenceReader.Read()"]
TEX_LOADER["TextureLoader"]
AUDIO_LOADER["AudioClipLoader"]
SONG_INFO["SongInfo (メタデータ)"]
SEQUENCE["Sequence (ノートデータ)"]
JACKET["Texture2D (ジャケット画像)"]
AUDIO["AudioClip (音楽ファイル)"]
SONG_CACHE["SongInfoCache"]
CHART_CACHE["ChartInfoCache"]
FOLDER_CACHE["FolderTextureCache"]

SONGS -.->|"ディレクトリスキャン"| SIL
SIL -.->|"楽曲選択時"| SONG_INFO
JACKET -.->|"再生開始時"| FOLDER_CACHE
SEQUENCE -.->|"完全な譜面解析"| CHART_CACHE

subgraph キャッシュ ["キャッシュ"]
    SONG_CACHE
    CHART_CACHE
    FOLDER_CACHE
end

subgraph 解析済みデータ ["解析済みデータ"]
    SONG_INFO
    SEQUENCE
    JACKET
    AUDIO
end

subgraph 読込パイプライン ["読込パイプライン"]
    SIL
    SEQ_READER
    TEX_LOADER
    AUDIO_LOADER
    SIL -.->|"ジャケット読込"| TEX_LOADER
end

subgraph 外部コンテンツ ["外部コンテンツ"]
    EXT_DIR
    SONGS
end
```

読込パイプラインは2つのフェーズで動作します:

**フェーズ1（楽曲選択シーン）**: `SongInfoLoader.ReadAsync()`がSongsディレクトリをスキャンし、メタデータ（タイトル、アーティスト、難易度）の譜面ファイルヘッダーを解析し、ジャケット画像を読み込みます。この段階では、メモリ使用量と起動時間を最小限に抑えるため、完全な譜面データは読み込まれません。

**フェーズ2（ゲームシーン）**: 楽曲が選択されると、`SequenceReader.Read()`が完全な譜面解析を実行し、ノート位置、タイミングデータ、BPM変更、スクロール修飾子を`Sequence`オブジェクトに変換します。オーディオファイルは`MusicManager.InitAsync()`を介して非同期に読み込まれます。


---

## 技術スタック 

### Unityとコアパッケージ 

| コンポーネント | バージョン/パッケージ | 目的 |
| --- | --- | --- |
| Unity Engine | 2021.3+（LTS） | コアフレームワーク |
| TextMeshPro | ビルトイン | UIテキストレンダリング |
| Addressables | com.unity.addressables | アセット管理 |
| Localization | com.unity.localization | 多言語サポート |
| Input System | com.unity.inputsystem | 拡張タッチ処理 |



### サードパーティミドルウェア 

| ミドルウェア | 目的 | 統合ポイント |
| --- | --- | --- |
| CRI ADX2 | ピッチシフトを伴うオーディオ再生 | `MusicManager`、`TouchSEManager` |
| CRI Sofdec2 | 動画背景再生 | `BgManager` |
| XLua | カスタム動作用のLuaスクリプティング | `LuaManager` |
| DOTween | UIとゲームプレイのアニメーション | UIコントローラー、ノートアニメーション |
| FancyScrollView | 最適化されたスクロール可能リスト | 楽曲選択の`ScrollView` |
| LiteDB | 構造化されたスコアストレージ | `ScoreDataPrefas` |

### プラットフォーム固有機能 

アプリケーションは`ExternalDirectory`を通じてプラットフォームの違いを抽象化します:

* **Android**: 外部ストレージ（`/storage/emulated/0/Android/data/...`）
* **iOS**: Documentsディレクトリ（`Application.persistentDataPath`）
* **Windows（エディター）**: AppDataフォルダ



---

## シーン初期化パターン 

すべてのシーンは一貫した初期化パターンに従います:

1. **LifetimeScope Awake()**: Presenterを作成し依存関係を注入
2. **Presenter IStartable.Start()**: ビジネスロジックを初期化
3. **View Init()**: UIコンポーネントとイベントハンドラーを設定
4. **非同期読込**: ノンブロッキング操作のために`UniTask`を介してアセットを読込
5. **Presenter ITickable.Tick()**: フレームごとの更新
6. **Presenter IDisposable.Dispose()**: シーンアンロード時のクリーンアップ

ゲームプレイシーンは、次のような特殊なパターンで`MusicGameSceneController.Start()`を使用します:

1. シーンエントリーを検証（エディター安全性チェック）
2. すべてのマネージャーコンポーネントを同期的に初期化
3. 重い操作（譜面解析、オーディオ読込）のために`InitAsync()`を実行
4. すべての非同期操作が完了した後にのみゲームループを開始



 

---

## パフォーマンスに関する考慮事項 

コードベースはいくつかのパフォーマンス最適化を実装しています:

### メモリ管理 

* ノート、ロングノート、エフェクト、拍線のオブジェクトプーリングは、フレームごとのアロケーションを排除
* メッシュ生成の一時バッファ用の配列プーリング（`ArrayPool<T>`）
* マテリアルのインスタンス化を避けるためにキャッシュされた`MaterialPropertyBlock`インスタンス
* リサイズを減らすために明示的な容量を持つ事前割り当てコレクション



 

### 更新ループの最適化 

* `MusicGameSceneController`の単一`Update()`がすべてのサブシステムの`CallUpdate()`を呼び出し、Unityのオーバーヘッドを最小化
* 非アクティブなシステムをスキップする早期終了パターン
* `[MethodImpl(MethodImplOptions.AggressiveInlining)]`を使用したホットパスメソッドのインライン化



 

### レンダリング最適化 

* レーンセパレーターと背景要素の静的バッチング
* ドローコールを削減するためのロングノートのメッシュ結合
* ヒッチを防ぐための起動時のシェーダーバリアントコレクションのウォーミング



---

## エラーハンドリングとローカライゼーション 

アプリケーションは`DialogManager`を通じた集中エラーハンドリングパターンを使用します:

```c#
var localize = LocalizeManager.Instance;
var builder = new DialogParametor.Builder(
    localize.GetStringValue(LocalizationConstant.ERROR_LOAD_CHART_HEADER),
    exceptionMessage
);
builder.AddDefaultAction(
    localize.GetStringValue(LocalizationConstant.BACK_SELECT_MUSIC),
    () => GameManager.Instance.ChangeScene(SceneBuildIndex.SelectMusic)
);
DialogManager.Instance.Open(builder.Build());
```

すべてのユーザー向け文字列は、型安全なキーアクセス用の自動生成された定数クラス（`LocalizationConstant`）を使用して、Unityのローカライゼーションパッケージを通じて外部化されています。システムは日本語と英語をサポートし、追加言語への拡張性を備えています。

### On this page

* [概要](#1-)
* [目的と範囲](#1--1)
* [プロジェクト構造](#1--2)
* [アプリケーションフロー図](#1--3)
* [主要なシングルトンマネージャー](#1--4)
* [コアゲームプレイアーキテクチャ](#1--5)
* [アーキテクチャパターン](#1--6)
* [MVP（Model-View-Presenter）パターン](#1-mvpmodel-view-presenter)
* [遅延初期化を伴うシングルトンパターン](#1--7)
* [オブジェクトプーリング](#1--8)
* [イベント駆動通信](#1--9)
* [データ永続化アーキテクチャ](#1--10)
* [譜面とアセット読込パイプライン](#1--11)
* [技術スタック](#1--12)
* [Unityとコアパッケージ](#1-unity)
* [サードパーティミドルウェア](#1--13)
* [プラットフォーム固有機能](#1--14)
* [シーン初期化パターン](#1--15)
* [パフォーマンスに関する考慮事項](#1--16)
* [メモリ管理](#1--17)
* [更新ループの最適化](#1--18)
* [レンダリング最適化](#1--19)
* [エラーハンドリングとローカライゼーション](#1--20)

