

# 設定と構成 

## 目的と範囲 

このページでは、DKLIKEリズムゲーム全体で使用される包括的な設定と構成システムについて説明します。ランタイムオプション、永続化メカニズム、およびゲームプレイ、オーディオ、表示、入力の動作を制御する構成階層のアーキテクチャをカバーします。

特定の設定カテゴリに関する詳細情報については：

* **ゲーム設定**（ノート、表示、音量）：[ゲーム設定管理](#6.1)を参照
* **判定時間と特殊オプション**：[判定タイミング設定](#6.2)を参照
* **Unityプロジェクトレベルの設定**：[プロジェクト設定](#6.3)を参照

ゲームプレイ中に設定がどのように使用されるかについては、[判定メカニクス](#4.1)と[コアゲームプレイシステム](#3)を参照してください。

---

## アーキテクチャ概要 

設定システムは、ランタイム状態、永続化、ストレージを分離する3層アーキテクチャを実装しています：

**設定アーキテクチャ図**

```mermaid
flowchart TD

%% ===== ストレージ層 =====
JSON_FILES["JSON ファイル<br/>Application.persistentDataPath/Save"]
CONSTANTS["Constants.cs<br/>デフォルト値"]

subgraph ストレージ層 ["ストレージ層"]
    JSON_FILES
    CONSTANTS
end

%% ===== 永続化層 =====
GSP["GameSettingsPrefas<br/>Serializable シングルトン"]
OSP["OnlineSettingsPrefas<br/>Serializable シングルトン"]
FILE_SYS["File<T> システム<br/>汎用シリアライゼーション"]

subgraph 永続化層 ["永続化層"]
    GSP
    OSP
    FILE_SYS
end

GSP -->|"保存 / 読込"| FILE_SYS
OSP -->|"保存 / 読込"| FILE_SYS
FILE_SYS -->|"書込 / 読込"| JSON_FILES
CONSTANTS -->|"初期値"| GSP
CONSTANTS -->|"初期値"| OSP

%% ===== ランタイム層 =====
GM["GameManager.Instance"]
NOTES_OPT["NotesOption"]
DISP_OPT["DisplayOption"]
VOL_OPT["VolumeOption"]
JUDGE_OPT["JudgeTimeOption"]
ONLINE_OPT["OnlineSettings"]

subgraph ランタイム層 ["ランタイム層"]
    GM
    NOTES_OPT
    DISP_OPT
    VOL_OPT
    JUDGE_OPT
    ONLINE_OPT
end

GM -->|"保持"| NOTES_OPT
GM -->|"保持"| DISP_OPT
GM -->|"保持"| VOL_OPT
GM -->|"ロード"| JUDGE_OPT
GM -->|"ロード"| ONLINE_OPT

GSP -->|"反映"| NOTES_OPT
GSP -->|"反映"| DISP_OPT
GSP -->|"反映"| VOL_OPT
GSP -->|"反映"| JUDGE_OPT
OSP -->|"反映"| ONLINE_OPT

%% ===== 外部リソース =====
EXT_DIR["ExternalDirectory<br/>プラットフォーム固有パス"]
SONGS["Songs フォルダ"]
NOTESKIN["NoteSkins フォルダ"]
TOUCHSE["SoundEffects フォルダ"]
GLOBAL_LUA["GlobalLua フォルダ"]

subgraph 外部リソース ["外部リソース"]
    EXT_DIR
    SONGS
    NOTESKIN
    TOUCHSE
    GLOBAL_LUA
end

EXT_DIR --> SONGS
EXT_DIR --> NOTESKIN
EXT_DIR --> TOUCHSE
EXT_DIR --> GLOBAL_LUA

GM -->|"参照"| SONGS
GM -->|"参照"| NOTESKIN
GM -->|"参照"| TOUCHSE
GM -->|"参照"| GLOBAL_LUA

```


## 設定カテゴリ 

アプリケーションは設定を5つのドメイン固有のオプションクラスに整理しています：

| オプションクラス | 目的 | 永続化 | 主な設定 |
| --- | --- | --- | --- |
| `NotesOption` | ノート表示と動作 | `GameSettingsPrefas` | サイズ、スキン、速度、距離、judgeLineY |
| `DisplayOption` | 視覚効果とUI | `GameSettingsPrefas` | FPS表示、UI可視性、エフェクト切替 |
| `VolumeOption` | オーディオレベル | `GameSettingsPrefas` | 音楽、SE、ビデオ音量 |
| `JudgeTimeOption` | タイミングウィンドウと特殊オプション | `GameSettingsPrefas` | 判定タイミング、音楽速度、ミラー、バイブレーション |
| `OnlineSettings` | ネットワーク設定 | `OnlineSettingsPrefas` | サーバーURL、アカウント認証情報 |

各オプションクラスは、`File<T>`システムを介してJSONに永続化できるシリアライズ可能なC#クラスです。

## 構成階層 

設定は3つの異なる層に整理されています：

**構成層図**

```mermaid
flowchart TD

%% ===== 層1: プロジェクト設定 =====
PROJ_SETTINGS["ProjectSettings.asset<br/>プラットフォーム設定"]
SCRIPTING_DEFINES["スクリプト定義シンボル"]
AUDIO_SETTINGS["AudioSettings<br/>DSP バッファサイズ"]

subgraph LAYER1 ["層1: プロジェクト設定"]
    PROJ_SETTINGS
    SCRIPTING_DEFINES
    AUDIO_SETTINGS
end

%% ===== 層2: 永続設定 =====
JSON_SETTINGS["GameSettingsPrefas.json<br/>ユーザー設定"]
ONLINE_JSON["OnlineSettingsPrefas.json<br/>サーバー設定"]

subgraph LAYER2 ["層2: 永続設定"]
    JSON_SETTINGS
    ONLINE_JSON
end

%% ===== 層3: ランタイム設定 =====
GM_OPTIONS["GameManager Options<br/>ゲームプレイ中アクティブ"]

subgraph LAYER3 ["層3: ランタイム設定"]
    GM_OPTIONS
end

%% ===== 影響関係 =====
PROJ_SETTINGS -->|"初期環境"| JSON_SETTINGS
SCRIPTING_DEFINES -->|"機能切替"| GM_OPTIONS
AUDIO_SETTINGS -->|"初期値"| JSON_SETTINGS

JSON_SETTINGS -->|"読込"| GM_OPTIONS
ONLINE_JSON -->|"上書き / 同期"| GM_OPTIONS

```

### 層1: プロジェクト設定 

ビルド時の動作を定義するUnity管理の設定ファイル：

* **プラットフォーム固有の設定**

* バンドルバージョン: `1.1.8`
* アプリケーション識別子: `com.ELEBEAT.DKLIKE`
* プラットフォームごとのスクリプト定義シンボル
* オーディオDSPバッファサイズ
* **グラフィック設定**: 

* シェーダーバリアントとレンダリングパス
* プラットフォーム固有のグラフィックAPI

### 層2: 永続設定 

`Application.persistentDataPath/Save`に保存されるJSONファイル：

* `(GameSettingsPrefas).json`: `NotesOption`、`DisplayOption`、`VolumeOption`、`JudgeTimeOption`を含む
* `(OnlineSettingsPrefas).json`: `OnlineSettings`を含む

保存パスはプラットフォーム固有です：

* **エディタ**: プロジェクトルートディレクトリ
* **Android**: `Application.persistentDataPath`
* **iOS**: `Application.persistentDataPath`

### 層3: ランタイム設定 

実行中に`GameManager.Instance`が保持するオプションオブジェクト。UIパネルによって変更され、ゲームプレイ動作に即座に影響します。

 

 

---

## 永続化システム 

設定システムは、保存/読込操作を処理するために汎用シリアライゼーションパターンを使用します：

**永続化フロー図**

```mermaid
flowchart TD

%% ===== 読込フロー =====
APP_START["アプリケーション起動"]

PREFAS_LOAD["GameSettingsPrefas<br/>.instance"]
FILE_READ["File<T><br/>Open()"]
JSON_READ["JSON ファイルを<br/>読込"]
DEFAULTS["デフォルト値を適用<br/>(ファイル未検出時)"]
GM_LOAD["GameManager.Instance<br/>オプション読込"]

%% ===== 保存フロー =====
UI_CHANGE["UI パネルで<br/>ユーザーが設定変更"]
UPDATE_GM["GameManager.Instance<br/>オプション更新"]
PREFAS_SAVE["GameSettingsPrefas<br/>Save()"]
FILE_WRITE["File<T><br/>Write()"]
JSON_DISK["ディスク上の<br/>JSON ファイル"]

%% 読込の流れ
APP_START --> PREFAS_LOAD
PREFAS_LOAD --> FILE_READ
FILE_READ -->|存在| JSON_READ
FILE_READ -->|未検出| DEFAULTS
JSON_READ --> GM_LOAD
DEFAULTS --> GM_LOAD

%% 保存の流れ
UI_CHANGE --> UPDATE_GM
UPDATE_GM --> PREFAS_SAVE
PREFAS_SAVE --> FILE_WRITE
FILE_WRITE --> JSON_DISK

subgraph 読込フロー ["読込フロー"]
    APP_START
    PREFAS_LOAD
    FILE_READ
    JSON_READ
    DEFAULTS
    GM_LOAD
end

subgraph 保存フロー ["保存フロー"]
    UI_CHANGE
    UPDATE_GM
    PREFAS_SAVE
    FILE_WRITE
    JSON_DISK
end

```

### Fileシステム 

JSONシリアライゼーションとオプショナルな暗号化を処理する汎用シリアライゼーションユーティリティ：

```
File<T>.Open<T>() : T
File<T>.Write<T>(T data)
```

システムは保存ディレクトリが存在しない場合、自動的に作成します： 

### Serializableパターン 

`GameSettingsPrefas`と`OnlineSettingsPrefas`は、遅延読込と自動保存変更を管理するシングルトンパターンを実装しています。`.instance`経由でアクセスされると：

1. データが既にロードされているかチェック
2. されていなければ、`File<T>.Open()`を呼び出してディスクから読込
3. ファイルが存在しない場合、デフォルト値で初期化
4. 以降のアクセスのためにロードされたデータをキャッシュ

保存操作は明示的にトリガーされます： 


## 判定時間設定 

`JudgeTimeOption`はタイミングウィンドウと特殊ゲームプレイオプションを管理します：

| 設定 | 型 | デフォルト | 目的 |
| --- | --- | --- | --- |
| `BrilliantTime` | float | `Constant.JudgeTime.BRILLIANT_TIME` | Brilliant判定ウィンドウ（秒） |
| `GreatTime` | float | `Constant.JudgeTime.GREAT_TIME` | Great判定ウィンドウ（秒） |
| `FastTime` | float | `Constant.JudgeTime.FAST_TIME` | Fast判定ウィンドウ（秒） |
| `BadTime` | float | `Constant.JudgeTime.BAD_TIME` | Bad判定ウィンドウ（秒） |
| `JudgeDistance` | float | `Constant.JudgeTime.JUDGE_DISTANCE` | 判定の距離乗数 |
| `LongRevisionTime` | float | `Constant.JudgeTime.LONG_REVISION_TIME` | ロングノート終端の時間調整 |
| `LongRevisionDistance` | float | `Constant.JudgeTime.LONG_REVISION_DISTANCE` | ロングノートの距離調整 |
| `FuzzyStartTime` | float | `Constant.JudgeTime.FUZZY_START_TIME` | ファジー判定開始ウィンドウ |
| `CanSave` | bool | `false` | カスタムタイミングでスコア保存可能か |
| `MusicRate` | float | `1.0f` | 音楽再生速度乗数 |
| `FuzzyJudgeMitigation` | bool | `true` | ファジー判定緩和を有効化 |
| `Mirror` | bool | `false` | ノートレーンを水平反転 |
| `Vibration` | bool | `false` | ヒット時の触覚フィードバック有効化 |
| `PauseLongPress` | bool | `false` | ポーズに長押しを要求 |
| `GlobalLuaName` | string | `"Default"` | アクティブなグローバルLuaスクリプト名 |
| `NullTapNoSoundTime` | float | `0.2f` | 空打ちSE再生前の遅延 |
| `DspBufferSize` | int | `256` | オーディオDSPバッファサイズ（サンプル） |

### カスタム判定検出 

`IsCustom`プロパティは、タイミングパラメータがデフォルトと異なる場合を自動的に検出します： 

カスタムタイミングがアクティブな場合、不公平な利点を防ぐために`CanSave`を介してスコア保存を無効にできます。

### ヘルパーメソッド 

`JudgeTimeOption`は判定計算のためのユーティリティメソッドを提供します：

* `GetHitTime()`: 最長の判定ウィンドウを返す
* `GetLongEndHitTime()`: ロングノート補正を含む最長ウィンドウを返す
* `GetComboHitTime()`: コンボ維持可能な最長ウィンドウを返す 


---

## オーディオ設定 

### DSPバッファサイズ 

DSPバッファサイズはオーディオレイテンシを制御し、判定タイミングに影響します：

**DSPバッファ設定**

```mermaid
flowchart TD

%% UI
DSP_PANEL["DspBufferSizePanel<br/>トグル: 256 / 512"]
IOS_DISABLED["iOS: 設定無効<br/>固定バッファサイズ"]

%% Runtime / Option
JUDGE_OPT_DSP["JudgeTimeOption<br/>DspBufferSize"]

%% Audio API
AUDIO_SETTINGS["AudioSettings<br/>GetConfiguration()"]
AUDIO_RESET["AudioSettings<br/>Reset(config)"]

%% Platform
WINDOWS_EDITOR["Windows / Editor<br/>固定: 1024"]
ANDROID["Android<br/>ユーザー設定を使用"]
IOS["iOS<br/>プラットフォームデフォルト"]

%% UI フロー
DSP_PANEL --> JUDGE_OPT_DSP
IOS -->|設定非表示| IOS_DISABLED

%% プラットフォーム分岐
JUDGE_OPT_DSP --> ANDROID
JUDGE_OPT_DSP --> WINDOWS_EDITOR
JUDGE_OPT_DSP --> IOS

%% Audio 反映
ANDROID --> AUDIO_SETTINGS
WINDOWS_EDITOR --> AUDIO_SETTINGS
IOS --> AUDIO_SETTINGS

AUDIO_SETTINGS --> AUDIO_RESET

subgraph ユーザーインターフェース ["ユーザーインターフェース"]
    DSP_PANEL
    IOS_DISABLED
end

subgraph アプリケーション層 ["アプリケーション層"]
    JUDGE_OPT_DSP
    AUDIO_SETTINGS
    AUDIO_RESET
end

subgraph プラットフォーム処理 ["プラットフォーム処理"]
    WINDOWS_EDITOR
    ANDROID
    IOS
end

```

バッファサイズの変更にはオーディオシステムのリセットが必要です： 

プラットフォーム固有の動作：

* **iOS**: 設定は非表示、プラットフォームデフォルトを使用
* **Android**: ユーザーは256または512サンプルを選択可能
* **Windowsエディタ**: 設定に関わらず1024サンプルを強制

バッファサイズ変更後、適切な再生を確保するためにプレビュー音楽キャッシュがクリアされます


## 外部リソースパス 

`ExternalDirectory`はユーザーコンテンツのプラットフォーム抽象化されたパスを提供します：

**外部ディレクトリ構造**

```mermaid
flowchart TD

ROOT["ExternalDirectory.RootFolder"]
SONGS["Songs/ ユーザー追加譜面"]
NOTESKINS["NoteSkins/ カスタムノートグラフィック"]
SOUNDEFFECTS["SoundEffects/ カスタムタッチSE"]
GLOBALLUA["GlobalLua/ カスタムLuaスクリプト"]
SAVE["Save/ 永続設定"]
DOCUMENTS["Documents/ ユーザー文書"]
RIVALDATA["RivalData/ ライバルスコアデータベース"]
MOCKAPI["MockAPI/ APIモックレスポンス"]

ROOT -.-> SONGS
ROOT -.-> NOTESKINS
ROOT -.-> SOUNDEFFECTS
ROOT -.-> GLOBALLUA
ROOT -.-> SAVE
ROOT -.-> DOCUMENTS
ROOT -.-> RIVALDATA
ROOT -.-> MOCKAPI
```

### ルートフォルダ解決 

プラットフォーム固有のルートパス： 

* **エディタ**: `Directory.GetCurrentDirectory()`（プロジェクトルート）
* **Android**: `Application.persistentDataPath`
* **iOS**: `Application.persistentDataPath`

### パスプロパティ 

すべてのパスは効率的な文字列連結のために`ZString.Concat`を使用する静的プロパティとして公開されています：

* `SongsPath`: ユーザー追加楽曲フォルダ
* `NoteSkinsPath`: カスタムノートスキングラフィック
* `SoundEffectsPath`: カスタムタッチ効果音 
* `GlobalLuaPath`: カスタムグローバルLuaスクリプト
* `SavePath`: 永続設定とデータ
* `DocumentsPath`: ユーザー文書
* `RivalDataPath`: ライバルスコアLiteDBファイル
* `MockAPIPath`: モックAPIレスポンスファイル

### ディレクトリ作成 

静的メソッドは使用前にディレクトリの存在を保証します：

```
CreateSongsDirectory()
CreateNoteSkinsDirectory()
CreateTouchSoundEffectsDirectory()
CreateGlobalLuaDirectory()
CreateSaveDirectory()
CreateDocumentsDirectory()
CreateRivalDataDirectory()
CreateMockAPIDirectory()
```

これらはアプリケーション初期化中に呼び出され、期待されるフォルダ構造の存在を確保します。

---

## 設定UI アーキテクチャ 

設定は楽曲選択シーンの特殊なパネルコンポーネントを通じて構成されます：

**設定UIコンポーネント**

```mermaid
flowchart TD

%% メインパネル
GAME_SETTINGS["GameSettingsPanel"]
JUDGE_SETTINGS["JudgeTimeSettingsPanel"]

%% 判定関連
JUDGE_TIME_P["JudgeTimePanel<br/>Brilliant / Great / Fast / Bad"]
JUDGE_DIST_P["JudgeDistancePanel<br/>距離乗数"]
JUDGE_OTHER_P["JudgeOtherPanel<br/>保存可能トグル"]

%% オーディオ
NULL_TAP_P["NullTapPanel<br/>空打ち遅延"]
DSP_BUFFER_P["DspBufferSizePanel<br/>オーディオバッファサイズ"]

%% 特殊オプション
MUSIC_RATE_P["MusicRatePanel<br/>速度乗数"]
FUZZY_P["FuzzyJudgeMitigationPanel<br/>ファジー判定トグル"]
MIRROR_P["MirrorPanel<br/>ミラートグル"]
VIBRATION_P["VibrationPanel<br/>触覚トグル"]
PAUSE_P["PauseLongPressPanel<br/>ポーズモードトグル"]
GLOBAL_LUA_P["GlobalLuaPanel<br/>Lua スクリプト選択"]

%% メイン → サブパネル
GAME_SETTINGS --> JUDGE_SETTINGS
GAME_SETTINGS --> NULL_TAP_P
GAME_SETTINGS --> DSP_BUFFER_P
GAME_SETTINGS --> MUSIC_RATE_P
GAME_SETTINGS --> FUZZY_P
GAME_SETTINGS --> MIRROR_P
GAME_SETTINGS --> VIBRATION_P
GAME_SETTINGS --> PAUSE_P
GAME_SETTINGS --> GLOBAL_LUA_P

JUDGE_SETTINGS --> JUDGE_TIME_P
JUDGE_SETTINGS --> JUDGE_DIST_P
JUDGE_SETTINGS --> JUDGE_OTHER_P

subgraph メイン設定パネル ["メイン設定パネル"]
    GAME_SETTINGS
    JUDGE_SETTINGS
end

subgraph 判定時間サブパネル ["判定時間サブパネル"]
    JUDGE_TIME_P
    JUDGE_DIST_P
    JUDGE_OTHER_P
end

subgraph オーディオサブパネル ["オーディオサブパネル"]
    NULL_TAP_P
    DSP_BUFFER_P
end

subgraph 特殊オプションサブパネル ["特殊オプションサブパネル"]
    MUSIC_RATE_P
    FUZZY_P
    MIRROR_P
    VIBRATION_P
    PAUSE_P
    GLOBAL_LUA_P
end

```

### JudgeTimeSettingsPanel 

すべての判定と特殊オプション制御を実装するメイン設定パネル： 

主な責務：

* 現在の値でサブパネルを初期化
* `GameManager.Instance.JudgeTimeOption`を更新するコールバックを配線
* カスタム判定ステータスを検出
* 楽曲リロード機能を処理

### サブパネルパターン 

各サブパネルは一貫したパターンに従います：

1. `JudgeTimeSettingsPanel`にネストされた**Serializableクラス**
2. 初期値を設定しイベントを配線する**Init()メソッド**
3. 親パネルがサブスクライブする**OnChangeコールバック**（`Action<T>`）
4. デフォルト値に戻す**Reset()メソッド**（オプショナル）

例： 

### プラットフォーム固有UI 

一部のパネルはサポートされていないプラットフォームでコントロールを非表示にします：

* **VibrationPanel**: `!SystemInfo.supportsVibration`の場合非表示
* **DspBufferSizePanel**: iOSで非表示 



---

## スクリプト定義シンボル 

プラットフォーム固有のコンパイルはスクリプト定義で制御されます
| プラットフォーム | 定義シンボル | 目的 |
| --- | --- | --- |
| Android | `TMPro`, `DOTWEEN`, `UNITYWEBVIEW_ANDROID_USES_CLEARTEXT_TRAFFIC`, `ELEBEAT_PRODUCT` | Android用プロダクションビルド |
| Standalone | `ELEBEAT_STAGING`, `DOTWEEN` | デスクトップテスト用ステージングビルド |
| iPhone | `ELEBEAT_PRODUCT`, `TMPro`, `DOTWEEN` | iOS用プロダクションビルド |

これらのシンボルは、コードベース全体で条件付きコンパイルブロックを制御します：

```c#
#if UNITY_EDITOR    // エディタ専用コード
#elif UNITY_ANDROID    // Android固有コード
#elif UNITY_IOS    // iOS固有コード
#endif
```

 

---

## 定数とデフォルト値 

すべての設定のデフォルト値は`Constant.cs`クラスに集約されています：

### Constant.JudgeTime 

`JudgeTimeOption`が参照するタイミングウィンドウ定数：

* `BRILLIANT_TIME`: デフォルトのBrilliant判定ウィンドウ
* `GREAT_TIME`: デフォルトのGreat判定ウィンドウ
* `FAST_TIME`: デフォルトのFast判定ウィンドウ
* `BAD_TIME`: デフォルトのBad判定ウィンドウ
* `JUDGE_DISTANCE`: デフォルトの距離乗数
* `LONG_REVISION_TIME`: デフォルトのロングノート時間補正
* `LONG_REVISION_DISTANCE`: デフォルトのロングノート距離補正
* `FUZZY_START_TIME`: デフォルトのファジー判定開始時間

これらの定数は以下で使用されます：

1. `JudgeTimeOption`が最初に作成されるときのデフォルト値として
2. リセット操作用 
3. カスタム判定検出用 

### Constant.PlayerOption.Other 

その他のデフォルト定数値：

* `DEFAULT_GLOBAL_LUA_NAME`: `"Default"` 
* `DEFAULT_GLOBAL_LUA_FILENAME`: デフォルトLuaスクリプトのファイル名

### On this page

* [設定と構成](#6-)
* [目的と範囲](#6--1)
* [アーキテクチャ概要](#6--2)
* [設定カテゴリ](#6--3)
* [構成階層](#6--4)
* [層1: プロジェクト設定](#6-1-)
* [層2: 永続設定](#6-2-)
* [層3: ランタイム設定](#6-3-)
* [永続化システム](#6--5)
* [File システム](#6-file)
* [Serializable パターン](#6-serializable)
* [判定時間設定](#6--6)
* [カスタム判定検出](#6--7)
* [ヘルパーメソッド](#6--8)
* [オーディオ設定](#6--9)
* [DSPバッファサイズ](#6-dsp)
* [外部リソースパス](#6--10)
* [ルートフォルダ解決](#6--11)
* [パスプロパティ](#6--12)
* [ディレクトリ作成](#6--13)
* [設定UI アーキテクチャ](#6-ui-)
* [JudgeTimeSettingsPanel](#6-judgetimesettingspanel)
* [サブパネルパターン](#6--14)
* [プラットフォーム固有UI](#6-ui)
* [スクリプト定義シンボル](#6--15)
* [定数とデフォルト値](#6--16)
* [Constant.JudgeTime](#6-constantjudgetime)
* [Constant.PlayerOption.Other](#6-constantplayeroptionother)
* [設定データフロー](#6--17)

