

# 譜面情報パネル 

## 目的と範囲 

譜面情報パネルは、楽曲選択シーンにおける譜面（ビートマップ）のメタデータとノート密度パターンの詳細な分析と可視化を提供します。ノート数の統計情報、レーン分布、カーネル密度推定を使用してリアルタイムに計算される密度グラフを表示します。譜面ファイル自体の読み込みと解析については、[ノートと譜面管理](#3.2)を参照してください。ゲームプレイに影響する設定については、[ゲーム設定管理](#6.1)を参照してください。



---

## システムアーキテクチャ 

譜面情報パネルは、譜面データの分析と可視化のために連携する3つの主要コンポーネントで構成されています：

```mermaid
flowchart TD

MSV["MusicSelectSceneView"]
SIP["SequenceInfoPanel"]
DD["DensityDrawer"]
RM["RouletteManager"]
TS["TextScroll"]
SR["SequenceReader"]
SEQ["Sequence"]
BPM["BpmHelper"]
KDE["KernelDensityEstimation"]
DP["DensityPlot リスト"]
TOGGLES["DensityToggle x4"]
TEXTS["TextMeshProUGUI 要素"]
GRAPHS["RawImage x4"]
SCROLL["ScrollRect"]

MSV -.->|"Open(SongInfo)"| SIP
SIP -.->|"含む"| SR
SIP -.->|"Read(songInfo, difficulty)"| BPM
DD -.->|"KernelDensityEstimate()"| KDE
DD -.->|"格納"| DP
DD -.->|"含む"| GRAPHS
DD -.->|"Init(songInfo)"| TEXTS
SIP -.->|"DrawGraph()"| TOGGLES
SIP -.->|"DrawInfo()"| TEXTS
SIP -.->|"含む"| GRAPHS
SIP -.-> SCROLL
TOGGLES -.-> DD

subgraph UIコンポーネント ["UIコンポーネント"]
    TOGGLES
    TEXTS
    GRAPHS
    SCROLL
end

subgraph 統計分析 ["統計分析"]
    KDE
    DP
    KDE -.->|"密度値を返却"| DP
end

subgraph 譜面データ処理 ["譜面データ処理"]
    SR
    SEQ
    BPM
    SR -.->|"返却"| SEQ
end

subgraph 譜面情報パネル ["譜面情報パネル"]
    SIP
    DD
    RM
    TS
    SIP -.->|"含む"| DD
    SIP -.->|"Init(noteCounts)"| RM
end

subgraph 楽曲選択シーン ["楽曲選択シーン"]
    MSV
end
```



 

---

## SequenceInfoPanel コンポーネント 

### クラス構造 

`SequenceInfoPanel` クラスはパネルのライフサイクルを管理し、譜面データの読み込みと表示を調整します。

| フィールド | 型 | 目的 |
| --- | --- | --- |
| `_closeButton` | `Button` | パネルを閉じる |
| `_scrollRect` | `ScrollRect` | 縦スクロールを有効化 |
| `_rouletteManager` | `RouletteManager` | ノートタイプ分布をアニメーション表示 |
| `_densityDrawer` | `DensityDrawer` | 密度グラフのレンダリングを処理 |
| `_sequenceArtistText` | `TextScroll` | 譜面アーティスト/クレジット情報を表示 |
| `_loadStateText` | `TextMeshProUGUI` | 読み込み状態またはエラーを表示 |
| `_totalNotesText` | `TextMeshProUGUI` | 総ノート数を表示 |
| `_noteCountText` | `TextMeshProUGUI[]` | ノートタイプ別の数（黄色/青色/緑色）を表示 |
| `_longCount` | `TextMeshProUGUI` | ロングノート数を表示 |
| `_fuzzyLongCount` | `TextMeshProUGUI` | ファジーロングノート数を表示 |
| `_laneNotesCount` | `TextMeshProUGUI` | 7レーンのノート分布を表示 |
| `_densityToggles` | `Toggle[]` | 密度可視化タイプを切り替え |



### 開始フロー 

```mermaid
sequenceDiagram
  participant p1 as ユーザー
  participant p2 as SequenceInfoPanel
  participant p3 as SequenceReader
  participant p4 as BpmHelper
  participant p5 as DensityDrawer
  participant p6 as Sequence

  p1->>p2: Open(songInfo)
  p2->>p2: 読み込み状態を表示
  p2->>p2: スクロール位置をリセット
  p2->>p2: CancellationToken を作成
  p2->>p2: LoadAsync(token | songInfo | difficulty)
  p2->>p3: Read(songInfo | difficulty)
  p3-->>p2: Sequence オブジェクト
  alt 解析エラー
    p2->>p2: エラーメッセージを表示
    p2->>p2: コンテンツエリアをリサイズ
  else 解析成功
    p2->>p2: SetSequenceDetail(sequence)
    p2->>p4: Init(songInfo)
    p2->>p5: Calculate(sequence | bpmHelper | Total)
    p2->>p5: DrawInfo(Total | noteLength)
    p2->>p5: DrawGraph(Total | noteLength)
    p2->>p2: 読み込み状態を非表示
  end
```



### ノート数計算 

パネルは `NoteType` 列挙型に基づいてノートを3つのタイプに分類します：

```mermaid
flowchart TD

SEQ["Sequence.NoteTypes"]
NORMAL["NoteType.Normal"]
LSTART["NoteType.LongStart"]
LRELAY["NoteType.LongRelay"]
LEND["NoteType.LongEnd"]
FUZZY["NoteType.Fuzzy"]
FSTART["NoteType.FuzzyLongStart"]
FRELAY["NoteType.FuzzyLongRelay"]
FEND["NoteType.FuzzyLongEnd"]

SEQ -.-> NORMAL
SEQ -.-> LSTART
SEQ -.-> LRELAY
SEQ -.-> LEND
SEQ -.-> FUZZY
SEQ -.-> FSTART
SEQ -.-> FRELAY
SEQ -.-> FEND

subgraph 緑色ノート ["緑色ノート"]
    FUZZY
    FSTART
    FRELAY
    FEND
end

subgraph 青色ノート ["青色ノート"]
    LSTART
    LRELAY
    LEND
end

subgraph 黄色ノート ["黄色ノート"]
    NORMAL
end
```

実装はLINQスタイルの列挙を使用してノートをカウントします：



### レーン分布分析 

パネルは、パフォーマンスのためにスタック割り当てされたspanを使用して、7レーンのノート分布を追跡します：

```
レーン 0 | レーン 1 | レーン 2 | レーン 3 | レーン 4 | レーン 5 | レーン 6
```

出力フォーマット: `count0 | count1 | count2 | count3 | count4 | count5 | count6`



---

## DensityDrawer コンポーネント 

### 概要 

`DensityDrawer` は、カーネル密度推定（KDE）を使用して、時間経過に伴うノート密度を計算しレンダリングします。`DensityType` 列挙型で表される4つの可視化モードをサポートします：

| DensityType | 値 | 説明 |
| --- | --- | --- |
| `Total` | 0 | すべてのノートを合算 |
| `Yellow` | 1 | 通常のタップノートのみ |
| `Blue` | 2 | ロングノートとそのコンポーネント |
| `Green` | 3 | ファジーノートとファジーロングノート |



### データ構造 

```mermaid
classDiagram
    class DensityPlot {
        +float Time
        +float Density
        +DensityPlot(float time, float density)
    }
    class DensityDrawer {
        -TextMeshProUGUI _peakNpsText
        -TextMeshProUGUI _medianNpsText
        -TextMeshProUGUI _timeText
        -RawImage[] _densityGraphRawImage
        -List<DensityPlot> _densityPlotList
        -Color[] _buffer
        -Texture2D[] _drawTexture
        -float _offset
        -bool[] _isDensityDrawn
        -float _maxDensity
        -float _medianDensity
        -float _lastTime
        -float _totalPeakNps
        -float _totalMedianNps
        +Init()
        +Reset(float offset)
        +Calculate(Sequence, BpmHelper, DensityType) : int
        +DrawInfo(DensityType, int length)
        +DrawGraph(DensityType, int length)
        +Dispose()
    }
    DensityDrawer --> DensityPlot : リストを作成
```



### 計算パイプライン 

```mermaid
flowchart TD

START["Calculate<br/>呼び出し"]
CHECK["ノート数 > 1 ?"]
RETURN["そのまま<br/>カウントを返却"]

CONVERT["ビートを<br/>時間に変換"]
FILTER["DensityType ?"]

ALL["すべてのノートを使用"]
SPECIFIC["ノートタイプで<br/>フィルタ"]

KDE_LOOP["時間間隔をループ"]
KDE["KernelDensityEstimate"]
PLOT["DensityPlot を作成"]
ADD["_densityPlotList に追加"]
MORE["さらに間隔がある ?"]

STATS_CHECK["DensityType == Total ?"]
CALC_PEAK["Peak NPS を計算"]
CALC_MEDIAN["Median NPS を計算"]
CALC_MAX["Max Density を計算"]

DONE["完了"]

%% 開始～前処理
START --> CHECK
CHECK -->|No| RETURN
CHECK -->|Yes| CONVERT
CONVERT --> FILTER

%% DensityType 分岐
FILTER -->|Total| ALL
FILTER -->|Specific| SPECIFIC

ALL --> KDE_LOOP
SPECIFIC --> KDE_LOOP

%% KDE ループ
KDE_LOOP --> KDE
KDE --> PLOT
PLOT --> ADD
ADD --> MORE

MORE -->|Yes| KDE_LOOP
MORE -->|No| STATS_CHECK

%% 統計計算
STATS_CHECK -->|Yes| CALC_PEAK
CALC_PEAK --> CALC_MEDIAN
CALC_MEDIAN --> CALC_MAX
CALC_MAX --> DONE

STATS_CHECK -->|No| DONE

```



### カーネル密度推定 

密度計算は、設定可能な帯域幅を持つガウシアンカーネルを使用します：

```
density(t) = (1/n*h) * Σ K((t - ti) / h)

ここで：
- t = 評価時点
- ti = ノート時間
- h = 帯域幅（0.42）
- K(x) = ガウシアンカーネル = (1/√(2π)) * exp(-0.5 * x²)
- n = ノート数
```



 

### 可視化プロセス 

グラフレンダリングパイプラインは動的な `Texture2D` オブジェクトを作成し、密度曲線をピクセル単位で描画します：

```mermaid
flowchart TD

DRAW_START["DrawGraph<br/>呼び出し"]
ALREADY["既に描画済み ?"]
SKIP["レンダリングを<br/>スキップ"]

CREATE_TEX["Texture2D を作成"]
ALLOC_BUF["Color バッファを<br/>割り当て"]
FILL_BG["背景色を<br/>塗りつぶし"]
DRAW_MEDIAN["中央値線を<br/>描画"]

SCALE_CHECK["DensityType ?"]
USE_MAX["最大密度を<br/>スケールとして使用"]
CALC_SCALE["相対スケールを<br/>計算"]

INTERPOLATE["プロット点を<br/>補間"]
FILL_COL["グラデーションで<br/>列を塗りつぶし"]

SET_PIX["Texture2D に<br/>SetPixels"]
APPLY["Apply して<br/>RawImage に割り当て"]

FLAG["_isDensityDrawn<br/>フラグを設定"]
END["終了"]

%% 開始
DRAW_START --> ALREADY

%% 描画済みチェック
ALREADY -->|Yes| SKIP
ALREADY -->|No| CREATE_TEX

SKIP --> END

%% 描画準備
CREATE_TEX --> ALLOC_BUF
ALLOC_BUF --> FILL_BG
FILL_BG --> DRAW_MEDIAN

%% スケール決定
DRAW_MEDIAN --> SCALE_CHECK
SCALE_CHECK -->|Total| USE_MAX
SCALE_CHECK -->|Other| CALC_SCALE

USE_MAX --> INTERPOLATE
CALC_SCALE --> INTERPOLATE

%% 描画
INTERPOLATE --> FILL_COL
FILL_COL --> SET_PIX
SET_PIX --> APPLY

%% 完了
APPLY --> FLAG
FLAG --> END

```



### カラースキーム 

各密度タイプは異なる色グラデーションを使用します：

| タイプ | 低色 | 高色 |
| --- | --- | --- |
| Total | シアン (0, 0.678, 0.753) | 紫 (0.51, 0, 0.631) |
| Yellow | 黄色 (1, 1, 0) | 濃黄色 (1, 0.784, 0) |
| Blue | 濃青 (0, 91/255, 1) | 明青 (0, 170/255, 1) |
| Green | 緑 (0, 1, 0) | 濃緑 (0.216, 0.753, 0) |



 

### NPS メトリクス 

ドロワーは2つの主要なメトリクスを計算します：

**Peak NPS（秒間ノート数）:**

```
Peak NPS = max(density) * total_note_count
```

**Median NPS:**

1. `_densityPlotList` からすべての密度値を抽出
2. 配列をソート
3. 中央値を取得（偶数カウントの場合は2つの中央値の平均）
4. 総ノート数を掛ける



 

---

## ユーザーインターフェース要素 

### トグルシステム 

パネルは `ToggleGroup` 内に整理された4つのトグルを提供します：

```mermaid
flowchart TD

TG["ToggleGroup"]
T0["トグル 0: トータル"]
T1["トグル 1: 黄色"]
T2["トグル 2: 青色"]
T3["トグル 3: 緑色"]
CALC0["Total を計算"]
CALC1["Yellow を計算"]
CALC2["Blue を計算"]
CALC3["Green を計算"]
DRAW["DrawInfo + DrawGraph"]

TG -.-> T0
TG -.-> T1
TG -.->|"onValueChanged"| T2
TG -.-> T3
T0 -.->|"onValueChanged"| CALC0
T1 -.->|"onValueChanged"| CALC1
T2 -.->|"onValueChanged"| CALC2
T3 -.-> CALC3
CALC0 -.-> DRAW
CALC1 -.-> DRAW
CALC2 -.-> DRAW
CALC3 -.-> DRAW
```

 

 

### 表示エリア 

プレハブは情報を個別のセクションに整理します：

| セクション | コンポーネント | 目的 |
| --- | --- | --- |
| ヘッダー | `_sequenceArtistText` | 譜面クレジット/アーティスト情報 |
| 統計 | `_totalNotesText`, `_noteCountText[]` | タイプ別ノート数 |
| 詳細統計 | `_longCount`, `_fuzzyLongCount`, `_laneNotesCount` | 詳細な内訳 |
| 密度メトリクス | `_peakNpsText`, `_medianNpsText`, `_timeText` | NPS と長さ |
| 可視化 | `_densityGraphRawImage[]` | 密度グラフ（1200x200 px） |
| コントロール | `_densityToggles[]`, `_closeButton` | ユーザー操作 |



---

## 非同期読み込みとエラー処理 

### キャンセレーショントークンパターン 

パネルは、ユーザーがパネルを閉じたり別の譜面を開いたりしたときのキャンセルをサポートするために `CancellationTokenSource` を使用します：

```mermaid
sequenceDiagram
  participant p1 as ユーザー
  participant p2 as SequenceInfoPanel
  participant p3 as LoadAsync タスク

  p1->>p2: 譜面 A を開く
  p2->>p2: CancellationTokenSource を作成
  p2->>p3: LoadAsync(token) を開始
  alt ユーザーが早期にパネルを閉じる
    p1->>p2: Close()
    p2->>p2: トークンをキャンセル
    p2->>p2: ctSource = null を設定
    p3->>p3: IsCancellationRequested をチェック
    p3->>p3: 早期に返却
  else ユーザーが譜面 B を開く
    p1->>p2: 譜面 B を開く
    p2->>p2: 前のトークンをキャンセル
    p2->>p2: 新しい CancellationTokenSource を作成
    p2->>p3: 新しい LoadAsync を開始
  else 読み込みが正常に完了
    p3-->>p2: 譜面が読み込まれた
    p2->>p2: データを表示
  end
```



 

### エラー状態 

譜面の解析が失敗した場合、パネルは：

1. 例外の詳細を含むローカライズされたエラーメッセージを表示
2. コンテンツエリアの高さを1200から600に縮小して空のグラフエリアを隠す
3. エラーフラグ `_isErrored` を保存して、次回の成功時に高さを復元



---

## パフォーマンスの考慮事項 

### テクスチャキャッシング 

`DensityDrawer` は遅延初期化を伴う4つのキャッシュされた `Texture2D` オブジェクト（密度タイプごとに1つ）を保持します：

* 最初に要求されたときにのみテクスチャを作成
* `_isDensityDrawn` フラグが冗長なレンダリングを防止
* パネルを閉じるとリセットして状態をクリア



 

### スタック割り当て 

レーンカウントは、ゼロアロケーションの一時ストレージに `stackalloc` を使用します：

```c#
Span<int> laneCounts = stackalloc int[7] { 0, 0, 0, 0, 0, 0, 0 };
```

 

### グラフ補間 

密度グラフは、レンダリング中のヒープアロケーションを避けるために、プロット座標用のスタック割り当てされたspanを使用します：

```c#
Span<int> pX = stackalloc int[plotCount];
Span<int> pY = stackalloc int[plotCount];
```



---

## 統合ポイント 

### MusicSelectSceneView 

パネルは `MusicSelectSceneView` によってインスタンス化され初期化されます：

```
MusicSelectSceneView.Init()
  └─> SequenceInfoPanel.Init()
        ├─> SetEvent() - ボタン/トグルコールバックを接続
        └─> DensityDrawer.Init()
```

 高レベルアーキテクチャ図で参照

### GameManager 依存関係 

パネルは現在の難易度選択を照会します：

* `GameManager.Instance.SelectDifficulty` - 譜面読み込み用の現在の難易度レベル

 

### ローカライゼーション 

すべてのテキストは多言語サポートのために `LocalizeManager` を使用します：

* `LocalizationConstant.ChartInfoLoading`
* `LocalizationConstant.ERROR_LOAD_CHART_TEXT`
* `LocalizationConstant.DensityMusicLength`


## ライフサイクルのまとめ 

```mermaid
stateDiagram-v2
    [*] --> Initialized

    Initialized --> Closed : Init()<br/>GameObject.SetActive(false)

    Closed --> Opening : Open(songInfo)
    Opening --> Loading : LoadAsync()

    Loading --> ParseError : 例外がスロー
    Loading --> ParseSuccess : Sequence が読み込まれた

    ParseError --> Displayed : エラーメッセージを表示

    ParseSuccess --> CalculatingDensity : Calculate(Total)
    CalculatingDensity --> DrawingGraph : DrawInfo + DrawGraph
    DrawingGraph --> Displayed : すべてのデータを表示

    Displayed --> Displayed : トグルが変更された

    Displayed --> Closed : Close()
    Closed --> [*] : OnDestroy()
```

### On this page

* [譜面情報パネル](#5.3-)
* [目的と範囲](#5.3--1)
* [システムアーキテクチャ](#5.3--2)
* [SequenceInfoPanel コンポーネント](#5.3-sequenceinfopanel-)
* [クラス構造](#5.3--3)
* [開始フロー](#5.3--4)
* [ノート数計算](#5.3--5)
* [レーン分布分析](#5.3--6)
* [DensityDrawer コンポーネント](#5.3-densitydrawer-)
* [概要](#5.3--7)
* [データ構造](#5.3--8)
* [計算パイプライン](#5.3--9)
* [カーネル密度推定](#5.3--10)
* [可視化プロセス](#5.3--11)
* [カラースキーム](#5.3--12)
* [NPS メトリクス](#5.3-nps-)
* [ユーザーインターフェース要素](#5.3--13)
* [トグルシステム](#5.3--14)
* [表示エリア](#5.3--15)
* [非同期読み込みとエラー処理](#5.3--16)
* [キャンセレーショントークンパターン](#5.3--17)
* [エラー状態](#5.3--18)
* [パフォーマンスの考慮事項](#5.3--19)
* [テクスチャキャッシング](#5.3--20)
* [スタック割り当て](#5.3--21)
* [グラフ補間](#5.3--22)
* [統合ポイント](#5.3--23)
* [MusicSelectSceneView](#5.3-musicselectsceneview)
* [GameManager 依存関係](#5.3-gamemanager-)
* [ローカライゼーション](#5.3--24)
* [ライフサイクルのまとめ](#5.3--25)

